/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sageimport;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.sageimport.SageImportModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.sageimport.details.ImportDetailsPanel;
import ch.icit.pegasus.client.gui.modules.sageimport.details.SageDataDetails;
import ch.icit.pegasus.client.gui.modules.sageimport.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.SageImportSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.SageImportAccess;
import ch.icit.pegasus.server.core.dtos.sage.SageImportLight;
import ch.icit.pegasus.server.core.dtos.sage.SageImportLight_;
import ch.icit.pegasus.server.core.dtos.search.SageImportSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SageImportModule
extends ScreenTableView<SageImportLight, SageImportSearchConfiguration.SAGE_IMPORT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    public final String FILTER_NUMBER_OR_NAME = "number";
    public final String FILTER_PERIOD = "period";
    public final String FILTER_VALIDITY = "validity";
    private String number;
    private PeriodComplete period;
    private Boolean validity;

    public SageImportModule() {
        super(SageImportLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return SageImportAccess.MODULE_SAGE_IMPORT;
    }

    @Override
    public boolean isDeletable(RowModel<SageImportLight> model) {
        return true;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField("number", Words.NUMBER, "");
        this.filterChain.addSelectionComboBox(ComboBoxFactory.getYesNoComboBox(true), 110, "validity", Words.VALID, Words.ALL);
        TitledPeriodEditor periodEditor = this.filterChain.addPeriodSelection("period", new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), Words.DATE, false);
        periodEditor.setCheckBoxEnabled();
        periodEditor.setCheckBoxChecked(false);
        periodEditor.setCommitOnFocusLost(true);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<SageImportLight, SageImportSearchConfiguration.SAGE_IMPORT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.number = null;
            this.period = null;
            this.validity = null;
        } else if (name != null) {
            if (name.equals("number")) {
                this.number = (String)value;
            } else if (name.equals("period")) {
                this.period = ((TitledPeriodEditor)value).getPeriod();
            } else if (name.equals("validity")) {
                this.validity = value.equals(Words.YES) ? Boolean.valueOf(true) : (value.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null);
            }
        }
        SageImportSearchConfiguration c = new SageImportSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setPeriod(this.period);
        c.setValidity(this.validity);
        try {
            c.setNumber(Integer.valueOf(this.number));
        }
        catch (NumberFormatException e) {
            c.setNumber(null);
        }
        c.setName(this.number);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<SageImportLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(SageImportSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<SageImportLight> model) {
        if (model == null) {
            return false;
        }
        if (model.getNode() == null) {
            return false;
        }
        if (model.getNode().getValue() == null) {
            return false;
        }
        SageImportLight sageImportLight = (SageImportLight)model.getNode().getValue();
        if (sageImportLight == null) {
            return false;
        }
        return !screen.getInvokingName().equals(SageImportAccess.ACTION_SAGE_IMPORT_RESOLVE.getIdentifier()) || !Boolean.TRUE.equals(sageImportLight.getImportValidity());
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<SageImportLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<SageImportLight> rowEditor = new MessageProvidedRowEditor<SageImportLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            if (model.isAddRow()) {
                ImportDetailsPanel d1 = new ImportDetailsPanel((RowEditor<SageImportLight>)rowEditor, p);
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.addToFocusQueue(d1);
            } else {
                SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<SageImportLight>)rowEditor, p);
                SageDataDetails d2 = new SageDataDetails((RowEditor<SageImportLight>)rowEditor, p);
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.addToFocusQueue(d1);
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                rowEditor.addToFocusQueue(d2);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new SageImportModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.VALIDITY, "", BooleanConverter.class, null, SageImportLight_.importValidity, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth));
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)SageImportSearchConfiguration.SAGE_IMPORT_COLUMN.NUMBER, SageImportLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        columns.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)SageImportSearchConfiguration.SAGE_IMPORT_COLUMN.NAME, SageImportLight_.name, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, Integer.MAX_VALUE));
        columns.add(new TableColumnInfo(Words.PERIOD, "", (Class)PeriodConverter.class, (Enum<?>)SageImportSearchConfiguration.SAGE_IMPORT_COLUMN.PERIOD, SageImportLight_.period, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        return columns;
    }
}

