/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.retailinmotion;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.LocationConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.retailinmotion.RetailInMotionModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.retailinmotion.details.ConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.retailinmotion.details.ConfigurationDetailsPanel2;
import ch.icit.pegasus.client.gui.modules.retailinmotion.details.TransactionDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.RetailInMotionDataImportSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportLight;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RetailInMotionAccess;
import ch.icit.pegasus.server.core.dtos.search.ADataImportSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.RetailInMotionDataImportSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class RetailInMotionModule
extends ScreenTableView<RetailInMotionDataImportLight, ADataImportSearchConfiguration.DATA_IMPORT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_DATE = "date_filter";
    private static final String FILTER_STATE = "state_filter";
    private static final String FILTER_CHECKOUT_STATE = "checkout_filter";
    private PeriodComplete searchCriteria2 = null;
    private Boolean searchFilter;
    private Boolean checkoutFilter;

    public RetailInMotionModule() {
        super(RetailInMotionDataImportLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public boolean isDeletable(RowModel<RetailInMotionDataImportLight> model) {
        return true;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return RetailInMotionAccess.MODULE_RETAIL_IN_MOTION_DATA_IMPORT;
    }

    public RetailInMotionModuleDataHandler getDataHandler() {
        return (RetailInMotionModuleDataHandler)this.getTable().getModel().getDataHandler();
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", ADataImportSearchConfiguration.DATA_IMPORT_COLUMN.DATE + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        ComboBox b = ComboBoxFactory.getRetailInMotionStateComboBox(true);
        ComboBox b2 = ComboBoxFactory.getArticleSwapStateComboBox2(true);
        this.filterChain.addSelectionComboBox(b, 110, FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addSelectionComboBox(b2, 110, FILTER_CHECKOUT_STATE, Words.CHECKOUT_STATE, Words.ALL);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        TitledPeriodEditor periodSelection = this.filterChain.addPeriodSelection(FILTER_DATE, p.getStartDate(), p.getEndDate(), null, true);
        periodSelection.setCheckBoxEnabled();
        periodSelection.setCheckBoxChecked(false);
        periodSelection.setCommitOnFocusLost(true);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<RetailInMotionDataImportLight, ADataImportSearchConfiguration.DATA_IMPORT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria2 = FilterChainConfiguration.getDefaultSearchPeriod();
            this.checkoutFilter = null;
            this.searchFilter = null;
        } else if (name == FILTER_DATE) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.searchCriteria2 = per;
        } else if (name == FILTER_STATE) {
            if (Words.ALL.equals(value)) {
                this.searchFilter = null;
            } else if (Words.VALID.equals(value)) {
                this.searchFilter = true;
            } else if (Words.NOT_ALL_MATCHED.equals(value)) {
                this.searchFilter = false;
            }
        } else if (name == FILTER_CHECKOUT_STATE) {
            if (Words.ALL.equals(value)) {
                this.checkoutFilter = null;
            } else if (Words.PERFORMED.equals(value)) {
                this.checkoutFilter = true;
            } else if (Words.NOT_PERFORMED.equals(value)) {
                this.checkoutFilter = false;
            }
        }
        RetailInMotionDataImportSearchConfiguration c = new RetailInMotionDataImportSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setPeriod(this.searchCriteria2);
        c.setImportValidity(this.searchFilter);
        c.setPerformed(this.checkoutFilter);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<RetailInMotionDataImportLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(RetailInMotionDataImportSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<RetailInMotionDataImportLight> model) {
        RetailInMotionDataImportLight ab = (RetailInMotionDataImportLight)model.getNode().getValue();
        return model != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<RetailInMotionDataImportLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<RetailInMotionDataImportLight> rowEditor = new MessageProvidedRowEditor<RetailInMotionDataImportLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            if (model.isAddRow()) {
                ConfigurationDetailsPanel d1 = new ConfigurationDetailsPanel((RowEditor<RetailInMotionDataImportLight>)rowEditor, p);
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.addToFocusQueue(d1);
            } else {
                ConfigurationDetailsPanel2 d1 = new ConfigurationDetailsPanel2((RowEditor<RetailInMotionDataImportLight>)rowEditor, p);
                TransactionDetailsPanel d2 = new TransactionDetailsPanel((RowEditor<RetailInMotionDataImportLight>)rowEditor, p);
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.addToFocusQueue(d1);
                rowEditor.addToFocusQueue(d2);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new RetailInMotionModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.STATE, "", (Class)BooleanConverter.class, (Enum<?>)ADataImportSearchConfiguration.DATA_IMPORT_COLUMN.IMPORT_VALIDITY, RetailInMotionDataImportLight_.importValidity, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth));
        info.add(new TableColumnInfo(Words.CHECKOUT_STATE, "", BooleanConverter.class, null, RetailInMotionDataImportLight_.checkoutPerformed, TableColumnInfo.state2, TableColumnInfo.state2, TableColumnInfo.state2));
        info.add(new TableColumnInfo(Words.CREATION_DATE, "", (Class)DateTimeConverter.class, (Enum<?>)ADataImportSearchConfiguration.DATA_IMPORT_COLUMN.DATE, RetailInMotionDataImportLight_.creationTime, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        info.add(new TableColumnInfo(Words.CREATION_USER, "", UserConverter.class, null, RetailInMotionDataImportLight_.creationUser, 200, 200, 200));
        info.add(new TableColumnInfo(Words.DELIVERY_DATE, "", DateConverter.class, null, RetailInMotionDataImportLight_.deliveryDate, 200, 200, 200));
        info.add(new TableColumnInfo(Words.LOCATION, "", LocationConverter.class, null, RetailInMotionDataImportLight_.location, 200, 200, 200));
        return info;
    }
}

