/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.restaurant.details;

import ch.icit.pegasus.client.converter.AirportConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.color.ColorChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Color3DComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete_;
import ch.icit.pegasus.server.core.dtos.tracking.TruckComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class BasicDetailsPanel
extends DefaultDetailsPanel<RestaurantComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> name;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDComboBox> deliveryLocation;
    private TitledItem<ColorChooser> colorChooser;
    private TitledItem<RDTextField> deliveryAddress;
    private TitledItem<RDTextField> externalId;

    public BasicDetailsPanel(RowEditor<RestaurantComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.BASIC_DATA);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryLocation = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(AirportConverter.class)), Words.DELIVERY_LOCATION, TitledItem.TitledItemOrientation.NORTH);
        this.colorChooser = new TitledItem<ColorChooser>(new ColorChooser(), "Color Code", TitledItem.TitledItemOrientation.NORTH);
        this.deliveryAddress = new TitledItem<RDTextField>(new RDTextField(provider), "Delivery Address", TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.externalId = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), "External Id", TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.deliveryLocation);
        this.addToView(this.colorChooser);
        this.addToView(this.deliveryAddress);
        this.addToView(this.externalId);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && (this.editor.getModel().getNode().getChildNamed(RestaurantComplete_.name).getValue() == null || this.editor.getModel().getNode().getChildNamed(RestaurantComplete_.name).getValue().equals(""))) {
            this.name.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LOCATION_IS_SET));
        }
        if (this.deliveryLocation.getElement().isWritable() && this.editor.getModel().getNode().getChildNamed(RestaurantComplete_.deliveryAirport).getValue() == null) {
            this.deliveryLocation.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DELIVERY_AIRPORT_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled);
        }
        this.deliveryLocation.setEnabled(isEnabled);
        this.colorChooser.setEnabled(isEnabled && this.provider.isWritable(RestaurantComplete_.colorCode));
        this.deliveryAddress.setEnabled(isEnabled);
        this.externalId.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.deliveryLocation.kill();
        this.colorChooser.kill();
        this.deliveryAddress.kill();
        this.externalId.kill();
        this.name = null;
        this.locations = null;
        this.deliveryLocation = null;
        this.colorChooser = null;
        this.deliveryAddress = null;
        this.externalId = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.deliveryLocation);
        CheckedListAdder.addToList(focusList, this.deliveryAddress);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.colorChooser);
        CheckedListAdder.addToList(focusList, this.externalId);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            RestaurantComplete dto = (RestaurantComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.name.getElement().setNode(node.getChildNamed(RestaurantComplete_.name));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(TruckComplete_.eligibleLocations));
        }
        this.deliveryAddress.getElement().setNode(node.getChildNamed(RestaurantComplete_.deliveryAddress));
        Color3DComplete color = (Color3DComplete)node.getChildNamed(RestaurantComplete_.colorCode).getValue();
        if (color == null) {
            color = new Color3DComplete();
            color.setClientOId(Long.valueOf(ADTO.getNextId()));
            color.setRed(Double.valueOf(0.0));
            color.setGreen(Double.valueOf(0.0));
            color.setBlue(Double.valueOf(0.0));
            node.getChildNamed(RestaurantComplete_.colorCode).setValue((Object)color, 0L);
        } else {
            if (color.getBlue() == null) {
                color.setBlue(Double.valueOf(0.0));
            }
            if (color.getRed() == null) {
                color.setRed(Double.valueOf(0.0));
            }
            if (color.getGreen() == null) {
                color.setGreen(Double.valueOf(0.0));
            }
        }
        this.deliveryLocation.getElement().refreshPossibleValues(NodeToolkit.getAffixList(AirportComplete.class));
        this.deliveryLocation.getElement().setNode(node.getChildNamed(RestaurantComplete_.deliveryAirport));
        this.colorChooser.getElement().setNode(node.getChildNamed(RestaurantComplete_.colorCode));
        this.externalId.getElement().setNode(node.getChildNamed(RestaurantComplete_.externalReference));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = BasicDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.name.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.deliveryLocation.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.deliveryAddress.getPreferredSize().getHeight());
            if (Boolean.TRUE.equals(BasicDetailsPanel.this.viewSettings.getShowLocation())) {
                h += BasicDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + BasicDetailsPanel.this.locations.getPreferredSize().getHeight());
            }
            h += BasicDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.colorChooser.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.externalId.getPreferredSize().getHeight());
            return new Dimension(0, h += BasicDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            BasicDetailsPanel.this.name.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.name.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.horizontalBorder, (int)BasicDetailsPanel.this.name.getPreferredSize().getHeight());
            BasicDetailsPanel.this.deliveryLocation.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.name.getY() + BasicDetailsPanel.this.name.getHeight() + BasicDetailsPanel.this.inner_verticalBorder);
            BasicDetailsPanel.this.deliveryLocation.setSize(200, (int)BasicDetailsPanel.this.deliveryLocation.getPreferredSize().getHeight());
            BasicDetailsPanel.this.deliveryAddress.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.deliveryLocation.getY() + BasicDetailsPanel.this.deliveryLocation.getHeight() + BasicDetailsPanel.this.inner_verticalBorder);
            BasicDetailsPanel.this.deliveryAddress.setSize(BasicDetailsPanel.this.deliveryAddress.getPreferredSize());
            BasicDetailsPanel.this.colorChooser.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.deliveryAddress.getY() + BasicDetailsPanel.this.deliveryAddress.getHeight() + BasicDetailsPanel.this.inner_verticalBorder);
            BasicDetailsPanel.this.colorChooser.setSize(BasicDetailsPanel.this.colorChooser.getPreferredSize());
            BasicDetailsPanel.this.externalId.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.colorChooser.getY() + BasicDetailsPanel.this.colorChooser.getHeight() + BasicDetailsPanel.this.inner_verticalBorder);
            BasicDetailsPanel.this.externalId.setSize(BasicDetailsPanel.this.externalId.getPreferredSize());
            if (Boolean.TRUE.equals(BasicDetailsPanel.this.viewSettings.getShowLocation())) {
                BasicDetailsPanel.this.locations.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.externalId.getY() + BasicDetailsPanel.this.externalId.getHeight() + BasicDetailsPanel.this.inner_verticalBorder);
                BasicDetailsPanel.this.locations.setSize(BasicDetailsPanel.this.locations.getPreferredSize());
            }
        }
    }
}

