/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.reporting;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.modules.reporting.insert.ABCInsert;
import ch.icit.pegasus.client.gui.modules.reporting.insert.SCMKPIInsert;
import ch.icit.pegasus.client.gui.modules.reporting.insert.TopArticleInsert;
import ch.icit.pegasus.client.gui.modules.reporting.insert.flight.FlightReportInsert;
import ch.icit.pegasus.client.gui.screentemplates.TitledScreenInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ReportingAccess;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ReportingModule
extends TitledScreenInsert
implements ItemListener,
InnerPopUpListener2,
AbstractDataInsertModule,
Module {
    private static final long serialVersionUID = 1L;
    private boolean isChaning = false;
    private TitledItem<ComboBox> masterDataSelection;
    private DefaultDataInsert insert;
    private ScrollPane parameterScrollPane;

    public ReportingModule() {
        Color defaultBackgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color"));
        this.masterDataSelection = new TitledItem<ComboBox>(new ComboBox(null, null, null), null, TitledItem.TitledItemOrientation.NORTH);
        this.parameterScrollPane = new ScrollPane();
        this.parameterScrollPane.setBackground(defaultBackgroundColor);
        this.parameterScrollPane.getVerticalScrollBar().setBackground(defaultBackgroundColor);
        this.parameterScrollPane.getHorizontalScrollBar().setBackground(defaultBackgroundColor);
        this.parameterScrollPane.setHorizontalScrollBarPolicy(30);
        this.parameterScrollPane.setVerticalScrollBarPolicy(20);
        this.parameterScrollPane.setOpaque(false);
        this.parameterScrollPane.getViewport().setOpaque(false);
        this.setLayout(new Layout());
        this.add(this.masterDataSelection);
        this.add(this.parameterScrollPane);
        this.masterDataSelection.getElement().addItemListener(this);
    }

    @Override
    public void setMainFrame(MainFrame frame) {
        super.setMainFrame(frame);
        this.fillGUI();
    }

    private void fillGUI() {
        RDProvider p = new RDProvider(HUDToolkit.getCurrentAccessRight(ReportingAccess.MODULE_REPORTING, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()), false);
        this.masterDataSelection.getElement().addItem("");
        if (p.isWritable(ReportingAccess.ABC.getFieldName())) {
            this.masterDataSelection.getElement().addItem(REPORTS.ABC);
        }
        if (p.isWritable(ReportingAccess.TOP_ARTICLE.getFieldName())) {
            this.masterDataSelection.getElement().addItem(REPORTS.TOPARTICLE);
        }
        if (p.isWritable(ReportingAccess.FLIGHT_COSTS.getName())) {
            this.masterDataSelection.getElement().addItem(REPORTS.FLIGHT_REPORT);
        }
        if (p.isWritable(ReportingAccess.SCM_KPI.getFieldName())) {
            this.masterDataSelection.getElement().addItem(REPORTS.SCM_KPI);
        }
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    public void started() {
        this.getMainFrame().getTitleBar().setHUDButtonsEnabled(false, 1155);
    }

    public void ended() {
        this.getMainFrame().getTitleBar().setHUDButtonsEnabled(true, 1155);
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    public void redo() {
    }

    public void undo() {
    }

    private void setInsert(DefaultDataInsert insert) {
        if (this.insert != null) {
            this.insert.fadeOut(true);
            this.insert = null;
        }
        this.insert = insert;
        if (this.insert != null) {
            this.parameterScrollPane.setViewportView(this.insert);
            this.insert.fadeIn();
            this.insert.loadData();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.getMainFrame() != null) {
            this.getMainFrame().showHUDButtons(105);
        }
        if (e.getStateChange() == 1) {
            this.isChaning = true;
            this.popUpClosed(null, new Object[0]);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.insert != null) {
            this.insert.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.parameterScrollPane != null) {
            this.parameterScrollPane.kill();
        }
        this.parameterScrollPane = null;
        if (this.insert != null) {
            this.insert.kill();
        }
        this.insert = null;
        if (this.masterDataSelection != null) {
            this.masterDataSelection.kill();
        }
        this.masterDataSelection = null;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (this.isChaning) {
            if (xargs == null) {
                return;
            }
            if (this.masterDataSelection.getElement().getSelectedItem() == REPORTS.ABC) {
                this.setInsert(new ABCInsert(this));
                this.setEnabled(true);
            } else if (this.masterDataSelection.getElement().getSelectedItem() == REPORTS.TOPARTICLE) {
                this.setInsert(new TopArticleInsert(this));
                this.setEnabled(true);
            } else if (this.masterDataSelection.getElement().getSelectedItem() == REPORTS.FLIGHT_REPORT) {
                this.setInsert(new FlightReportInsert(this));
                this.setEnabled(true);
            } else if (this.masterDataSelection.getElement().getSelectedItem() == REPORTS.SCM_KPI) {
                this.setInsert(new SCMKPIInsert(this));
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void setSelectionEnabled(boolean isEnabled) {
        this.masterDataSelection.setEnabled(isEnabled);
    }

    @Override
    public void dataSaved() {
    }

    @Override
    public void setLoading(boolean b) {
    }

    @Override
    public String getScreenTitle() {
        return ReportingAccess.MODULE_REPORTING.getDisplayName();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ReportingModule.this.layoutTitle(parent);
            ReportingModule.this.masterDataSelection.setLocation(130, 22);
            ReportingModule.this.masterDataSelection.setSize(466, (int)ReportingModule.this.masterDataSelection.getPreferredSize().getHeight());
            if (ReportingModule.this.parameterScrollPane != null) {
                ReportingModule.this.parameterScrollPane.setLocation(0, ReportingModule.this.masterDataSelection.getY() + ReportingModule.this.masterDataSelection.getHeight() + 15);
                ReportingModule.this.parameterScrollPane.setSize(parent.getWidth(), parent.getHeight() - (ReportingModule.this.parameterScrollPane.getY() + 10));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private static enum REPORTS {
        ABC,
        TOPARTICLE,
        FLIGHT_REPORT,
        SCM_KPI;


        public String toString() {
            switch (this) {
                case ABC: {
                    return "ABC";
                }
                case TOPARTICLE: {
                    return "Top Articles";
                }
                case FLIGHT_REPORT: {
                    return "Flight Cost Report";
                }
                case SCM_KPI: {
                    return "SCM KPI";
                }
            }
            return super.toString();
        }
    }
}

