/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar.view.utils;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.Batchable;
import ch.icit.pegasus.client.gui.batch.impl.FlightSaveBatch;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarDetailsPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.masterdata.Coordinate3dComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class RadarDetailsPopupInsert
extends LoadablePopupInsert
implements Batchable<FlightLight>,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    private RadarDetailsPanel panel;
    private MultiLineTextLabel message;
    private boolean isForeGround;
    private Node<FlightLight> node;
    private boolean saved = false;

    public RadarDetailsPopupInsert(MainFrame mainFrame, Node<FlightLight> flight) {
        this.node = flight;
        this.panel = new RadarDetailsPanel(mainFrame);
        this.panel.setNode(flight);
        this.setLayout(new Layout());
        this.add(this.panel);
        this.panel.allInstalled();
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.panel.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.panel != null) {
            return this.panel.isInnerComponent(c);
        }
        return false;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND && !this.saved) {
            this.isForeGround = true;
            this.node = this.panel.getNode();
            this.panel.fadeOut(true);
            this.panel = null;
            this.showAnimation(((FlightLight)this.node.getValue()).getId() == null ? "Open Flight" : "Update Flight");
            this.popup.enableBackgroundButton(false);
            this.popup.enableOKButton(false);
            this.popup.enableCancelButton(false);
            ThreadSafeLoader.run(this.getJob());
        } else {
            this.isForeGround = false;
            super.enterPressed(isOK);
        }
    }

    @Override
    public BatchJob<FlightLight> getBatchJob(ThreadSafeExecutable job) {
        return new FlightSaveBatch(job, this.panel.getNode());
    }

    @Override
    public ThreadSafeExecutable getJob() {
        RadarDetailsPopupInsert r = null;
        r = this.isForeGround ? this : new RemoteLoader(){

            public void remoteObjectLoaded(Node<?> node) {
            }

            public void errorOccurred(ClientException exception) {
                RadarDetailsPopupInsert.this.errorOccurred(exception);
            }
        };
        final RadarDetailsPopupInsert loader = r;
        final Node<FlightLight> writeNode = this.node;
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node retNode = null;
                writeNode.commit(FlightLight.class);
                Node id = writeNode.getChildNamed(new String[]{"id"});
                FlightComplete newDTO = null;
                ArrayList<String> errorCallback = new ArrayList<String>();
                FlightComplete oldDTO = (FlightComplete)writeNode.getValue(FlightComplete.class);
                if (id.getValue() == null) {
                    switch (oldDTO.getFlightState()) {
                        case CANCELLED: 
                        case OPEN: {
                            List spmlOrders = oldDTO.getSpmlOrders();
                            List additionalOrders = oldDTO.getAdditionalOrders();
                            oldDTO.setSpmlOrders(new ArrayList());
                            oldDTO.setAdditionalOrders(new ArrayList());
                            FlightComplete o = null;
                            try {
                                o = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).create(oldDTO, errorCallback);
                            }
                            catch (ClientSaveOnServerException e) {
                                errorCallback.add(e.getMessage());
                            }
                            if (errorCallback.isEmpty()) {
                                Coordinate3dComplete c2;
                                Coordinate3dComplete c1;
                                GalleyEquipmentSetLight es2;
                                GalleyEquipmentLight eq2;
                                Object es;
                                GalleyEquipmentLight eq;
                                newDTO = o;
                                if (additionalOrders.isEmpty() && spmlOrders.isEmpty()) break;
                                Node addSpaces = null;
                                try {
                                    addSpaces = INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalOrderSpaces(new FlightReference(newDTO.getId())).getList(), false);
                                }
                                catch (ClientServerCallException e) {
                                    errorCallback.add(e.getMessage());
                                }
                                Node smplSpaces = null;
                                try {
                                    smplSpaces = INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalSPMLOrderSpaces(new FlightReference(newDTO.getId())).getList(), false);
                                }
                                catch (ClientServerCallException e) {
                                    errorCallback.add(e.getMessage());
                                }
                                if (spmlOrders != null) {
                                    for (SpecialMealOrderComplete order : spmlOrders) {
                                        DeliverySpaceComplete s2;
                                        if (!order.getMenuType().getAdditional().booleanValue() || order.getStowingPosition().getId() == null) {
                                            order.setStowingPosition(null);
                                        }
                                        if (order.getStowingPosition() != null) {
                                            for (DeliverySpaceComplete s2 : (List)smplSpaces.getValue()) {
                                                eq = s2.getContainingEquipment();
                                                es = eq.getContainingGalley();
                                                eq2 = order.getStowingPosition().getContainingEquipment();
                                                es2 = eq2.getContainingGalley();
                                                if (!eq.getPositionCode().equals(eq2.getPositionCode()) || !es.getGalleyCode().equals(es2.getGalleyCode())) continue;
                                                c1 = s2.getCoordinates();
                                                c2 = order.getStowingPosition().getCoordinates();
                                                if (!c1.getX().equals(c2.getX()) || !c1.getY().equals(c2.getY())) continue;
                                                order.setStowingPosition(s2);
                                            }
                                        }
                                        ArrayList<FlightLegComplete> newLegs = new ArrayList<FlightLegComplete>();
                                        s2 = order.getLegs().iterator();
                                        while (s2.hasNext()) {
                                            ILegComplete oldLeg = (ILegComplete)s2.next();
                                            for (FlightLegComplete l : newDTO.getLegs()) {
                                                Integer i2;
                                                Integer i1 = oldLeg.getNumber();
                                                if (!i1.equals(i2 = l.getNumber())) continue;
                                                newLegs.add(l);
                                            }
                                        }
                                        order.setLegs(newLegs);
                                    }
                                    newDTO.setSpmlOrders(spmlOrders);
                                }
                                if (additionalOrders != null) {
                                    for (SpecialMealOrderComplete order : additionalOrders) {
                                        if (order.getStowingPosition().getId() == null) {
                                            order.setStowingPosition(null);
                                        }
                                        if (order.getStowingPosition() != null) {
                                            for (DeliverySpaceComplete s2 : (List)addSpaces.getValue()) {
                                                eq = s2.getContainingEquipment();
                                                es = eq.getContainingGalley();
                                                eq2 = order.getStowingPosition().getContainingEquipment();
                                                es2 = eq2.getContainingGalley();
                                                if (!eq.getPositionCode().equals(eq2.getPositionCode()) || !es.getGalleyCode().equals(es2.getGalleyCode())) continue;
                                                c1 = s2.getCoordinates();
                                                c2 = order.getStowingPosition().getCoordinates();
                                                if (!c1.getX().equals(c2.getX()) || !c1.getY().equals(c2.getY())) continue;
                                                order.setStowingPosition(s2);
                                            }
                                        }
                                        for (FlightLegComplete l : newDTO.getLegs()) {
                                            Integer i2;
                                            Integer i1 = order.getLeg().getNumber();
                                            if (!i1.equals(i2 = l.getNumber())) continue;
                                            order.setLeg((ILegComplete)l);
                                        }
                                    }
                                    newDTO.setAdditionalOrders(additionalOrders);
                                }
                                try {
                                    o = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(newDTO, new ListWrapper(errorCallback), false, false, false, false).getObject();
                                }
                                catch (ClientSaveOnServerException e) {
                                    errorCallback.add(e.getMessage());
                                }
                                if (!errorCallback.isEmpty()) {
                                    retNode = new Node();
                                    retNode.setValue((Object)ScreenValidationObject.createList(errorCallback), 0L);
                                    break;
                                }
                                newDTO = o;
                                break;
                            }
                            retNode = new Node();
                            retNode.setValue((Object)ScreenValidationObject.convertListFromString(errorCallback), 0L);
                            break;
                        }
                        case CLOSED: {
                            break;
                        }
                        case EN_ROUTE: {
                            break;
                        }
                        case PLANNED: {
                            break;
                        }
                    }
                } else {
                    FlightComplete dto = (FlightComplete)writeNode.getValue(FlightComplete.class);
                    StowingListLight oldList = null;
                    if (writeNode.getChildNamed(new String[]{"oldSTW"}) != null) {
                        oldList = (StowingListLight)writeNode.getChildNamed(new String[]{"oldSTW"}).getValue();
                    }
                    StowingListLight newList = dto.getActiveStowingList();
                    FlightComplete o = null;
                    try {
                        o = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(dto, new ListWrapper(errorCallback), false, false, false, false).getObject();
                    }
                    catch (ClientSaveOnServerException e) {
                        errorCallback.add(e.getMessage());
                    }
                    if (errorCallback.isEmpty()) {
                        newDTO = o;
                    } else {
                        retNode = new Node();
                        retNode.setValue((Object)ScreenValidationObject.convertListFromString(errorCallback), 0L);
                    }
                }
                if (retNode != null) {
                    FlightComplete c = null;
                    if (oldDTO.getId() == null) {
                        oldDTO.setFlightState(FlightStateE.PLANNED);
                        try {
                            c = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getPlannedFlightComplete((FlightLight)oldDTO).getValue();
                        }
                        catch (ClientGetFromServerException e) {
                            errorCallback.add(e.getMessage());
                        }
                    } else {
                        try {
                            c = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(oldDTO.getId())).getValue();
                        }
                        catch (ClientGetFromServerException e) {
                            errorCallback.add(e.getMessage());
                        }
                    }
                    if (c != null) {
                        writeNode.removeExistingValues();
                        writeNode.setValue((Object)c, 0L);
                        writeNode.updateNode();
                    }
                    retNode.setValue((Object)ScreenValidationObject.createList(errorCallback), 0L);
                    return retNode;
                }
                if (newDTO != null) {
                    writeNode.removeExistingValues();
                    writeNode.setValue(newDTO, 0L);
                    writeNode.updateNode();
                }
                return writeNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return loader;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.message = new MultiLineTextLabel();
        if (node.getValue() instanceof ScreenValidationObject) {
            this.message.setText(((ScreenValidationObject)node.getValue()).getMessage());
        } else if (node.getValue() instanceof ScreenValidationList) {
            this.message.setText(ScreenValidationObject.createMessageList((List)((List)node.getValue())));
        } else {
            this.message.setText("Flight saved");
        }
        this.saved = true;
        this.popup.setOkButtonText("Close");
        this.popup.enableOKButton(true);
        this.popup.enableBackgroundButton(false);
        this.message.setProgress(0.0f);
        this.add((Component)this.message, 0);
        this.message.fadeIn();
        this.hideAnimation();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (RadarDetailsPopupInsert.this.loadingAnimation != null) {
                RadarDetailsPopupInsert.this.loadingAnimation.setLocation((int)(((double)parent.getWidth() - RadarDetailsPopupInsert.this.loadingAnimation.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - RadarDetailsPopupInsert.this.loadingAnimation.getPreferredSize().getHeight()) / 2);
                RadarDetailsPopupInsert.this.loadingAnimation.setSize(RadarDetailsPopupInsert.this.loadingAnimation.getPreferredSize());
            }
            if (RadarDetailsPopupInsert.this.message != null) {
                RadarDetailsPopupInsert.this.message.setLocation(10, 10);
                RadarDetailsPopupInsert.this.message.setSize(parent.getWidth() - 20, parent.getHeight() - 20);
            }
            if (RadarDetailsPopupInsert.this.panel != null) {
                RadarDetailsPopupInsert.this.panel.setLocation(0, 0);
                RadarDetailsPopupInsert.this.panel.setSize(parent.getSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension(0, 0);
        }
    }
}

