/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar.view;

import ch.icit.pegasus.client.gui.modules.radar.view.RadarFlightWidget;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarPanel;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarPanelHour;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class RadarContentPane
extends DefaultPanel
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private List<RadarPanelHour> ranges = new ArrayList<RadarPanelHour>();
    private Node<List<FlightLight>> node;
    private Time startTime;
    private Time endTime;
    private Date currentDate;
    private int days2Show;
    private int[] widths;
    private RadarPanel panel;
    private RadarFlightWidget selectedWidget;
    private RadarPanelHour selectedHour;

    public RadarContentPane(RadarPanel panel, Node<List<FlightLight>> node) {
        this.setFocusable(false);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                RadarContentPane.this.selectFlight(null, null, 0, 0);
            }
        });
        this.panel = panel;
        this.setLayout(new Layout());
        this.node = node;
        Color c = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_table_panel_background_color"));
        this.setBackground(c);
        this.node.addNodeListener((NodeListener)this);
    }

    public RadarFlightWidget getSelectedFlight() {
        return this.selectedWidget;
    }

    public RadarPanel getRadarPanel() {
        return this.panel;
    }

    protected void selectFlight(RadarFlightWidget flight, RadarPanelHour hour, int x, int y) {
        RadarFlightWidget old = this.selectedWidget;
        RadarPanelHour oldHour = this.selectedHour;
        if (this.selectedWidget != null) {
            this.selectedWidget.setSelected(false, 0, 0);
        }
        this.selectedWidget = flight;
        this.selectedHour = hour;
        if (old != null && oldHour != this.selectedHour) {
            oldHour.repaint(32L);
        }
        this.panel.selectNode(this.selectedWidget);
        if (this.selectedWidget != null) {
            this.selectedWidget.setSelected(true, x, y);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintChildren(g2);
    }

    public void setFlightRange(Time start, Time end, Date startDate, int days) {
        if (this.currentDate != null && startDate != null && start != null && end != null && this.startTime != null && this.endTime != null && start.getTime() == this.startTime.getTime() && end.getTime() == this.endTime.getTime() && this.currentDate.getTime() == startDate.getTime() && this.days2Show == days) {
            return;
        }
        this.removeAll();
        this.ranges.clear();
        if (this.startTime == null) {
            this.startTime = new Time(0, 0, 0);
        }
        if (this.endTime == null) {
            this.endTime = new Time(23, 0, 0);
        }
        this.currentDate = new PeriodComplete(startDate, startDate).getStartDate();
        this.days2Show = days;
        Calendar cal = TimeUtil.createCalendar();
        cal.setTimeInMillis(this.startTime.getTime());
        int s = cal.get(11);
        cal.setTimeInMillis(this.endTime.getTime());
        int e = cal.get(11) + 1;
        for (int j = 0; j < this.days2Show; ++j) {
            Date cd = new Date(startDate != null ? startDate.getTime() : System.currentTimeMillis() + (long)j * 86400000L);
            for (int i = s; i < e; ++i) {
                RadarPanelHour rph = new RadarPanelHour(this);
                rph.setWidths(this.widths);
                rph.setHour(i);
                rph.setDate(cd);
                rph.setTiger(i % 2 == 0);
                this.ranges.add(rph);
                this.add(rph);
            }
        }
        Collections.sort(this.ranges);
        if (this.node != null) {
            this.node.getAllChildAddEvents((NodeListener)this);
        }
        this.revalidate();
    }

    private void insertFlight(Node<FlightLight> flight, FlightLegComplete leg, boolean isFirst, boolean isLast) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean isOutbound = leg.getDepartureAirport().equals((Object)settings.getHomeBase());
        if (leg.getDepartureAirport().equals((Object)settings.getDayStop()) || leg.getDepartureAirport().equals((Object)settings.getNightStop())) {
            isOutbound = true;
        } else if (leg.getArrivalAirport().equals((Object)settings.getDayStop()) || leg.getArrivalAirport().equals((Object)settings.getNightStop())) {
            isOutbound = false;
            return;
        }
        if (isFirst) {
            if (isOutbound) {
                this.insertFlight(flight, leg, ((FlightLight)flight.getValue()).getRealstd(), ((FlightLight)flight.getValue()).getOutboundCode(), isOutbound);
            } else {
                this.insertFlight(flight, leg, ((FlightLight)flight.getValue()).getRealsta(), ((FlightLight)flight.getValue()).getInboundCode(), isOutbound);
            }
        } else if (isLast) {
            if (isOutbound) {
                this.insertFlight(flight, leg, ((FlightLight)flight.getValue()).getRealstd(), ((FlightLight)flight.getValue()).getOutboundCode(), isOutbound);
            } else {
                this.insertFlight(flight, leg, ((FlightLight)flight.getValue()).getRealsta(), ((FlightLight)flight.getValue()).getInboundCode(), isOutbound);
            }
        } else {
            java.util.Date nt = CalendarUtil.getDateWithoutTime((long)((FlightLight)flight.getValue()).getRealstd().getTime(), (boolean)true);
            if (leg.getFlightTime() != null) {
                long time = CalendarUtil.getHourAndMinutes((Time)leg.getFlightTime());
                nt.setTime(nt.getTime() + time);
                Timestamp ts = new Timestamp(nt.getTime());
                this.insertFlight(flight, leg, ts, leg.getFlightNo(), isOutbound);
            }
        }
    }

    private void addFlight(Node<FlightLight> flight) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        int count = 0;
        for (FlightLegComplete leg : ((FlightLight)flight.getValue()).getLegs()) {
            if (settings.getHomeBase().equals((Object)leg.getArrivalAirport()) || settings.getHomeBase().equals((Object)leg.getDepartureAirport())) {
                this.insertFlight(flight, leg, count == 0, count == ((FlightLight)flight.getValue()).getLegs().size() - 1);
            }
            ++count;
        }
    }

    private void removeFlight(Node<FlightLight> flight) {
        for (RadarPanelHour rph : this.ranges) {
            if (!rph.tryToRemoveFlight(flight)) continue;
            return;
        }
    }

    private void insertFlight(Node<FlightLight> flight, FlightLegComplete leg, Timestamp flightDate, String flightCode, boolean isOutbound) {
        long rangeStart = this.currentDate.getTime();
        long rangeEnd = rangeStart + 86400000L * (long)this.days2Show;
        if (rangeStart <= flightDate.getTime() && rangeEnd >= flightDate.getTime()) {
            Calendar c = TimeUtil.createCalendar();
            c.setTimeInMillis(flightDate.getTime());
            int dayOfMonth1 = c.get(5);
            int year1 = c.get(1);
            int month1 = c.get(2);
            int hour = c.get(11);
            for (RadarPanelHour h : this.ranges) {
                c.setTimeInMillis(h.getDate().getTime());
                int dayOfMonth2 = c.get(5);
                int year2 = c.get(1);
                int month2 = c.get(2);
                if (h.getHour() != hour || dayOfMonth1 != dayOfMonth2 || year1 != year2 || month1 != month2) continue;
                h.addFlight(flight, leg, flightDate, flightCode, isOutbound);
                return;
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    public void setColumnWidths(int[] widths) {
        this.widths = widths;
        for (RadarPanelHour r : this.ranges) {
            r.setWidths(widths);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
        this.addFlight(child);
        this.panel.revalidatePane();
        this.revalidate();
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        this.removeFlight(child);
        this.panel.revalidatePane();
        this.revalidate();
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    public void moveBackward() {
        RadarFlightWidget cw = this.selectedWidget;
        RadarPanelHour ch = null;
        if (this.selectedHour != null) {
            ch = this.selectedHour;
        } else if (!this.ranges.isEmpty()) {
            ch = this.ranges.get(0);
        }
        while (ch != null) {
            RadarFlightWidget n = ch.getPrevious(cw);
            if (n != null) {
                this.selectFlight(n, ch, 0, 0);
                return;
            }
            ch = this.getPrevious(ch);
        }
    }

    public void moveForward() {
        RadarFlightWidget cw = this.selectedWidget;
        RadarPanelHour ch = null;
        if (this.selectedHour != null) {
            ch = this.selectedHour;
        } else if (!this.ranges.isEmpty()) {
            ch = this.ranges.get(0);
        }
        while (ch != null) {
            RadarFlightWidget n = ch.getNext(cw);
            if (n != null) {
                this.selectFlight(n, ch, 0, 0);
                return;
            }
            ch = this.getNext(ch);
        }
    }

    private RadarPanelHour getNext(RadarPanelHour h) {
        int i = this.ranges.indexOf(h);
        if (++i < this.ranges.size()) {
            return this.ranges.get(i);
        }
        return null;
    }

    private RadarPanelHour getPrevious(RadarPanelHour h) {
        int i = this.ranges.indexOf(h);
        if (--i >= 0) {
            return this.ranges.get(i);
        }
        return null;
    }

    public List<FlightLight> getFlights() {
        ArrayList<FlightLight> ret = new ArrayList<FlightLight>();
        for (RadarPanelHour hourPanel : this.ranges) {
            ret.addAll(hourPanel.getFlights());
        }
        return ret;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int cy = 0;
            for (RadarPanelHour r : RadarContentPane.this.ranges) {
                cy = (int)((double)cy + r.getPreferredSize().getHeight());
            }
            return new Dimension(0, cy);
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = 0;
            for (RadarPanelHour r : RadarContentPane.this.ranges) {
                r.setLocation(0, cy);
                r.setSize(parent.getWidth(), (int)r.getPreferredSize().getHeight());
                cy += r.getHeight();
            }
            if (RadarContentPane.this.selectedWidget != null) {
                int sx = RadarContentPane.this.selectedWidget.getX() + RadarContentPane.this.selectedWidget.getParent().getX();
                int sy = RadarContentPane.this.selectedWidget.getY() + RadarContentPane.this.selectedWidget.getParent().getY();
                RadarContentPane.this.selectedWidget.layoutButtons(parent, sx += RadarContentPane.this.selectedWidget.getWidth() / 2, sy += RadarContentPane.this.selectedWidget.getHeight() / 2);
            }
        }
    }
}

