/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseproposal;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.purchaseproposal.PurchaseProposalServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.MatDispoSupplierAndStoreTemplateComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalArticleComplete;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalComplete;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalLight;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalReference;
import ch.icit.pegasus.server.core.dtos.search.PurchaseProposalSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class PurchaseProposalModuleDataHandler
extends DefaultDataHandler<PurchaseProposalLight, PurchaseProposalComplete> {
    public PurchaseProposalModuleDataHandler(long id, ScreenTableView<PurchaseProposalLight, PurchaseProposalSearchConfiguration.PURCHASE_PROPOSAL_COLUMN> tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<PurchaseProposalLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseProposalComplete purchaseProposal = (PurchaseProposalComplete)node.getValue(PurchaseProposalComplete.class);
                PurchaseProposalComplete dto = (PurchaseProposalComplete)((PurchaseProposalServiceManager)ServiceManagerRegistry.getService(PurchaseProposalServiceManager.class)).updatePurchaseProposal(purchaseProposal).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<PurchaseProposalComplete> createEmptyNode() {
        PurchaseProposalComplete d = new PurchaseProposalComplete();
        d.setFlightsPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<PurchaseProposalComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(PurchaseProposalComplete.class);
                PurchaseProposalComplete dto = (PurchaseProposalComplete)node.getValue(PurchaseProposalComplete.class);
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                PurchaseProposalComplete nDto = (PurchaseProposalComplete)((PurchaseProposalServiceManager)ServiceManagerRegistry.getService(PurchaseProposalServiceManager.class)).createPurchaseProposal(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, System.currentTimeMillis());
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseProposalModuleDataHandler.this.setCurrentLoadMaximum(3);
                PurchaseProposalModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                PurchaseProposalModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                PurchaseProposalModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(MatDispoSupplierAndStoreTemplateComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return PurchaseProposalModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<PurchaseProposalComplete> resetData(Node<PurchaseProposalComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseProposalLight dto = (PurchaseProposalLight)node.getValue(PurchaseProposalLight.class);
                PurchaseProposalComplete purchaseProposal = (PurchaseProposalComplete)((PurchaseProposalServiceManager)ServiceManagerRegistry.getService(PurchaseProposalServiceManager.class)).getPurchaseProposal((PurchaseProposalReference)dto).getValue();
                for (PurchaseProposalArticleComplete article : purchaseProposal.getArticles()) {
                    BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(article.getArticle().getId())).getValue();
                    INodeCreator.getDefaultImpl().getNode4DTO((Object)artC, false, false);
                }
                node.removeExistingValues();
                node.setValue((Object)purchaseProposal, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Class<PurchaseProposalComplete> getCommittingClass() {
        return PurchaseProposalComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<PurchaseProposalLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

