/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.preview.details;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.LocationConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewLight;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewStateE;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<ManualPurchaseOrderPreviewLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> name;
    private TitledItem<RDDateChooser> createForDate;
    private TitledItem<RDTextArea> comment;
    private TitledItem<RDComboBox> location;

    public SpecificationDetailsPanel(RowEditor<ManualPurchaseOrderPreviewLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.setCustomLayouter(new Layout());
        this.number = new TitledItem<TextLabel>(new TextLabel(ConverterRegistry.getConverter(IntegerConverter.class)), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.createForDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.CREATED_FOR_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.comment = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.COMMENT, TitledItem.TitledItemOrientation.NORTH);
        this.comment.setIgnorePrefHeight(true);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(LocationConverter.class)), Words.LOCATION, TitledItem.TitledItemOrientation.NORTH);
        }
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.createForDate);
        this.addToView(this.comment);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.location);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.name);
        CheckedListAdder.addToList(a, this.createForDate);
        CheckedListAdder.addToList(a, this.location);
        CheckedListAdder.addToList(a, this.comment);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean created = this.editor.getModel().getNode().getChildNamed(ManualPurchaseOrderPreviewLight_.orderState).getValue() != PurchaseOrderPreviewStateE.CREATED;
        boolean en = isEnabled && created;
        super.setEnabled(en);
        this.number.setEnabled(en);
        this.name.setEnabled(en);
        this.createForDate.setEnabled(en);
        this.comment.setEnabled(en);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location.setEnabled(en);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.name.kill();
        this.createForDate.kill();
        this.comment.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location.kill();
        }
        this.number = null;
        this.name = null;
        this.createForDate = null;
        this.comment = null;
        this.location = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.number.getElement().setNode(node.getChildNamed(ManualPurchaseOrderPreviewLight_.number));
        this.name.getElement().setNode(node.getChildNamed(ManualPurchaseOrderPreviewLight_.name));
        this.createForDate.getElement().setNode(node.getChildNamed(ManualPurchaseOrderPreviewLight_.createdForDate));
        this.comment.getElement().setNode(node.getChildNamed(ManualPurchaseOrderPreviewLight_.comment));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location.getElement().refreshPossibleValues(NodeToolkit.getAffixList(LocationComplete.class));
            this.location.getElement().setNode(node.getChildNamed(ManualPurchaseOrderPreviewLight_.orderLocation));
        }
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.editor.getModel().getNode().getChildNamed(ManualPurchaseOrderPreviewLight_.orderLocation).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Location is set"));
        }
        return validationObjects;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w3tl = parent.getWidth() - 3 * SpecificationDetailsPanel.this.horizontalBorder;
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(w3tl /= 3, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(w3tl * 2, (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.createForDate.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.createForDate.setSize(SpecificationDetailsPanel.this.createForDate.getPreferredSize());
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.location.setLocation(SpecificationDetailsPanel.this.name.getX(), SpecificationDetailsPanel.this.createForDate.getY());
                SpecificationDetailsPanel.this.location.setSize(120, (int)SpecificationDetailsPanel.this.location.getPreferredSize().getHeight());
            }
            SpecificationDetailsPanel.this.comment.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.createForDate.getY() + SpecificationDetailsPanel.this.createForDate.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.comment.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, parent.getHeight() - (SpecificationDetailsPanel.this.comment.getY() + SpecificationDetailsPanel.this.verticalBorder));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.createForDate.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h += 200;
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

