/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details.utils;

import ch.icit.pegasus.client.util.ConverterInconsistenceException;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.recipe.InterpolationStepComplete;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.QuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.StepQuantityInterpolationComplete;
import ch.icit.util.Invoker;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class Toolkit {
    public static QuantityInterpolationComplete copyQuantityInterpolation(QuantityInterpolationComplete c) {
        LinearQuantityInterpolationComplete nc = null;
        if (c instanceof LinearQuantityInterpolationComplete) {
            LinearQuantityInterpolationComplete cc = (LinearQuantityInterpolationComplete)c;
            int i = Invoker.getFieldCount(LinearQuantityInterpolationComplete.class);
            if (i != 7) {
                throw new ConverterInconsistenceException("Try to copy Linear Quantity Interpolation. Expected 7 fields but found " + i + " fields.");
            }
            nc = new LinearQuantityInterpolationComplete();
            QuantityComplete q = new QuantityComplete();
            q.setQuantity(cc.getResultingQuantity().getQuantity());
            q.setUnit(cc.getResultingQuantity().getUnit());
            nc.setResultingQuantity(q);
        } else if (c instanceof StepQuantityInterpolationComplete) {
            StepQuantityInterpolationComplete cc = (StepQuantityInterpolationComplete)c;
            int i = Invoker.getFieldCount(StepQuantityInterpolationComplete.class);
            if (i != 7) {
                throw new ConverterInconsistenceException("Try to copy Step Quantity Interpolation. Expected 7 fields but found " + i + " fields.");
            }
            nc = new StepQuantityInterpolationComplete();
            ((StepQuantityInterpolationComplete)nc).setSteps(Toolkit.copySteps(cc.getSteps()));
        }
        return nc;
    }

    private static List<InterpolationStepComplete> copySteps(List<InterpolationStepComplete> lists) {
        int i = Invoker.getFieldCount(InterpolationStepComplete.class);
        if (i != 8) {
            throw new ConverterInconsistenceException("Try to copy Interplation Step. Expected 8 fields but found " + i + " fields.");
        }
        ArrayList<InterpolationStepComplete> l = new ArrayList<InterpolationStepComplete>();
        for (InterpolationStepComplete step : lists) {
            InterpolationStepComplete s = new InterpolationStepComplete();
            s.setSequenceNumber(step.getSequenceNumber());
            QuantityComplete q = new QuantityComplete();
            q.setQuantity(step.getResultingQuantity().getQuantity());
            q.setUnit(step.getResultingQuantity().getUnit());
            QuantityComplete bound = new QuantityComplete();
            bound.setQuantity(step.getUpperBound().getQuantity());
            bound.setUnit(step.getUpperBound().getUnit());
            s.setResultingQuantity(q);
            s.setUpperBound(bound);
            l.add(s);
        }
        return l;
    }

    protected Date getStart(PeriodComplete p) {
        Date d = p == null ? null : p.getStartDate();
        return d == null ? null : Toolkit.setStartOfDay(d);
    }

    protected Date getEnd(PeriodComplete p) {
        Date d = p == null ? null : p.getEndDate();
        return d == null ? null : Toolkit.setEndOfDay(d);
    }

    public static <T extends Date> T setStartOfDay(T date) {
        if (date == null) {
            return null;
        }
        long millis = new DateTime(date.getTime()).withTime(0, 0, 0, 0).getMillis();
        date.setTime(millis);
        return date;
    }

    public static <T extends Date> T setEndOfDay(T date) {
        if (date == null) {
            return null;
        }
        long millis = new DateTime(date.getTime()).withTime(23, 59, 59, 999).getMillis();
        date.setTime(millis);
        return date;
    }

    public static <T extends Date> T setDay(T date, int hours, int minutes, int seconds, int milliseconds) {
        if (date == null) {
            return null;
        }
        if (hours < 0 || hours > 23) {
            return null;
        }
        if (minutes < 0 || minutes > 59) {
            return null;
        }
        if (seconds < 0 || seconds > 59) {
            return null;
        }
        if (milliseconds < 0 || milliseconds > 999) {
            return null;
        }
        long millis = new DateTime(date.getTime()).withTime(hours, minutes, seconds, milliseconds).getMillis();
        date.setTime(millis);
        return date;
    }
}

