/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispo.details;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2DecimalUnnormalizedNodeBased;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.matdispo.MatDispoOldModule;
import ch.icit.pegasus.client.gui.modules.matdispo.details.FlightDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitView;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tooltip.impls.PackagingQuantityFormulaCoverter;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.recipe.AllergenDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import ch.icit.utils.ExcelRow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArticleDetailsPanel
extends SplitView
implements ButtonListener,
SearchTextField2Listener {
    private static final Logger log = LoggerFactory.getLogger(ArticleDetailsPanel.class);
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2> articleSearch;
    private TextButton add;
    private TextButton clearAll;
    private SystemSettingsComplete settings;
    private Map<FlightLight, List<String>> warnings = new HashMap<FlightLight, List<String>>();
    private Map<CustomerLight, List<String>> warnings2 = new HashMap<CustomerLight, List<String>>();
    private Table2 results;
    private MatDispoOldModule matDispo;
    private CurrencyVariantAccessor accessor = new CurrencyVariantAccessorImpl();

    public ArticleDetailsPanel(MatDispoOldModule md) {
        this.matDispo = md;
        this.articleSearch = new TitledItem<SearchTextField2<BasicArticleLight>>(SearchTextField2Factory.getBasicArticleSearchField(false, new DTOProxyNode()), Words.ARTICLE, TitledItem.TitledItemOrientation.NORTH);
        this.articleSearch.getElement().addSearchTextFieldListener(this);
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.add = new TextButton(Words.ADD);
        this.clearAll = new TextButton(Words.CLEAR_ALL);
        this.add.addButtonListener(this);
        this.clearAll.addButtonListener(this);
        this.results = new Table2(false, "");
        this.results.setScrollDownOnAdd(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 80, 80, 80));
        int tw = 2 * this.results.getCellPadding() + InputComboBox2.getPreferredWidth(this, 11);
        columns.add(new TableColumnInfo(Words.NORMALIZED_QTY, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.UNROUNDED_QTY, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.USER_QTY, null, null, null, "", tw, tw, tw));
        tw = 2 * this.results.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        this.results.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.results.getModel().setNode((Node)new ViewNode(""));
        this.setLayout(new Layout());
        this.add(this.articleSearch);
        this.add(this.add);
        this.add(this.clearAll);
        this.add(this.results);
    }

    @Override
    public void resetData() {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.articleSearch.setEnabled(isEnabled);
        this.add.setEnabled(isEnabled & this.articleSearch.getElement().isItemSelected());
        this.clearAll.setEnabled(isEnabled);
        this.results.setEnabled(isEnabled);
    }

    public boolean isTableEmpty() {
        return this.results.getRows().isEmpty();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.articleSearch.kill();
        this.add.kill();
        this.clearAll.kill();
        this.results.kill();
        this.articleSearch = null;
        this.add = null;
        this.clearAll = null;
        this.results = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.articleSearch.getFocusComponents();
        a.addAll(this.add.getFocusComponents());
        a.addAll(this.clearAll.getFocusComponents());
        a.addAll(this.results.getFocusComponents());
        return a;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.add) {
            if (this.articleSearch.getElement().isItemSelected()) {
                this.addToList(this.articleSearch.getElement().getNode());
            }
            this.articleSearch.requestFocusInWindowNow();
        } else if (source == this.clearAll) {
            Iterator it = this.results.getModel().getNode().getFailSafeChildIterator();
            while (it.hasNext()) {
                this.removeNodeFromList((Node)it.next());
            }
            this.warnings = new HashMap<FlightLight, List<String>>();
        }
    }

    private void removeNodeFromList(Node<?> n) {
        this.results.getModel().getNode().removeChild(n, 0L);
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        if (n.getValue(BasicArticleComplete.class) == null) {
            final Node<?> r = n;
            this.add.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    BasicArticleLight l = (BasicArticleLight)r.getValue();
                    BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)l).getValue();
                    r.removeExistingValues();
                    r.setValue((Object)artC, 0L);
                    return r;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ArticleDetailsPanel.this.add.setEnabled(true);
                            ArticleDetailsPanel.this.add.requestFocusInWindowNow();
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ArticleDetailsPanel.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.add.setEnabled(true);
            this.add.requestFocusInWindowNow();
        }
    }

    private void addToList(Node n) {
        BasicArticleComplete artC = (BasicArticleComplete)n.getValue(BasicArticleComplete.class);
        HashMap<CustomerLight, Map<BasicArticleComplete, Object>> mapIndex = new HashMap<CustomerLight, Map<BasicArticleComplete, Object>>();
        HashMap<BasicArticleComplete, QuantityComplete> map = new HashMap<BasicArticleComplete, QuantityComplete>();
        map.put(artC, new QuantityComplete(Double.valueOf(0.0), artC.getBaseUnit()));
        mapIndex.put(null, map);
        this.addArticlesNew(mapIndex, true);
    }

    private Node<BasicArticleComplete> getArticleNode(BasicArticleComplete p, CustomerLight customerLight) {
        Iterator it = this.results.getModel().getNode().getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            boolean takeit = false;
            takeit = customerLight != null ? (n.getChildNamed(new String[]{"customer"}) != null && n.getChildNamed(new String[]{"customer"}).getValue() != null ? n.getChildNamed(new String[]{"customer"}).getValue().equals(customerLight) : false) : n.getChildNamed(new String[]{"customer"}) == null || n.getChildNamed(new String[]{"customer"}).getValue() == null;
            if (!takeit || !n.getChildNamed(new String[]{"article"}).getValue().equals(p)) continue;
            return n;
        }
        return null;
    }

    public void addArticlesNew(Map<CustomerLight, Map<BasicArticleComplete, Object>> a, boolean merge) {
        if (!merge) {
            this.results.getModel().setNode((Node)new ViewNode(""));
        }
        for (Map.Entry<CustomerLight, Map<BasicArticleComplete, Object>> e0 : a.entrySet()) {
            for (Map.Entry<BasicArticleComplete, Object> e : e0.getValue().entrySet()) {
                ViewNode node = this.getArticleNode(e.getKey(), e0.getKey());
                if (node == null) {
                    node = new ViewNode("");
                    Node artNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)e.getKey(), false, true);
                    artNode.setValue((Object)e.getKey(), 0L);
                    artNode.setName("article");
                    node.addChild(artNode, 0L);
                    Node calculatedQty = new Node();
                    calculatedQty.setName("calculatedQty");
                    Node unroundedQty = new Node();
                    unroundedQty.setName("unroundedQty");
                    Node roundedQty = new Node();
                    roundedQty.setName("roundedQty");
                    Node userQty = new Node();
                    userQty.setName("userQty");
                    UnitComplete unit = ArticleToolkit.getLowestArticleUnit(e.getKey());
                    unroundedQty.setValue((Object)new QuantityComplete(Double.valueOf(0.0), unit), 0L);
                    roundedQty.setValue((Object)new QuantityComplete(Double.valueOf(0.0), e.getKey().getBaseUnit()), 0L);
                    userQty.setValue((Object)new QuantityComplete(Double.valueOf(0.0), unit), 0L);
                    calculatedQty.setValue((Object)new QuantityComplete(Double.valueOf(0.0), e.getKey().getBaseUnit()), 0L);
                    node.addChild(unroundedQty, 0L);
                    node.addChild(roundedQty, 0L);
                    node.addChild(userQty, 0L);
                    node.addChild(calculatedQty, 0L);
                    DTOProxyNode customer = new DTOProxyNode();
                    customer.setName("customer");
                    customer.setValue((Object)e0.getKey(), 0L);
                    node.addChild((Node)customer, 0L);
                    this.results.getModel().getNode().addChild((Node)node, 0L);
                }
                Node unroundedQty = node.getChildNamed(new String[]{"unroundedQty"});
                Node roundedQty = node.getChildNamed(new String[]{"roundedQty"});
                Node userQty = node.getChildNamed(new String[]{"userQty"});
                Node calculatedQty = node.getChildNamed(new String[]{"calculatedQty"});
                double unRounded = (Double)unroundedQty.getChildNamed(QuantityComplete_.quantity).getValue();
                double rounded = (Double)unroundedQty.getChildNamed(QuantityComplete_.quantity).getValue();
                double user = (Double)userQty.getChildNamed(QuantityComplete_.quantity).getValue();
                UnitComplete unRoundedUnit = (UnitComplete)unroundedQty.getChildNamed(QuantityComplete_.unit).getValue();
                UnitComplete roundedUnit = (UnitComplete)roundedQty.getChildNamed(QuantityComplete_.unit).getValue();
                UnitComplete userUnit = (UnitComplete)userQty.getChildNamed(QuantityComplete_.unit).getValue();
                double nq = 0.0;
                UnitComplete nu = null;
                if (e.getValue() instanceof StoreQuantityComplete) {
                    nq = ((StoreQuantityComplete)e.getValue()).getAmount().doubleValue();
                    nu = ((QuantityComplete)e.getValue()).getUnit();
                } else if (e.getValue() instanceof QuantityComplete) {
                    nq = ((QuantityComplete)e.getValue()).getQuantity();
                    nu = ((QuantityComplete)e.getValue()).getUnit();
                }
                double newUnrounded = UnitConversionToolkit.convertUnit((UnitComplete)nu, (UnitComplete)unRoundedUnit, (double)nq, (BasicArticleLight)((BasicArticleLight)e.getKey()), (Timestamp)new Timestamp(System.currentTimeMillis()));
                double newRounded = UnitConversionToolkit.convertUnit((UnitComplete)nu, (UnitComplete)roundedUnit, (double)nq, (BasicArticleLight)((BasicArticleLight)e.getKey()), (Timestamp)new Timestamp(System.currentTimeMillis()));
                double newUser = UnitConversionToolkit.convertUnit((UnitComplete)nu, (UnitComplete)userUnit, (double)nq, (BasicArticleLight)((BasicArticleLight)e.getKey()), (Timestamp)new Timestamp(System.currentTimeMillis()));
                unroundedQty.getChildNamed(QuantityComplete_.quantity).setValue((Object)(unRounded += newUnrounded), 0L);
                roundedQty.getChildNamed(QuantityComplete_.quantity).setValue((Object)(rounded += newRounded), 0L);
                userQty.getChildNamed(QuantityComplete_.quantity).setValue((Object)(user += newUser), 0L);
                calculatedQty.getChildNamed(QuantityComplete_.quantity).setValue((Object)unRounded, 0L);
                calculatedQty.getChildNamed(QuantityComplete_.unit).setValue((Object)unRoundedUnit, 0L);
            }
        }
        for (Table2RowPanel p : this.results.getRows()) {
            TableRowImpl pi = (TableRowImpl)p;
            pi.updateAmount();
        }
    }

    public List<ExcelRow> getExcelRows(BondedStateE bondedState, boolean includeActualStock, FlightDetailsPanel fdp, LoadingAnimation animation) throws ClientRemoteException, ClientServerCallException {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        ExcelRow h = new ExcelRow();
        h.setHeader(true);
        h.addCell((Object)"Material Disposition", new String[0]);
        rows.add(h);
        ExcelRow h2 = new ExcelRow();
        h2.setHeader(true);
        h2.addCell((Object)"No", new String[0]);
        h2.addCell((Object)"Customer Article No", new String[0]);
        h2.addCell((Object)"Name", new String[0]);
        h2.addCell((Object)Words.CUSTOMER, new String[0]);
        h2.addCell((Object)"is Customer Owner", new String[0]);
        h2.addCell((Object)"in use", new String[0]);
        h2.addCell((Object)Words.EXCLUDE_FROM_MATERIAL_COST_CALCULATIONS, new String[0]);
        h2.addCell((Object)"Piece Qty", new String[0]);
        h2.addCell((Object)"Piece Unit", new String[0]);
        h2.addCell((Object)"Normalized Qty", new String[0]);
        h2.addCell((Object)"Normalized Unit", new String[0]);
        h2.addCell((Object)"Calc Qty", new String[0]);
        h2.addCell((Object)"Calc Unit", new String[0]);
        h2.addCell((Object)"Store Qty", new String[0]);
        h2.addCell((Object)"Store Unit", new String[0]);
        h2.addCell((Object)"User Qty", new String[0]);
        h2.addCell((Object)"User Unit", new String[0]);
        if (includeActualStock) {
            h2.addCell((Object)"Dispo UoM", new String[0]);
            h2.addCell((Object)"Dispo Calc", new String[0]);
            h2.addCell((Object)"Dispo Stock", new String[0]);
            h2.addCell((Object)"Dispo Order", new String[0]);
        }
        h2.addCell((Object)"Store", new String[0]);
        h2.addCell((Object)"Supplier", new String[0]);
        h2.addCell((Object)"U/P", new String[0]);
        h2.addCell((Object)"", new String[0]);
        h2.addCell((Object)"", new String[0]);
        h2.addCell((Object)"Total Cost ", new String[0]);
        h2.addCell((Object)"", new String[0]);
        h2.addCell((Object)"Conversion", new String[0]);
        h2.addCell((Object)"Purchase Waste", new String[0]);
        h2.addCell((Object)"Default Cooking Waste", new String[0]);
        h2.addCell((Object)Words.ALLERGEN_STATE, new String[0]);
        h2.addCell((Object)Words.ALLERGEN_APPROVED, new String[0]);
        h2.addCell((Object)Words.ALLERGEN_APPROVED_DATE, new String[0]);
        h2.addCell((Object)Words.ALLERGENS, new String[0]);
        h2.addCell((Object)Words.CATEGORY, new String[0]);
        h2.addCell((Object)Words.GROUP, new String[0]);
        h2.addCell((Object)Words.SUB_GROUP, new String[0]);
        h2.addCell((Object)Words.GMCCODE, new String[0]);
        rows.add(h2);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        int count = 1;
        int maxCount = this.results.getRowCount();
        Map stocks = null;
        if (includeActualStock) {
            animation.stateChanged("Load Actual Stock");
            ArrayList<BasicArticleComplete> articles = new ArrayList<BasicArticleComplete>();
            for (Table2RowPanel p : this.results.getRows()) {
                BasicArticleComplete article = (BasicArticleComplete)p.getModel().getNode().getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class);
                articles.add(article);
            }
            stocks = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStock(new ListWrapper(articles)).getMap();
        }
        block8: for (Table2RowPanel p : this.results.getRows()) {
            animation.stateChanged("Process Article " + count + "/" + maxCount);
            BasicArticleComplete article = (BasicArticleComplete)p.getModel().getNode().getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class);
            switch (bondedState) {
                case ALL: {
                    break;
                }
                case NOT_BONDED: {
                    if (!article.getBonded().booleanValue()) break;
                    continue block8;
                }
                case ONLY_BONDED: {
                    if (article.getBonded().booleanValue()) break;
                    continue block8;
                }
            }
            try {
                ExcelRow r = new ExcelRow();
                r.addCell((Object)article.getNumber(), new String[0]);
                r.addCell((Object)article.getCustomerArticleNumber(), new String[0]);
                if (bondedState == BondedStateE.ALL) {
                    String artName = "";
                    artName = article.getName();
                    if (article.getBonded().booleanValue()) {
                        artName = artName + " *";
                    }
                    r.addCell((Object)artName, new String[0]);
                } else {
                    r.addCell((Object)article.getName(), new String[0]);
                }
                Node customerNode = p.getModel().getNode().getChildNamed(new String[]{"customer"});
                String t = null;
                if (customerNode != null && customerNode.getValue() != null) {
                    t = ((CustomerLight)customerNode.getValue()).getCode();
                }
                r.addCell(t, new String[0]);
                r.addCell((Object)(Boolean.TRUE.equals(article.getCustomerIsOwner()) && article.getCustomer() != null ? WordsToolkit.toLowerCase((String)Words.YES) : WordsToolkit.toLowerCase((String)Words.NO_ANSWER)), new String[0]);
                r.addCell((Object)(Boolean.TRUE.equals(article.getIsInUse()) ? WordsToolkit.toLowerCase((String)Words.YES) : WordsToolkit.toLowerCase((String)Words.NO_ANSWER)), new String[0]);
                r.addCell((Object)(Boolean.TRUE.equals(article.getExcludeFromMaterialCostCalculations()) ? WordsToolkit.toLowerCase((String)Words.YES) : WordsToolkit.toLowerCase((String)Words.NO_ANSWER)), new String[0]);
                Node calcN = p.getModel().getNode().getChildNamed(new String[]{"calculatedQty"});
                Node qq = p.getModel().getNode().getChildNamed(new String[]{"userQty"});
                Node rq = p.getModel().getNode().getChildNamed(new String[]{"roundedQty"});
                Node urq = p.getModel().getNode().getChildNamed(new String[]{"unroundedQty"});
                Converter c1 = ConverterRegistry.getConverter(UnitConverter.class);
                Object q = qq.getChildNamed(new String[]{"quantity"}).getValue();
                double userQty = 0.0;
                if (q instanceof Integer) {
                    userQty = ((Integer)q).doubleValue();
                } else if (q instanceof Long) {
                    userQty = ((Long)q).doubleValue();
                } else if (q instanceof Double) {
                    userQty = (Double)q;
                }
                UnitComplete userUnit = (UnitComplete)qq.getChildNamed(new String[]{"unit"}).getValue();
                q = rq.getChildNamed(new String[]{"quantity"}).getValue();
                double normalizedQty = 0.0;
                if (q instanceof Integer) {
                    normalizedQty = ((Integer)q).doubleValue();
                } else if (q instanceof Long) {
                    normalizedQty = ((Long)q).doubleValue();
                } else if (q instanceof Double) {
                    normalizedQty = (Double)q;
                }
                UnitComplete normalizedUnit = (UnitComplete)rq.getChildNamed(new String[]{"unit"}).getValue();
                q = urq.getChildNamed(new String[]{"quantity"}).getValue();
                double unroundedQty = 0.0;
                if (q instanceof Integer) {
                    unroundedQty = ((Integer)q).doubleValue();
                } else if (q instanceof Long) {
                    unroundedQty = ((Long)q).doubleValue();
                } else if (q instanceof Double) {
                    unroundedQty = (Double)q;
                }
                UnitComplete unroundedUnit = (UnitComplete)urq.getChildNamed(new String[]{"unit"}).getValue();
                double roundedQty = (int)(unroundedQty + 0.5);
                UnitComplete pieceUnit = settings.getPieceUnit();
                Double pieceAmount = null;
                if (pieceUnit != null && UnitConversionToolkit.isUnitContaining((UnitComplete)unroundedUnit, (UnitComplete)pieceUnit, (BasicArticleLight)article, (Timestamp)new Timestamp(System.currentTimeMillis())) != 11) {
                    pieceAmount = UnitConversionToolkit.convertUnit((UnitComplete)unroundedUnit, (UnitComplete)pieceUnit, (double)unroundedQty, (BasicArticleLight)article, (Timestamp)new Timestamp(System.currentTimeMillis()));
                }
                r.addCell(pieceAmount, new String[0]);
                r.addCell((Object)(pieceUnit != null ? pieceUnit.getShortName() : ""), new String[0]);
                r.addCell((Object)normalizedQty, new String[0]);
                r.addCell((Object)normalizedUnit.getShortName(), new String[0]);
                double absStore = UnitConversionToolkit.convertUnit((UnitComplete)unroundedUnit, (UnitComplete)article.getMainStoreUnit(), (double)roundedQty, (BasicArticleLight)article, (Timestamp)new Timestamp(System.currentTimeMillis()));
                double userStore = UnitConversionToolkit.convertUnit((UnitComplete)unroundedUnit, (UnitComplete)article.getMainStoreUnit(), (double)userQty, (BasicArticleLight)article, (Timestamp)new Timestamp(System.currentTimeMillis()));
                r.addCell((Object)((QuantityComplete)calcN.getValue()).getQuantity(), new String[0]);
                r.addCell((Object)((QuantityComplete)calcN.getValue()).getUnit().getShortName(), new String[0]);
                r.addCell((Object)absStore, new String[0]);
                r.addCell((Object)article.getMainStoreUnit().getShortName(), new String[0]);
                r.addCell((Object)userStore, new String[0]);
                r.addCell((Object)article.getMainStoreUnit().getShortName(), new String[0]);
                if (includeActualStock) {
                    StoreQuantityComplete atStock = (StoreQuantityComplete)stocks.get(article);
                    if (atStock == null) {
                        atStock = new StoreQuantityComplete(Long.valueOf(0L), article.getFloatStoreUnit());
                    }
                    double calc = absStore;
                    double stock = UnitConversionToolkit.convertUnit((UnitComplete)atStock.getUnit(), (UnitComplete)article.getFloatStoreUnit(), (double)atStock.getAmount().longValue(), (BasicArticleLight)article, (Timestamp)new Timestamp(System.currentTimeMillis()));
                    double order = Math.max(0.0, calc - stock);
                    r.addCell((Object)article.getFloatStoreUnit().getShortName(), new String[0]);
                    r.addCell((Object)calc, new String[0]);
                    r.addCell((Object)stock, new String[0]);
                    r.addCell((Object)order, new String[0]);
                }
                if (article.getStoreConditions().isEmpty()) {
                    r.addCell((Object)"", new String[0]);
                } else {
                    r.addCell((Object)ArticleToolkit.getFirstStoreCondition(article).getPosition().getStore().getCode(), new String[0]);
                }
                SupplierConditionComplete s = ArticleToolkit.getCheapestSupplier(article, (Node<UnitComplete>)qq.getChildNamed(new String[]{"unit"}), (Node<Object>)qq.getChildNamed(new String[]{"quantity"}), false, null, settings, this, this.accessor, new Timestamp(System.currentTimeMillis()));
                if (s == null) {
                    r.addCell((Object)"", new String[0]);
                    r.addCell((Object)"", new String[0]);
                    r.addCell((Object)"", new String[0]);
                    r.addCell((Object)article.getPriceUnit().getShortName(), new String[0]);
                    r.addCell((Object)"", new String[0]);
                    r.addCell((Object)"", new String[0]);
                } else {
                    r.addCell((Object)(s.getSupplier().getNumber() + " - " + s.getSupplier().getName()), new String[0]);
                    r.addCell((Object)((StepPriceFunctionComplete)s.getStepPrice().getSteps().get(0)).getPrice().getPrice(), new String[0]);
                    r.addCell((Object)((StepPriceFunctionComplete)s.getStepPrice().getSteps().get(0)).getPrice().getCurrency().getCode(), new String[0]);
                    r.addCell((Object)article.getPriceUnit().getShortName(), new String[0]);
                    double na = UnitConversionToolkit.convertUnit((UnitComplete)unroundedUnit, (UnitComplete)article.getPriceUnit(), (double)unroundedQty, (BasicArticleLight)article, (Timestamp)new Timestamp(System.currentTimeMillis()));
                    double costs = na * ((StepPriceFunctionComplete)s.getStepPrice().getSteps().get(0)).getPrice().getPrice();
                    r.addCell((Object)costs, new String[0]);
                    r.addCell((Object)((StepPriceFunctionComplete)s.getStepPrice().getSteps().get(0)).getPrice().getCurrency().getCode(), new String[0]);
                }
                PackagingQuantityFormulaCoverter pc = (PackagingQuantityFormulaCoverter)ConverterRegistry.getConverter(PackagingQuantityFormulaCoverter.class);
                r.addCell((Object)pc.convert(article, (Node<BasicArticleComplete>)null, new Object[0]), new String[0]);
                r.addCell((Object)ArticleToolkit.getPurchaseWaste(article, false), new String[0]);
                r.addCell((Object)ArticleToolkit.getCookingWaste(article, null, false), new String[0]);
                r.addCell((Object)article.getAllergenApproveState(), new String[0]);
                r.addCell((Object)(article.getAllergensApproved() != false ? Words.YES : Words.NO_ANSWER), new String[0]);
                r.addCell((Object)article.getLastAllergensApproved(), new String[0]);
                String al = "";
                Collections.sort(article.getAllergenDeclarations());
                for (AllergenDeclarationComplete dec : article.getAllergenDeclarations()) {
                    if (!Boolean.TRUE.equals(dec.getDeclare())) continue;
                    al = al + dec.getCharacteristic().getCode();
                    if (Boolean.TRUE.equals(dec.getContainsTraces())) {
                        al = al + "*";
                    }
                    al = al + ", ";
                }
                if (!al.isEmpty()) {
                    al = al.substring(0, al.length() - 2);
                }
                r.addCell((Object)al, new String[0]);
                r.addCell((Object)article.getCategory().getParent().getParent().getName(), new String[0]);
                r.addCell((Object)article.getCategory().getParent().getName(), new String[0]);
                r.addCell((Object)article.getCategory().getName(), new String[0]);
                r.addCell((Object)article.getGmcCode(), new String[0]);
                rows.add(r);
            }
            catch (Exception e) {
                log.error("Error in Article", (Throwable)e);
                throw new ClientRemoteException("Error in article " + article.getNumber() + " - " + article.getName() + ".", null, new String[0]);
            }
            ++count;
        }
        rows.addAll(this.getSummary(bondedState));
        return rows;
    }

    private List<ExcelRow> getSummary(BondedStateE bondedState) {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        rows.add(new ExcelRow());
        ExcelRow bonded = new ExcelRow();
        bonded.addCell((Object)"Bonded", new String[0]);
        bonded.addCell((Object)((BondedStateEConverter)ConverterRegistry.getConverter(BondedStateEConverter.class)).convert(bondedState, null, new Object[0]), new String[0]);
        rows.add(bonded);
        ExcelRow hint = new ExcelRow();
        hint.addCell((Object)"", new String[0]);
        hint.addCell((Object)"* = bonded Article", new String[0]);
        rows.add(hint);
        return rows;
    }

    public void addWarnings(Map<FlightLight, List<String>> warnings2) {
        this.warnings.putAll(warnings2);
    }

    public void addWarnings2(Map<CustomerLight, List<String>> warnings2) {
        this.warnings2.putAll(warnings2);
    }

    public List<ExcelRow> getWarnings() {
        ExcelRow r;
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        ExcelRow h = new ExcelRow(true);
        h.addCell((Object)"Calculate Article Warnings", new String[0]);
        rows.add(h);
        h = new ExcelRow(true);
        h.addCell((Object)"Std", new String[0]);
        h.addCell((Object)"Outbound Code", new String[0]);
        h.addCell((Object)"Customer Code", new String[0]);
        h.addCell((Object)"Warning", new String[0]);
        rows.add(h);
        for (Map.Entry<FlightLight, List<String>> entry : this.warnings.entrySet()) {
            for (String ws : entry.getValue()) {
                r = new ExcelRow();
                r.addCell(entry.getKey() != null ? entry.getKey().getStd() : "", new String[0]);
                r.addCell((Object)(entry.getKey() != null ? entry.getKey().getOutboundCode() : ""), new String[0]);
                r.addCell((Object)(entry.getKey() != null ? entry.getKey().getCustomer().getCode() : ""), new String[0]);
                r.addCell((Object)ws, new String[0]);
                rows.add(r);
            }
        }
        for (Map.Entry<FlightLight, List<String>> entry : this.warnings2.entrySet()) {
            for (String ws : entry.getValue()) {
                r = new ExcelRow();
                r.addCell((Object)"", new String[0]);
                r.addCell((Object)"", new String[0]);
                r.addCell((Object)(entry.getKey() != null ? ((CustomerLight)entry.getKey()).getCode() : ""), new String[0]);
                r.addCell((Object)ws, new String[0]);
                rows.add(r);
            }
        }
        return rows;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel no;
        private TextLabel name;
        private TextLabel customer;
        private InputComboBox2 amount;
        private QuantityRenderer rounded;
        private QuantityRenderer unRounded;
        private DeleteButton delete;
        private ArticleInfoButton info;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.no = new TextLabel(m.getNode().getChildNamed(new String[]{"article-number"}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.name = new TextLabel(m.getNode().getChildNamed(new String[]{"article-name"}));
            Node qn = m.getNode().getChildNamed(new String[]{"userQty"});
            if (qn == null) {
                QuantityComplete qt = (QuantityComplete)m.getNode().getChildNamed(new String[]{"roundedQty"}).getValue();
                QuantityComplete q = new QuantityComplete(qt);
                qn = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
                qn.setName("userQty");
                m.getNode().addChild(qn, 0L);
            }
            this.customer = new TextLabel(m.getNode().getChildNamed(new String[]{"customer"}), ConverterRegistry.getConverter(CustomerCodeConverter.class));
            Node dateNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
            this.info = new ArticleInfoButton((Node<BasicArticleReference>)this.model.getNode().getChildNamed(new String[]{"article"}), (Node<Date>)dateNode, 1062347);
            Node qqn = qn.getChildNamed(new String[]{"quantity"});
            this.amount = new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            List units = UnitConversionToolkit.getPossibleUnits((BasicArticleLight)((BasicArticleComplete)m.getNode().getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class)), (Timestamp)new Timestamp(System.currentTimeMillis()), (boolean)true, (SystemSettingsComplete)ArticleDetailsPanel.this.settings);
            this.amount.setPossibleUnits(INodeCreator.getDefaultImpl().createNodes(units, false));
            this.amount.setNode(qqn, qn.getChildNamed(new String[]{"unit"}));
            this.rounded = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(new String[]{"roundedQty"}), (Converter<?, ?>)ConverterRegistry.getConverter(QuantityConverter2DecimalUnnormalizedNodeBased.class));
            this.unRounded = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(new String[]{"unroundedQty"}), (Converter<?, ?>)ConverterRegistry.getConverter(QuantityConverter2DecimalUnnormalizedNodeBased.class));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.no);
            this.add(this.name);
            this.add(this.info);
            this.add(this.customer);
            this.add(this.amount);
            this.add(this.rounded);
            this.add(this.unRounded);
            this.add(this.delete);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.name.kill();
            this.rounded.kill();
            this.unRounded.kill();
            this.amount.kill();
            this.delete.kill();
            this.info.kill();
            this.customer.kill();
            this.no = null;
            this.name = null;
            this.customer = null;
            this.rounded = null;
            this.unRounded = null;
            this.amount = null;
            this.delete = null;
            this.info = null;
            ArticleDetailsPanel.this.settings = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"article-number"}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new String[]{"article-name"}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new String[]{"customer"}).getValue();
                }
                case 3: {
                    return this.rounded.getNode().getValue();
                }
                case 4: {
                    return this.unRounded.getNode().getValue();
                }
                case 5: {
                    return this.amount.getValueNode().getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.no.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.info.setEnabled(isEnabled);
            this.customer.setEnabled(isEnabled);
            this.rounded.setEnabled(isEnabled);
            this.unRounded.setEnabled(isEnabled);
            this.amount.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                ArticleDetailsPanel.this.removeNodeFromList(this.model.getNode());
            }
        }

        public void updateAmount() {
            this.rounded.setNode(this.model.getNode().getChildNamed(new String[]{"roundedQty"}));
            this.unRounded.setNode(this.model.getNode().getChildNamed(new String[]{"unroundedQty"}));
            this.amount.setNode(this.model.getNode().getChildNamed(new String[]{"userQty"}));
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.no.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(TableRowImpl.this.no.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.info.getPreferredSize().getWidth())), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                TableRowImpl.this.info.setLocation(TableRowImpl.this.name.getX() + TableRowImpl.this.name.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.info.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.info.setSize(TableRowImpl.this.info.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.customer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.rounded.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.rounded.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.rounded.setSize(TableRowImpl.this.rounded.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.unRounded.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.unRounded.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.unRounded.setSize(TableRowImpl.this.unRounded.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.amount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.amount.setSize(TableRowImpl.this.amount.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            ArticleDetailsPanel.this.articleSearch.setLocation(10, 10);
            ArticleDetailsPanel.this.articleSearch.setSize(250, (int)ArticleDetailsPanel.this.articleSearch.getPreferredSize().getHeight());
            ArticleDetailsPanel.this.add.setLocation(ArticleDetailsPanel.this.articleSearch.getX() + ArticleDetailsPanel.this.articleSearch.getWidth() + 10, (int)((double)(ArticleDetailsPanel.this.articleSearch.getY() + ArticleDetailsPanel.this.articleSearch.getHeight()) - ArticleDetailsPanel.this.add.getPreferredSize().getHeight()));
            ArticleDetailsPanel.this.add.setSize(ArticleDetailsPanel.this.add.getPreferredSize());
            ArticleDetailsPanel.this.clearAll.setLocation(ArticleDetailsPanel.this.add.getX() + ArticleDetailsPanel.this.add.getWidth() + 10, ArticleDetailsPanel.this.add.getY());
            ArticleDetailsPanel.this.clearAll.setSize(ArticleDetailsPanel.this.clearAll.getPreferredSize());
            ArticleDetailsPanel.this.results.setLocation(1, ArticleDetailsPanel.this.articleSearch.getY() + ArticleDetailsPanel.this.articleSearch.getHeight() + 10);
            ArticleDetailsPanel.this.results.setSize(parent.getWidth() - 2, parent.getHeight() - (ArticleDetailsPanel.this.results.getY() + 3));
        }
    }
}

