/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tables.MailTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantDeliverySettingsComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantDeliverySettingsComplete_;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsRestaurantConfig
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private ScrollableBackground scrollPane;
    private Node<RestaurantDeliverySettingsComplete> node;
    private TitledItem<CheckBox> useRestaurantFeature;
    private TitledItem<SearchTextField2> stowingListTemplate;
    private TitledItem<TextField> defaultOrderTime;
    private TitledItem<CheckBox> sendMailAfterCreation;
    private MailTable notificationMails;

    public SettingsRestaurantConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.useRestaurantFeature = new TitledItem<CheckBox>(new CheckBox(), "Activate Restaurant Feature", TitledItem.TitledItemOrientation.EAST);
        this.useRestaurantFeature.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        this.stowingListTemplate = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(SearchTextField2Factory.getStowingTemplateSearchField(true, null), Words.STOWING_LIST_TEMPLATE, TitledItem.TitledItemOrientation.NORTH);
        this.defaultOrderTime = new TitledItem<TextField>(new TextField(null, TextFieldType.DAYTIME), "Default Order Time", TitledItem.TitledItemOrientation.NORTH);
        this.sendMailAfterCreation = new TitledItem<CheckBox>(new CheckBox(), "Send Mail after Order Creation", TitledItem.TitledItemOrientation.EAST);
        this.notificationMails = new MailTable();
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.useRestaurantFeature);
        this.scrollPane.getViewPort().add(this.stowingListTemplate);
        this.scrollPane.getViewPort().add(this.defaultOrderTime);
        this.scrollPane.getViewPort().add(this.sendMailAfterCreation);
        this.scrollPane.getViewPort().add(this.notificationMails);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return "Restaurant Settings";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.useRestaurantFeature.kill();
            this.stowingListTemplate.kill();
            this.defaultOrderTime.kill();
            this.sendMailAfterCreation.kill();
            this.notificationMails.kill();
        }
        this.stowingListTemplate = null;
        this.useRestaurantFeature = null;
        this.defaultOrderTime = null;
        this.sendMailAfterCreation = null;
        this.notificationMails = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            boolean checked = this.useRestaurantFeature.getElement().isChecked() && isEnabled;
            this.useRestaurantFeature.setEnabled(isEnabled);
            this.stowingListTemplate.setEnabled(isEnabled && checked);
            this.defaultOrderTime.setEnabled(isEnabled && checked);
            boolean checked2 = this.sendMailAfterCreation.getElement().isChecked() && isEnabled;
            this.sendMailAfterCreation.setEnabled(isEnabled);
            this.notificationMails.setEnabled(checked2);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.useRestaurantFeature);
            CheckedListAdder.addToList(focusList, this.stowingListTemplate);
            CheckedListAdder.addToList(focusList, this.defaultOrderTime);
            CheckedListAdder.addToList(focusList, this.sendMailAfterCreation);
            CheckedListAdder.addToList(focusList, this.notificationMails);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.useRestaurantFeature.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsRestaurantConfig.this.node.commitThis(RestaurantDeliverySettingsComplete.class);
                RestaurantDeliverySettingsComplete s = (RestaurantDeliverySettingsComplete)SettingsRestaurantConfig.this.node.getValue(RestaurantDeliverySettingsComplete.class);
                s = (RestaurantDeliverySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateRestaurantSettings(s).getValue();
                SettingsRestaurantConfig.this.node.removeExistingValues();
                SettingsRestaurantConfig.this.node.setValue((Object)s, 0L);
                SettingsRestaurantConfig.this.node.updateNode();
                return SettingsRestaurantConfig.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsRestaurantConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsRestaurantConfig.this.changeLoadingState("Load 1/1 Modules");
                Node restaurantSettings = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getRestaurantSettingsCached();
                if (restaurantSettings.getValue() == null) {
                    RestaurantDeliverySettingsComplete settingsComplete = new RestaurantDeliverySettingsComplete();
                    settingsComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
                    restaurantSettings.setValue((Object)settingsComplete, 0L);
                }
                if (((RestaurantDeliverySettingsComplete)restaurantSettings.getValue()).getDefaultOrderTime() == null) {
                    ((RestaurantDeliverySettingsComplete)restaurantSettings.getValue()).setDefaultOrderTime(DateUtil.getSQLTime((int)18, (int)0, (int)0));
                }
                return restaurantSettings;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsRestaurantConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.setNode(node);
    }

    private void setNode(Node<RestaurantDeliverySettingsComplete> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        node.updateNode();
        this.useRestaurantFeature.getElement().setNode(node.getChildNamed(RestaurantDeliverySettingsComplete_.useRestaurantDelivery));
        this.stowingListTemplate.getElement().setNode(node.getChildNamed(RestaurantDeliverySettingsComplete_.defaultStowingList));
        this.defaultOrderTime.getElement().setNode(node.getChildNamed(RestaurantDeliverySettingsComplete_.defaultOrderTime));
        this.sendMailAfterCreation.getElement().setNode(node.getChildNamed(RestaurantDeliverySettingsComplete_.sendMailAfterCreation));
        this.notificationMails.getModel().setNode(node.getChildNamed(RestaurantDeliverySettingsComplete_.mailReceipts));
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsRestaurantConfig.this.layoutAnimation(parent);
            if (SettingsRestaurantConfig.this.isInserted) {
                SettingsRestaurantConfig.this.scrollPane.setLocation(1, 1);
                SettingsRestaurantConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsRestaurantConfig.this.isInserted) {
                h = (int)((double)h + (SettingsRestaurantConfig.this.useRestaurantFeature.getPreferredSize().getHeight() + (double)border));
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 40;
            int border = 10;
            w /= 2;
            if (SettingsRestaurantConfig.this.isInserted) {
                SettingsRestaurantConfig.this.useRestaurantFeature.setLocation(border, border * 2);
                SettingsRestaurantConfig.this.useRestaurantFeature.setSize(SettingsRestaurantConfig.this.useRestaurantFeature.getPreferredSize());
                SettingsRestaurantConfig.this.stowingListTemplate.setLocation(border, SettingsRestaurantConfig.this.useRestaurantFeature.getY() + SettingsRestaurantConfig.this.useRestaurantFeature.getHeight() + border);
                SettingsRestaurantConfig.this.stowingListTemplate.setSize(200, (int)SettingsRestaurantConfig.this.stowingListTemplate.getPreferredSize().getHeight());
                SettingsRestaurantConfig.this.defaultOrderTime.setLocation(border, SettingsRestaurantConfig.this.stowingListTemplate.getY() + SettingsRestaurantConfig.this.stowingListTemplate.getHeight() + border);
                SettingsRestaurantConfig.this.defaultOrderTime.setSize(SettingsRestaurantConfig.this.defaultOrderTime.getPreferredSize());
                SettingsRestaurantConfig.this.sendMailAfterCreation.setLocation(border, SettingsRestaurantConfig.this.defaultOrderTime.getY() + SettingsRestaurantConfig.this.defaultOrderTime.getHeight() + border);
                SettingsRestaurantConfig.this.sendMailAfterCreation.setSize(SettingsRestaurantConfig.this.sendMailAfterCreation.getPreferredSize());
                SettingsRestaurantConfig.this.notificationMails.setLocation(border, SettingsRestaurantConfig.this.sendMailAfterCreation.getY() + SettingsRestaurantConfig.this.sendMailAfterCreation.getHeight() + border);
                SettingsRestaurantConfig.this.notificationMails.setSize(300, 400);
            }
        }
    }
}

