/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.DayTimeConverter;
import ch.icit.pegasus.client.converter.FlightTypesConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.FlightTransactionGeneratorServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.FlightTransactionGeneratorSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;

public class SettingsFlightConfig
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<SystemSettingsComplete> node;
    private ScrollableBackground scrollPane;
    private TitledItem<ComboBox> defaultFS_type;
    private TitledItem<CheckBox> groupSpecialMealsOnLabel;
    private TitledItem<TextField> maxPaxPerLeg;
    private TitledItem<TextField> maxLabelEntries;
    private TitledItem<TextField> defaultDeliverySlipSender;
    private TitledItem<CheckBox> autoCheckout;
    private TitledItem<DateChooser> autoCheckoutStartDate;
    private TitledItem<CheckBox> scheduledFlightTransactionProcessing;
    private TitledItem<CheckBox> autoUploadSobData;
    private TitledItem<CheckBox> multipleHomeBaseWarning;
    private TitledItem<CheckBox> forceHaulType;
    private TitledItem<CheckBox> showTotalPaxOnSheets;
    private TitledItem<ComboBox> defaultAdditionalLabelColor;
    private TitledItem<CheckBox> sortFlightAdditionalBySequence;
    private TitledItem<CheckBox> printAdditionalOnSeparateLabel;
    private TitledItem<CheckBox> enableProductDefaultLabelColor;
    private TitledItem<CheckBox> enableServiceLabelColor;
    private TitledItem<CheckBox> changeFlightStateToEnRouteWhenRCCheckout;
    private TitledItem<StorePositionSearchBox> defaultFlightCheckinPosition;

    public SettingsFlightConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.defaultFS_type = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(FlightTypesConverter.class)), "Default FS Type", TitledItem.TitledItemOrientation.NORTH);
        this.groupSpecialMealsOnLabel = new TitledItem<CheckBox>(new CheckBox(), "Group special meals on the label", TitledItem.TitledItemOrientation.EAST);
        this.maxPaxPerLeg = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), "Max Pax per Leg (over all Cabin Classes)", TitledItem.TitledItemOrientation.NORTH);
        this.maxLabelEntries = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), "Max Label Entries", TitledItem.TitledItemOrientation.NORTH);
        this.defaultDeliverySlipSender = new TitledItem<TextField>(new TextField(null, TextFieldType.NORMAL), "Default Delivery Slip Sender", TitledItem.TitledItemOrientation.NORTH);
        this.autoCheckout = new TitledItem<CheckBox>(new CheckBox(), "Enable Auto checkout", TitledItem.TitledItemOrientation.EAST);
        this.autoCheckout.getElement().addButtonListener(this);
        this.autoCheckoutStartDate = new TitledItem<DateChooser>(new DateChooser(), "Start Date", TitledItem.TitledItemOrientation.NORTH);
        this.autoCheckoutStartDate.getElement().setIsTimestamp(true);
        this.scheduledFlightTransactionProcessing = new TitledItem<CheckBox>(new CheckBox(), Words.SCHEDULED_FLIGHT_TRANSACTION_PROCESSING, TitledItem.TitledItemOrientation.EAST);
        this.autoUploadSobData = new TitledItem<CheckBox>(new CheckBox(), Words.AUT_UPLOAD_SOB_DATA, TitledItem.TitledItemOrientation.EAST);
        this.multipleHomeBaseWarning = new TitledItem<CheckBox>(new CheckBox(), "Warn if Home Base is in Leg List more than twice", TitledItem.TitledItemOrientation.EAST);
        this.forceHaulType = new TitledItem<CheckBox>(new CheckBox(), "Force Haul Type in Flight and Flight Schedule", TitledItem.TitledItemOrientation.EAST);
        this.showTotalPaxOnSheets = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_TOTAL_PAX_ON_REPORTS, TitledItem.TitledItemOrientation.EAST);
        this.defaultAdditionalLabelColor = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(ColorConverter.class), true), Words.DEFAULT_ADDITIONAL_LABEL_COLOR, TitledItem.TitledItemOrientation.NORTH);
        this.sortFlightAdditionalBySequence = new TitledItem<CheckBox>(new CheckBox(), Words.SORT_FLIGHT_ADDITIONAL_BY_SEQUENCE, TitledItem.TitledItemOrientation.EAST);
        this.printAdditionalOnSeparateLabel = new TitledItem<CheckBox>(new CheckBox(), Words.PRINT_ADDITIONAL_ON_SEPARATE_LABEL, TitledItem.TitledItemOrientation.EAST);
        this.enableProductDefaultLabelColor = new TitledItem<CheckBox>(new CheckBox(), Words.ENABLE_PRODUCT_DEFAULT_LABEL_COLOR, TitledItem.TitledItemOrientation.EAST);
        this.enableServiceLabelColor = new TitledItem<CheckBox>(new CheckBox(), Words.ENABLE_SERVICE_LABEL_COLOR, TitledItem.TitledItemOrientation.EAST);
        this.changeFlightStateToEnRouteWhenRCCheckout = new TitledItem<CheckBox>(new CheckBox(), Words.CHANGE_FLIGHT_STATE_TO_EN_ROUTE_WHEN_RC_CHECKOUT, TitledItem.TitledItemOrientation.EAST);
        this.defaultFlightCheckinPosition = new TitledItem<StorePositionSearchBox>(new StorePositionSearchBox(), "Default Flight Checkin Store", TitledItem.TitledItemOrientation.NORTH);
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.defaultFS_type);
        this.scrollPane.getViewPort().add(this.groupSpecialMealsOnLabel);
        this.scrollPane.getViewPort().add(this.maxPaxPerLeg);
        this.scrollPane.getViewPort().add(this.maxLabelEntries);
        this.scrollPane.getViewPort().add(this.autoCheckout);
        this.scrollPane.getViewPort().add(this.autoCheckoutStartDate);
        this.scrollPane.getViewPort().add(this.scheduledFlightTransactionProcessing);
        this.scrollPane.getViewPort().add(this.autoUploadSobData);
        this.scrollPane.getViewPort().add(this.multipleHomeBaseWarning);
        this.scrollPane.getViewPort().add(this.forceHaulType);
        this.scrollPane.getViewPort().add(this.showTotalPaxOnSheets);
        this.scrollPane.getViewPort().add(this.defaultAdditionalLabelColor);
        this.scrollPane.getViewPort().add(this.sortFlightAdditionalBySequence);
        this.scrollPane.getViewPort().add(this.printAdditionalOnSeparateLabel);
        this.scrollPane.getViewPort().add(this.enableProductDefaultLabelColor);
        this.scrollPane.getViewPort().add(this.enableServiceLabelColor);
        this.scrollPane.getViewPort().add(this.changeFlightStateToEnRouteWhenRCCheckout);
        this.scrollPane.getViewPort().add(this.defaultFlightCheckinPosition);
        this.scrollPane.getViewPort().add(this.defaultDeliverySlipSender);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return "Settings";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.defaultFS_type.kill();
            this.maxPaxPerLeg.kill();
            this.maxLabelEntries.kill();
            this.autoCheckout.kill();
            this.autoCheckoutStartDate.kill();
            this.scheduledFlightTransactionProcessing.kill();
            this.autoUploadSobData.kill();
            this.multipleHomeBaseWarning.kill();
            this.forceHaulType.kill();
            this.showTotalPaxOnSheets.kill();
            this.defaultAdditionalLabelColor.kill();
            this.sortFlightAdditionalBySequence.kill();
            this.printAdditionalOnSeparateLabel.kill();
            this.enableProductDefaultLabelColor.kill();
            this.enableServiceLabelColor.kill();
            this.changeFlightStateToEnRouteWhenRCCheckout.kill();
            this.defaultFlightCheckinPosition.kill();
            this.defaultDeliverySlipSender.kill();
        }
        this.defaultFS_type = null;
        this.maxPaxPerLeg = null;
        this.maxLabelEntries = null;
        this.autoCheckout = null;
        this.autoCheckoutStartDate = null;
        this.scheduledFlightTransactionProcessing = null;
        this.autoUploadSobData = null;
        this.multipleHomeBaseWarning = null;
        this.forceHaulType = null;
        this.showTotalPaxOnSheets = null;
        this.defaultAdditionalLabelColor = null;
        this.sortFlightAdditionalBySequence = null;
        this.printAdditionalOnSeparateLabel = null;
        this.enableProductDefaultLabelColor = null;
        this.enableServiceLabelColor = null;
        this.changeFlightStateToEnRouteWhenRCCheckout = null;
        this.defaultFlightCheckinPosition = null;
        this.defaultDeliverySlipSender = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.defaultFS_type.setEnabled(isEnabled);
            this.maxPaxPerLeg.setEnabled(isEnabled);
            this.maxLabelEntries.setEnabled(isEnabled);
            this.autoCheckout.setEnabled(isEnabled);
            this.autoCheckoutStartDate.setEnabled(isEnabled && this.autoCheckout.getElement().isChecked());
            this.autoUploadSobData.setEnabled(isEnabled);
            this.multipleHomeBaseWarning.setEnabled(isEnabled);
            this.forceHaulType.setEnabled(isEnabled);
            this.showTotalPaxOnSheets.setEnabled(isEnabled);
            this.defaultAdditionalLabelColor.setEnabled(isEnabled);
            this.sortFlightAdditionalBySequence.setEnabled(isEnabled);
            this.printAdditionalOnSeparateLabel.setEnabled(isEnabled);
            this.enableProductDefaultLabelColor.setEnabled(isEnabled);
            this.enableServiceLabelColor.setEnabled(isEnabled);
            this.changeFlightStateToEnRouteWhenRCCheckout.setEnabled(isEnabled);
            this.defaultFlightCheckinPosition.setEnabled(isEnabled);
            this.defaultDeliverySlipSender.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.defaultFS_type);
            CheckedListAdder.addToList(focusList, this.maxPaxPerLeg);
            CheckedListAdder.addToList(focusList, this.maxLabelEntries);
            CheckedListAdder.addToList(focusList, this.defaultDeliverySlipSender);
            CheckedListAdder.addToList(focusList, this.autoCheckout);
            CheckedListAdder.addToList(focusList, this.autoCheckoutStartDate);
            CheckedListAdder.addToList(focusList, this.scheduledFlightTransactionProcessing);
            CheckedListAdder.addToList(focusList, this.autoUploadSobData);
            CheckedListAdder.addToList(focusList, this.multipleHomeBaseWarning);
            CheckedListAdder.addToList(focusList, this.forceHaulType);
            CheckedListAdder.addToList(focusList, this.showTotalPaxOnSheets);
            CheckedListAdder.addToList(focusList, this.defaultAdditionalLabelColor);
            CheckedListAdder.addToList(focusList, this.sortFlightAdditionalBySequence);
            CheckedListAdder.addToList(focusList, this.printAdditionalOnSeparateLabel);
            CheckedListAdder.addToList(focusList, this.enableProductDefaultLabelColor);
            CheckedListAdder.addToList(focusList, this.enableServiceLabelColor);
            CheckedListAdder.addToList(focusList, this.changeFlightStateToEnRouteWhenRCCheckout);
            CheckedListAdder.addToList(focusList, this.defaultFlightCheckinPosition);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.defaultFS_type.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsFlightConfig.this.node.commitThis(SystemSettingsComplete.class);
                SystemSettingsComplete s = (SystemSettingsComplete)SettingsFlightConfig.this.node.getValue(SystemSettingsComplete.class);
                s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSystemSettings(s).getValue();
                FlightTransactionGeneratorSettingsComplete processingSettings = (FlightTransactionGeneratorSettingsComplete)((FlightTransactionGeneratorServiceManager)ServiceManagerRegistry.getService(FlightTransactionGeneratorServiceManager.class)).getSettings().getValue();
                if (Boolean.TRUE.equals(s.getScheduledFlightTransactionProcessing())) {
                    TimerServiceSettingsComplete ts = processingSettings.getTimerServiceSettings();
                    if (ts == null) {
                        ts = new TimerServiceSettingsComplete();
                        DailyTimeComplete daily = new DailyTimeComplete();
                        daily.setHours(Integer.valueOf(1));
                        daily.setMinutes(Integer.valueOf(0));
                        daily.setSeconds(Integer.valueOf(0));
                        ts.setTimerServiceConfig((TimerServiceConfigComplete)daily);
                        ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(ts).getValue();
                        processingSettings.setTimerServiceSettings(ts);
                    } else {
                        TimerServiceConfigComplete timerServiceConfig = ts.getTimerServiceConfig();
                        DailyTimeComplete dayTime = (DailyTimeComplete)timerServiceConfig;
                        dayTime.setHours(DayTimeConverter.getHours((Time)processingSettings.getProcessingTime()));
                        dayTime.setMinutes(DayTimeConverter.getMinutes((Time)processingSettings.getProcessingTime()));
                    }
                    ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)processingSettings);
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.FLIGHT_TRANSACTION_GENERATOR, s.getScheduledFlightTransactionProcessing().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.FLIGHT_TRANSACTION_GENERATOR);
                    ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)processingSettings);
                }
                SettingsFlightConfig.this.node.removeExistingValues();
                SettingsFlightConfig.this.node.setValue((Object)s, 0L);
                SettingsFlightConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsFlightConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsFlightConfig.this.changeLoadingState("Load 1/3 Modules");
                StaticEnumServiceManager.getAllFlightTypes();
                SettingsFlightConfig.this.changeLoadingState("Load 2/3 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                SettingsFlightConfig.this.changeLoadingState("Load 3/3 Modules");
                return ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsFlightConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<?> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        this.defaultFS_type.getElement().refreshPossibleValues(NodeToolkit.getAffixList(FlightTypeE.class));
        this.defaultFS_type.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.defaultFlightScheduleType));
        this.groupSpecialMealsOnLabel.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.groupSpecialMealsOnLabel));
        this.maxPaxPerLeg.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.maxNumPax));
        this.maxLabelEntries.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.maxLabelEntries));
        this.autoCheckout.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.autoCheckout));
        this.autoCheckoutStartDate.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.autoCheckoutStart));
        this.scheduledFlightTransactionProcessing.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.scheduledFlightTransactionProcessing));
        this.autoUploadSobData.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.autoUploadSoBDataOnStateChangeEnRoute));
        this.multipleHomeBaseWarning.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.mutlipleHomebaseWarning));
        this.forceHaulType.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.forceHaulType));
        this.showTotalPaxOnSheets.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.showTotalPaxOnSheets));
        this.defaultAdditionalLabelColor.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ColorComplete.class));
        this.defaultAdditionalLabelColor.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.defaultAdditionalLabelColor));
        this.sortFlightAdditionalBySequence.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.sortFlightAdditionalsBySequence));
        this.printAdditionalOnSeparateLabel.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.printAdditionalOnSeparateLabel));
        this.enableProductDefaultLabelColor.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.enableProductDefaultLabelColor));
        this.enableServiceLabelColor.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.enableServiceLabelColor));
        this.changeFlightStateToEnRouteWhenRCCheckout.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.changeFlightStateToEnRouteWhenRcCheckout));
        this.defaultFlightCheckinPosition.getElement().setNode((Node<StorePositionLight>)node.getChildNamed(SystemSettingsComplete_.defaultFlightCheckinPosition));
        this.defaultDeliverySlipSender.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.defaultDeliverySlipSender));
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> focusList = new ArrayList<ScreenValidationObject>();
        return focusList;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsFlightConfig.this.layoutAnimation(parent);
            if (SettingsFlightConfig.this.isInserted) {
                SettingsFlightConfig.this.scrollPane.setLocation(1, 1);
                SettingsFlightConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsFlightConfig.this.isInserted) {
                h = (int)((double)h + SettingsFlightConfig.this.defaultFS_type.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.groupSpecialMealsOnLabel.getPreferredSize().getHeight());
                h += border / 4;
                h = (int)((double)h + SettingsFlightConfig.this.autoCheckoutStartDate.getPreferredSize().getHeight());
                h += border / 4;
                h = (int)((double)h + SettingsFlightConfig.this.scheduledFlightTransactionProcessing.getPreferredSize().getHeight());
                h += border / 4;
                h = (int)((double)h + SettingsFlightConfig.this.autoUploadSobData.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.maxPaxPerLeg.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.defaultDeliverySlipSender.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.multipleHomeBaseWarning.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.forceHaulType.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.showTotalPaxOnSheets.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.defaultAdditionalLabelColor.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.sortFlightAdditionalBySequence.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.printAdditionalOnSeparateLabel.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.enableProductDefaultLabelColor.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.enableServiceLabelColor.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.changeFlightStateToEnRouteWhenRCCheckout.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightConfig.this.defaultFlightCheckinPosition.getPreferredSize().getHeight());
                h += border;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (SettingsFlightConfig.this.isInserted) {
                SettingsFlightConfig.this.defaultFS_type.setLocation(border, border);
                SettingsFlightConfig.this.defaultFS_type.setSize(100, (int)SettingsFlightConfig.this.defaultFS_type.getPreferredSize().getHeight());
                SettingsFlightConfig.this.groupSpecialMealsOnLabel.setLocation(border, SettingsFlightConfig.this.defaultFS_type.getY() + SettingsFlightConfig.this.defaultFS_type.getHeight() + border);
                SettingsFlightConfig.this.groupSpecialMealsOnLabel.setSize(SettingsFlightConfig.this.groupSpecialMealsOnLabel.getPreferredSize());
                SettingsFlightConfig.this.autoCheckoutStartDate.setLocation((int)((double)border + SettingsFlightConfig.this.autoCheckout.getPreferredSize().getWidth() + (double)border), SettingsFlightConfig.this.groupSpecialMealsOnLabel.getY() + SettingsFlightConfig.this.groupSpecialMealsOnLabel.getHeight() + border / 4);
                SettingsFlightConfig.this.autoCheckoutStartDate.setSize(SettingsFlightConfig.this.autoCheckoutStartDate.getPreferredSize());
                SettingsFlightConfig.this.autoCheckout.setLocation(border, (int)((double)(SettingsFlightConfig.this.autoCheckoutStartDate.getY() + SettingsFlightConfig.this.autoCheckoutStartDate.getHeight()) - SettingsFlightConfig.this.autoCheckout.getPreferredSize().getHeight()));
                SettingsFlightConfig.this.autoCheckout.setSize(SettingsFlightConfig.this.autoCheckout.getPreferredSize());
                SettingsFlightConfig.this.scheduledFlightTransactionProcessing.setLocation(border, SettingsFlightConfig.this.autoCheckout.getY() + SettingsFlightConfig.this.autoCheckout.getHeight() + border / 4);
                SettingsFlightConfig.this.scheduledFlightTransactionProcessing.setSize(SettingsFlightConfig.this.scheduledFlightTransactionProcessing.getPreferredSize());
                SettingsFlightConfig.this.autoUploadSobData.setLocation(border, SettingsFlightConfig.this.scheduledFlightTransactionProcessing.getY() + SettingsFlightConfig.this.scheduledFlightTransactionProcessing.getHeight() + border / 4);
                SettingsFlightConfig.this.autoUploadSobData.setSize(SettingsFlightConfig.this.autoUploadSobData.getPreferredSize());
                SettingsFlightConfig.this.maxPaxPerLeg.setLocation(border, SettingsFlightConfig.this.autoUploadSobData.getY() + SettingsFlightConfig.this.autoUploadSobData.getHeight() + border);
                SettingsFlightConfig.this.maxPaxPerLeg.setSize(120, (int)SettingsFlightConfig.this.maxPaxPerLeg.getPreferredSize().getHeight());
                SettingsFlightConfig.this.maxLabelEntries.setLocation(SettingsFlightConfig.this.maxPaxPerLeg.getX() + SettingsFlightConfig.this.maxPaxPerLeg.getWidth() + border, SettingsFlightConfig.this.maxPaxPerLeg.getY());
                SettingsFlightConfig.this.maxLabelEntries.setSize(120, (int)SettingsFlightConfig.this.maxLabelEntries.getPreferredSize().getHeight());
                SettingsFlightConfig.this.defaultDeliverySlipSender.setLocation(border, SettingsFlightConfig.this.maxPaxPerLeg.getY() + SettingsFlightConfig.this.maxPaxPerLeg.getHeight() + border);
                SettingsFlightConfig.this.defaultDeliverySlipSender.setSize(350, (int)SettingsFlightConfig.this.defaultDeliverySlipSender.getPreferredSize().getHeight());
                SettingsFlightConfig.this.multipleHomeBaseWarning.setLocation(border, SettingsFlightConfig.this.defaultDeliverySlipSender.getY() + SettingsFlightConfig.this.defaultDeliverySlipSender.getHeight() + border);
                SettingsFlightConfig.this.multipleHomeBaseWarning.setSize(350, (int)SettingsFlightConfig.this.multipleHomeBaseWarning.getPreferredSize().getHeight());
                SettingsFlightConfig.this.forceHaulType.setLocation(border, SettingsFlightConfig.this.multipleHomeBaseWarning.getY() + SettingsFlightConfig.this.multipleHomeBaseWarning.getHeight() + border / 4);
                SettingsFlightConfig.this.forceHaulType.setSize(350, (int)SettingsFlightConfig.this.multipleHomeBaseWarning.getPreferredSize().getHeight());
                SettingsFlightConfig.this.showTotalPaxOnSheets.setLocation(border, SettingsFlightConfig.this.forceHaulType.getY() + SettingsFlightConfig.this.forceHaulType.getHeight() + border);
                SettingsFlightConfig.this.showTotalPaxOnSheets.setSize(SettingsFlightConfig.this.showTotalPaxOnSheets.getPreferredSize());
                SettingsFlightConfig.this.defaultAdditionalLabelColor.setLocation(border, SettingsFlightConfig.this.showTotalPaxOnSheets.getY() + SettingsFlightConfig.this.showTotalPaxOnSheets.getHeight() + border);
                SettingsFlightConfig.this.defaultAdditionalLabelColor.setSize(SettingsFlightConfig.this.defaultAdditionalLabelColor.getPreferredSize());
                SettingsFlightConfig.this.sortFlightAdditionalBySequence.setLocation(border, SettingsFlightConfig.this.defaultAdditionalLabelColor.getY() + SettingsFlightConfig.this.defaultAdditionalLabelColor.getHeight() + border);
                SettingsFlightConfig.this.sortFlightAdditionalBySequence.setSize(SettingsFlightConfig.this.sortFlightAdditionalBySequence.getPreferredSize());
                SettingsFlightConfig.this.printAdditionalOnSeparateLabel.setLocation(border, SettingsFlightConfig.this.sortFlightAdditionalBySequence.getY() + SettingsFlightConfig.this.sortFlightAdditionalBySequence.getHeight() + border);
                SettingsFlightConfig.this.printAdditionalOnSeparateLabel.setSize(SettingsFlightConfig.this.printAdditionalOnSeparateLabel.getPreferredSize());
                SettingsFlightConfig.this.enableProductDefaultLabelColor.setLocation(border, SettingsFlightConfig.this.printAdditionalOnSeparateLabel.getY() + SettingsFlightConfig.this.printAdditionalOnSeparateLabel.getHeight() + border);
                SettingsFlightConfig.this.enableProductDefaultLabelColor.setSize(SettingsFlightConfig.this.enableProductDefaultLabelColor.getPreferredSize());
                SettingsFlightConfig.this.enableServiceLabelColor.setLocation(border, SettingsFlightConfig.this.enableProductDefaultLabelColor.getY() + SettingsFlightConfig.this.enableProductDefaultLabelColor.getHeight() + border);
                SettingsFlightConfig.this.enableServiceLabelColor.setSize(SettingsFlightConfig.this.enableServiceLabelColor.getPreferredSize());
                SettingsFlightConfig.this.changeFlightStateToEnRouteWhenRCCheckout.setLocation(border, SettingsFlightConfig.this.enableServiceLabelColor.getY() + SettingsFlightConfig.this.enableServiceLabelColor.getHeight() + border);
                SettingsFlightConfig.this.changeFlightStateToEnRouteWhenRCCheckout.setSize(SettingsFlightConfig.this.changeFlightStateToEnRouteWhenRCCheckout.getPreferredSize());
                SettingsFlightConfig.this.defaultFlightCheckinPosition.setLocation(border, SettingsFlightConfig.this.changeFlightStateToEnRouteWhenRCCheckout.getY() + SettingsFlightConfig.this.changeFlightStateToEnRouteWhenRCCheckout.getHeight() + border);
                SettingsFlightConfig.this.defaultFlightCheckinPosition.setSize(SettingsFlightConfig.this.defaultFlightCheckinPosition.getPreferredSize());
            }
        }
    }
}

