/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.scan.AutoDocumentScanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.scan.AutoDocumentScanSettingsComplete_;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsAutoDocumentScanConfig
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private Node<AutoDocumentScanSettingsComplete> node;
    private ScrollableBackground scrollPane;
    private TitledItem<CheckBox> useAutoScan;

    public SettingsAutoDocumentScanConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.useAutoScan = new TitledItem<CheckBox>(new CheckBox(), "Use Auto Scan Purchase Documents", TitledItem.TitledItemOrientation.EAST);
        this.useAutoScan.getElement().addButtonListener(this);
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.useAutoScan);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return "Settings Auto Document Scan";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.useAutoScan.kill();
        }
        this.useAutoScan = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useAutoScan.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.useAutoScan);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.useAutoScan.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsAutoDocumentScanConfig.this.node.commitThis(AutoDocumentScanSettingsComplete.class);
                AutoDocumentScanSettingsComplete s = (AutoDocumentScanSettingsComplete)SettingsAutoDocumentScanConfig.this.node.getValue(AutoDocumentScanSettingsComplete.class);
                s = (AutoDocumentScanSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)s).getValue();
                SettingsAutoDocumentScanConfig.this.node.removeExistingValues();
                SettingsAutoDocumentScanConfig.this.node.setValue((Object)s, 0L);
                SettingsAutoDocumentScanConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsAutoDocumentScanConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsAutoDocumentScanConfig.this.changeLoadingState("Load 1/1 Modules");
                AutoDocumentScanSettingsComplete value = (AutoDocumentScanSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getDocumentScanRequestSettings().getValue();
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)value, false, false);
                n.removeExistingValues();
                n.setValue((Object)value, 0L);
                n.updateNode();
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsAutoDocumentScanConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<?> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        this.useAutoScan.getElement().setNode(node.getChildNamed(AutoDocumentScanSettingsComplete_.useAutoScan));
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsAutoDocumentScanConfig.this.layoutAnimation(parent);
            if (SettingsAutoDocumentScanConfig.this.isInserted) {
                SettingsAutoDocumentScanConfig.this.scrollPane.setLocation(1, 1);
                SettingsAutoDocumentScanConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsAutoDocumentScanConfig.this.isInserted) {
                h += border;
                h = (int)((double)h + SettingsAutoDocumentScanConfig.this.useAutoScan.getPreferredSize().getHeight());
                h += border;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 40;
            int border = 10;
            w /= 2;
            if (SettingsAutoDocumentScanConfig.this.isInserted) {
                SettingsAutoDocumentScanConfig.this.useAutoScan.setLocation(border, border);
                SettingsAutoDocumentScanConfig.this.useAutoScan.setSize(SettingsAutoDocumentScanConfig.this.useAutoScan.getPreferredSize());
            }
        }
    }
}

