/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice.manager.details.utils;

import ch.icit.pegasus.client.converter.Airport2Converter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.LegListStringConverter;
import ch.icit.pegasus.client.converter.LocationsConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.PriceConverter3;
import ch.icit.pegasus.client.converter.PurchaseOrderInvoiceConverter;
import ch.icit.pegasus.client.converter.RequisitionOrderInvoiceConverter;
import ch.icit.pegasus.client.converter.ServiceProductConverter;
import ch.icit.pegasus.client.converter.TradeGoodsConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.invoice.InvoiceToolkit;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.CellViewFlightStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewModificationStateERenderer;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.handlingcost.AbsolutePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.AbsolutePriceCalculationComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostTypeE;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.FlightInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.FlightInvoiceConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.HandlingCostInvoiceConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight_;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceTypeE;
import ch.icit.pegasus.server.core.dtos.invoice.ProductInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.ProductInvoiceConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.ProductInvoiceItemComplete;
import ch.icit.pegasus.server.core.dtos.invoice.ProductInvoiceItemComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.PurchaseInvoiceConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.RequisitionInvoiceConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.ServiceProductInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.ServiceProductInvoiceConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.TradeGoodInvoiceConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.report.OrderInvoiceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.HandlingCostSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ServiceProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.TradeGoodsSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete_;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductInvoiceItemComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductInvoiceItemComplete_;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConfigFlightPopupInsert
extends PopUpInsert
implements ButtonListener,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private final boolean isNoPro;
    private TextLabel title;
    private InvoiceConfigType type;
    private Table2 table;
    private TitledItem<SearchTextField> searchField;
    private TextButton searchButton;
    private TextButton removeAll;
    private TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>> haulPanel;
    private TitledItem<ComboBox> category;
    private TitledItem<ComboBox> flightState;
    private TitledItem<ComboBox> hourlyWork;
    private TitledItem<CheckBox> onlyClosed;
    private TitledItem<ComboBox> dateType;
    private LoadingAnimation animation;
    private InvoiceTypeE currentInvoiceType;
    private Node node;
    boolean isOpen = false;
    private TitledItem<SearchTextField2> deliveryAirport;

    public ConfigFlightPopupInsert(Node n, InvoiceConfigType type, InvoiceTypeE invoiceType) {
        this.node = n;
        this.type = type;
        this.currentInvoiceType = invoiceType;
        this.border = 10;
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.isSolarCompany = Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType());
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)settings);
        if (this.type == InvoiceConfigType.FLIGHT) {
            this.title = new TextLabel(Words.CHOICE_INVOICE_OPTIONS);
            if (!this.isSolarCompany) {
                MultiHaulTypeSelectionComboBox haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
                this.haulPanel = new TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>>(new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(haulCombo), Words.HAUL_TYPE, TitledItem.TitledItemOrientation.NORTH);
                this.category = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(FlightCategoryComplete.class), ConverterRegistry.getConverter(FlightCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
                this.category.getElement().addItem(Words.ALL);
            }
            this.flightState = new TitledItem<ComboBox>(ComboBoxFactory.getFlightStateComboBox(true), "Flight State", TitledItem.TitledItemOrientation.NORTH);
        } else if (this.type == InvoiceConfigType.SERVICEPRODUCT && this.isNoPro) {
            this.hourlyWork = new TitledItem<ComboBox>(new ComboBox(), "Hourly Work", TitledItem.TitledItemOrientation.NORTH);
            this.hourlyWork.getElement().addItem(Words.ALL);
            this.hourlyWork.getElement().addItem(Words.HOURLY_WORK);
            this.hourlyWork.getElement().addItem(Words.NORMAL);
            this.hourlyWork.getElement().setSelectedItem(Words.ALL);
        }
        this.table = new Table2(false, "", false, false);
        this.table.setScrollDownOnAdd(true);
        this.table.setSortedColumn(3);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int dWidth = TableColumnInfo.dateColumnWidth + 2 * this.table.getCellPadding();
        String searchFieldName = "";
        switch (this.type) {
            case FLIGHT: {
                int tw;
                searchFieldName = Words.OUTBOUND;
                if (this.isSolarCompany) {
                    columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 108, 108, 108));
                    columns.add(new TableColumnInfo(Words.OUTBOUND, null, null, null, "", 30, 30, 30));
                    tw = TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding();
                    columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", tw, tw, tw));
                    ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
                    ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
                    ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
                    break;
                }
                columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 108, 108, 108));
                columns.add(new TableColumnInfo(Words.OUTBOUND, null, null, null, "", 30, 30, 30));
                tw = TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding();
                columns.add(new TableColumnInfo(Words.DEPARTURE, null, null, null, "", tw, tw, tw));
                tw = TableColumnInfo.locationWidth;
                columns.add(new TableColumnInfo(Words.TO, null, null, null, "", tw, tw, tw));
                columns.add(new TableColumnInfo(Words.NUMBER, null, null, null, "", 30, 30, 30));
                columns.add(new TableColumnInfo(Words.LOC, null, null, null, "", tw, tw, tw));
                columns.add(new TableColumnInfo(Words.INVOICED, null, null, null, "", 235, 235, 235));
                ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(0.4);
                ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(3)).setxExpand(0.4);
                ((TableColumnInfo)columns.get(4)).setxExpand(0.2);
                ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
                break;
            }
            case SERVICEPRODUCT: {
                searchFieldName = Words.OUTBOUND;
                columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
                columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
                columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 30, 30, 30));
                columns.add(new TableColumnInfo(Words.UP, null, null, null, "", TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
                columns.add(new TableColumnInfo(Words.QTY, null, null, null, "", TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
                ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
                ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
                break;
            }
            case TRADEGOODS: {
                searchFieldName = Words.OUTBOUND;
                columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 100, 100, 100));
                columns.add(new TableColumnInfo(Words.TRADE_GOOD, null, null, null, "", 30, 30, 30));
                columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", 30, 30, 30));
                columns.add(new TableColumnInfo(Words.LOC, null, null, null, "", 60, 60, 60));
                ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
                ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
                ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
                break;
            }
            case PURCHASE: {
                searchFieldName = Words.ORDER_NO;
                columns.add(new TableColumnInfo(Words.SUPPLIER, null, null, null, "", 30, 30, 30));
                columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", dWidth, dWidth, dWidth));
                ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
                break;
            }
            case REQUISITION: {
                searchFieldName = Words.ORDER_NO;
                columns.add(new TableColumnInfo(Words.DEPARTMENT, null, null, null, "", 30, 30, 30));
                columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", dWidth, dWidth, dWidth));
                ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
                break;
            }
            case PRODUCT: {
                searchFieldName = Words.PRODUCT;
                columns.add(new TableColumnInfo(Words.NUMBER, null, null, null, "", 100, 100, 100));
                columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 30, 30, 30));
                columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", 120, 120, 120));
                columns.add(new TableColumnInfo(Words.QTY, null, null, null, "", 90, 90, 90));
                ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
                ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
                break;
            }
            case HANDLING_COSTS: {
                searchFieldName = Words.HANDLING_COST;
                columns.add(new TableColumnInfo(Words.NUMBER, null, null, null, "", 100, 100, 100));
                columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 30, 30, 30));
                columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", 120, 120, 120));
                ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
                ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            }
        }
        int dw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getCellPadding() * 2;
        columns.add(new TableColumnInfo("", null, null, null, "", dw, dw, dw));
        ((TableColumnInfo)columns.get(columns.size() - 1)).setxExpand(0.0);
        Table2Model tModel = new Table2Model(columns, true){

            @Override
            public boolean checkIfIsToAdd(Node node) {
                switch (ConfigFlightPopupInsert.this.type) {
                    case FLIGHT: {
                        if (node.getValue() instanceof FlightInvoiceConfigurationComplete) {
                            return !((FlightInvoiceConfigurationComplete)node.getValue()).getFlights().isEmpty();
                        }
                        return false;
                    }
                }
                return true;
            }
        };
        tModel.setViewFactory(model -> {
            switch (this.type) {
                case SERVICEPRODUCT: {
                    return new TableRowImpl2(model);
                }
                case FLIGHT: {
                    return new TableRowImpl(model);
                }
                case PURCHASE: {
                    return new TableRowImplPurchase(model);
                }
                case REQUISITION: {
                    return new TableRowImplRequisition(model);
                }
                case TRADEGOODS: {
                    return new TableRowImpl(model);
                }
                case PRODUCT: {
                    return new TableRowProduct(model);
                }
                case HANDLING_COSTS: {
                    return new TableRowHandlingCost(model);
                }
            }
            return new TableRowImpl(model);
        });
        this.table.setModel(tModel);
        this.searchField = new TitledItem<SearchTextField>(new SearchTextField(), searchFieldName, TitledItem.TitledItemOrientation.NORTH);
        this.searchField.setIgnorePrefWidth(true);
        this.searchButton = new TextButton("");
        this.searchButton.addButtonListener(this);
        this.removeAll = new TextButton(Words.CLEAR_ALL);
        this.removeAll.addButtonListener(this);
        ArrayList<ADTO> locs = new ArrayList<ADTO>();
        locs.add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
        this.setLayout(new Layout());
        switch (this.type) {
            case FLIGHT: {
                this.searchButton.setText(Words.RELOAD_FLIGHTS);
                this.table.getModel().setNode(n);
                break;
            }
            case SERVICEPRODUCT: {
                this.searchButton.setText(Words.RELOAD_SERVICE_PRODUCTS);
                this.table.getModel().setNode(n.getChildNamed(ServiceProductInvoiceConfigurationComplete_.serviceProducts));
                break;
            }
            case TRADEGOODS: {
                this.searchButton.setText(Words.RELOAD_TRADE_GOODS);
                this.table.getModel().setNode(n.getChildNamed(TradeGoodInvoiceConfigurationComplete_.tradeGoods));
                break;
            }
            case PURCHASE: {
                this.searchButton.setText(Words.RELOAD_PURCHASE_ORDERS);
                this.table.getModel().setNode(n.getChildNamed(PurchaseInvoiceConfigurationComplete_.purchaseOrders));
                break;
            }
            case REQUISITION: {
                this.searchButton.setText(Words.RELOAD_REQUISITION_ORDERS);
                this.table.getModel().setNode(n.getChildNamed(RequisitionInvoiceConfigurationComplete_.requisitions));
                this.onlyClosed = new TitledItem<CheckBox>(new CheckBox(), Words.ONLY_CLOSED, TitledItem.TitledItemOrientation.EAST);
                this.dateType = new TitledItem<ComboBox>(new ComboBox(), Words.DATE_SELECTION, TitledItem.TitledItemOrientation.NORTH);
                this.dateType.getElement().addItem(DateSelectionType.DELIVER_DATE);
                this.dateType.getElement().addItem(DateSelectionType.SCHEDULED_DELIVERY_DATE);
                this.add(this.onlyClosed);
                this.add(this.dateType);
                break;
            }
            case PRODUCT: {
                this.searchButton.setText(Words.RELOAD_PRODUCTS);
                this.table.getModel().setNode(n.getChildNamed(ProductInvoiceConfigurationComplete_.products));
                Node delAirPort = n.getChildNamed(ProductInvoiceConfigurationComplete_.deliveryAirport);
                delAirPort.setConverter(Airport2Converter.class);
                this.deliveryAirport = new TitledItem<SearchTextField2<AirportComplete>>(SearchTextField2Factory.getAirportSearchField(true, delAirPort), Words.DELIVERY_AIRPORT, TitledItem.TitledItemOrientation.NORTH);
                this.add(this.deliveryAirport);
                break;
            }
            case HANDLING_COSTS: {
                this.searchButton.setText(Words.RELOAD_HANDLINGS);
                this.table.getModel().setNode(n.getChildNamed(HandlingCostInvoiceConfigurationComplete_.handlingCosts));
            }
        }
        if (this.type == InvoiceConfigType.FLIGHT) {
            Object stateValue = this.node.getParent().getChildNamed(new String[]{"state"}).getValue();
            this.isOpen = stateValue != InvoiceStateE.CLOSED && stateValue != InvoiceStateE.CANCELLED;
            this.add(this.flightState);
            if (!this.isSolarCompany) {
                this.add(this.haulPanel);
                this.add(this.category);
                this.haulPanel.setEnabled(this.isOpen);
                this.category.setEnabled(this.isOpen);
            }
            this.add(this.title);
            this.flightState.setEnabled(this.isOpen);
        } else {
            this.isOpen = this.node.getParent().getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CLOSED;
        }
        this.searchField.setEnabled(this.isOpen);
        this.searchButton.setEnabled(this.isOpen);
        if (this.hourlyWork != null) {
            this.add(this.hourlyWork);
        }
        this.add(this.table);
        this.add(this.searchField);
        this.add(this.searchButton);
        this.add(this.removeAll);
        this.setEnabled(this.isEnabled());
    }

    public void ensureAnimation(String msg) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(msg);
            this.add((Component)this.animation, 0);
            this.animation.start();
            this.animation.fadeIn();
        }
    }

    public void removeAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.addAll(this.searchField.getFocusComponents());
        a.addAll(this.searchButton.getFocusComponents());
        a.addAll(this.removeAll.getFocusComponents());
        CheckedListAdder.addToList(a, this.hourlyWork);
        a.addAll(this.table.getFocusComponents());
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.type == InvoiceConfigType.FLIGHT) {
            this.title.kill();
        }
        this.table.kill();
        this.table = null;
        if (this.deliveryAirport != null) {
            this.deliveryAirport.kill();
            this.deliveryAirport = null;
        }
        if (this.hourlyWork != null) {
            this.hourlyWork.kill();
            this.hourlyWork = null;
        }
        this.searchButton.kill();
        this.searchButton = null;
        this.removeAll.kill();
        this.removeAll = null;
        this.searchField.kill();
        this.searchField = null;
        if (this.haulPanel != null) {
            this.haulPanel.kill();
        }
        this.haulPanel = null;
        if (this.flightState != null) {
            this.flightState.kill();
        }
        this.flightState = null;
        if (this.category != null) {
            this.category.kill();
        }
        this.category = null;
        if (this.animation != null) {
            this.animation.kill();
            this.animation = null;
        }
        if (this.onlyClosed != null) {
            this.onlyClosed.kill();
        }
        if (this.dateType != null) {
            this.dateType.kill();
        }
        this.onlyClosed = null;
        this.dateType = null;
        this.title = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.title == null) {
            return;
        }
        boolean isOpen = false;
        if (this.node.getParent().getChildNamed(new String[]{"state"}) == null) {
            isOpen = this.node.getParent().getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CLOSED && this.node.getParent().getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CANCELLED && this.node.getParent().getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CREDIT_NOTE;
        } else {
            boolean bl = isOpen = this.node.getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CLOSED && this.node.getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CANCELLED && this.node.getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CREDIT_NOTE;
        }
        if (this.type == InvoiceConfigType.FLIGHT) {
            this.title.setEnabled(isEnabled && isOpen);
            if (!this.isSolarCompany) {
                this.haulPanel.setEnabled(isEnabled && isOpen);
                this.haulPanel.revalidate();
                this.category.setEnabled(isEnabled && isOpen);
            }
            this.flightState.setEnabled(isEnabled && isOpen);
        }
        this.table.setEnabled(isEnabled);
        this.searchButton.setEnabled(isEnabled && isOpen);
        this.removeAll.setEnabled(isEnabled && isOpen);
        this.searchField.setEnabled(isEnabled && isOpen);
        if (this.hourlyWork != null) {
            this.hourlyWork.setEnabled(isEnabled && isOpen);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.searchButton) {
            this.setEnabled(false);
            this.ensureAnimation(Words.LOAD_DATA);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    switch (ConfigFlightPopupInsert.this.type) {
                        case FLIGHT: {
                            this.searchFlight();
                            break;
                        }
                        case SERVICEPRODUCT: {
                            this.searchServiceProduct();
                            break;
                        }
                        case TRADEGOODS: {
                            this.searchTradegoods();
                            break;
                        }
                        case PURCHASE: {
                            this.searchPurchaseOrder();
                            break;
                        }
                        case REQUISITION: {
                            this.searchRequisitionOrder();
                            break;
                        }
                        case PRODUCT: {
                            this.searchProduct();
                            break;
                        }
                        case HANDLING_COSTS: {
                            this.searchHandlingCosts();
                        }
                    }
                    return null;
                }

                private void searchRequisitionOrder() throws ClientServerCallException {
                    Integer rqNo = null;
                    try {
                        int i = Integer.valueOf(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                        rqNo = i;
                    }
                    catch (NumberFormatException i) {
                        // empty catch block
                    }
                    PeriodComplete p = new PeriodComplete((Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-startDate"}).getValue(), (Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-endDate"}).getValue());
                    OrderInvoiceReportConfiguration configuration = new OrderInvoiceReportConfiguration();
                    configuration.setPeriod(p);
                    configuration.setIncludeRedirect(Boolean.valueOf(false));
                    configuration.setOnlyClosed(((CheckBox)ConfigFlightPopupInsert.this.onlyClosed.getElement()).isChecked());
                    configuration.setUseScheduleDeliveryDate(((ComboBox)ConfigFlightPopupInsert.this.dateType.getElement()).getSelectedItem() == DateSelectionType.SCHEDULED_DELIVERY_DATE);
                    List ret = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).findInvoicableRequisitionOrders(configuration).getList();
                    Node nn = ConfigFlightPopupInsert.this.node.getChildNamed(RequisitionInvoiceConfigurationComplete_.requisitions);
                    for (RequisitionOrderLight f : ret) {
                        if (((CheckBox)ConfigFlightPopupInsert.this.onlyClosed.getElement()).isChecked() && f.getState() != OrderStateE.CLOSED || rqNo != null && rqNo.intValue() != f.getNumber().intValue()) continue;
                        Iterator it2 = nn.getChilds();
                        boolean found = false;
                        while (it2.hasNext() && !found) {
                            Node n = (Node)it2.next();
                            if (!n.getValue().equals(f)) continue;
                            found = true;
                        }
                        if (found) continue;
                        nn.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)f, true, false), 0L);
                    }
                }

                private void searchPurchaseOrder() throws ClientServerCallException {
                    PeriodComplete period = new PeriodComplete((Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-startDate"}).getValue(), (Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-endDate"}).getValue());
                    OrderInvoiceReportConfiguration configuration = new OrderInvoiceReportConfiguration();
                    configuration.setPeriod(period);
                    List ret = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).findInvoicablePurchaseOrders(configuration).getList();
                    Integer rqNo = null;
                    try {
                        int i = Integer.valueOf(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                        rqNo = i;
                    }
                    catch (NumberFormatException i) {
                        // empty catch block
                    }
                    Node nn = ConfigFlightPopupInsert.this.node.getChildNamed(PurchaseInvoiceConfigurationComplete_.purchaseOrders);
                    for (PurchaseOrderLight f : ret) {
                        if (f.getState() != OrderStateE.CLOSED || rqNo != null && f.getNumber().intValue() != rqNo.intValue()) continue;
                        Iterator it2 = nn.getChilds();
                        boolean found = false;
                        while (it2.hasNext() && !found) {
                            Node n = (Node)it2.next();
                            if (!n.getValue().equals(f)) continue;
                            found = true;
                        }
                        if (found) continue;
                        nn.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)f, true, false), 0L);
                    }
                }

                private void searchFlight() throws ClientServerCallException {
                    FlightSearchConfiguration config = new FlightSearchConfiguration();
                    switch (ConfigFlightPopupInsert.this.currentInvoiceType) {
                        case COMMISSION: 
                        case COMPLEMENTARY: 
                        case FREE_SOB: 
                        case SOB_ONLY: {
                            config.setStowageType(FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.SALES_ON_BOARD);
                            break;
                        }
                        case MANUAL_CREDIT_NOTE: 
                        case NORMAL: {
                            config.setStowageType(FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.REGULAR);
                            break;
                        }
                    }
                    config.setDeliveryAirport((AirportComplete)ConfigFlightPopupInsert.this.node.getParent().getChildNamed(InvoiceLight_.deliveryAirport).getValue());
                    config.setCustomer((CustomerLight)ConfigFlightPopupInsert.this.node.getParent().getChildNamed(new String[]{"customer"}).getValue());
                    config.setFlightNumber(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                    config.setDayPeriod(new PeriodComplete((Date)ConfigFlightPopupInsert.this.node.getParent().getChildNamed(new String[]{"period-startDate"}).getValue(), (Date)ConfigFlightPopupInsert.this.node.getParent().getChildNamed(new String[]{"period-endDate"}).getValue()));
                    config.setIsInvoiced(Boolean.valueOf(false));
                    config.setSearchedType((InvoiceTypeE)ConfigFlightPopupInsert.this.node.getParent().getChildNamed(InvoiceLight_.invoiceType).getValue());
                    if (ConfigFlightPopupInsert.this.haulPanel != null) {
                        ArrayList<HaulTypeComplete> haulTypeList = new ArrayList<HaulTypeComplete>();
                        if (((MultiSelectionPanel)ConfigFlightPopupInsert.this.haulPanel.getElement()).getSelectedObjects() != null) {
                            for (Object o : ((MultiSelectionPanel)ConfigFlightPopupInsert.this.haulPanel.getElement()).getSelectedObjects()) {
                                haulTypeList.add((HaulTypeComplete)o);
                            }
                        }
                        config.setHaulTypeList(haulTypeList);
                        config.setShowNullHaulTypes(Boolean.valueOf(((MultiSelectionPanel)ConfigFlightPopupInsert.this.haulPanel.getElement()).isActivated()));
                    }
                    if (ConfigFlightPopupInsert.this.category != null) {
                        FlightCategoryComplete cat = null;
                        if (((ComboBox)ConfigFlightPopupInsert.this.category.getElement()).getSelectedItem() instanceof Node) {
                            cat = (FlightCategoryComplete)((Node)((ComboBox)ConfigFlightPopupInsert.this.category.getElement()).getSelectedItem()).getValue();
                        }
                        if (((ComboBox)ConfigFlightPopupInsert.this.category.getElement()).getSelectedItem() instanceof FlightCategoryComplete) {
                            cat = (FlightCategoryComplete)((ComboBox)ConfigFlightPopupInsert.this.category.getElement()).getSelectedItem();
                        }
                        config.setCategory(cat);
                    }
                    if (ConfigFlightPopupInsert.this.flightState != null && ConfigFlightPopupInsert.this.flightState.getElement() != null && ((ComboBox)ConfigFlightPopupInsert.this.flightState.getElement()).getSelectedItem() != null) {
                        if (((ComboBox)ConfigFlightPopupInsert.this.flightState.getElement()).getSelectedItem() instanceof String) {
                            if (((ComboBox)ConfigFlightPopupInsert.this.flightState.getElement()).getSelectedItem().equals(Words.ALL)) {
                                config.setFlightState(null);
                                config.setOnlyOpenFlights(Boolean.valueOf(true));
                            }
                            if (((ComboBox)ConfigFlightPopupInsert.this.flightState.getElement()).getSelectedItem().equals(Words.ALL_EXCEPT_PLANNED)) {
                                config.setFlightState(null);
                                config.setOnlyOpenFlights(Boolean.valueOf(true));
                            }
                        } else if (((ComboBox)ConfigFlightPopupInsert.this.flightState.getElement()).getSelectedItem() instanceof FlightStateE) {
                            FlightStateE fs = (FlightStateE)((ComboBox)ConfigFlightPopupInsert.this.flightState.getElement()).getSelectedItem();
                            config.setFlightState(fs);
                            config.setOnlyOpenFlights(Boolean.valueOf(true));
                        }
                    }
                    LocationComplete loc = (LocationComplete)ConfigFlightPopupInsert.this.node.getParent().getChildNamed(new String[]{"eligibleLocations"}).getChildAt(0).getValue();
                    ArrayList<LocationComplete> locations = new ArrayList<LocationComplete>();
                    locations.add(loc);
                    config.setLocations(locations);
                    try {
                        SearchResultIterator flightSearch = new SearchResultIterator((ASearchConfiguration)config);
                        for (FlightLight flight : flightSearch) {
                            if (ConfigFlightPopupInsert.this.isFlightInvoiced(flight, ConfigFlightPopupInsert.this.node)) continue;
                            FlightInvoiceConfigurationComplete flightConfig = new FlightInvoiceConfigurationComplete();
                            flightConfig.setClientOId(Long.valueOf(ADTO.getNextId()));
                            if (flight.getFlightState() == FlightStateE.CANCELLED) {
                                flightConfig.setHandling(Boolean.valueOf(flight.getPredefineInvoiceCanceledFlightHandling() != false && flight.getInvoiceNormalHandling() == false));
                                flightConfig.setMeals(Boolean.valueOf(flight.getPredefineInvoiceCanceledFlightMeal() != false && flight.getInvoiceNormalMeal() == false));
                                flightConfig.setStandard(Boolean.valueOf(flight.getPredefineInvoiceCanceledFlightStandard() != false && flight.getInvoiceNormalStandard() == false));
                                flightConfig.setAdditional(Boolean.valueOf(flight.getPredefineInvoiceCanceledFlightAdditional() != false && flight.getInvoiceNormalAdditional() == false));
                                flightConfig.setHandlingFromStowing(Boolean.valueOf(flight.getPredefineInvoiceCanceledFlightHandlingFromStowing() != false && flight.getInvoiceNormalHandlingFromStowing() == false));
                            } else {
                                flightConfig.setHandling(Boolean.valueOf(flight.getInvoiceNormalHandling() == false));
                                flightConfig.setMeals(Boolean.valueOf(flight.getInvoiceNormalMeal() == false));
                                flightConfig.setStandard(Boolean.valueOf(flight.getInvoiceNormalStandard() == false));
                                flightConfig.setAdditional(Boolean.valueOf(flight.getInvoiceNormalAdditional() == false));
                                flightConfig.setHandlingFromStowing(Boolean.valueOf(flight.getInvoiceNormalHandlingFromStowing() == false));
                            }
                            flightConfig.getFlights().add(flight);
                            ConfigFlightPopupInsert.this.node.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)flightConfig, true, false), 0L);
                        }
                    }
                    catch (ServiceException e) {
                        throw new ClientServerCallException((Exception)((Object)e));
                    }
                }

                private void searchServiceProduct() throws ClientServerCallException {
                    ServiceProductSearchConfiguration config = new ServiceProductSearchConfiguration();
                    CustomerLight customer = (CustomerLight)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"customer"}).getValue();
                    config.setCustomer(customer);
                    Boolean hourlyWorkFilter = null;
                    if (ConfigFlightPopupInsert.this.hourlyWork != null) {
                        hourlyWorkFilter = ((ComboBox)ConfigFlightPopupInsert.this.hourlyWork.getElement()).getSelectedItem().equals(Words.ALL) ? null : (((ComboBox)ConfigFlightPopupInsert.this.hourlyWork.getElement()).getSelectedItem().equals(Words.HOURLY_WORK) ? Boolean.valueOf(true) : Boolean.valueOf(false));
                    }
                    try {
                        int i = Integer.valueOf(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                        config.setNumber(Integer.valueOf(i));
                    }
                    catch (NumberFormatException e) {
                        config.setNumber(null);
                        config.setName(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                    }
                    if (config.getName() != null && config.getName().isEmpty()) {
                        config.setName(null);
                    }
                    PeriodComplete period = new PeriodComplete((Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-startDate"}).getValue(), (Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-endDate"}).getValue());
                    config.setPeriod(period);
                    ArrayList<ADTO> locations = new ArrayList<ADTO>();
                    locations.add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                    config.setLocations(locations);
                    Node nn = ConfigFlightPopupInsert.this.node.getChildNamed(new String[]{"serviceProducts"});
                    try {
                        SearchResultIterator serviceSearch = new SearchResultIterator((ASearchConfiguration)config);
                        for (ServiceProductComplete f : serviceSearch) {
                            SystemSettingsComplete settings;
                            boolean isNoPro;
                            if (Boolean.TRUE.equals(f.getIsDeleted()) || hourlyWorkFilter != null && !hourlyWorkFilter.equals(f.getHourlyWork())) continue;
                            Iterator it2 = nn.getChilds();
                            boolean found = false;
                            while (it2.hasNext() && !found) {
                                Node n = (Node)it2.next();
                                if (!n.getChildNamed(new String[]{"serviceProduct"}).getValue().equals(f)) continue;
                                found = true;
                            }
                            if (!found) {
                                ServiceProductInvoiceItemComplete nf = new ServiceProductInvoiceItemComplete();
                                nf.setClientOId(Long.valueOf(ADTO.getNextId()));
                                nf.setQuantity(Integer.valueOf(1));
                                nf.setServiceProduct(f);
                                nf.setInvoice((ServiceProductInvoiceConfigurationComplete)ConfigFlightPopupInsert.this.node.getValue());
                                nn.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)nf, true, false), 0L);
                            }
                            if (!(isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)(settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue())))) continue;
                            Double count = 1.0;
                            try {
                                InvoiceLight invoice = (InvoiceLight)ConfigFlightPopupInsert.this.node.getParent().getParent().getValue();
                                count = ((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).calculateProductServiceCount(f, customer, period, new InvoiceReference(invoice.getId()));
                            }
                            catch (Exception e) {
                                InnerPopupFactory.showErrorDialog(e.getMessage(), (Component)ConfigFlightPopupInsert.this);
                            }
                            it2 = nn.getChilds();
                            while (it2.hasNext()) {
                                Node n = (Node)it2.next();
                                if (!n.getChildNamed(new String[]{"serviceProduct"}).getValue().equals(f)) continue;
                                n.getChildNamed(ServiceProductInvoiceItemComplete_.quantity).setValue((Object)count.intValue(), 0L);
                            }
                        }
                    }
                    catch (ServiceException e) {
                        throw new ClientServerCallException((Exception)((Object)e));
                    }
                }

                private void searchHandlingCosts() throws ClientServerCallException {
                    HandlingCostSearchConfiguration config = new HandlingCostSearchConfiguration();
                    config.setType(HandlingCostTypeE.FLIGHT);
                    config.setCustomer((CustomerReference)((CustomerLight)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"customer"}).getValue()));
                    try {
                        int i = Integer.valueOf(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                        config.setNumber(Integer.valueOf(i));
                    }
                    catch (NumberFormatException e) {
                        config.setNumber(null);
                        config.setName(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                    }
                    if (config.getName() != null && config.getName().isEmpty()) {
                        config.setName(null);
                    }
                    config.setPeriod(new PeriodComplete((Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-startDate"}).getValue(), (Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-endDate"}).getValue()));
                    ArrayList<ADTO> locations = new ArrayList<ADTO>();
                    locations.add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                    config.setLocations(locations);
                    Node nn = ConfigFlightPopupInsert.this.node.getChildNamed(HandlingCostInvoiceConfigurationComplete_.handlingCosts);
                    try {
                        SearchResultIterator serviceSearch = new SearchResultIterator((ASearchConfiguration)config);
                        for (HandlingCostComplete f : serviceSearch) {
                            if (Boolean.TRUE.equals(f.getIsDeleted()) || !(f.getCurrentVariant().getQuantity() instanceof AbsolutePriceCalculationComplete)) continue;
                            nn.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)f, true, true), 0L);
                        }
                    }
                    catch (ServiceException e) {
                        throw new ClientServerCallException((Exception)((Object)e));
                    }
                }

                private void searchProduct() throws ClientServerCallException {
                    ProductSearchConfiguration config = new ProductSearchConfiguration();
                    config.setCustomer((CustomerLight)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"customer"}).getValue());
                    try {
                        int i = Integer.valueOf(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                        config.setNumber(Integer.valueOf(i));
                    }
                    catch (NumberFormatException e) {
                        config.setNumber(null);
                        config.setName(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                    }
                    if (config.getName() != null && config.getName().isEmpty()) {
                        config.setName(null);
                    }
                    config.setPeriod(new PeriodComplete((Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-startDate"}).getValue(), (Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-endDate"}).getValue()));
                    ArrayList<ADTO> locations = new ArrayList<ADTO>();
                    locations.add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                    config.setLocations(locations);
                    Node nn = ConfigFlightPopupInsert.this.node.getChildNamed(ProductInvoiceConfigurationComplete_.products);
                    try {
                        SearchResultIterator serviceSearch = new SearchResultIterator((ASearchConfiguration)config);
                        for (ProductComplete f : serviceSearch) {
                            if (Boolean.TRUE.equals(f.getIsDeleted())) continue;
                            Iterator it2 = nn.getChilds();
                            boolean found = false;
                            while (it2.hasNext() && !found) {
                                Node n = (Node)it2.next();
                                if (!n.getChildNamed(ProductInvoiceItemComplete_.product).getValue().equals(f)) continue;
                                found = true;
                            }
                            if (found) continue;
                            ProductInvoiceItemComplete nf = new ProductInvoiceItemComplete();
                            nf.setClientOId(Long.valueOf(ADTO.getNextId()));
                            nf.setQuantity(Integer.valueOf(1));
                            nf.setProduct(f);
                            nf.setInvoice((ProductInvoiceConfigurationComplete)ConfigFlightPopupInsert.this.node.getValue());
                            nn.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)nf, true, false), 0L);
                        }
                    }
                    catch (ServiceException e) {
                        throw new ClientServerCallException((Exception)((Object)e));
                    }
                }

                private void searchTradegoods() throws ClientServerCallException {
                    TradeGoodsSearchConfiguration config = new TradeGoodsSearchConfiguration();
                    config.setCustomer((CustomerReference)((CustomerLight)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"customer"}).getValue()));
                    ArrayList<ADTO> locations = new ArrayList<ADTO>();
                    locations.add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                    config.setLocations(locations);
                    try {
                        int i = Integer.valueOf(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                        config.setNumber(Integer.valueOf(i));
                    }
                    catch (NumberFormatException e) {
                        config.setName(((SearchTextField)ConfigFlightPopupInsert.this.searchField.getElement()).getText());
                    }
                    if (config.getName() != null && config.getName().isEmpty()) {
                        config.setName(null);
                    }
                    config.setPeriod(new PeriodComplete((Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-startDate"}).getValue(), (Date)ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"period-endDate"}).getValue()));
                    try {
                        SearchResultIterator tradeGoodsSearch = new SearchResultIterator((ASearchConfiguration)config);
                        Node nn = ConfigFlightPopupInsert.this.node.getChildNamed(new String[]{"tradeGoods"});
                        for (TradeGoodsLight f : tradeGoodsSearch) {
                            if (Boolean.TRUE.equals(f.getIsDeleted())) continue;
                            Iterator it2 = nn.getChilds();
                            boolean found = false;
                            while (it2.hasNext() && !found) {
                                Node n = (Node)it2.next();
                                if (!n.getValue().equals(f)) continue;
                                found = true;
                            }
                            if (found) continue;
                            nn.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)f, true, false), 0L);
                        }
                    }
                    catch (ServiceException e) {
                        throw new ClientServerCallException((Exception)((Object)e));
                    }
                }

                @Override
                public RemoteLoader getInvoker() {
                    return ConfigFlightPopupInsert.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.removeAll) {
            Iterator it = this.table.getModel().getNode().getFailSafeChildIterator();
            while (it.hasNext()) {
                this.table.getModel().getNode().removeChild((Node)it.next(), 0L);
            }
        }
    }

    protected boolean isFlightInvoiced(FlightLight flight, Node allInvoicedThings) {
        Iterator it = allInvoicedThings.getFailSafeChildIterator();
        while (it.hasNext()) {
            FlightInvoiceConfigurationComplete c;
            Node n = (Node)it.next();
            if (!(n.getValue() instanceof FlightInvoiceConfigurationComplete) || !(c = (FlightInvoiceConfigurationComplete)n.getValue()).getFlights().contains(flight)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.removeAnimation();
        this.setEnabled(true);
        if (this.table != null) {
            this.table.revalidate();
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private Component flightState;
        private TextLabel outbound;
        private TextLabel departure;
        private TextLabel departureTo;
        private TextLabel location;
        private TextLabel number;
        private TitledItem<CheckBox> mealsF;
        private TitledItem<CheckBox> standardF;
        private TitledItem<CheckBox> handlingF;
        private TitledItem<CheckBox> additionalF;
        private TitledItem<CheckBox> handlingF_STW;
        private InfoButton cancelInfo;
        private DeleteButton delete;
        private boolean isCanceled;
        private Node<FlightLight> flightNode;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.isCanceled = false;
            this.setLayout(new InnerLayout());
            boolean isOpen = false;
            isOpen = ConfigFlightPopupInsert.this.node.getParent() != null && ConfigFlightPopupInsert.this.node.getParent().getChildNamed(new String[]{"state"}) != null;
            if (isOpen) {
                boolean bl = isOpen = ConfigFlightPopupInsert.this.node.getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CLOSED && ConfigFlightPopupInsert.this.node.getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CANCELLED && ConfigFlightPopupInsert.this.node.getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CREDIT_NOTE;
            }
            if (!isOpen && (isOpen = ConfigFlightPopupInsert.this.node.getParent().getParent() != null && ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"state"}) != null)) {
                boolean bl = isOpen = ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CLOSED && ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CANCELLED && ConfigFlightPopupInsert.this.node.getParent().getParent().getChildNamed(new String[]{"state"}).getValue() != InvoiceStateE.CREDIT_NOTE;
            }
            if (m.getNode().getValue() instanceof TradeGoodsLight) {
                this.outbound = new TextLabel(m.getNode(), ConverterRegistry.getConverter(TradeGoodsConverter.class));
                this.departure = new TextLabel(m.getNode().getChildNamed(new String[]{"sellDate"}), ConverterRegistry.getConverter(DateConverter.class));
                this.flightState = new CellViewModificationStateERenderer((ModificationStateE)m.getNode().getChildNamed(new String[]{"state"}).getValue());
                this.location = new TextLabel(m.getNode().getChildNamed(new String[]{"eligibleLocations"}), ConverterRegistry.getConverter(LocationsConverter.class));
            } else if (m.getNode().getValue() instanceof FlightInvoiceConfigurationComplete) {
                Node nm = m.getNode().getChildNamed(FlightInvoiceConfigurationComplete_.flights);
                if (nm.getChildCount() == 0) {
                    nm.getAllChildAddEvents(null);
                }
                if (nm.getChildCount() > 0) {
                    this.flightNode = nm.getChildAt(0);
                    this.flightState = new CellViewFlightStateERenderer((FlightLight)this.flightNode.getValue());
                    this.outbound = new TextLabel(this.flightNode.getChildNamed(FlightLight_.outboundCode));
                    this.departure = new TextLabel(this.flightNode.getChildNamed(FlightLight_.std), ConverterRegistry.getConverter(DateTimeConverter.class));
                    this.departureTo = new TextLabel(this.flightNode.getChildNamed(FlightLight_.legs), ConverterRegistry.getConverter(LegListStringConverter.class));
                    this.number = new TextLabel(this.flightNode.getChildNamed(FlightLight_.trackingNumber), ConverterRegistry.getConverter(IntegerConverter.class));
                    this.mealsF = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(FlightInvoiceConfigurationComplete_.meals)), "M:", TitledItem.TitledItemOrientation.WEST);
                    this.standardF = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(FlightInvoiceConfigurationComplete_.standard)), "S:", TitledItem.TitledItemOrientation.WEST);
                    this.handlingF = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(FlightInvoiceConfigurationComplete_.handling)), "H:", TitledItem.TitledItemOrientation.WEST);
                    this.handlingF_STW = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(FlightInvoiceConfigurationComplete_.handlingFromStowing)), "HS:", TitledItem.TitledItemOrientation.WEST);
                    this.additionalF = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(FlightInvoiceConfigurationComplete_.additional)), "A:", TitledItem.TitledItemOrientation.WEST);
                    this.cancelInfo = new InfoButton();
                    this.cancelInfo.installStringViewer(InvoiceToolkit.getCancelMessage((FlightLight)this.flightNode.getValue(), (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
                    this.location = new TextLabel(this.flightNode.getChildNamed(FlightLight_.eligibleLocations), ConverterRegistry.getConverter(LocationsConverter.class));
                    FlightLight f = (FlightLight)this.flightNode.getValue();
                    this.isCanceled = f.getFlightState() == FlightStateE.CANCELLED;
                }
            } else if (m.getNode().getValue() instanceof ServiceProductComplete) {
                this.outbound = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ServiceProductConverter.class));
                this.departure = new TextLabel(m.getNode().getChildNamed(new String[]{"period"}), ConverterRegistry.getConverter(PeriodConverter.class));
                this.flightState = new CellViewModificationStateERenderer((ModificationStateE)m.getNode().getChildNamed(new String[]{"currentVariant-state"}).getValue());
                this.departureTo = new TextLabel("");
                this.location = new TextLabel(m.getNode().getChildNamed(new String[]{"eligibleLocations"}), ConverterRegistry.getConverter(LocationsConverter.class));
            }
            if (isOpen) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
            }
            this.add(this.flightState);
            this.add(this.outbound);
            this.add(this.departure);
            if (this.departureTo != null) {
                this.add(this.departureTo);
            }
            this.add(this.location);
            if (this.mealsF != null) {
                this.add(this.mealsF);
            }
            if (this.standardF != null) {
                this.add(this.standardF);
            }
            if (this.handlingF != null) {
                this.add(this.handlingF);
            }
            if (this.handlingF_STW != null) {
                this.add(this.handlingF_STW);
            }
            if (this.additionalF != null) {
                this.add(this.additionalF);
            }
            if (this.cancelInfo != null) {
                this.add(this.cancelInfo);
            }
            if (this.number != null) {
                this.add(this.number);
            }
            if (this.delete != null) {
                this.add(this.delete);
            }
            this.setEnabled(true);
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (ConfigFlightPopupInsert.this.type) {
                case FLIGHT: {
                    switch (column) {
                        case 0: {
                            return this.flightNode.getChildNamed(FlightLight_.flightState).getValue();
                        }
                        case 1: {
                            return this.flightNode.getChildNamed(FlightLight_.outboundCode).getValue();
                        }
                        case 2: {
                            return this.flightNode.getChildNamed(FlightLight_.std).getValue();
                        }
                        case 3: {
                            return this.departureTo.getText();
                        }
                        case 4: {
                            return this.flightNode.getChildNamed(FlightLight_.trackingNumber).getValue();
                        }
                        case 5: {
                            return this.location.getText();
                        }
                        case 6: {
                            return null;
                        }
                    }
                    break;
                }
                case SERVICEPRODUCT: {
                    switch (column) {
                        case 0: {
                            return this.model.getNode().getChildNamed(new String[]{"state"}).getValue();
                        }
                        case 1: {
                            return this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
                        }
                        case 2: {
                            return this.model.getNode().getChildNamed(new String[]{"std"}).getValue();
                        }
                        case 3: {
                            return this.location.getText();
                        }
                    }
                    break;
                }
                case TRADEGOODS: {
                    switch (column) {
                        case 0: {
                            return null;
                        }
                        case 1: {
                            return this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
                        }
                        case 2: {
                            return this.model.getNode().getChildNamed(new String[]{"period-startDate"}).getValue();
                        }
                        case 3: {
                            return this.location.getText();
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.flightState != null && this.flightState instanceof Killable) {
                ((Killable)((Object)this.flightState)).kill();
            }
            this.flightState = null;
            this.outbound.kill();
            this.outbound = null;
            this.departure.kill();
            this.departure = null;
            if (this.departureTo != null) {
                this.departureTo.kill();
            }
            this.departureTo = null;
            this.location.kill();
            this.location = null;
            if (this.delete != null) {
                this.delete.kill();
            }
            this.delete = null;
            if (this.mealsF != null) {
                this.mealsF.kill();
            }
            this.mealsF = null;
            if (this.standardF != null) {
                this.standardF.kill();
            }
            this.standardF = null;
            if (this.handlingF != null) {
                this.handlingF.kill();
            }
            this.handlingF = null;
            if (this.handlingF_STW != null) {
                this.handlingF_STW.kill();
            }
            this.handlingF_STW = null;
            if (this.additionalF != null) {
                this.additionalF.kill();
            }
            this.additionalF = null;
            if (this.number != null) {
                this.number.kill();
            }
            this.number = null;
            if (this.cancelInfo != null) {
                this.cancelInfo.kill();
            }
            this.cancelInfo = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean additional;
            if (this.flightState != null) {
                this.flightState.setEnabled(isEnabled);
            }
            this.outbound.setEnabled(isEnabled);
            if (this.number != null) {
                this.number.setEnabled(isEnabled);
            }
            if (this.departure != null) {
                this.departure.setEnabled(isEnabled);
            }
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
            this.location.setEnabled(isEnabled);
            boolean meal = this.flightNode != null && !Boolean.TRUE.equals(this.flightNode.getChildNamed(FlightLight_.invoiceNormalMeal).getValue()) || this.mealsF != null && this.mealsF.getElement().isChecked();
            boolean standard = this.flightNode != null && !Boolean.TRUE.equals(this.flightNode.getChildNamed(FlightLight_.invoiceNormalStandard).getValue()) || this.standardF != null && this.standardF.getElement().isChecked();
            boolean handling = this.flightNode != null && !Boolean.TRUE.equals(this.flightNode.getChildNamed(FlightLight_.invoiceNormalHandling).getValue()) || this.handlingF != null && this.handlingF.getElement().isChecked();
            boolean handlingFromStowing = this.flightNode != null && !Boolean.TRUE.equals(this.flightNode.getChildNamed(FlightLight_.invoiceNormalHandlingFromStowing).getValue()) || this.handlingF_STW != null && this.handlingF_STW.getElement().isChecked();
            boolean bl = additional = this.flightNode != null && !Boolean.TRUE.equals(this.flightNode.getChildNamed(FlightLight_.invoiceNormalAdditional).getValue()) || this.additionalF != null && this.additionalF.getElement().isChecked();
            if (this.mealsF != null) {
                this.mealsF.setEnabled(isEnabled && ConfigFlightPopupInsert.this.isOpen && meal);
            }
            if (this.standardF != null) {
                this.standardF.setEnabled(isEnabled && ConfigFlightPopupInsert.this.isOpen && standard);
            }
            if (this.handlingF != null) {
                this.handlingF.setEnabled(isEnabled && ConfigFlightPopupInsert.this.isOpen && handling);
            }
            if (this.additionalF != null) {
                this.additionalF.setEnabled(isEnabled && ConfigFlightPopupInsert.this.isOpen && additional);
            }
            if (this.handlingF_STW != null) {
                this.handlingF_STW.setEnabled(isEnabled && ConfigFlightPopupInsert.this.isOpen && handlingFromStowing);
            }
            if (this.cancelInfo != null) {
                this.cancelInfo.setEnabled(isEnabled);
            }
            if (this.departureTo != null) {
                this.departureTo.setEnabled(isEnabled);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = 0;
                int currentX = 0;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                if (TableRowImpl.this.flightState != null) {
                    TableRowImpl.this.flightState.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightState.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.flightState.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightState.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.outbound.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.outbound.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.outbound.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.outbound.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.departure.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.departure.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.departure.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.departure.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                int index = 4;
                if (TableRowImpl.this.departureTo != null) {
                    TableRowImpl.this.departureTo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.departureTo.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.departureTo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.departureTo.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                    index = 5;
                }
                if (TableRowImpl.this.number != null) {
                    TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                }
                TableRowImpl.this.location.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.location.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.location.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.location.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                if (TableRowImpl.this.mealsF != null) {
                    TableRowImpl.this.mealsF.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.mealsF.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.mealsF.setSize(TableRowImpl.this.mealsF.getPreferredSize());
                    TableRowImpl.this.standardF.setLocation(TableRowImpl.this.mealsF.getX() + TableRowImpl.this.mealsF.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.mealsF.getY());
                    TableRowImpl.this.standardF.setSize((int)(TableRowImpl.this.standardF.getPreferredSize().getWidth() + 1.0), (int)TableRowImpl.this.standardF.getPreferredSize().getHeight());
                    TableRowImpl.this.handlingF.setLocation(TableRowImpl.this.standardF.getX() + TableRowImpl.this.standardF.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.standardF.getY());
                    TableRowImpl.this.handlingF.setSize((int)(TableRowImpl.this.handlingF.getPreferredSize().getWidth() + 1.0), (int)TableRowImpl.this.handlingF.getPreferredSize().getHeight());
                    TableRowImpl.this.handlingF_STW.setLocation(TableRowImpl.this.handlingF.getX() + TableRowImpl.this.handlingF.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.handlingF.getY());
                    TableRowImpl.this.handlingF_STW.setSize((int)(TableRowImpl.this.handlingF_STW.getPreferredSize().getWidth() + 1.0), (int)TableRowImpl.this.handlingF_STW.getPreferredSize().getHeight());
                    TableRowImpl.this.additionalF.setLocation(TableRowImpl.this.handlingF_STW.getX() + TableRowImpl.this.handlingF_STW.getWidth() + TableRowImpl.this.getInnerCellPadding(), TableRowImpl.this.handlingF_STW.getY());
                    TableRowImpl.this.additionalF.setSize((int)(TableRowImpl.this.additionalF.getPreferredSize().getWidth() + 1.0), (int)TableRowImpl.this.additionalF.getPreferredSize().getHeight());
                    TableRowImpl.this.cancelInfo.setLocation(TableRowImpl.this.additionalF.getX() + TableRowImpl.this.additionalF.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cancelInfo.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.cancelInfo.setSize(TableRowImpl.this.cancelInfo.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                }
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }

    private class TableRowHandlingCost
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel number;
        private TextLabel name;
        private TextLabel unitPrice;
        private DeleteButton delete;

        public TableRowHandlingCost(Table2RowModel m) {
            super(m);
            this.number = new TextLabel(m.getNode().getChildNamed(HandlingCostComplete_.number), ConverterRegistry.getConverter(IntegerConverter.class));
            this.name = new TextLabel(m.getNode().getChildNamed(new DtoField[]{HandlingCostComplete_.currentVariant, HandlingCostVariantComplete_.name}));
            PriceComplete price = new PriceComplete();
            price.setPrice((Double)m.getNode().getChildNamed(new DtoField[]{HandlingCostComplete_.currentVariant, HandlingCostVariantComplete_.quantity, AbsolutePriceCalculationComplete_.price}).getValue());
            price.setCurrency((CurrencyComplete)m.getNode().getChildNamed(new DtoField[]{HandlingCostComplete_.currentVariant, HandlingCostVariantComplete_.quantity, AbsolutePriceCalculationComplete_.currency}).getValue());
            this.unitPrice = new TextLabel(INodeCreator.getDefaultImpl().getNode4DTO((Object)price, false, false), ConverterRegistry.getConverter(PriceConverter3.class));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.number);
            this.add(this.name);
            this.add(this.unitPrice);
            this.add(this.delete);
        }

        public ArrayList<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.number.getNode().getValue();
                }
                case 1: {
                    return this.name.getNode().getValue();
                }
                case 2: {
                    return this.unitPrice.getNode().getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.unitPrice.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.number.kill();
            this.name.kill();
            this.unitPrice.kill();
            this.delete.kill();
            this.number = null;
            this.name = null;
            this.unitPrice = null;
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowHandlingCost.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowHandlingCost.this.model.getParentModel().getColumnWidth(0);
                TableRowHandlingCost.this.number.setLocation(currentX + TableRowHandlingCost.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowHandlingCost.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowHandlingCost.this.number.setSize(w - 2 * TableRowHandlingCost.this.getCellPadding(), (int)TableRowHandlingCost.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowHandlingCost.this.model.getParentModel().getColumnWidth(1);
                TableRowHandlingCost.this.name.setLocation(currentX + TableRowHandlingCost.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowHandlingCost.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowHandlingCost.this.name.setSize(w - 2 * TableRowHandlingCost.this.getCellPadding(), (int)TableRowHandlingCost.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowHandlingCost.this.model.getParentModel().getColumnWidth(2);
                TableRowHandlingCost.this.unitPrice.setLocation(currentX + TableRowHandlingCost.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowHandlingCost.this.unitPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowHandlingCost.this.unitPrice.setSize(w - 2 * TableRowHandlingCost.this.getCellPadding(), (int)TableRowHandlingCost.this.unitPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowHandlingCost.this.model.getParentModel().getColumnWidth(3);
                TableRowHandlingCost.this.delete.setLocation(currentX + TableRowHandlingCost.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowHandlingCost.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowHandlingCost.this.delete.setSize(TableRowHandlingCost.this.delete.getPreferredSize());
            }
        }
    }

    private class TableRowProduct
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel number;
        private TextLabel name;
        private TextLabel unitPrice;
        private TextField quantity;
        private DeleteButton delete;

        public TableRowProduct(Table2RowModel m) {
            super(m);
            this.number = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ProductInvoiceItemComplete_.product, ProductComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.name = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ProductInvoiceItemComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.name}));
            this.unitPrice = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ProductInvoiceItemComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.salesPrice}), ConverterRegistry.getConverter(PriceConverter3.class));
            this.quantity = new NumberTextField(m.getNode().getChildNamed(ProductInvoiceItemComplete_.quantity), TextFieldType.INT);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.number);
            this.add(this.name);
            this.add(this.unitPrice);
            this.add(this.quantity);
            this.add(this.delete);
        }

        public ArrayList<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.quantity);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.number.getNode().getValue();
                }
                case 1: {
                    return this.name.getNode().getValue();
                }
                case 2: {
                    return this.unitPrice.getNode().getValue();
                }
                case 3: {
                    return this.quantity.getNode().getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.unitPrice.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.number.kill();
            this.name.kill();
            this.unitPrice.kill();
            this.quantity.kill();
            this.delete.kill();
            this.number = null;
            this.name = null;
            this.unitPrice = null;
            this.quantity = null;
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowProduct.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowProduct.this.model.getParentModel().getColumnWidth(0);
                TableRowProduct.this.number.setLocation(currentX + TableRowProduct.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowProduct.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowProduct.this.number.setSize(w - 2 * TableRowProduct.this.getCellPadding(), (int)TableRowProduct.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowProduct.this.model.getParentModel().getColumnWidth(1);
                TableRowProduct.this.name.setLocation(currentX + TableRowProduct.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowProduct.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowProduct.this.name.setSize(w - 2 * TableRowProduct.this.getCellPadding(), (int)TableRowProduct.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowProduct.this.model.getParentModel().getColumnWidth(2);
                TableRowProduct.this.unitPrice.setLocation(currentX + TableRowProduct.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowProduct.this.unitPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowProduct.this.unitPrice.setSize(w - 2 * TableRowProduct.this.getCellPadding(), (int)TableRowProduct.this.unitPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowProduct.this.model.getParentModel().getColumnWidth(3);
                TableRowProduct.this.quantity.setLocation(currentX + TableRowProduct.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowProduct.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowProduct.this.quantity.setSize(w - 2 * TableRowProduct.this.getCellPadding(), (int)TableRowProduct.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowProduct.this.model.getParentModel().getColumnWidth(4);
                TableRowProduct.this.delete.setLocation(currentX + TableRowProduct.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowProduct.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowProduct.this.delete.setSize(TableRowProduct.this.delete.getPreferredSize());
            }
        }
    }

    private class TableRowImpl2
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private Component state;
        private TextLabel number;
        private TextLabel name;
        private TextLabel unitPrice;
        private TextField quantity;
        private DeleteButton delete;

        public TableRowImpl2(Table2RowModel m) {
            super(m);
            this.state = new CellViewModificationStateERenderer((ModificationStateE)m.getNode().getChildNamed(new DtoField[]{ServiceProductInvoiceItemComplete_.serviceProduct, ServiceProductComplete_.currentVariant, ServiceProductVariantComplete_.state}).getValue());
            this.number = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ServiceProductInvoiceItemComplete_.serviceProduct, ServiceProductComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.name = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ServiceProductInvoiceItemComplete_.serviceProduct, ServiceProductComplete_.currentVariant, ServiceProductVariantComplete_.name}));
            this.unitPrice = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ServiceProductInvoiceItemComplete_.serviceProduct, ServiceProductComplete_.currentVariant, ServiceProductVariantComplete_.salesPrice}), ConverterRegistry.getConverter(PriceConverter3.class));
            this.quantity = new NumberTextField(m.getNode().getChildNamed(ServiceProductInvoiceItemComplete_.quantity), TextFieldType.INT);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.state);
            this.add(this.number);
            this.add(this.name);
            this.add(this.unitPrice);
            this.add(this.quantity);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.quantity);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"serviceProduct-currentVariant-state"}).getValue();
                }
                case 1: {
                    return this.number.getNode().getValue();
                }
                case 2: {
                    return this.name.getNode().getValue();
                }
                case 3: {
                    return this.unitPrice.getNode().getValue();
                }
                case 4: {
                    return this.quantity.getNode().getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.state.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.unitPrice.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.remove(this.state);
            this.number.kill();
            this.name.kill();
            this.unitPrice.kill();
            this.quantity.kill();
            this.delete.kill();
            this.state = null;
            this.number = null;
            this.name = null;
            this.unitPrice = null;
            this.quantity = null;
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl2.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl2.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl2.this.state.setLocation(currentX + TableRowImpl2.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl2.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl2.this.state.setSize(w - 2 * TableRowImpl2.this.getCellPadding(), (int)TableRowImpl2.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl2.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl2.this.number.setLocation(currentX + TableRowImpl2.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl2.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl2.this.number.setSize(w - 2 * TableRowImpl2.this.getCellPadding(), (int)TableRowImpl2.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl2.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl2.this.name.setLocation(currentX + TableRowImpl2.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl2.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl2.this.name.setSize(w - 2 * TableRowImpl2.this.getCellPadding(), (int)TableRowImpl2.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl2.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl2.this.unitPrice.setLocation(currentX + TableRowImpl2.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl2.this.unitPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl2.this.unitPrice.setSize(w - 2 * TableRowImpl2.this.getCellPadding(), (int)TableRowImpl2.this.unitPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl2.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl2.this.quantity.setLocation(currentX + TableRowImpl2.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl2.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl2.this.quantity.setSize(w - 2 * TableRowImpl2.this.getCellPadding(), (int)TableRowImpl2.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl2.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl2.this.delete.setLocation(currentX + TableRowImpl2.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl2.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl2.this.delete.setSize(TableRowImpl2.this.delete.getPreferredSize());
            }
        }
    }

    private class TableRowImplPurchase
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel supplier;
        private TextLabel date;
        private DeleteButton delete;

        public TableRowImplPurchase(Table2RowModel m) {
            super(m);
            this.supplier = new TextLabel(m.getNode(), ConverterRegistry.getConverter(PurchaseOrderInvoiceConverter.class));
            this.date = new TextLabel(m.getNode().getChildNamed(PurchaseOrderLight_.orderDate), ConverterRegistry.getConverter(DateConverter.class));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.supplier);
            this.add(this.date);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.delete.getFocusComponents();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
            }
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.getModel().getNode().getChildNamed(PurchaseOrderLight_.supplier).getValue();
                }
                case 1: {
                    return this.getModel().getNode().getChildNamed(PurchaseOrderLight_.orderDate).getValue();
                }
            }
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currenX = 0;
                int w = TableRowImplPurchase.this.model.getParentModel().getColumnWidth(0);
                TableRowImplPurchase.this.supplier.setLocation(currenX + TableRowImplPurchase.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplPurchase.this.supplier.getPreferredSize().getHeight()) / 2.0));
                TableRowImplPurchase.this.supplier.setSize(w - 2 * TableRowImplPurchase.this.getCellPadding(), (int)TableRowImplPurchase.this.supplier.getPreferredSize().getHeight());
                currenX += w;
                w = TableRowImplPurchase.this.model.getParentModel().getColumnWidth(1);
                TableRowImplPurchase.this.date.setLocation(currenX + TableRowImplPurchase.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplPurchase.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImplPurchase.this.date.setSize(w - 2 * TableRowImplPurchase.this.getCellPadding(), (int)TableRowImplPurchase.this.date.getPreferredSize().getHeight());
                TableRowImplPurchase.this.setControlsX(currenX += w);
                TableRowImplPurchase.this.delete.setLocation(currenX + TableRowImplPurchase.this.getCellPadding(), (int)((double)parent.getHeight() - TableRowImplPurchase.this.delete.getPreferredSize().getHeight()) / 2);
                TableRowImplPurchase.this.delete.setSize(TableRowImplPurchase.this.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImplPurchase.this.getDefaultRowHeight());
            }
        }
    }

    private class TableRowImplRequisition
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel department;
        private TextLabel date;
        private DeleteButton delete;

        public TableRowImplRequisition(Table2RowModel m) {
            super(m);
            this.department = new TextLabel(m.getNode(), ConverterRegistry.getConverter(RequisitionOrderInvoiceConverter.class));
            this.date = new TextLabel(m.getNode().getChildNamed(RequisitionOrderLight_.requiredOn), ConverterRegistry.getConverter(DateConverter.class));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.department);
            this.add(this.date);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.delete.getFocusComponents();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
            }
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.getModel().getNode().getChildNamed(RequisitionOrderLight_.requiredBy).getValue();
                }
                case 1: {
                    return this.getModel().getNode().getChildNamed(RequisitionOrderLight_.requiredOn).getValue();
                }
            }
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currenX = 0;
                int w = TableRowImplRequisition.this.model.getParentModel().getColumnWidth(0);
                TableRowImplRequisition.this.department.setLocation(currenX + TableRowImplRequisition.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplRequisition.this.department.getPreferredSize().getHeight()) / 2.0));
                TableRowImplRequisition.this.department.setSize(w - 2 * TableRowImplRequisition.this.getCellPadding(), (int)TableRowImplRequisition.this.department.getPreferredSize().getHeight());
                currenX += w;
                w = TableRowImplRequisition.this.model.getParentModel().getColumnWidth(1);
                TableRowImplRequisition.this.date.setLocation(currenX + TableRowImplRequisition.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplRequisition.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImplRequisition.this.date.setSize(w - 2 * TableRowImplRequisition.this.getCellPadding(), (int)TableRowImplRequisition.this.date.getPreferredSize().getHeight());
                TableRowImplRequisition.this.setControlsX(currenX += w);
                TableRowImplRequisition.this.delete.setLocation(currenX + TableRowImplRequisition.this.getCellPadding(), (int)((double)parent.getHeight() - TableRowImplRequisition.this.delete.getPreferredSize().getHeight()) / 2);
                TableRowImplRequisition.this.delete.setSize(TableRowImplRequisition.this.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImplRequisition.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ConfigFlightPopupInsert.this.border;
            if (ConfigFlightPopupInsert.this.type == InvoiceConfigType.FLIGHT) {
                h = (int)((double)h + ConfigFlightPopupInsert.this.title.getPreferredSize().getHeight());
                h += ConfigFlightPopupInsert.this.border;
            }
            if (ConfigFlightPopupInsert.this.type == InvoiceConfigType.REQUISITION) {
                h = (int)((double)h + ConfigFlightPopupInsert.this.searchButton.getPreferredSize().getHeight());
                h += ConfigFlightPopupInsert.this.border / 2;
            }
            h = (int)((double)h + ConfigFlightPopupInsert.this.searchButton.getPreferredSize().getHeight());
            h += ConfigFlightPopupInsert.this.border / 2;
            return new Dimension(200, h += 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            int ch = 0;
            if (ConfigFlightPopupInsert.this.animation != null) {
                ConfigFlightPopupInsert.this.animation.setLocation((int)(((double)parent.getWidth() - ConfigFlightPopupInsert.this.animation.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - ConfigFlightPopupInsert.this.animation.getPreferredSize().getHeight()) / 2.0));
                ConfigFlightPopupInsert.this.animation.setSize(ConfigFlightPopupInsert.this.animation.getPreferredSize());
            }
            if (ConfigFlightPopupInsert.this.type == InvoiceConfigType.FLIGHT) {
                ConfigFlightPopupInsert.this.title.setLocation(ConfigFlightPopupInsert.this.border, ConfigFlightPopupInsert.this.border);
                ConfigFlightPopupInsert.this.title.setSize(parent.getWidth() - 2 * ConfigFlightPopupInsert.this.border, (int)ConfigFlightPopupInsert.this.title.getPreferredSize().getHeight());
                ch = ConfigFlightPopupInsert.this.title.getY() + ConfigFlightPopupInsert.this.title.getHeight() + ConfigFlightPopupInsert.this.border;
            } else if (ConfigFlightPopupInsert.this.type == InvoiceConfigType.REQUISITION) {
                ConfigFlightPopupInsert.this.dateType.setLocation(ConfigFlightPopupInsert.this.border, ConfigFlightPopupInsert.this.border);
                ConfigFlightPopupInsert.this.dateType.setSize(180, (int)ConfigFlightPopupInsert.this.dateType.getPreferredSize().getHeight());
                ConfigFlightPopupInsert.this.onlyClosed.setLocation(ConfigFlightPopupInsert.this.dateType.getX() + ConfigFlightPopupInsert.this.dateType.getWidth() + ConfigFlightPopupInsert.this.border, (int)((double)(ConfigFlightPopupInsert.this.dateType.getY() + ConfigFlightPopupInsert.this.dateType.getHeight()) - ConfigFlightPopupInsert.this.onlyClosed.getPreferredSize().getHeight()) + 5);
                ConfigFlightPopupInsert.this.onlyClosed.setSize(ConfigFlightPopupInsert.this.onlyClosed.getPreferredSize());
                ch = ConfigFlightPopupInsert.this.dateType.getY() + ConfigFlightPopupInsert.this.dateType.getHeight() + ConfigFlightPopupInsert.this.border;
            }
            ConfigFlightPopupInsert.this.searchField.setLocation(ConfigFlightPopupInsert.this.border, ch);
            ConfigFlightPopupInsert.this.searchField.setSize(150, (int)ConfigFlightPopupInsert.this.searchField.getPreferredSize().getHeight());
            int cx = ConfigFlightPopupInsert.this.searchField.getX() + ConfigFlightPopupInsert.this.searchField.getWidth();
            if (ConfigFlightPopupInsert.this.haulPanel != null) {
                ConfigFlightPopupInsert.this.flightState.setLocation(ConfigFlightPopupInsert.this.searchField.getX() + ConfigFlightPopupInsert.this.searchField.getWidth() + ConfigFlightPopupInsert.this.border, ch);
                ConfigFlightPopupInsert.this.flightState.setSize(120, (int)ConfigFlightPopupInsert.this.flightState.getPreferredSize().getHeight());
                ConfigFlightPopupInsert.this.haulPanel.setLocation(ConfigFlightPopupInsert.this.flightState.getX() + ConfigFlightPopupInsert.this.flightState.getWidth() + ConfigFlightPopupInsert.this.border, ch);
                ConfigFlightPopupInsert.this.haulPanel.setSize((int)ConfigFlightPopupInsert.this.haulPanel.getPreferredSize().getWidth(), (int)ConfigFlightPopupInsert.this.haulPanel.getPreferredSize().getHeight());
                cx = ConfigFlightPopupInsert.this.haulPanel.getX() + ConfigFlightPopupInsert.this.haulPanel.getWidth();
                ConfigFlightPopupInsert.this.category.setLocation(cx + ConfigFlightPopupInsert.this.border, ch);
                ConfigFlightPopupInsert.this.category.setSize(120, (int)ConfigFlightPopupInsert.this.category.getPreferredSize().getHeight());
                cx = ConfigFlightPopupInsert.this.category.getX() + ConfigFlightPopupInsert.this.category.getWidth();
            }
            ConfigFlightPopupInsert.this.searchButton.setLocation(cx + ConfigFlightPopupInsert.this.border, ch + 22);
            ConfigFlightPopupInsert.this.searchButton.setSize(ConfigFlightPopupInsert.this.searchButton.getPreferredSize());
            ConfigFlightPopupInsert.this.removeAll.setLocation(ConfigFlightPopupInsert.this.searchButton.getX() + ConfigFlightPopupInsert.this.searchButton.getWidth() + 10, ConfigFlightPopupInsert.this.searchButton.getY());
            ConfigFlightPopupInsert.this.removeAll.setSize(ConfigFlightPopupInsert.this.removeAll.getPreferredSize());
            if (ConfigFlightPopupInsert.this.hourlyWork != null) {
                ConfigFlightPopupInsert.this.hourlyWork.setLocation(ConfigFlightPopupInsert.this.removeAll.getX() + ConfigFlightPopupInsert.this.removeAll.getWidth() + 10, ConfigFlightPopupInsert.this.searchField.getY());
                ConfigFlightPopupInsert.this.hourlyWork.setSize(ConfigFlightPopupInsert.this.hourlyWork.getPreferredSize());
            }
            ConfigFlightPopupInsert.this.table.setLocation(0, ConfigFlightPopupInsert.this.searchField.getY() + ConfigFlightPopupInsert.this.searchField.getHeight() + ConfigFlightPopupInsert.this.border / 2);
            if (ConfigFlightPopupInsert.this.type == InvoiceConfigType.PRODUCT) {
                ConfigFlightPopupInsert.this.table.setSize(parent.getWidth(), (int)((double)parent.getHeight() - ((double)(ConfigFlightPopupInsert.this.table.getY() + 5) + ConfigFlightPopupInsert.this.deliveryAirport.getPreferredSize().getHeight() + 5.0)));
                ConfigFlightPopupInsert.this.deliveryAirport.setLocation(0, ConfigFlightPopupInsert.this.table.getY() + ConfigFlightPopupInsert.this.table.getHeight() + 5);
                ConfigFlightPopupInsert.this.deliveryAirport.setSize(parent.getWidth(), (int)ConfigFlightPopupInsert.this.deliveryAirport.getPreferredSize().getHeight());
            } else {
                ConfigFlightPopupInsert.this.table.setSize(parent.getWidth(), parent.getHeight() - (ConfigFlightPopupInsert.this.table.getY() + 1));
            }
        }
    }

    public static enum InvoiceConfigType {
        FLIGHT,
        TRADEGOODS,
        SERVICEPRODUCT,
        REQUISITION,
        PURCHASE,
        PRODUCT,
        HANDLING_COSTS;

    }

    public static enum DateSelectionType {
        SCHEDULED_DELIVERY_DATE,
        DELIVER_DATE;


        public String toString() {
            switch (this) {
                case DELIVER_DATE: {
                    return Words.DELIVERY_DATE;
                }
                case SCHEDULED_DELIVERY_DATE: {
                    return Words.SCHEDULED_DELIVERY_DATE;
                }
            }
            return "";
        }
    }
}

