/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice.creator.details.utils;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbGroupTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.modules.invoice.creator.details.utils.InvoiceConfigPopup;
import ch.icit.pegasus.client.gui.modules.invoice.creator.details.utils.InvoiceGroupTitleConverter;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.invoice.FlightInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.PurchaseInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.RequisitionInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.TradeGoodInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class InvoiceBreadCrumpGroupTable
extends BreadCrumbGroupTable {
    private static final long serialVersionUID = 1L;

    public InvoiceBreadCrumpGroupTable(IDataHandler dataHandler, BreadCrumbPanel master, String buttonText) {
        super(dataHandler, master, buttonText, null);
    }

    @Override
    public Table2RowPanel getGroupTableRow(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    public List<InvoiceComplete> getNewInvoices() {
        ArrayList<InvoiceComplete> invoices = new ArrayList<InvoiceComplete>();
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pi = (TableRowImpl)p;
            invoices.add(pi.makeReadyForCommit());
        }
        return invoices;
    }

    @Override
    public boolean hasAddButton() {
        return false;
    }

    @Override
    public boolean hasTitle() {
        return false;
    }

    @Override
    public void addButtonPressed() {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> a = new ArrayList<TableColumnInfo>();
        a.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 40, 40, 40));
        int tw = this.getTable().getCellPadding() * 2 + this.getTable().getInnerCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) * 2;
        a.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)a.get(0)).setxExpand(1.0);
        ((TableColumnInfo)a.get(1)).setxExpand(0.0);
        return a;
    }

    @Override
    public Comparator<?> getGroupComparator() {
        return null;
    }

    public Converter<Object, String> getTitleConverter() {
        return ConverterRegistry.getConverter(InvoiceGroupTitleConverter.class);
    }

    @Override
    public int getSortingIndex() {
        return 0;
    }

    public List<ScreenValidationObject> validateComponents() {
        ArrayList<ScreenValidationObject> ret = new ArrayList<ScreenValidationObject>();
        for (Table2RowPanel p : this.getTable().getRows()) {
            TableRowImpl m = (TableRowImpl)p;
            List<ScreenValidationObject> a = m.validateRow();
            ret.addAll(a);
        }
        return ret;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private TextLabel customer;
        private EditButton edit;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.customer = new TextLabel(m.getNode().getChildNamed(new String[]{"customer"}), ConverterRegistry.getConverter(CustomerConverter.class));
            this.edit = new EditButton();
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layouter());
            this.edit.addButtonListener(this);
            this.add(this.customer);
            this.add(this.edit);
            this.add(this.delete);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.customer.kill();
            this.edit.kill();
            this.delete.kill();
            this.customer = null;
            this.edit = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.edit.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"customer-number"}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.customer.setEnabled(isEnabled);
            this.edit.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.edit) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.DETAILS);
                popUp.setView(new InvoiceConfigPopup((Node<InvoiceComplete>)this.model.getNode()));
                popUp.showPopUp(x, y, 400, 350, this, source);
            } else if (source == this.delete) {
                InvoiceBreadCrumpGroupTable.this.getTable().getModel().getNode().removeChild(this.getModel().getNode(), 0L);
            }
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            this.customer.setValid();
        }

        public InvoiceComplete makeReadyForCommit() {
            this.model.getNode().commit(InvoiceComplete.class);
            InvoiceComplete invoice = (InvoiceComplete)this.model.getNode().getValue(InvoiceComplete.class);
            Iterator it = this.model.getNode().getChildNamed(new String[]{"invoiceItems"}).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                InvoiceConfigurationComplete c = this.insertItemIntoConfig(n.getValue(), invoice);
                if (n.getValue() instanceof FlightLight) {
                    if (c == null) {
                        c = new FlightInvoiceConfigurationComplete();
                        c.setInvoice(invoice);
                        invoice.getConfigurations().add(c);
                    }
                    ((FlightInvoiceConfigurationComplete)c).getFlights().add((FlightLight)n.getValue());
                    continue;
                }
                if (n.getValue() instanceof TradeGoodsLight) {
                    if (c == null) {
                        c = new TradeGoodInvoiceConfigurationComplete();
                        c.setInvoice(invoice);
                        invoice.getConfigurations().add(c);
                    }
                    ((TradeGoodInvoiceConfigurationComplete)c).getTradeGoods().add((TradeGoodsLight)n.getValue(TradeGoodsLight.class));
                    continue;
                }
                if (n.getValue() instanceof RequisitionOrderLight) {
                    if (c == null) {
                        c = new RequisitionInvoiceConfigurationComplete();
                        c.setInvoice(invoice);
                        invoice.getConfigurations().add(c);
                    }
                    ((RequisitionInvoiceConfigurationComplete)c).getRequisitions().add((RequisitionOrderLight)n.getValue());
                    continue;
                }
                if (!(n.getValue() instanceof PurchaseOrderLight)) continue;
                if (c == null) {
                    c = new PurchaseInvoiceConfigurationComplete();
                    c.setInvoice(invoice);
                    invoice.getConfigurations().add(c);
                }
                ((PurchaseInvoiceConfigurationComplete)c).getPurchaseOrders().add((PurchaseOrderLight)n.getValue());
            }
            return invoice;
        }

        private InvoiceConfigurationComplete insertItemIntoConfig(Object invoiceItem, InvoiceComplete invoice) {
            for (InvoiceConfigurationComplete c : invoice.getConfigurations()) {
                if (invoiceItem instanceof FlightLight && c instanceof FlightInvoiceConfigurationComplete) {
                    return c;
                }
                if (invoiceItem instanceof TradeGoodsLight && c instanceof TradeGoodInvoiceConfigurationComplete) {
                    return c;
                }
                if (invoiceItem instanceof RequisitionOrderLight && c instanceof RequisitionInvoiceConfigurationComplete) {
                    return c;
                }
                if (!(invoiceItem instanceof PurchaseOrderLight) || !(c instanceof PurchaseInvoiceConfigurationComplete)) continue;
                return c;
            }
            return null;
        }

        public List<ScreenValidationObject> validateRow() {
            ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
            if (this.model.getNode().getChildNamed(new String[]{"invoiceDate"}).getValue() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DATE_IS_SET));
            }
            if (this.model.getNode().getChildNamed(new String[]{"period"}).getValue() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_START_END_DATE));
            } else {
                if (this.model.getNode().getChildNamed(new String[]{"period-startDate"}).getValue() == null) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_START_END_DATE));
                }
                if (this.model.getNode().getChildNamed(new String[]{"period-endDate"}).getValue() == null) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_START_END_DATE));
                }
            }
            if (this.model.getNode().getChildNamed(new String[]{"customer"}).getValue() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMER));
            }
            if (!a.isEmpty()) {
                this.customer.setInvalid();
            } else {
                a.addAll(this.checkInvoicedItems((Date)this.model.getNode().getChildNamed(new String[]{"period-startDate"}).getValue(), (Date)this.model.getNode().getChildNamed(new String[]{"period-endDate"}).getValue(), (CustomerLight)this.model.getNode().getChildNamed(new String[]{"customer"}).getValue()));
            }
            if (!a.isEmpty()) {
                this.customer.setInvalid();
            }
            return a;
        }

        private List<ScreenValidationObject> checkInvoicedItems(Date startDate, Date endDate, CustomerLight currentCustomer) {
            ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
            return rets;
        }

        private class Layouter
        extends DefaultLayout {
            private Layouter() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.customer.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.edit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.edit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.edit.setSize(TableRowImpl.this.edit.getPreferredSize());
                TableRowImpl.this.delete.setLocation(TableRowImpl.this.edit.getX() + TableRowImpl.this.edit.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

