/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice.creator.details;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.FlightDateConverter;
import ch.icit.pegasus.client.converter.LegListStringConverter;
import ch.icit.pegasus.client.converter.PurchaseOrderInvoiceConverter;
import ch.icit.pegasus.client.converter.RequisitionOrderInvoiceConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.invoice.InvoiceToolkit;
import ch.icit.pegasus.client.gui.modules.invoice.creator.details.InvoiceDetailsPanel;
import ch.icit.pegasus.client.gui.modules.invoice.manager.details.utils.ConfigFlightPopupInsert;
import ch.icit.pegasus.client.gui.modules.invoice.manager.details.utils.InvoiceConfigurationPanel;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitScreenView;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitView;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.DepartmentConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.CellViewFlightStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.custom.CellViewReturnsCountStateERenderer;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight_;
import ch.icit.pegasus.server.core.dtos.report.OrderInvoiceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.TradeGoodsSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight_;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class InvoiceSearchDetailsPanel
extends SplitView
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private TitledItem<SearchComboBox> customer;
    private TitledItem<SearchTextField> name;
    private TitledPeriodEditor period;
    private TitledItem<ComboBox> category;
    private TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>> haulPanel;
    private TitledItem<ComboBox> department;
    private TitledItem<ComboBox> flightState;
    private TitledItem<CheckBox> tradeGoods;
    private TitledItem<CheckBox> flights;
    private TitledItem<CheckBox> requisitions;
    private TitledItem<CheckBox> purchase;
    private TitledItem<CheckBox> onlyClosed;
    private TitledItem<ComboBox> dateType;
    private TitledItem<SearchComboBox> supplier;
    private TitledItem<ComboBox> requisitionInternalDepartment;
    private TitledItem<ComboBox> requisitionAirlineDepartment;
    private TitledItem<SearchTextField2> airport;
    private LoadingAnimation animation;
    private TextButton search;
    private TextButton addAll;
    private TextButton fillAllEmptyCustomers;
    private Table2 table;
    private int horizontalBorder;
    private int verticalBorder;
    private SplitScreenView view;
    private InvoiceDetailsPanel invoicePanel;
    private ComboBox periodSearchMode;

    public InvoiceSearchDetailsPanel(SplitScreenView view, InvoiceDetailsPanel panel) {
        this.view = view;
        this.invoicePanel = panel;
        this.isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        this.horizontalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_horizontal_border"));
        this.verticalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_vertical_border"));
        this.customer = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCustomerSearchField(true, new DTOProxyNode()), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        if (!this.isSolarCompany) {
            this.supplier = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getSupplierSearchField(true, new DTOProxyNode()), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        }
        this.name = new TitledItem<SearchTextField>(new SearchTextField(), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        Date d = new Date(System.currentTimeMillis());
        PeriodComplete p = new PeriodComplete(d, d);
        EmbeddedDTONode n = new EmbeddedDTONode();
        n.setValue((Object)p, 0L);
        this.period = new TitledPeriodEditor((Node<PeriodComplete>)n, true, null);
        this.period.setComboBoxWidth(100);
        this.period.setInnerGap(-1);
        if (!this.isSolarCompany) {
            this.onlyClosed = new TitledItem<CheckBox>(new CheckBox(), Words.ONLY_CLOSED, TitledItem.TitledItemOrientation.EAST);
            this.dateType = new TitledItem<ComboBox>(new ComboBox(), Words.DATE_SELECTION, TitledItem.TitledItemOrientation.NORTH);
            this.dateType.getElement().addItem(ConfigFlightPopupInsert.DateSelectionType.DELIVER_DATE);
            this.dateType.getElement().addItem(ConfigFlightPopupInsert.DateSelectionType.SCHEDULED_DELIVERY_DATE);
            this.department = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(DepartmentConverter.class), true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
            this.flightState = new TitledItem<ComboBox>(ComboBoxFactory.getFlightStateComboBoxWithoutPlanned(), Words.FLIGHT_STATE, TitledItem.TitledItemOrientation.NORTH);
            this.tradeGoods = new TitledItem<CheckBox>(new CheckBox(), Words.TRADE_GOODS, TitledItem.TitledItemOrientation.EAST);
            this.flights = new TitledItem<CheckBox>(new CheckBox(), Words.FLIGHTS, TitledItem.TitledItemOrientation.EAST);
            this.requisitions = new TitledItem<CheckBox>(new CheckBox(), Words.REQUISITION_ORDER, TitledItem.TitledItemOrientation.EAST);
            this.purchase = new TitledItem<CheckBox>(new CheckBox(), Words.PURCHASE_ORDER, TitledItem.TitledItemOrientation.EAST);
            MultiHaulTypeSelectionComboBox haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
            this.haulPanel = new TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>>(new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(haulCombo), Words.HAUL_TYPE, TitledItem.TitledItemOrientation.NORTH);
            this.airport = new TitledItem<SearchTextField2<AirportComplete>>(SearchTextField2Factory.getAirportSearchField(true, new DTOProxyNode()), Words.DELIVERY_AIRPORT, TitledItem.TitledItemOrientation.NORTH);
            this.requisitionInternalDepartment = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(DepartmentConverter.class), true), Words.REQUIRED_BY_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
            this.requisitionAirlineDepartment = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(DepartmentConverter.class), true), Words.ORDERED_FOR_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
            this.periodSearchMode = new ComboBox();
            this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.staOnly);
            this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
            this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
            this.periodSearchMode.setSelectedItem(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
            this.period.setComboBox(this.periodSearchMode);
            this.category = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(FlightCategoryComplete.class), ConverterRegistry.getConverter(FlightCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
            this.fillAllEmptyCustomers = new TextButton("Fill empty Customers");
            this.fillAllEmptyCustomers.addButtonListener(this);
        }
        this.search = new TextButton(Words.SEARCH);
        this.search.addButtonListener(this);
        this.addAll = new TextButton(Words.ADD_ALL);
        this.addAll.addButtonListener(this);
        this.table = new Table2(false, "", false, false);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw1 = 100;
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", tw1, tw1, tw1));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth));
        if (!this.isSolarCompany) {
            columns.add(new TableColumnInfo(Words.LEGS, null, null, null, "", TableColumnInfo.legsWidth, TableColumnInfo.legsWidth, TableColumnInfo.legsWidth));
            tw1 = TableColumnInfo.state3 + 2 * this.table.getCellPadding();
            columns.add(new TableColumnInfo(Words.RC_STATE, null, null, null, "", tw1, tw1, tw1));
            tw1 = TableColumnInfo.periodColumnWidth + 2 * TableColumnInfo.timeColumnWidth + 2 * this.table.getCellPadding();
        }
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", tw1, tw1, tw1));
        if (!this.isSolarCompany) {
            columns.add(new TableColumnInfo(Words.UNINVOICED_PARTS, null, null, null, "", 135, 135, 135));
        }
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + this.table.getCellPadding() * 2 + 10;
        columns.add(new TableColumnInfo(Words.ADD, null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode(view.getSplitView1List());
        this.setLayout(new Layout());
        if (!this.isSolarCompany) {
            this.add(this.requisitionInternalDepartment);
            this.add(this.requisitionAirlineDepartment);
            this.add(this.category);
            this.add(this.haulPanel);
            this.add(this.supplier);
            this.add(this.flights);
            this.add(this.tradeGoods);
            this.add(this.requisitions);
            this.add(this.purchase);
            this.add(this.flightState);
            this.add(this.department);
            this.add(this.onlyClosed);
            this.add(this.dateType);
            this.add(this.airport);
            this.add(this.fillAllEmptyCustomers);
        }
        this.add(this.customer);
        this.add(this.name);
        this.add(this.period);
        this.add(this.search);
        this.add(this.table);
        this.add(this.addAll);
    }

    private void ensureAnimation() {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(Words.LOAD);
            this.add((Component)this.animation, 0);
            this.animation.start();
            this.animation.fadeIn();
        }
        this.revalidate();
    }

    private void removeAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation.stop();
            this.animation = null;
        }
    }

    @Override
    public void resetData() {
        this.table.getModel().setNode(new Node());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (!this.isSolarCompany) {
            this.flights.setEnabled(isEnabled);
            this.tradeGoods.setEnabled(isEnabled);
            this.category.setEnabled(isEnabled);
            this.haulPanel.setEnabled(isEnabled);
            this.requisitions.setEnabled(isEnabled);
            this.purchase.setEnabled(isEnabled);
            this.department.setEnabled(isEnabled);
            this.flightState.setEnabled(isEnabled);
            this.onlyClosed.setEnabled(isEnabled);
            this.dateType.setEnabled(isEnabled);
            this.supplier.setEnabled(isEnabled);
            this.requisitionInternalDepartment.setEnabled(isEnabled);
            this.requisitionAirlineDepartment.setEnabled(isEnabled);
            this.airport.setEnabled(isEnabled);
            this.fillAllEmptyCustomers.setEnabled(isEnabled);
        }
        this.customer.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.period.setEnabled(isEnabled);
        this.search.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        this.addAll.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (!this.isSolarCompany) {
            this.flights.kill();
            this.tradeGoods.kill();
            this.category.kill();
            this.haulPanel.kill();
            this.requisitions.kill();
            this.purchase.kill();
            this.department.kill();
            this.flightState.kill();
            this.onlyClosed.kill();
            this.dateType.kill();
            this.supplier.kill();
            this.requisitionInternalDepartment.kill();
            this.requisitionAirlineDepartment.kill();
            this.airport.kill();
            this.fillAllEmptyCustomers.kill();
        }
        this.customer.kill();
        this.name.kill();
        this.period.kill();
        this.search.kill();
        this.table.kill();
        this.addAll.kill();
        this.customer = null;
        this.name = null;
        this.period = null;
        this.flights = null;
        this.tradeGoods = null;
        this.search = null;
        this.table = null;
        this.addAll = null;
        this.category = null;
        this.haulPanel = null;
        this.requisitions = null;
        this.purchase = null;
        this.department = null;
        this.flightState = null;
        this.onlyClosed = null;
        this.dateType = null;
        this.supplier = null;
        this.requisitionInternalDepartment = null;
        this.requisitionAirlineDepartment = null;
        this.airport = null;
        this.fillAllEmptyCustomers = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.flightState);
        CheckedListAdder.addToList(focusList, this.haulPanel);
        CheckedListAdder.addToList(focusList, this.supplier);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.category);
        CheckedListAdder.addToList(focusList, this.period);
        CheckedListAdder.addToList(focusList, this.flights);
        CheckedListAdder.addToList(focusList, this.tradeGoods);
        CheckedListAdder.addToList(focusList, this.requisitions);
        CheckedListAdder.addToList(focusList, this.purchase);
        CheckedListAdder.addToList(focusList, this.dateType);
        CheckedListAdder.addToList(focusList, this.onlyClosed);
        CheckedListAdder.addToList(focusList, this.search);
        CheckedListAdder.addToList(focusList, this.fillAllEmptyCustomers);
        CheckedListAdder.addToList(focusList, this.requisitionInternalDepartment);
        CheckedListAdder.addToList(focusList, this.requisitionAirlineDepartment);
        CheckedListAdder.addToList(focusList, this.airport);
        return focusList;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        super.setVisibleContainer(pane);
        if (!this.isSolarCompany) {
            this.flightState.setVisibleContainer(pane);
            this.category.setVisibleContainer(pane);
            this.flights.setVisibleContainer(pane);
            this.tradeGoods.setVisibleContainer(pane);
            this.haulPanel.setVisibleContainer(pane);
            this.department.setVisibleContainer(pane);
            this.supplier.setVisibleContainer(pane);
            this.fillAllEmptyCustomers.setVisibleContainer(pane);
            this.dateType.setVisibleContainer(pane);
            this.onlyClosed.setVisibleContainer(pane);
            this.requisitions.setVisibleContainer(pane);
            this.purchase.setVisibleContainer(pane);
            this.requisitionInternalDepartment.setVisibleContainer(pane);
            this.requisitionAirlineDepartment.setVisibleContainer(pane);
            this.airport.setVisibleContainer(pane);
        }
        this.customer.setVisibleContainer(pane);
        this.name.setVisibleContainer(pane);
        this.period.setVisibleContainer(pane);
        this.search.setVisibleContainer(pane);
        this.table.setVisibleContainer(pane);
        this.addAll.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.customer.getElement().requestFocusInWindowNow();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        block12: {
            CustomerLight sc;
            TableRowImpl ri;
            block13: {
                block11: {
                    if (source != this.fillAllEmptyCustomers) break block11;
                    CustomerLight customer = (CustomerLight)this.customer.getElement().getNode().getValue();
                    if (customer == null) {
                        InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Select Customer in 'Customer Search Field'.")}), "Unable to insert Customer to empty Invoice entries", (Component)this);
                        return;
                    }
                    for (Table2RowPanel row : this.table.getRows()) {
                        TableRowImpl rowImpl = (TableRowImpl)row;
                        if (rowImpl.customerSearch.getNode() == null) continue;
                        rowImpl.customerSearch.getNode().setValue((Object)customer, 0L);
                    }
                    break block12;
                }
                if (source != this.search) break block13;
                if (!(this.isSolarCompany || this.flights.getElement().isChecked() || this.tradeGoods.getElement().isChecked() || this.requisitions.getElement().isChecked() || this.purchase.getElement().isChecked())) {
                    InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Nothing selected to search. Please select 'Flights', 'Trade Goods', 'Requisition' or 'Purchase'.")}), "Unable to search not invoiced items", (Component)this);
                    return;
                }
                this.view.setEnabled(false);
                this.ensureAnimation();
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        Node results = new Node();
                        if (InvoiceSearchDetailsPanel.this.isSolarCompany) {
                            InvoiceSearchDetailsPanel.this.searchFlights(results);
                            return results;
                        }
                        if (((CheckBox)InvoiceSearchDetailsPanel.this.flights.getElement()).isChecked()) {
                            InvoiceSearchDetailsPanel.this.searchFlights(results);
                        }
                        if (((CheckBox)InvoiceSearchDetailsPanel.this.tradeGoods.getElement()).isChecked()) {
                            InvoiceSearchDetailsPanel.this.searchTradeGoods(results);
                        }
                        if (((CheckBox)InvoiceSearchDetailsPanel.this.requisitions.getElement()).isChecked()) {
                            InvoiceSearchDetailsPanel.this.searchRequisitions(results);
                        }
                        if (((CheckBox)InvoiceSearchDetailsPanel.this.purchase.getElement()).isChecked()) {
                            InvoiceSearchDetailsPanel.this.searchPurchaseOrders(results);
                        }
                        return results;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                if (node.getValue() != null && node.getValue() instanceof List) {
                                    List l = (List)node.getValue();
                                    if (!l.isEmpty()) {
                                        InvoiceSearchDetailsPanel.this.view.getSplitView1List().removeExistingValues();
                                        InvoiceSearchDetailsPanel.this.view.getSplitView1List().setValue(node.getValue(), 0L);
                                        InvoiceSearchDetailsPanel.this.view.getSplitView1List().updateNode();
                                        InvoiceSearchDetailsPanel.this.view.getSplitView1List().getAllChildAddEventsFor(null, new String[0]);
                                        InvoiceSearchDetailsPanel.this.table.getModel().setNode(InvoiceSearchDetailsPanel.this.view.getSplitView1List());
                                    } else {
                                        InvoiceSearchDetailsPanel.this.view.getSplitView1List().removeExistingValues();
                                        InvoiceSearchDetailsPanel.this.table.getModel().setNode(null);
                                    }
                                }
                                InvoiceSearchDetailsPanel.this.view.setEnabled(true);
                                InvoiceSearchDetailsPanel.this.removeAnimation();
                            }

                            public void errorOccurred(ClientException exception) {
                                InvoiceSearchDetailsPanel.this.errorOccurred(exception);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
                break block12;
            }
            if (source != this.addAll || this.table == null || this.table.getModel() == null || this.table.getModel().getNode() == null) break block12;
            boolean hasCustomerSet = true;
            for (Table2RowPanel r : this.table.getRows()) {
                ri = (TableRowImpl)r;
                sc = null;
                sc = ri.getModel().getNode().getValue() instanceof PurchaseOrderLight ? (CustomerLight)ri.customerSearch.getNode().getValue() : (ri.getModel().getNode().getValue() instanceof RequisitionOrderLight ? (CustomerLight)ri.customerSearch.getNode().getValue() : (ri.getModel().getNode().getValue() instanceof FlightLight ? (CustomerLight)ri.getModel().getNode().getChildNamed(FlightLight_.customer).getValue() : (CustomerLight)ri.getModel().getNode().getChildNamed(TradeGoodsLight_.customer).getValue()));
                if (sc == null) {
                    hasCustomerSet = false;
                }
                if (hasCustomerSet) continue;
                ri.customerSearch.setInvalid();
            }
            if (!hasCustomerSet) {
                InnerPopupFactory.showErrorDialog("Ensure all Customers are set", (Component)this);
                return;
            }
            for (Table2RowPanel r : this.table.getRows()) {
                ri = (TableRowImpl)r;
                sc = null;
                if (ri.getModel().getNode().getValue() instanceof PurchaseOrderLight) {
                    sc = (CustomerLight)ri.customerSearch.getNode().getValue();
                } else if (ri.getModel().getNode().getValue() instanceof RequisitionOrderLight) {
                    sc = (CustomerLight)ri.customerSearch.getNode().getValue();
                } else {
                    sc = ri.getModel().getNode().getValue() instanceof FlightLight ? (CustomerLight)ri.getModel().getNode().getChildNamed(FlightLight_.customer).getValue() : (CustomerLight)ri.getModel().getNode().getChildNamed(TradeGoodsLight_.customer).getValue();
                    sc = (CustomerLight)ri.getModel().getNode().getChildNamed(new String[]{"customer"}).getValue();
                }
                this.invoicePanel.addInvoiceItems(ri.getModel().getNode(), sc, new PeriodComplete(this.period.getStartDate(), this.period.getEndDate()));
            }
        }
    }

    private void searchTradeGoods(Node results) throws ServiceException {
        TradeGoodsSearchConfiguration c = new TradeGoodsSearchConfiguration();
        c.setCustomer((CustomerReference)this.customer.getElement().getNode().getValue());
        if (this.name.getElement().getText() != null && !this.name.getElement().getText().isEmpty()) {
            c.setName(this.name.getElement().getText());
        }
        c.setPeriod(new PeriodComplete(this.period.getStartDate(), this.period.getEndDate()));
        c.setIsInvoiced(Boolean.valueOf(false));
        SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)c);
        while (sri.hasNext()) {
            TradeGoodsLight n = (TradeGoodsLight)sri.next();
            if (results.getValue() instanceof List) {
                ((List)results.getValue()).add(n);
                continue;
            }
            results.setValue(new ArrayList(), 0L);
            ((List)results.getValue()).add(n);
        }
    }

    private void searchFlights(Node results) throws ServiceException {
        FlightSearchConfiguration c = new FlightSearchConfiguration();
        c.setCustomer((CustomerLight)this.customer.getElement().getNode().getValue());
        if (this.name.getElement().getText() != null && !this.name.getElement().getText().isEmpty()) {
            c.setFlightNumber(this.name.getElement().getText());
        }
        PeriodComplete p = new PeriodComplete(this.period.getStartDate(), this.period.getEndDate());
        c.setIsInvoiced(Boolean.valueOf(false));
        c.setSearchedType(InvoiceTypeE.NORMAL);
        c.setDayPeriod(p);
        if (!this.isSolarCompany) {
            c.setFlightStdSta((FlightSearchConfiguration.FLIGHT_STD_STA)this.periodSearchMode.getSelectedItem());
        } else {
            c.setFlightStdSta(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
        }
        if (!this.isSolarCompany) {
            FlightCategoryComplete cat = null;
            if (this.category.getElement().getSelectedItem() instanceof Node) {
                cat = (FlightCategoryComplete)((Node)this.category.getElement().getSelectedItem()).getValue();
            } else if (this.category.getElement().getSelectedItem() instanceof FlightCategoryComplete) {
                cat = (FlightCategoryComplete)this.category.getElement().getSelectedItem();
            }
            c.setCategory(cat);
            if (this.flightState.getElement() != null && this.flightState.getElement().getSelectedItem() != null) {
                if (this.flightState.getElement().getSelectedItem() instanceof String) {
                    if (this.flightState.getElement().getSelectedItem().equals(Words.ALL)) {
                        c.setFlightState(null);
                    } else if (this.flightState.getElement().getSelectedItem().equals(Words.ALL_EXCEPT_PLANNED)) {
                        c.setOnlyOpenFlights(Boolean.valueOf(true));
                    }
                } else if (this.flightState.getElement().getSelectedItem() instanceof FlightStateE) {
                    FlightStateE fs = (FlightStateE)this.flightState.getElement().getSelectedItem();
                    c.setOnlyOpenFlights(Boolean.valueOf(true));
                    c.setFlightState(fs);
                }
            }
            if (this.haulPanel.getElement().isActivated()) {
                ArrayList<HaulTypeComplete> types = new ArrayList<HaulTypeComplete>();
                Object[] oo = this.haulPanel.getElement().getSelectedObjects();
                if (oo != null) {
                    for (Object o : this.haulPanel.getElement().getSelectedObjects()) {
                        types.add((HaulTypeComplete)o);
                    }
                }
                c.setHaulTypeList(types);
                c.setShowNullHaulTypes(Boolean.valueOf(true));
                c.setHaulType(null);
            } else {
                c.setHaulTypeList(null);
                c.setShowNullHaulTypes(Boolean.valueOf(false));
            }
            c.setDeliveryAirport((AirportComplete)this.airport.getElement().getNode().getValue());
        }
        SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)c);
        while (sri.hasNext()) {
            FlightLight f = (FlightLight)sri.next();
            if (f.getFlightState() == FlightStateE.PLANNED) continue;
            if (f.getFlightState() == FlightStateE.CANCELLED) {
                boolean take = false;
                if (f.getPredefineInvoiceCanceledFlightAdditional().booleanValue()) {
                    take = true;
                }
                if (f.getPredefineInvoiceCanceledFlightHandling().booleanValue()) {
                    take = true;
                }
                if (f.getPredefineInvoiceCanceledFlightHandlingFromStowing().booleanValue()) {
                    take = true;
                }
                if (f.getPredefineInvoiceCanceledFlightMeal().booleanValue()) {
                    take = true;
                }
                if (f.getPredefineInvoiceCanceledFlightStandard().booleanValue()) {
                    take = true;
                }
                if (!take) continue;
            }
            if (results.getValue() instanceof List) {
                ((List)results.getValue()).add(f);
                continue;
            }
            results.setValue(new ArrayList(), 0L);
            ((List)results.getValue()).add(f);
        }
    }

    protected void searchPurchaseOrders(Node results) throws ServiceException {
        OrderInvoiceReportConfiguration configuration = new OrderInvoiceReportConfiguration();
        configuration.setPeriod(new PeriodComplete(this.period.getStartDate(), this.period.getEndDate()));
        configuration.setInternalDepartment((CostCenterComplete)this.department.getElement().getNode().getValue());
        configuration.setUseScheduleDeliveryDate(this.dateType.getElement().getSelectedItem() == ConfigFlightPopupInsert.DateSelectionType.SCHEDULED_DELIVERY_DATE);
        configuration.setSupplier((SupplierLight)this.supplier.getElement().getNode().getValue());
        List ret = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).findInvoicablePurchaseOrders(configuration).getList();
        Integer poNo = null;
        try {
            int i = Integer.valueOf(this.name.getElement().getText());
            poNo = i;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret.isEmpty()) {
            results.removeAllChilds();
            this.table.resetTable();
        }
        for (PurchaseOrderComplete n : ret) {
            if (n.getState() != OrderStateE.CLOSED || poNo != null && poNo.intValue() != n.getNumber().intValue()) continue;
            if (results.getValue() instanceof List) {
                ((List)results.getValue()).add(n);
                continue;
            }
            results.setValue(new ArrayList(), 0L);
            ((List)results.getValue()).add(n);
        }
    }

    protected void searchRequisitions(Node results) throws ServiceException {
        OrderInvoiceReportConfiguration configuration = new OrderInvoiceReportConfiguration();
        configuration.setPeriod(new PeriodComplete(this.period.getStartDate(), this.period.getEndDate()));
        configuration.setInternalDepartment((CostCenterComplete)this.requisitionInternalDepartment.getElement().getNode().getValue());
        configuration.setAirlineDepartment((CostCenterComplete)this.requisitionAirlineDepartment.getElement().getNode().getValue());
        configuration.setOnlyClosed(this.onlyClosed.getElement().isChecked());
        configuration.setUseScheduleDeliveryDate(this.dateType.getElement().getSelectedItem() == ConfigFlightPopupInsert.DateSelectionType.SCHEDULED_DELIVERY_DATE);
        configuration.setIncludeRedirect(Boolean.valueOf(false));
        List ret = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).findInvoicableRequisitionOrders(configuration).getList();
        Integer rqNo = null;
        try {
            int i = Integer.valueOf(this.name.getElement().getText());
            rqNo = i;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (ret.isEmpty()) {
            results.removeAllChilds();
            if (results.getValue() instanceof List) {
                ((List)results.getValue()).clear();
            } else {
                results.setValue(new ArrayList(), 0L);
            }
        } else {
            for (RequisitionOrderComplete n : ret) {
                if (this.onlyClosed.getElement().isChecked() && n.getState() != OrderStateE.CLOSED || rqNo != null && rqNo.intValue() != n.getNumber().intValue()) continue;
                if (results.getValue() instanceof List) {
                    ((List)results.getValue()).add(n);
                    continue;
                }
                results.setValue(new ArrayList(), 0L);
                ((List)results.getValue()).add(n);
            }
        }
    }

    public void dataLoaded() {
        if (!this.isSolarCompany) {
            this.department.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
            this.requisitionAirlineDepartment.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
            this.requisitionInternalDepartment.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
            this.category.getElement().refreshPossibleValues(NodeToolkit.getAffixList(FlightCategoryComplete.class));
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private CellViewFlightStateERenderer flightState;
        private TextLabel name;
        private TextLabel customer;
        private SearchTextField2 customerSearch;
        private TextLabel destination;
        private TextLabel date;
        private CellViewReturnsCountStateERenderer renderer;
        private InvoiceConfigurationPanel uninvoicedParts;
        private AddButton addButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            if (m.getNode().getValue() instanceof FlightLight) {
                String fName = "";
                Node dNode = m.getNode();
                FlightLight flight = (FlightLight)m.getNode().getValue();
                fName = flight.getFlightType() == FlightTypeE.RETURN ? (String)m.getNode().getChildNamed(new String[]{"outboundCode"}).getValue() : (String)m.getNode().getChildNamed(new String[]{"inboundCode"}).getValue();
                if (!InvoiceSearchDetailsPanel.this.isSolarCompany) {
                    fName = fName + " (" + InvoiceToolkit.getLegPaxCount(flight) + ")";
                }
                this.flightState = new CellViewFlightStateERenderer((FlightLight)m.getNode().getValue());
                this.flightState.setCalculationWarningInset(0);
                this.name = new TextLabel(fName);
                this.customer = new TextLabel(((CustomerConverter)ConverterRegistry.getConverter(CustomerConverter.class)).convert(flight.getCustomer(), null, new Object[0]));
                if (!InvoiceSearchDetailsPanel.this.isSolarCompany) {
                    this.renderer = new CellViewReturnsCountStateERenderer(flight.getReturnsCountState(), flight);
                    this.uninvoicedParts = new InvoiceConfigurationPanel(m.getNode());
                    this.destination = new TextLabel(dNode.getChildNamed(FlightLight_.legs), ConverterRegistry.getConverter(LegListStringConverter.class));
                }
                this.date = new TextLabel(dNode, ConverterRegistry.getConverter(FlightDateConverter.class));
            } else if (m.getNode().getValue() instanceof TradeGoodsLight) {
                this.name = new TextLabel(m.getNode().getChildNamed(new String[]{"sellName"}));
                this.customer = new TextLabel(m.getNode().getChildNamed(new String[]{"customer"}), ConverterRegistry.getConverter(CustomerConverter.class));
                this.date = new TextLabel(m.getNode().getChildNamed(new String[]{"sellDate"}), ConverterRegistry.getConverter(DateConverter.class));
                this.uninvoicedParts = new InvoiceConfigurationPanel(m.getNode());
                this.destination = new TextLabel("");
            } else if (m.getNode().getValue() instanceof RequisitionOrderLight) {
                this.name = new TextLabel(m.getNode(), ConverterRegistry.getConverter(RequisitionOrderInvoiceConverter.class));
                this.date = new TextLabel(m.getNode().getChildNamed(RequisitionOrderLight_.requiredOn), ConverterRegistry.getConverter(DateConverter.class));
                DTOProxyNode prox = new DTOProxyNode();
                RequisitionOrderLight o = (RequisitionOrderLight)m.getNode().getValue();
                if (o.getRequiredBy() instanceof ExternalCostCenterComplete) {
                    ExternalCostCenterComplete ic = (ExternalCostCenterComplete)o.getRequiredBy();
                    prox.setValue((Object)ic.getCustomer(), 0L);
                }
                this.customerSearch = SearchTextField2Factory.getCustomerSearchField(true, prox);
            } else if (m.getNode().getValue() instanceof PurchaseOrderLight) {
                this.name = new TextLabel(m.getNode(), ConverterRegistry.getConverter(PurchaseOrderInvoiceConverter.class));
                DTOProxyNode prox = new DTOProxyNode();
                if (m.getNode().getChildNamed(PurchaseOrderLight_.customer) != null && m.getNode().getChildNamed(new DtoField[]{PurchaseOrderLight_.customer, ExternalCostCenterComplete_.customer}) != null) {
                    prox.setValue((Object)((CustomerLight)m.getNode().getChildNamed(new DtoField[]{PurchaseOrderLight_.customer, ExternalCostCenterComplete_.customer}).getValue()), 0L);
                }
                this.customerSearch = SearchTextField2Factory.getCustomerSearchField(true, prox);
                this.date = new TextLabel(m.getNode().getChildNamed(PurchaseOrderLight_.orderDate), ConverterRegistry.getConverter(DateConverter.class));
            }
            this.addButton = new AddButton();
            this.addButton.addButtonListener(this);
            this.setLayout(new Layout());
            if (this.flightState != null) {
                this.add(this.flightState);
            }
            this.add(this.name);
            if (this.customer != null) {
                this.add(this.customer);
            }
            if (this.customerSearch != null) {
                this.add(this.customerSearch);
            }
            if (this.renderer != null) {
                this.add(this.renderer);
            }
            this.add(this.date);
            if (this.uninvoicedParts != null) {
                this.add(this.uninvoicedParts);
            }
            this.add(this.addButton);
            if (this.destination != null) {
                this.add(this.destination);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.name.getText();
                }
                case 1: {
                    return this.date.getNode().getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            if (this.flightState != null) {
                this.flightState.setEnabled(isEnabled);
            }
            if (this.renderer != null) {
                this.renderer.setEnabled(isEnabled);
            }
            if (this.customer != null) {
                this.customer.setEnabled(isEnabled);
            }
            if (this.customerSearch != null) {
                this.customerSearch.setEnabled(isEnabled);
            }
            this.date.setEnabled(isEnabled);
            if (this.uninvoicedParts != null) {
                this.uninvoicedParts.setEnabled(isEnabled);
            }
            this.addButton.setEnabled(isEnabled);
            if (this.destination != null) {
                this.destination.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            if (this.customer != null) {
                this.customer.kill();
            }
            this.date.kill();
            if (this.flightState != null) {
                this.flightState.kill();
            }
            this.flightState = null;
            if (this.uninvoicedParts != null) {
                this.uninvoicedParts.kill();
            }
            this.addButton.kill();
            if (this.destination != null) {
                this.destination.kill();
            }
            if (this.customerSearch != null) {
                this.customerSearch.kill();
            }
            if (this.renderer != null) {
                this.renderer.kill();
            }
            this.name = null;
            this.customer = null;
            this.date = null;
            this.uninvoicedParts = null;
            this.addButton = null;
            this.renderer = null;
            this.destination = null;
            this.customerSearch = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            CustomerLight sc = null;
            sc = this.customerSearch != null ? (CustomerLight)this.customerSearch.getNode().getValue() : (CustomerLight)this.model.getNode().getChildNamed(new String[]{"customer"}).getValue();
            if (sc == null) {
                InnerPopupFactory.showErrorDialog("Please selected Customer first", (Component)this);
                return;
            }
            InvoiceSearchDetailsPanel.this.invoicePanel.addInvoiceItems(this.model.getNode(), sc, new PeriodComplete(InvoiceSearchDetailsPanel.this.period.getStartDate(), InvoiceSearchDetailsPanel.this.period.getEndDate()));
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                if (TableRowImpl.this.flightState != null) {
                    TableRowImpl.this.flightState.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightState.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.flightState.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightState.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                if (TableRowImpl.this.customer != null) {
                    TableRowImpl.this.customer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                }
                if (TableRowImpl.this.customerSearch != null) {
                    TableRowImpl.this.customerSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customerSearch.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.customerSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customerSearch.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                if (TableRowImpl.this.destination != null) {
                    TableRowImpl.this.destination.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.destination.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.destination.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.destination.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                if (TableRowImpl.this.renderer != null) {
                    TableRowImpl.this.renderer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.renderer.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.renderer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.renderer.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                if (TableRowImpl.this.uninvoicedParts != null) {
                    TableRowImpl.this.uninvoicedParts.setLocation(currentX + TableRowImpl.this.getCellPadding(), 0);
                    TableRowImpl.this.uninvoicedParts.setSize(w - 2 * TableRowImpl.this.getCellPadding(), parent.getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.addButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.addButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.addButton.setSize(TableRowImpl.this.addButton.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            if (InvoiceSearchDetailsPanel.this.animation != null) {
                InvoiceSearchDetailsPanel.this.animation.setLocation((int)(((double)parent.getWidth() - InvoiceSearchDetailsPanel.this.animation.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - InvoiceSearchDetailsPanel.this.animation.getPreferredSize().getHeight()) / 2);
                InvoiceSearchDetailsPanel.this.animation.setSize(InvoiceSearchDetailsPanel.this.animation.getPreferredSize());
            }
            InvoiceSearchDetailsPanel.this.customer.setLocation(InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.verticalBorder);
            InvoiceSearchDetailsPanel.this.customer.setSize(195, (int)InvoiceSearchDetailsPanel.this.customer.getPreferredSize().getHeight());
            InvoiceSearchDetailsPanel.this.name.setLocation(InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.customer.getY() + InvoiceSearchDetailsPanel.this.customer.getHeight() + InvoiceSearchDetailsPanel.this.verticalBorder / 2);
            InvoiceSearchDetailsPanel.this.name.setSize(195, (int)InvoiceSearchDetailsPanel.this.name.getPreferredSize().getHeight());
            if (!InvoiceSearchDetailsPanel.this.isSolarCompany) {
                InvoiceSearchDetailsPanel.this.haulPanel.setLocation(InvoiceSearchDetailsPanel.this.name.getX() + InvoiceSearchDetailsPanel.this.name.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.name.getY());
                InvoiceSearchDetailsPanel.this.haulPanel.setSize(InvoiceSearchDetailsPanel.this.haulPanel.getPreferredSize());
                InvoiceSearchDetailsPanel.this.flightState.setLocation(InvoiceSearchDetailsPanel.this.customer.getX() + InvoiceSearchDetailsPanel.this.customer.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.customer.getY());
                InvoiceSearchDetailsPanel.this.flightState.setSize(InvoiceSearchDetailsPanel.this.haulPanel.getWidth(), (int)InvoiceSearchDetailsPanel.this.flightState.getPreferredSize().getHeight());
                InvoiceSearchDetailsPanel.this.supplier.setLocation(InvoiceSearchDetailsPanel.this.haulPanel.getX() + InvoiceSearchDetailsPanel.this.haulPanel.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.haulPanel.getY());
                InvoiceSearchDetailsPanel.this.supplier.setSize(200, (int)InvoiceSearchDetailsPanel.this.supplier.getPreferredSize().getHeight());
                InvoiceSearchDetailsPanel.this.department.setLocation(InvoiceSearchDetailsPanel.this.supplier.getX() + InvoiceSearchDetailsPanel.this.supplier.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.haulPanel.getY());
                InvoiceSearchDetailsPanel.this.department.setSize(200, (int)InvoiceSearchDetailsPanel.this.department.getPreferredSize().getHeight());
                InvoiceSearchDetailsPanel.this.dateType.setLocation(InvoiceSearchDetailsPanel.this.department.getX() + InvoiceSearchDetailsPanel.this.department.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.department.getY());
                InvoiceSearchDetailsPanel.this.dateType.setSize(200, (int)InvoiceSearchDetailsPanel.this.dateType.getPreferredSize().getHeight());
                InvoiceSearchDetailsPanel.this.onlyClosed.setLocation(InvoiceSearchDetailsPanel.this.dateType.getX() + InvoiceSearchDetailsPanel.this.dateType.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, (int)((double)(5 + InvoiceSearchDetailsPanel.this.dateType.getY() + InvoiceSearchDetailsPanel.this.dateType.getHeight()) - InvoiceSearchDetailsPanel.this.onlyClosed.getPreferredSize().getHeight()));
                InvoiceSearchDetailsPanel.this.onlyClosed.setSize(200, (int)InvoiceSearchDetailsPanel.this.onlyClosed.getPreferredSize().getHeight());
                InvoiceSearchDetailsPanel.this.category.setLocation(InvoiceSearchDetailsPanel.this.haulPanel.getX() + InvoiceSearchDetailsPanel.this.haulPanel.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.flightState.getY());
                InvoiceSearchDetailsPanel.this.category.setSize(120, (int)InvoiceSearchDetailsPanel.this.category.getPreferredSize().getHeight());
                InvoiceSearchDetailsPanel.this.period.setLocation(InvoiceSearchDetailsPanel.this.category.getX() + InvoiceSearchDetailsPanel.this.category.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.verticalBorder - 2);
                InvoiceSearchDetailsPanel.this.period.setSize(InvoiceSearchDetailsPanel.this.period.getPreferredSize());
                InvoiceSearchDetailsPanel.this.flights.setLocation(InvoiceSearchDetailsPanel.this.period.getX() + InvoiceSearchDetailsPanel.this.period.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.verticalBorder + 7);
                InvoiceSearchDetailsPanel.this.flights.setSize(InvoiceSearchDetailsPanel.this.flights.getPreferredSize());
                InvoiceSearchDetailsPanel.this.tradeGoods.setLocation(InvoiceSearchDetailsPanel.this.flights.getX(), InvoiceSearchDetailsPanel.this.flights.getY() + InvoiceSearchDetailsPanel.this.flights.getHeight() - 2);
                InvoiceSearchDetailsPanel.this.tradeGoods.setSize(InvoiceSearchDetailsPanel.this.tradeGoods.getPreferredSize());
                InvoiceSearchDetailsPanel.this.requisitions.setLocation(InvoiceSearchDetailsPanel.this.tradeGoods.getX() + InvoiceSearchDetailsPanel.this.tradeGoods.getWidth() + 15, InvoiceSearchDetailsPanel.this.flights.getY());
                InvoiceSearchDetailsPanel.this.requisitions.setSize(InvoiceSearchDetailsPanel.this.requisitions.getPreferredSize());
                InvoiceSearchDetailsPanel.this.purchase.setLocation(InvoiceSearchDetailsPanel.this.requisitions.getX(), InvoiceSearchDetailsPanel.this.tradeGoods.getY());
                InvoiceSearchDetailsPanel.this.purchase.setSize(InvoiceSearchDetailsPanel.this.purchase.getPreferredSize());
            } else {
                InvoiceSearchDetailsPanel.this.period.setLocation(InvoiceSearchDetailsPanel.this.customer.getX() + InvoiceSearchDetailsPanel.this.customer.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.customer.getY());
                InvoiceSearchDetailsPanel.this.period.setSize(InvoiceSearchDetailsPanel.this.period.getPreferredSize());
            }
            InvoiceSearchDetailsPanel.this.search.setLocation((int)((double)parent.getWidth() - (InvoiceSearchDetailsPanel.this.search.getPreferredSize().getWidth() + (double)InvoiceSearchDetailsPanel.this.horizontalBorder)), (int)((double)(InvoiceSearchDetailsPanel.this.name.getY() + InvoiceSearchDetailsPanel.this.name.getHeight()) - InvoiceSearchDetailsPanel.this.search.getPreferredSize().getHeight()));
            InvoiceSearchDetailsPanel.this.search.setSize(InvoiceSearchDetailsPanel.this.search.getPreferredSize());
            int cy = InvoiceSearchDetailsPanel.this.search.getY() + InvoiceSearchDetailsPanel.this.search.getHeight();
            if (!InvoiceSearchDetailsPanel.this.isSolarCompany) {
                InvoiceSearchDetailsPanel.this.fillAllEmptyCustomers.setLocation((int)((double)(InvoiceSearchDetailsPanel.this.search.getX() + InvoiceSearchDetailsPanel.this.search.getWidth()) - InvoiceSearchDetailsPanel.this.fillAllEmptyCustomers.getPreferredSize().getWidth()), InvoiceSearchDetailsPanel.this.search.getY() + InvoiceSearchDetailsPanel.this.search.getHeight() + InvoiceSearchDetailsPanel.this.horizontalBorder);
                InvoiceSearchDetailsPanel.this.fillAllEmptyCustomers.setSize(InvoiceSearchDetailsPanel.this.fillAllEmptyCustomers.getPreferredSize());
                InvoiceSearchDetailsPanel.this.requisitionInternalDepartment.setLocation(InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.name.getY() + InvoiceSearchDetailsPanel.this.name.getHeight() + InvoiceSearchDetailsPanel.this.verticalBorder);
                InvoiceSearchDetailsPanel.this.requisitionInternalDepartment.setSize(200, (int)InvoiceSearchDetailsPanel.this.requisitionInternalDepartment.getPreferredSize().getHeight());
                InvoiceSearchDetailsPanel.this.requisitionAirlineDepartment.setLocation(InvoiceSearchDetailsPanel.this.requisitionInternalDepartment.getX() + InvoiceSearchDetailsPanel.this.requisitionInternalDepartment.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.requisitionInternalDepartment.getY());
                InvoiceSearchDetailsPanel.this.requisitionAirlineDepartment.setSize(200, (int)InvoiceSearchDetailsPanel.this.requisitionAirlineDepartment.getPreferredSize().getHeight());
                InvoiceSearchDetailsPanel.this.airport.setLocation(InvoiceSearchDetailsPanel.this.requisitionAirlineDepartment.getX() + InvoiceSearchDetailsPanel.this.requisitionAirlineDepartment.getWidth() + InvoiceSearchDetailsPanel.this.horizontalBorder, InvoiceSearchDetailsPanel.this.requisitionInternalDepartment.getY());
                InvoiceSearchDetailsPanel.this.airport.setSize(200, (int)InvoiceSearchDetailsPanel.this.airport.getPreferredSize().getHeight());
                cy = InvoiceSearchDetailsPanel.this.requisitionInternalDepartment.getY() + InvoiceSearchDetailsPanel.this.requisitionInternalDepartment.getHeight();
            }
            InvoiceSearchDetailsPanel.this.table.setLocation(2, cy + InvoiceSearchDetailsPanel.this.verticalBorder);
            InvoiceSearchDetailsPanel.this.table.setSize(parent.getWidth() - 4, (int)((double)parent.getHeight() - ((double)(InvoiceSearchDetailsPanel.this.table.getY() + 2 * InvoiceSearchDetailsPanel.this.verticalBorder) + InvoiceSearchDetailsPanel.this.addAll.getPreferredSize().getHeight())));
            InvoiceSearchDetailsPanel.this.addAll.setLocation((int)((double)parent.getWidth() - (InvoiceSearchDetailsPanel.this.addAll.getPreferredSize().getWidth() + (double)InvoiceSearchDetailsPanel.this.horizontalBorder)), InvoiceSearchDetailsPanel.this.table.getY() + InvoiceSearchDetailsPanel.this.table.getHeight() + InvoiceSearchDetailsPanel.this.verticalBorder);
            InvoiceSearchDetailsPanel.this.addAll.setSize(InvoiceSearchDetailsPanel.this.addAll.getPreferredSize());
        }
    }
}

