/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.handlingcosts.details;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.HandlingCostsVariantConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.AVariantTemplateDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;
import java.util.List;

public class TemplateDetailsPanel
extends AVariantTemplateDetailsPanel<HandlingCostComplete, HandlingCostVariantComplete> {
    private static final long serialVersionUID = 1L;

    public TemplateDetailsPanel(RowEditor<HandlingCostComplete> editor, RDProvider provider) {
        super(editor, provider);
    }

    @Override
    public Converter<?, String> getVariantViewConverter() {
        return ConverterRegistry.getConverter(HandlingCostsVariantConverter.class);
    }

    @Override
    public SearchTextField2<HandlingCostComplete> createSearchField() {
        return SearchTextField2Factory.getHandlingCostSearchField(true, new DTOProxyNode());
    }

    @Override
    public HandlingCostComplete reloadItem(HandlingCostComplete item) throws ClientServerCallException {
        return (HandlingCostComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getHandlingCost(item).getValue();
    }

    @Override
    public Class<HandlingCostComplete> getVariantMasterClass() {
        return HandlingCostComplete.class;
    }

    @Override
    public List<HandlingCostVariantComplete> reloadVariants(List<HandlingCostVariantComplete> variants) throws ClientServerCallException {
        ArrayList<HandlingCostVariantComplete> refs = new ArrayList<HandlingCostVariantComplete>();
        refs.addAll(variants);
        return ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getHandlingCostVariants(new ListWrapper(refs)).getList();
    }

    @Override
    public HandlingCostComplete copyItem(HandlingCostComplete master, HandlingCostVariantComplete variant, boolean upload, boolean copyAllVariants) throws ClientServerCallException {
        return CopyTemplateToolkit.copyHandlingCost(master, copyAllVariants ? null : variant);
    }

    @Override
    public Class<HandlingCostVariantComplete> getVariantClass() {
        return HandlingCostVariantComplete.class;
    }

    @Override
    public void initNewVariant(HandlingCostComplete newVariant) {
        newVariant.getCurrentVariant().setName("");
        newVariant.getCurrentVariant().setCustomerInvoiceNumber("");
        newVariant.getCurrentVariant().setState(ModificationStateE.DRAFT);
    }

    @Override
    public String getSearchFieldTitle() {
        return Words.HANDLING_COST;
    }
}

