/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details.utils;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.HandlingCostToolkit;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostTypeE;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class HandlingCostTable<T>
extends DefaultPanel
implements Nodable {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    protected Node<T> node;
    private boolean isDraft = true;
    protected Node<CustomerLight> customer;
    private boolean includeProductHandlingCosts;
    private HandlingCostTypeE type;

    public HandlingCostTable(RDProvider provider, boolean withTitle, boolean includeProductHandlingCosts, HandlingCostTypeE type) {
        this.table = new Table2(true, Words.TABLE_ADD, withTitle, withTitle, Words.HANDLING_COSTS);
        this.includeProductHandlingCosts = includeProductHandlingCosts;
        this.type = type;
        this.table.setProvider(provider);
        this.table.setRequestFocusOnAdd(true);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                HandlingCostTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                HandlingCostTable.this.addButtonPressed();
            }
        });
        List<TableColumnInfo> columns = this.getColumns();
        this.table.setModel(new Table2Model(columns, model -> this.getRowPanel(model)));
        this.setLayout(new Layout());
        this.add(this.table);
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    public Table2RowPanel getRowPanel(Table2RowModel model) {
        return new TableRowImpl(model);
    }

    public void addButtonPressed() {
        DTOProxyNode n = new DTOProxyNode();
        try {
            this.node.getChildNamed(this.getAttributeName()).addChild((Node)n, System.currentTimeMillis());
        }
        catch (Exception e) {
            System.out.println("Upable to set generic Child");
            e.printStackTrace();
        }
        this.revalidate();
        this.getParent().validate();
    }

    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 30, 30, 30));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    public abstract DtoField[] getAttributeName();

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.table.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    public abstract Node<CustomerLight> getCustomerNode();

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        this.isDraft = true;
        this.setCustomer(this.getCustomerNode());
        this.table.getModel().setNode(node.getChildNamed(this.getAttributeName()));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled && this.isDraft);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    public void setCustomer(Node<CustomerLight> iWriteNode) {
        this.customer = iWriteNode;
    }

    public Table2 getTable() {
        return this.table;
    }

    public List<ScreenValidationObject> validateTable(boolean withText) {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            boolean valid = true;
            HashSet<HandlingCostComplete> handlingCost = new HashSet<HandlingCostComplete>();
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl pp = (TableRowImpl)p;
                if (!pp.isElementSet()) {
                    valid = false;
                    pp.setInValid();
                }
                if (handlingCost.add((HandlingCostComplete)p.getModel().getNode().getValue())) continue;
                valid = false;
                pp.setInValid();
            }
            if (!valid && withText) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_HANDLING_COST_SET_AND_UNIQUE));
            }
        }
        return o;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    public void setEditable(boolean isEditable) {
        this.table.setEditable(isEditable);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private RDSearchComboBox name;
        private DeleteButton delete;
        private InfoButton infoButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.name = new RDSearchComboBox(m.getParentModel().getTable().getProvider(), RDSearchComboBox.BoxSearchTypes.HANDLINGCOST);
            this.name.setOverrideName("handlingCosts");
            this.name.setNode(m.getNode());
            if (this.name.getEditor() != null) {
                Object[] o = new Object[3];
                o[0] = HandlingCostTable.this.customer;
                o[1] = HandlingCostTable.this.includeProductHandlingCosts;
                if (HandlingCostTable.this.type != null) {
                    o[2] = HandlingCostTable.this.type;
                }
                ((SearchComboBox)this.name.getEditor()).setAdditionalSearchField(o);
            }
            this.name.setProgress(1.0f);
            this.infoButton = new InfoButton(Words.HANDLING_COST_INFO);
            this.infoButton.installStringViewer(HandlingCostToolkit.getHandlingCostInfoString((HandlingCostComplete)this.model.getNode().getValue(), null));
            this.setLayout(new InnerLayout());
            if (m.getParentModel().getTable().getProvider() == null || m.getParentModel().getTable().getProvider().isDeletable("handlingCosts")) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
            }
            this.model.getNode().addNodeListener((NodeListener)this);
            this.add(this.name);
            this.add(this.infoButton);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.name.getText();
                }
            }
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.name != null) {
                this.name.requestFocusInWindowNow();
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
            this.infoButton.setEnabled(this.getModel().getParentModel().getTable().isEnabled());
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.name);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.name = null;
            this.infoButton.kill();
            this.infoButton = null;
            if (this.delete != null) {
                this.delete.kill();
            }
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (this.delete == source) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public boolean isElementSet() {
            if (this.model.getNode() != null) {
                return this.model.getNode().getValue() != null;
            }
            return false;
        }

        public void setInValid() {
            this.name.setInvalid();
        }

        public void valueChanged(Node<?> node) {
            if (this.infoButton != null && this.model.getNode() != null && this.model.getNode().getValue(HandlingCostComplete.class) != null) {
                this.infoButton.installStringViewer(HandlingCostToolkit.getHandlingCostInfoString((HandlingCostComplete)this.model.getNode().getValue(HandlingCostComplete.class), null));
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize((int)((double)w - ((double)(3 * TableRowImpl.this.getCellPadding()) + TableRowImpl.this.infoButton.getPreferredSize().getWidth())), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.name.getX() + TableRowImpl.this.name.getWidth() + HandlingCostTable.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            HandlingCostTable.this.table.setLocation(0, 0);
            HandlingCostTable.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }
    }
}

