/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details.utils;

import ch.icit.pegasus.client.converter.AircraftConverter;
import ch.icit.pegasus.client.converter.StowagePositionIdentifierConverter;
import ch.icit.pegasus.client.converter.StowingListNameConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.MappingTable2D;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.multiprint.ScrollablePopupInsert;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.StowagePositionIdentifier;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AircraftMappingPopup
extends ScrollablePopupInsert
implements AnimationListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> stowingList;
    private TitledItem<TextLabel> aircraft;
    private HorizontalSeparator sep1;
    private TitledItem<MappingTable2D<StowagePositionIdentifier, StowagePositionIdentifier>> mapping;
    protected Map<StowagePositionIdentifier, StowagePositionIdentifier> defaultMapping;
    private LoadingAnimation animation;
    private final Node stowing;
    private static final int STATE_LOAD_STOWING = 3;
    private static final int STATE_DO_MAPPING = 5;
    private static final int STATE_ERROR = 7;
    private String errorMsg = "";
    private final String copyMsg = "";
    private boolean isLoading = false;
    private int currentState = 0;
    private boolean autoMap = false;
    private Node<AircraftLight> newAircraft;
    private Node<Map<StowagePositionIdentifier, StowagePositionIdentifier>> aircraftMapping;

    public AircraftMappingPopup(Node<StowingListTemplateVariantLight> currentStowing, Node<AircraftLight> newAircraft, Node<Map<StowagePositionIdentifier, StowagePositionIdentifier>> aircraftMapping) {
        this(currentStowing, newAircraft, aircraftMapping, true);
    }

    public AircraftMappingPopup(Node<StowingListTemplateVariantLight> currentStowing, Node<AircraftLight> newAircraft, Node<Map<StowagePositionIdentifier, StowagePositionIdentifier>> aircraftMapping, boolean autoMap) {
        this.stowing = currentStowing;
        this.autoMap = autoMap;
        this.newAircraft = newAircraft;
        this.aircraftMapping = aircraftMapping;
        this.addInnerComponents();
        this.loadMappingData();
    }

    private void showAnimation(String text) {
        this.setEnabled(false);
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.getViewContainer().add((Component)this.animation, 0);
            this.animation.start();
            this.animation.fadeIn();
        }
        this.animation.stateChanged(text);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.setEnabled(true);
    }

    private void addInnerComponents() {
        this.getViewContainer().setLayout(new Layout());
        this.stowingList = new TitledItem<TextLabel>(new TextLabel(this.stowing, ConverterRegistry.getConverter(StowingListNameConverter.class)), Words.STOWING_LIST, TitledItem.TitledItemOrientation.NORTH);
        this.aircraft = new TitledItem<TextLabel>(new TextLabel(this.newAircraft, ConverterRegistry.getConverter(AircraftConverter.class)), Words.AIRCRAFT, TitledItem.TitledItemOrientation.NORTH);
        this.sep1 = new HorizontalSeparator();
        this.mapping = new TitledItem<1>(new MappingTable2D<StowagePositionIdentifier, StowagePositionIdentifier>(StowagePositionIdentifierConverter.class, StowagePositionIdentifierConverter.class, Words.STOWAGE_MAPPING_EQUIPMENT, Words.STOWAGE_MAPPING_AIRCRAFT, null, null){
            private static final long serialVersionUID = 1L;

            @Override
            public void findSelection(Node<StowagePositionIdentifier> currentNode, String text, List<Node<StowagePositionIdentifier>> mappingList, TextLabel currentCombo, List<Node<StowagePositionIdentifier>> sources) {
                StowagePositionIdentifier currentGroup = (StowagePositionIdentifier)currentNode.getValue();
                if (!AircraftMappingPopup.this.autoMap && AircraftMappingPopup.this.aircraftMapping != null) {
                    StowagePositionIdentifier np = (StowagePositionIdentifier)((Map)AircraftMappingPopup.this.aircraftMapping.getValue()).get(currentGroup);
                    Node id = INodeCreator.getDefaultImpl().getNode4DTO((Object)np, false, false);
                    currentCombo.setNode(id);
                } else if (AircraftMappingPopup.this.defaultMapping != null) {
                    StowagePositionIdentifier r = AircraftMappingPopup.this.defaultMapping.get(currentNode.getValue());
                    if (r != null) {
                        Node id = INodeCreator.getDefaultImpl().getNode4DTO((Object)r, false, false);
                        currentCombo.setNode(id);
                    }
                } else {
                    for (Node<StowagePositionIdentifier> n : mappingList) {
                        StowagePositionIdentifier posID = (StowagePositionIdentifier)n.getValue();
                        if (!posID.getGalleyCode().equals(currentGroup.getGalleyCode()) || !posID.getPositionCode().equals(currentGroup.getPositionCode())) continue;
                        if (posID.getIsHold() && currentGroup.getIsHold()) {
                            currentCombo.setNode((Node)n);
                            return;
                        }
                        if (posID.getIsHold() || currentGroup.getIsHold()) continue;
                        currentCombo.setNode((Node)n);
                        return;
                    }
                }
            }
        }, Words.STOWAGE_MAPPING, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add((Component)this.stowingList, -1);
        this.getViewContainer().add((Component)this.aircraft, -1);
        this.getViewContainer().add((Component)this.sep1, -1);
        this.getViewContainer().add((Component)this.mapping, -1);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.aircraft != null) {
            this.aircraft.setEnabled(isEnabled);
            this.stowingList.setEnabled(isEnabled);
            this.mapping.setEnabled(isEnabled);
            this.sep1.setEnabled(isEnabled);
        }
    }

    private void createMapping(List<StowagePositionIdentifier> poses) {
        ArrayList sourceList = new ArrayList();
        ArrayList destinationList = new ArrayList();
        for (StowagePositionIdentifier pose : poses) {
            if (this.isKilled()) {
                return;
            }
            StowagePositionIdentifier g = pose;
            Node p1 = new Node();
            p1.setValue((Object)g, 0L);
            sourceList.add(p1);
        }
        for (StowagePositionIdentifier spi : this.defaultMapping.keySet()) {
            destinationList.add(INodeCreator.getDefaultImpl().getNode4DTO((Object)spi, false, false));
        }
        this.mapping.getElement().setData(destinationList, sourceList);
        this.mapping.getElement().startDownload();
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.mapping != null) {
            return this.mapping.getFocusComponents();
        }
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.stowingList != null) {
            this.stowingList.kill();
        }
        if (this.aircraft != null) {
            this.aircraft.kill();
        }
        if (this.mapping != null) {
            this.mapping.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        this.stowingList = null;
        this.aircraft = null;
        this.mapping = null;
        this.sep1 = null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            return new Object[0];
        }
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.mapping != null) {
            return this.mapping.getElement().isInnerComponent(c);
        }
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    public Map<StowagePositionIdentifier, StowagePositionIdentifier> getSelectedMapping() {
        return this.mapping.getElement().getInvertedMappingTable();
    }

    @Override
    public void animationFinished(boolean wasFadin) {
        this.setEnabled(true);
        this.getViewContainer().add(this.mapping);
        this.mapping.fadeIn();
    }

    public void loadMappingData() {
        this.showAnimation(Words.LOAD_MAPPING);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Map m;
                long id = 0L;
                if (AircraftMappingPopup.this.stowing.getValue() instanceof StowingListTemplateVariantReference) {
                    id = ((StowingListTemplateVariantReference)AircraftMappingPopup.this.stowing.getValue()).getId();
                } else if (AircraftMappingPopup.this.stowing.getValue() instanceof StowingListReference) {
                    id = ((StowingListReference)AircraftMappingPopup.this.stowing.getValue()).getId();
                }
                AircraftLight r = (AircraftLight)AircraftMappingPopup.this.newAircraft.getValue();
                if (r == null) {
                    return INodeCreator.getDefaultImpl().getNode4DTO((Object)new ClientServerCallException("No Aircraft selected"), false, false);
                }
                List poses = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getTargetPositions((AircraftReference)r).getList();
                AircraftMappingPopup.this.defaultMapping = m = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getDefaultPositionMapping(new StowingListTemplateVariantReference(Long.valueOf(id)), new AircraftReference(r.getId())).getMap();
                Node l = INodeCreator.getDefaultImpl().createNodes(poses, false);
                return l;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (node != null && node.getValue() instanceof ClientServerCallException) {
                            InnerPopupFactory.showErrorDialog((Exception)((Object)((ClientServerCallException)((Object)node.getValue()))), (Component)AircraftMappingPopup.this);
                        } else if (node != null) {
                            try {
                                AircraftMappingPopup.this.createMapping((List)node.getValue());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        AircraftMappingPopup.this.hideAnimation();
                    }

                    public void errorOccurred(ClientException exception) {
                        AircraftMappingPopup.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 5;
            if (AircraftMappingPopup.this.stowingList != null) {
                AircraftMappingPopup.this.stowingList.setLocation(0, 0);
                AircraftMappingPopup.this.stowingList.setSize(parent.getWidth() - border, (int)AircraftMappingPopup.this.stowingList.getPreferredSize().getHeight());
                AircraftMappingPopup.this.aircraft.setLocation(0, AircraftMappingPopup.this.stowingList.getY() + AircraftMappingPopup.this.stowingList.getHeight() + border);
                AircraftMappingPopup.this.aircraft.setSize(parent.getWidth() - border, (int)AircraftMappingPopup.this.aircraft.getPreferredSize().getHeight());
                AircraftMappingPopup.this.sep1.setLocation(0, AircraftMappingPopup.this.aircraft.getY() + AircraftMappingPopup.this.aircraft.getHeight() + border);
                AircraftMappingPopup.this.sep1.setSize(parent.getWidth() - border, (int)AircraftMappingPopup.this.sep1.getPreferredSize().getHeight());
                if (AircraftMappingPopup.this.mapping != null) {
                    AircraftMappingPopup.this.mapping.setLocation(0, AircraftMappingPopup.this.sep1.getY() + AircraftMappingPopup.this.sep1.getHeight() + border);
                    AircraftMappingPopup.this.mapping.setSize(parent.getWidth() - border, parent.getHeight() - AircraftMappingPopup.this.mapping.getY());
                }
            }
            if (AircraftMappingPopup.this.animation != null) {
                AircraftMappingPopup.this.animation.setLocation((int)((double)parent.getWidth() - AircraftMappingPopup.this.animation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - AircraftMappingPopup.this.animation.getPreferredSize().getHeight()) / 2.0));
                AircraftMappingPopup.this.animation.setSize(AircraftMappingPopup.this.animation.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border = 5;
            int h = 0;
            if (AircraftMappingPopup.this.stowingList != null && !AircraftMappingPopup.this.isLoading) {
                h = (int)AircraftMappingPopup.this.stowingList.getPreferredSize().getHeight();
                h += border;
                h = (int)((double)h + AircraftMappingPopup.this.aircraft.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + AircraftMappingPopup.this.sep1.getPreferredSize().getHeight());
                h += border;
                if (AircraftMappingPopup.this.mapping != null) {
                    h = (int)((double)h + AircraftMappingPopup.this.mapping.getPreferredSize().getHeight());
                }
            }
            return new Dimension(0, h);
        }
    }
}

