/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details;

import ch.icit.pegasus.client.converter.ContactConverter;
import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.DTOProvider;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightScheduleAccess;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificationDetailsPanel
extends StateDependantDetailsPanel<FlightScheduleLight>
implements LafListener,
NodeListener,
ButtonListener,
DTOProvider,
InnerPopUpListener2,
SearchTextField2Listener {
    private static final Logger log = LoggerFactory.getLogger(SpecificationDetailsPanel.class);
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2<CustomerLight>> customer;
    private final HorizontalSeparator sep1;
    private TitledPeriodEditor periodEditor;
    private final HorizontalSeparator sep2;
    private TextLabel operationDayTitle;
    private TitledItem<RDCheckBox> check_all;
    private final VerticalSeparator sep3;
    private TitledItem<RDCheckBox> check_mo;
    private TitledItem<RDCheckBox> check_di;
    private TitledItem<RDCheckBox> check_mi;
    private TitledItem<RDCheckBox> check_do;
    private TitledItem<RDCheckBox> check_fr;
    private TitledItem<RDCheckBox> check_sa;
    private TitledItem<RDCheckBox> check_so;
    private TitledItem<RDComboBox> deliveryContact;
    private boolean stateChangedNow;
    private Node<List<Boolean>> operationDays;
    private Object lastSelectedDTO;
    private TitledItem<RDMultiLocationComboBox> locations;
    private HorizontalSeparator sep5;
    private TitledItem<RDComboBox> state;
    private TitledItem<RDCheckBox> upliftCount;
    private TitledItem<RDCheckBox> autoStockFlight;
    private TitledItem<RDCheckBox> loadToHandheld;
    private TitledItem<RDCheckBox> fillEmptyEquipments;
    private TitledItem<RDCheckBox> transitDelivery;
    private TitledItem<RDCheckBox> excludeFromKitchenForecast;
    private TitledItem<RDCheckBox> ignoreCustomerLabelConfig;

    public SpecificationDetailsPanel(RowEditor<FlightScheduleLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setCustomLayouter(new FlightScheduleDetails1Layout());
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(false, null), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.customer.getElement().addSearchTextFieldListener(this);
        this.periodEditor = new TitledPeriodEditor(null, null, true, provider);
        this.operationDayTitle = new TextLabel(Words.OPERATION_DAYS);
        this.check_all = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "", TitledItem.TitledItemOrientation.SOUTH);
        this.check_mo = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "", TitledItem.TitledItemOrientation.SOUTH);
        this.check_di = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "", TitledItem.TitledItemOrientation.SOUTH);
        this.check_mi = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "", TitledItem.TitledItemOrientation.SOUTH);
        this.check_do = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "", TitledItem.TitledItemOrientation.SOUTH);
        this.check_fr = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "", TitledItem.TitledItemOrientation.SOUTH);
        this.check_sa = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "", TitledItem.TitledItemOrientation.SOUTH);
        this.check_so = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "", TitledItem.TitledItemOrientation.SOUTH);
        this.check_all.getElement().addButtonListener(this);
        this.check_mo.getElement().addButtonListener(this);
        this.check_di.getElement().addButtonListener(this);
        this.check_mi.getElement().addButtonListener(this);
        this.check_do.getElement().addButtonListener(this);
        this.check_fr.getElement().addButtonListener(this);
        this.check_sa.getElement().addButtonListener(this);
        this.check_so.getElement().addButtonListener(this);
        this.sep1 = new HorizontalSeparator();
        this.sep2 = new HorizontalSeparator();
        this.sep3 = new VerticalSeparator();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider, true), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.upliftCount = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.UPLIFTCOUNT, TitledItem.TitledItemOrientation.EAST);
        if (Boolean.TRUE.equals(settings.getAutoCheckout())) {
            this.autoStockFlight = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.AUTO_CHECKOUT_FLIGHT, TitledItem.TitledItemOrientation.EAST);
        }
        this.loadToHandheld = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.LOAD_FLIGHT_TO_HANDHELD, TitledItem.TitledItemOrientation.EAST);
        if (Boolean.TRUE.equals(settings.getCanChooseDeliveryContactForDeliverySlip())) {
            this.deliveryContact = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ContactConverter.class), true, true), Words.DELIVERY_CONTACT, TitledItem.TitledItemOrientation.NORTH);
        }
        this.lafAttributeChanged("All attribues changed");
        this.setTitleText(Words.AIRLINE_AND_SCHEDULE);
        this.check_all.setTitleText(Words.WEEKDAY_SHORT_ALL);
        this.check_mo.setTitleText(Words.WEEKDAY_SHORT_MONDAY);
        this.check_di.setTitleText(Words.WEEKDAY_SHORT_TUESDAY);
        this.check_mi.setTitleText(Words.WEEKDAY_SHORT_WEDNEDAY);
        this.check_do.setTitleText(Words.WEEKDAY_SHORT_THURSDAY);
        this.check_fr.setTitleText(Words.WEEKDAY_SHORT_FRIDAY);
        this.check_sa.setTitleText(Words.WEEKDAY_SHORT_SATURDAY);
        this.check_so.setTitleText(Words.WEEKDAY_SHORT_SUNDAY);
        this.check_all.getElement().setOverrideName(FlightScheduleComplete_.daysOfWeek);
        this.check_mo.getElement().setOverrideName(FlightScheduleComplete_.daysOfWeek);
        this.check_di.getElement().setOverrideName(FlightScheduleComplete_.daysOfWeek);
        this.check_mi.getElement().setOverrideName(FlightScheduleComplete_.daysOfWeek);
        this.check_do.getElement().setOverrideName(FlightScheduleComplete_.daysOfWeek);
        this.check_fr.getElement().setOverrideName(FlightScheduleComplete_.daysOfWeek);
        this.check_sa.getElement().setOverrideName(FlightScheduleComplete_.daysOfWeek);
        this.check_so.getElement().setOverrideName(FlightScheduleComplete_.daysOfWeek);
        this.check_all.setAlignment(0);
        this.check_mo.setAlignment(0);
        this.check_di.setAlignment(0);
        this.check_mi.setAlignment(0);
        this.check_do.setAlignment(0);
        this.check_fr.setAlignment(0);
        this.check_sa.setAlignment(0);
        this.check_so.setAlignment(0);
        this.addToView(this.customer);
        this.sep5 = new HorizontalSeparator();
        this.state = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ModificationStateEConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        this.fillEmptyEquipments = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.LOAD_EMPTY_EQUIPMENTS, TitledItem.TitledItemOrientation.EAST);
        this.transitDelivery = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.TRANSIT_DELIVERY, TitledItem.TitledItemOrientation.EAST);
        this.excludeFromKitchenForecast = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.EXCLUDE_FROM_KITCHEN_FORECAST, TitledItem.TitledItemOrientation.EAST);
        if (CompanyUtil.isFPB((SystemSettingsComplete)settings)) {
            this.ignoreCustomerLabelConfig = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.IGNORE_CUSTOMER_LABEL_CONFIG, TitledItem.TitledItemOrientation.EAST);
            this.addToView(this.ignoreCustomerLabelConfig);
        }
        this.addToView(this.periodEditor);
        this.addToView(this.operationDayTitle);
        this.addToView(this.check_all);
        this.addToView(this.check_mo);
        this.addToView(this.check_di);
        this.addToView(this.check_mi);
        this.addToView(this.check_do);
        this.addToView(this.check_fr);
        this.addToView(this.check_sa);
        this.addToView(this.check_so);
        this.addToView(this.sep1);
        this.addToView(this.sep2);
        this.addToView(this.sep3);
        this.addToView(this.shape);
        this.addToView(this.state);
        this.addToView(this.sep5);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.upliftCount);
        if (this.autoStockFlight != null) {
            this.addToView(this.autoStockFlight);
        }
        this.addToView(this.loadToHandheld);
        this.addToView(this.fillEmptyEquipments);
        this.addToView(this.transitDelivery);
        this.addToView(this.excludeFromKitchenForecast);
        if (this.deliveryContact != null) {
            this.addToView(this.deliveryContact);
        }
        this.switchState(Button.ButtonState.STATE_SELECTED);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return FlightScheduleComplete_.state;
    }

    @Override
    public boolean isRemoteValidation() {
        return true;
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
        super.validateRemote(callBack);
        this.editor.getModel().getNode().commit(FlightScheduleComplete.class);
        FlightScheduleComplete flightSchedule = (FlightScheduleComplete)this.editor.getModel().getNode().getValue(FlightScheduleComplete.class);
        List duplicateFlightSchedule = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).findDuplicateFlightSchedule(flightSchedule).getList();
        if (duplicateFlightSchedule != null && !duplicateFlightSchedule.isEmpty()) {
            String schedules = "";
            for (FlightScheduleLight scheduleLight : duplicateFlightSchedule) {
                schedules = schedules + scheduleLight.getNumber().toString() + ", ";
            }
            schedules = schedules.substring(0, schedules.length() - 2);
            callBack.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Words.DUPLICATE_FLIGHT_SCHEDULE_FOUND, (Object[])new Object[]{schedules})));
        }
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            FlightScheduleComplete dto = (FlightScheduleComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.node = node;
        Node airlineN = node.getChildNamed(FlightScheduleComplete_.customer);
        this.customer.getElement().setNode(airlineN);
        this.operationDays = node.getChildNamed(FlightScheduleComplete_.daysOfWeek);
        this.periodEditor.setStartDateNode(node.getChildNamed(new DtoField[]{FlightScheduleComplete_.period, PeriodComplete_.startDate}));
        this.periodEditor.setEndDateNode(node.getChildNamed(new DtoField[]{FlightScheduleComplete_.period, PeriodComplete_.endDate}));
        this.check_all.getElement().setNode(null);
        while (this.operationDays.getChildCount() < 7) {
            this.operationDays.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)false, true, false), 0L);
        }
        this.check_mo.getElement().setNode(this.operationDays.getChildAt(0));
        this.check_di.getElement().setNode(this.operationDays.getChildAt(1));
        this.check_mi.getElement().setNode(this.operationDays.getChildAt(2));
        this.check_do.getElement().setNode(this.operationDays.getChildAt(3));
        this.check_fr.getElement().setNode(this.operationDays.getChildAt(4));
        this.check_sa.getElement().setNode(this.operationDays.getChildAt(5));
        this.check_so.getElement().setNode(this.operationDays.getChildAt(6));
        this.state.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ModificationStateE.class));
        this.state.getElement().setNode(node.getChildNamed(FlightScheduleComplete_.state));
        node.getChildNamed(FlightScheduleComplete_.customer).addNodeListener((NodeListener)this);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(FlightScheduleComplete_.eligibleLocations));
        }
        if (this.editor.getModel().isAddRow()) {
            this.customer.getElement().getNode().addNodeListener((NodeListener)this);
        }
        this.upliftCount.getElement().setNode(this.node.getChildNamed(FlightScheduleComplete_.upliftCount));
        if (this.editor.getModel().isAddRow()) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            Node ac = this.node.getChildNamed(FlightScheduleComplete_.autoCheckout);
            ac.setValue((Object)settings.getAutoCheckout(), 0L);
        }
        if (this.autoStockFlight != null) {
            this.autoStockFlight.getElement().setNode(this.node.getChildNamed(FlightScheduleComplete_.autoCheckout));
        }
        this.loadToHandheld.getElement().setNode(this.node.getChildNamed(FlightScheduleComplete_.loadFlightToHandheld));
        this.fillEmptyEquipments.getElement().setNode(this.node.getChildNamed(FlightScheduleComplete_.fillEmptyEquipments));
        this.transitDelivery.getElement().setNode(this.node.getChildNamed(FlightScheduleComplete_.transitDelivery));
        this.excludeFromKitchenForecast.getElement().setNode(this.node.getChildNamed(FlightScheduleLight_.excludeFromKitchenForecast));
        if (this.deliveryContact != null) {
            this.deliveryContact.getElement().setNode(this.node.getChildNamed(FlightScheduleComplete_.deliveryContact));
            this.deliveryContact.getElement().refreshPossibleValues(this.node.getChildNamed(new DtoField[]{FlightScheduleLight_.customer, CustomerLight_.contacts}));
        }
        if (this.ignoreCustomerLabelConfig != null) {
            this.ignoreCustomerLabelConfig.getElement().setNode(this.node.getChildNamed(FlightScheduleComplete_.ignoreCustomerLabelConfig));
        }
        this.loadCheckStates();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null) {
            this.node.getChildNamed(FlightScheduleComplete_.state).removeNodeListener((NodeListener)this);
        }
        if (this.customer != null) {
            if (this.customer.getElement().getNode() != null) {
                this.customer.getElement().getNode().removeNodeListener((NodeListener)this);
            }
            this.customer.kill();
        }
        if (this.locations != null) {
            this.locations.kill();
        }
        this.locations = null;
        this.periodEditor.kill();
        this.operationDayTitle.kill();
        this.check_all.kill();
        this.check_mo.kill();
        this.check_di.kill();
        this.check_mi.kill();
        this.check_do.kill();
        this.check_fr.kill();
        this.check_sa.kill();
        this.check_so.kill();
        this.state.kill();
        this.upliftCount.kill();
        this.sep5.kill();
        this.transitDelivery.kill();
        this.excludeFromKitchenForecast.kill();
        if (this.deliveryContact != null) {
            this.deliveryContact.kill();
        }
        if (this.autoStockFlight != null) {
            this.autoStockFlight.kill();
        }
        if (this.ignoreCustomerLabelConfig != null) {
            this.ignoreCustomerLabelConfig.kill();
        }
        this.ignoreCustomerLabelConfig = null;
        this.loadToHandheld.kill();
        this.fillEmptyEquipments.kill();
        this.excludeFromKitchenForecast = null;
        this.sep5 = null;
        this.customer = null;
        this.state = null;
        this.periodEditor = null;
        this.operationDayTitle = null;
        this.check_all = null;
        this.check_mo = null;
        this.check_di = null;
        this.check_mi = null;
        this.check_do = null;
        this.check_fr = null;
        this.check_sa = null;
        this.upliftCount = null;
        this.check_so = null;
        this.deliveryContact = null;
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.autoStockFlight = null;
        this.loadToHandheld = null;
        this.fillEmptyEquipments = null;
        this.transitDelivery = null;
    }

    @Override
    public void resetParagraph() {
        this.node = this.editor.getModel().getNode();
        Node airlineN = this.node.getChildNamed(FlightScheduleComplete_.customer);
        if (this.customer != null) {
            this.customer.getElement().setNode(airlineN);
        }
        this.operationDays = this.node.getChildNamed(FlightScheduleComplete_.daysOfWeek);
        if (this.operationDays.getChildCount() < 7) {
            this.operationDays.getAllChildAddEventsFor(null, new String[0]);
        }
        this.check_all.getElement().setChecked(false);
        if (this.customer != null) {
            this.customer.getElement().getNode().setValue(null, System.currentTimeMillis());
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
        if (this.operationDayTitle != null) {
            this.operationDayTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
            this.operationDayTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        }
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void valueChanged(Node<?> node) {
        if (node.getName().equals(FlightScheduleComplete_.state.getFieldName())) {
            this.stateChangedNow = true;
            this.editor.setEnabled(this.editor.isEnabled());
        } else if (node.getName().equals(FlightScheduleComplete_.customer.getFieldName())) {
            if (node != null && node.getValue() != null && node.getParent() != null) {
                Node spmlLabelNode;
                Node labelNode = node.getParent().getChildNamed(FlightScheduleComplete_.labelLayout);
                if (labelNode != null && labelNode.getValue() == null && node.getChildNamed(CustomerComplete_.defaultLabel).getValue() != null) {
                    labelNode.setValue(node.getChildNamed(CustomerComplete_.defaultLabel).getValue(), 0L);
                }
                if ((spmlLabelNode = node.getParent().getChildNamed(FlightScheduleComplete_.specialMealLayout)) != null && spmlLabelNode.getValue() == null && node.getChildNamed(CustomerComplete_.defaultSpmlLabel).getValue() != null) {
                    spmlLabelNode.setValue(node.getChildNamed(CustomerComplete_.defaultSpmlLabel).getValue(), 0L);
                }
            }
            if (this.deliveryContact != null) {
                this.deliveryContact.getElement().refreshPossibleValues(node.getChildNamed(CustomerLight_.contacts));
            }
            this.setEnabled(this.isEnabled());
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.editor.getModel().isAddRow()) {
            if (this.customer.getElement().getNode().getValue() == null) {
                this.customer.getElement().setInValid();
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMER));
            } else {
                this.customer.getElement().setValid();
            }
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() != 1) {
            this.locations.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCALTY_ONE_LOCATION_IS_SET));
        }
        o.addAll(ValidationUtil.validatePeriod((Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{FlightScheduleComplete_.period, PeriodComplete_.startDate}), (Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{FlightScheduleComplete_.period, PeriodComplete_.endDate}), this.periodEditor));
        return o;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        CheckBox b;
        if (this.check_all.getElement().getEditor() == source) {
            this.checkFullWeek(this.check_all.getElement().isChecked());
        } else if (source instanceof CheckBox && !(b = (CheckBox)source).isChecked() && this.check_all.getElement().isChecked()) {
            this.check_all.getElement().setChecked(false);
        }
    }

    private void loadCheckStates() {
        this.check_all.getElement().setChecked(this.areAllChecked());
    }

    private void checkFullWeek(boolean check) {
        Long currentId = System.currentTimeMillis();
        if (this.operationDays.getChildAt(0) instanceof Node) {
            this.operationDays.getChildAt(0).setValue((Object)check, currentId.longValue());
        }
        if (this.operationDays.getChildAt(1) instanceof Node) {
            this.operationDays.getChildAt(1).setValue((Object)check, currentId.longValue());
        }
        if (this.operationDays.getChildAt(2) instanceof Node) {
            this.operationDays.getChildAt(2).setValue((Object)check, currentId.longValue());
        }
        if (this.operationDays.getChildAt(3) instanceof Node) {
            this.operationDays.getChildAt(3).setValue((Object)check, currentId.longValue());
        }
        if (this.operationDays.getChildAt(4) instanceof Node) {
            this.operationDays.getChildAt(4).setValue((Object)check, currentId.longValue());
        }
        if (this.operationDays.getChildAt(5) instanceof Node) {
            this.operationDays.getChildAt(5).setValue((Object)check, currentId.longValue());
        }
        if (this.operationDays.getChildAt(6) instanceof Node) {
            this.operationDays.getChildAt(6).setValue((Object)check, currentId.longValue());
        }
    }

    private boolean areAllChecked() {
        return this.check_mo.getElement().isChecked() && this.check_di.getElement().isChecked() && this.check_mi.getElement().isChecked() && this.check_do.getElement().isChecked() && this.check_fr.getElement().isChecked() && this.check_sa.getElement().isChecked() && this.check_so.getElement().isChecked();
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.periodEditor);
        CheckedListAdder.addToList(focusList, this.check_all);
        CheckedListAdder.addToList(focusList, this.check_mo);
        CheckedListAdder.addToList(focusList, this.check_di);
        CheckedListAdder.addToList(focusList, this.check_mi);
        CheckedListAdder.addToList(focusList, this.check_do);
        CheckedListAdder.addToList(focusList, this.check_fr);
        CheckedListAdder.addToList(focusList, this.check_sa);
        CheckedListAdder.addToList(focusList, this.check_so);
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.upliftCount);
        CheckedListAdder.addToList(focusList, this.autoStockFlight);
        CheckedListAdder.addToList(focusList, this.loadToHandheld);
        CheckedListAdder.addToList(focusList, this.fillEmptyEquipments);
        CheckedListAdder.addToList(focusList, this.transitDelivery);
        CheckedListAdder.addToList(focusList, this.excludeFromKitchenForecast);
        CheckedListAdder.addToList(focusList, this.ignoreCustomerLabelConfig);
        return focusList;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean canReDraftIfInvoiced = true;
        boolean chooseDeliveryContact = false;
        try {
            Node customer;
            if (this.node != null && (customer = this.node.getChildNamed(FlightScheduleComplete_.customer)) != null) {
                chooseDeliveryContact = Boolean.TRUE.equals(((CustomerLight)customer.getValue()).getChooseDeliveryContactAtFlight());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (!isDraft) {
            canReDraftIfInvoiced = this.stateChangedNow ? true : this.provider.isWritable(FlightScheduleAccess.REDRAFT_IF_INVOICED) || this.provider.isWritable(FlightScheduleAccess.REDRAFT_IF_ACCEPTED);
        }
        boolean enabled = isEnabled && isDraft;
        super.setEnabled(enabled);
        this.customer.getElement().setEnabled(enabled);
        if (this.deliveryContact != null) {
            this.deliveryContact.getElement().setEnabled(isEnabled && chooseDeliveryContact);
        }
        this.periodEditor.setEnabled(enabled);
        this.check_all.getElement().setEnabled(enabled);
        this.check_mo.getElement().setEnabled(enabled);
        this.check_di.getElement().setEnabled(enabled);
        this.check_mi.getElement().setEnabled(enabled);
        this.check_do.getElement().setEnabled(enabled);
        this.check_fr.getElement().setEnabled(enabled);
        this.check_sa.getElement().setEnabled(enabled);
        this.check_so.getElement().setEnabled(enabled);
        this.state.setEnabled(isEnabled && canReDraftIfInvoiced);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(enabled);
        }
        this.upliftCount.setEnabled(enabled);
        if (this.autoStockFlight != null) {
            this.autoStockFlight.setEnabled(enabled);
        }
        this.loadToHandheld.setEnabled(enabled);
        this.fillEmptyEquipments.setEnabled(enabled);
        this.transitDelivery.setEnabled(enabled);
        this.excludeFromKitchenForecast.setEnabled(enabled);
        if (this.ignoreCustomerLabelConfig != null) {
            this.ignoreCustomerLabelConfig.setEnabled(enabled);
        }
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.editor.getModel().remoteObjectLoaded(node);
    }

    @Override
    public Object getSelectedDTO() {
        return this.lastSelectedDTO;
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.editor.getModel().isAddRow()) {
            this.customer.requestFocusInWindowNow();
        } else {
            this.periodEditor.requestFocusInWindowNow();
        }
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
        this.updateAutoCheckoutState();
    }

    private void updateAutoCheckoutState() {
        CustomerLight cv = (CustomerLight)this.editor.getModel().getNode().getChildNamed(FlightScheduleLight_.customer).getValue();
        this.editor.getModel().getNode().getChildNamed(FlightScheduleLight_.autoCheckout).setValue((Object)cv.getAutoCheckoutCustomer(), 0L);
    }

    private class FlightScheduleDetails1Layout
    extends DefaultLayout {
        private FlightScheduleDetails1Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            SpecificationDetailsPanel.this.customer.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.customer.setSize(w - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            int cy = SpecificationDetailsPanel.this.customer.getY() + SpecificationDetailsPanel.this.customer.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder;
            if (SpecificationDetailsPanel.this.deliveryContact != null) {
                SpecificationDetailsPanel.this.deliveryContact.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.customer.getY() + SpecificationDetailsPanel.this.customer.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
                SpecificationDetailsPanel.this.deliveryContact.setSize(w - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.deliveryContact.getPreferredSize().getHeight());
                cy = SpecificationDetailsPanel.this.deliveryContact.getY() + SpecificationDetailsPanel.this.deliveryContact.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder;
            }
            SpecificationDetailsPanel.this.sep1.setLocation(0, cy);
            SpecificationDetailsPanel.this.sep1.setSize(w, 1);
            SpecificationDetailsPanel.this.periodEditor.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.sep1.getY() + SpecificationDetailsPanel.this.sep1.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.periodEditor.setSize(w - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.sep2.setLocation(0, SpecificationDetailsPanel.this.periodEditor.getY() + SpecificationDetailsPanel.this.periodEditor.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.sep2.setSize(SpecificationDetailsPanel.this.sep1.getSize());
            SpecificationDetailsPanel.this.operationDayTitle.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.sep2.getY() + SpecificationDetailsPanel.this.sep2.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.operationDayTitle.setSize(SpecificationDetailsPanel.this.operationDayTitle.getPreferredSize());
            int cX = SpecificationDetailsPanel.this.horizontalBorder;
            SpecificationDetailsPanel.this.check_all.setLocation(cX, SpecificationDetailsPanel.this.operationDayTitle.getY() + SpecificationDetailsPanel.this.operationDayTitle.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.check_all.setSize(SpecificationDetailsPanel.this.check_all.getPreferredSize());
            SpecificationDetailsPanel.this.sep3.setLocation(cX += SpecificationDetailsPanel.this.check_all.getWidth() + 3, SpecificationDetailsPanel.this.check_all.getY() - 3);
            SpecificationDetailsPanel.this.sep3.setSize(1, SpecificationDetailsPanel.this.check_all.getHeight());
            int xSpace = w - ((cX += SpecificationDetailsPanel.this.sep3.getWidth() + 6) + SpecificationDetailsPanel.this.horizontalBorder);
            xSpace = (int)((double)xSpace - 7.0 * SpecificationDetailsPanel.this.check_mi.getPreferredSize().getWidth());
            if ((xSpace /= 6) > 2 * SpecificationDetailsPanel.this.horizontalBorder) {
                xSpace = 2 * SpecificationDetailsPanel.this.horizontalBorder;
            }
            SpecificationDetailsPanel.this.check_mo.setLocation(cX, SpecificationDetailsPanel.this.check_all.getY());
            SpecificationDetailsPanel.this.check_mo.setSize(SpecificationDetailsPanel.this.check_mo.getPreferredSize());
            SpecificationDetailsPanel.this.check_di.setLocation(cX += SpecificationDetailsPanel.this.check_mo.getWidth() + xSpace, SpecificationDetailsPanel.this.check_all.getY());
            SpecificationDetailsPanel.this.check_di.setSize(SpecificationDetailsPanel.this.check_di.getPreferredSize());
            SpecificationDetailsPanel.this.check_mi.setLocation(cX += SpecificationDetailsPanel.this.check_di.getWidth() + xSpace, SpecificationDetailsPanel.this.check_all.getY());
            SpecificationDetailsPanel.this.check_mi.setSize(SpecificationDetailsPanel.this.check_mi.getPreferredSize());
            SpecificationDetailsPanel.this.check_do.setLocation(cX += SpecificationDetailsPanel.this.check_mi.getWidth() + xSpace, SpecificationDetailsPanel.this.check_all.getY());
            SpecificationDetailsPanel.this.check_do.setSize(SpecificationDetailsPanel.this.check_do.getPreferredSize());
            SpecificationDetailsPanel.this.check_fr.setLocation(cX += SpecificationDetailsPanel.this.check_do.getWidth() + xSpace, SpecificationDetailsPanel.this.check_all.getY());
            SpecificationDetailsPanel.this.check_fr.setSize(SpecificationDetailsPanel.this.check_fr.getPreferredSize());
            SpecificationDetailsPanel.this.check_sa.setLocation(cX += SpecificationDetailsPanel.this.check_fr.getWidth() + xSpace, SpecificationDetailsPanel.this.check_all.getY());
            SpecificationDetailsPanel.this.check_sa.setSize(SpecificationDetailsPanel.this.check_sa.getPreferredSize());
            SpecificationDetailsPanel.this.check_so.setLocation(cX += SpecificationDetailsPanel.this.check_sa.getWidth() + xSpace, SpecificationDetailsPanel.this.check_all.getY());
            SpecificationDetailsPanel.this.check_so.setSize(SpecificationDetailsPanel.this.check_so.getPreferredSize());
            SpecificationDetailsPanel.this.shape.setSize(parent.getWidth(), parent.getHeight());
            cy = SpecificationDetailsPanel.this.check_so.getY() + SpecificationDetailsPanel.this.check_so.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder;
            SpecificationDetailsPanel.this.sep5.setLocation(0, cy);
            SpecificationDetailsPanel.this.sep5.setSize(parent.getWidth(), (int)SpecificationDetailsPanel.this.sep5.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.state.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.sep5.getY() + SpecificationDetailsPanel.this.sep5.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.state.setSize(150, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            cy = SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight();
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
                SpecificationDetailsPanel.this.locations.setSize(150, (int)SpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
                cy = SpecificationDetailsPanel.this.locations.getY() + SpecificationDetailsPanel.this.locations.getHeight();
            }
            SpecificationDetailsPanel.this.upliftCount.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.upliftCount.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.upliftCount.getPreferredSize().getHeight());
            cy = SpecificationDetailsPanel.this.upliftCount.getY() + SpecificationDetailsPanel.this.upliftCount.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder;
            if (SpecificationDetailsPanel.this.autoStockFlight != null) {
                SpecificationDetailsPanel.this.autoStockFlight.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy);
                SpecificationDetailsPanel.this.autoStockFlight.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.autoStockFlight.getPreferredSize().getHeight());
                cy = SpecificationDetailsPanel.this.autoStockFlight.getY() + SpecificationDetailsPanel.this.autoStockFlight.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder;
            }
            SpecificationDetailsPanel.this.loadToHandheld.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy);
            SpecificationDetailsPanel.this.loadToHandheld.setSize(SpecificationDetailsPanel.this.loadToHandheld.getPreferredSize());
            cy = SpecificationDetailsPanel.this.loadToHandheld.getY() + SpecificationDetailsPanel.this.loadToHandheld.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder;
            SpecificationDetailsPanel.this.fillEmptyEquipments.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy);
            SpecificationDetailsPanel.this.fillEmptyEquipments.setSize(SpecificationDetailsPanel.this.fillEmptyEquipments.getPreferredSize());
            cy = SpecificationDetailsPanel.this.fillEmptyEquipments.getY() + SpecificationDetailsPanel.this.fillEmptyEquipments.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder;
            SpecificationDetailsPanel.this.transitDelivery.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy);
            SpecificationDetailsPanel.this.transitDelivery.setSize(SpecificationDetailsPanel.this.transitDelivery.getPreferredSize());
            cy = SpecificationDetailsPanel.this.transitDelivery.getY() + SpecificationDetailsPanel.this.transitDelivery.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder;
            SpecificationDetailsPanel.this.excludeFromKitchenForecast.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy);
            SpecificationDetailsPanel.this.excludeFromKitchenForecast.setSize(SpecificationDetailsPanel.this.excludeFromKitchenForecast.getPreferredSize());
            cy = SpecificationDetailsPanel.this.excludeFromKitchenForecast.getY() + SpecificationDetailsPanel.this.excludeFromKitchenForecast.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder;
            if (SpecificationDetailsPanel.this.ignoreCustomerLabelConfig != null) {
                SpecificationDetailsPanel.this.ignoreCustomerLabelConfig.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy);
                SpecificationDetailsPanel.this.ignoreCustomerLabelConfig.setSize(SpecificationDetailsPanel.this.ignoreCustomerLabelConfig.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentX = 0;
            int currentY = 0;
            currentY += SpecificationDetailsPanel.this.verticalBorder;
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.inner_verticalBorder;
            if (SpecificationDetailsPanel.this.deliveryContact != null) {
                currentY = (int)((double)currentY + SpecificationDetailsPanel.this.deliveryContact.getPreferredSize().getHeight());
                currentY += SpecificationDetailsPanel.this.inner_verticalBorder;
            }
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.sep1.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.inner_verticalBorder;
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.inner_verticalBorder * 2;
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.sep2.getPreferredSize().getHeight());
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.operationDayTitle.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.inner_verticalBorder;
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.check_all.getPreferredSize().getHeight());
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.sep5.getPreferredSize().getHeight());
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.verticalBorder;
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                currentY = (int)((double)currentY + SpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
                currentY += SpecificationDetailsPanel.this.inner_verticalBorder;
            }
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.upliftCount.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.inner_verticalBorder;
            if (SpecificationDetailsPanel.this.autoStockFlight != null) {
                currentY = (int)((double)currentY + SpecificationDetailsPanel.this.autoStockFlight.getPreferredSize().getHeight());
                currentY += SpecificationDetailsPanel.this.inner_verticalBorder;
            }
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.loadToHandheld.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.inner_verticalBorder;
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.fillEmptyEquipments.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.inner_horizontalBorder;
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.transitDelivery.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.inner_verticalBorder;
            currentY = (int)((double)currentY + SpecificationDetailsPanel.this.excludeFromKitchenForecast.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.verticalBorder;
            currentX += SpecificationDetailsPanel.this.horizontalBorder;
            currentX = (int)((double)currentX + SpecificationDetailsPanel.this.periodEditor.getPreferredSize().getWidth());
            currentX += SpecificationDetailsPanel.this.horizontalBorder;
            if (SpecificationDetailsPanel.this.ignoreCustomerLabelConfig != null) {
                currentY = (int)((double)currentY + SpecificationDetailsPanel.this.ignoreCustomerLabelConfig.getPreferredSize().getHeight());
                currentY += SpecificationDetailsPanel.this.horizontalBorder;
            }
            return new Dimension(currentX, currentY + 15);
        }
    }
}

