/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.LegInfoConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.columnsorter.TableRowPanelComparator;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class DefaultUpliftDetailsPanel
extends StateDependantTableDetailsPanel<FlightScheduleLight> {
    private static final long serialVersionUID = 1L;
    private boolean isWritable = false;

    public DefaultUpliftDetailsPanel(RowEditor<FlightScheduleLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, true);
        this.setTitleText(Words.DEFAULT_UPLIFT);
        this.isWritable = provider.isWritable(FlightScheduleComplete_.additionalOrders);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.PRODUCT, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.LEG, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.CABIN_CLASS_SHORT, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(CompanyUtil.isFPB((SystemSettingsComplete)this.settings) ? Words.DELIVERY_NO : Words.POSITION, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.COUNT), null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.LABEL_TEXT, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.LABEL_COLOR, null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(Words.SPECIAL_PRICE, null, null, null, "", 180, 180, 180));
        columns.add(new TableColumnInfo(Words.PRINT_SINGLE_LABELS, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.table.getCellPadding() + 40 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(9)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setUseWriteAccessRight(true);
        table.setComparator(ComparatorRegistry.getComparator(TableRowPanelComparator.class));
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        AdditionalOrderTemplateComplete t = new AdditionalOrderTemplateComplete();
        t.setClientOId(Long.valueOf(ADTO.getNextId()));
        t.setQuantity(Integer.valueOf(0));
        t.setSequenceNumber(Integer.valueOf(this.table.getRowCount()));
        t.setPrintSingleLabels(settings.getPrintAdditionalOnSeparateLabel());
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)t, true, false);
        this.table.getModel().getNode().addChild(n, 0L);
    }

    @Override
    public void childRemoved() {
        this.table.writeNumber(AdditionalOrderTemplateComplete_.sequenceNumber, 0);
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.THREE);
        return rowPanel;
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return FlightScheduleLight_.state;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        boolean foundInvalidLine = false;
        for (Table2RowPanel rowPanel : this.table.getRows()) {
            TableRowImpl rowImpl = (TableRowImpl)rowPanel;
            if (rowImpl.isRowValid()) continue;
            foundInvalidLine = true;
        }
        if (foundInvalidLine) {
            ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DEFAULT_UPLIFT_QTY_IS_SET));
            return validationObjects;
        }
        return super.validateParagraph();
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(FlightScheduleComplete_.additionalOrders));
        this.table.updateOrder();
    }

    private class TableRowImpl
    extends SortableTable2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<ProductComplete> product;
        private ComboBox cabinClass;
        private ComboBox legs;
        private TextField position;
        private TextField count;
        private TextField labelText;
        private ComboBox labelColor;
        private CheckBox hasSpecialPrice;
        private InputComboBox specialPrice;
        private CheckBox printSingleLabels;

        public TableRowImpl(Table2RowModel m) {
            super(m, true, true);
            if (m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.product).getValue() != null) {
                ProductComplete psm = null;
                try {
                    psm = (ProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductByReference((ProductReference)m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.product).getValue()).getValue();
                    m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.product).removeExistingValues();
                    m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.product).setValue((Object)psm, 0L);
                    m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.product).updateNode();
                }
                catch (ClientServerCallException e) {
                    e.printStackTrace();
                }
            }
            this.setStartEndOffset(0, 1);
            this.setSortAttributeName(AdditionalOrderTemplateComplete_.sequenceNumber);
            this.product = SearchTextField2Factory.getProductSearchField(true, m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.product));
            this.product.setNode(m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.product));
            Object[] o = new Object[]{DefaultUpliftDetailsPanel.this.editor.getModel().getNode().getChildNamed(new DtoField[]{FlightScheduleComplete_.period, PeriodComplete_.startDate}).getValue(), DefaultUpliftDetailsPanel.this.editor.getModel().getNode().getChildNamed(new DtoField[]{FlightScheduleComplete_.period, PeriodComplete_.endDate}).getValue(), DefaultUpliftDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightScheduleComplete_.customer).getValue()};
            this.product.setAdditionalSearchField(o);
            this.legs = new ComboBox(m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.leg), DefaultUpliftDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightScheduleComplete_.legs), ConverterRegistry.getConverter(LegInfoConverter.class));
            this.cabinClass = new ComboBox(m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.cabinClass), NodeToolkit.getAffixList(CabinClassComplete.class), ConverterRegistry.getConverter(CabinClassConverter.class));
            this.position = new TextField(m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.defaultPosition));
            this.count = new NumberTextField(m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.quantity), TextFieldType.INT);
            this.labelText = new TextField(m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.labelText));
            this.labelColor = new ComboBox(m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.labelColor), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class));
            this.printSingleLabels = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.printSingleLabels));
            this.hasSpecialPrice = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(AdditionalOrderTemplateComplete_.hasSpecialPrice));
            this.hasSpecialPrice.addButtonListener(this);
            this.specialPrice = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{AdditionalOrderTemplateComplete_.specialPrice, PriceComplete_.price}), m.getNode().getChildNamed(new DtoField[]{AdditionalOrderTemplateComplete_.specialPrice, PriceComplete_.currency}), InputComboBox.InputComboBoxType.PRICE_DOUBLE);
            this.setLayout(new Layout());
            this.add(this.product);
            this.add(this.legs);
            this.add(this.cabinClass);
            this.add(this.position);
            this.add(this.count);
            this.add(this.labelText);
            this.add(this.labelColor);
            this.add(this.printSingleLabels);
            this.add(this.hasSpecialPrice);
            this.add(this.specialPrice);
        }

        @Override
        public boolean isRowValid() {
            if (this.model.getNode().getChildNamed(AdditionalOrderTemplateComplete_.product).getValue() == null) {
                return false;
            }
            return this.model.getNode().getChildNamed(AdditionalOrderTemplateComplete_.quantity).getValue() != null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            super.buttonPressed(source, x, y);
            if (source == this.hasSpecialPrice) {
                this.setEnabled(this.isEnabled());
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.product);
            CheckedListAdder.addToList(focusList, this.legs);
            CheckedListAdder.addToList(focusList, this.cabinClass);
            CheckedListAdder.addToList(focusList, this.position);
            CheckedListAdder.addToList(focusList, this.count);
            CheckedListAdder.addToList(focusList, this.labelText);
            CheckedListAdder.addToList(focusList, this.labelColor);
            CheckedListAdder.addToList(focusList, this.hasSpecialPrice);
            CheckedListAdder.addToList(focusList, this.specialPrice);
            CheckedListAdder.addToList(focusList, this.printSingleLabels);
            focusList.addAll(super.getFocusComponents());
            return focusList;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable);
            this.product.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable);
            this.legs.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable);
            this.cabinClass.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable);
            this.position.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable);
            this.count.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable);
            this.labelColor.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable);
            this.printSingleLabels.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable);
            this.labelText.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable);
            this.hasSpecialPrice.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable);
            this.specialPrice.setEnabled(isEnabled && DefaultUpliftDetailsPanel.this.isWritable && this.hasSpecialPrice.isChecked());
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.product.kill();
            this.product = null;
            this.legs.kill();
            this.legs = null;
            this.cabinClass.kill();
            this.cabinClass = null;
            this.position.kill();
            this.position = null;
            this.count.kill();
            this.count = null;
            this.labelText.kill();
            this.labelText = null;
            this.labelColor.kill();
            this.labelColor = null;
            this.hasSpecialPrice.kill();
            this.hasSpecialPrice = null;
            this.specialPrice.kill();
            this.specialPrice = null;
            this.printSingleLabels.kill();
            this.printSingleLabels = null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.product.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.product.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.product.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.product.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.legs.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.legs.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.legs.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.legs.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.position.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.position.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.position.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.position.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.labelText.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.labelText.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.labelText.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.labelText.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.labelColor.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.labelColor.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.labelColor.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.labelColor.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                TableRowImpl.this.hasSpecialPrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.hasSpecialPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.hasSpecialPrice.setSize(TableRowImpl.this.hasSpecialPrice.getPreferredSize());
                TableRowImpl.this.specialPrice.setLocation(TableRowImpl.this.hasSpecialPrice.getX() + TableRowImpl.this.hasSpecialPrice.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.specialPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.specialPrice.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.hasSpecialPrice.getPreferredSize().getWidth())), (int)TableRowImpl.this.specialPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(8);
                TableRowImpl.this.printSingleLabels.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.printSingleLabels.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.printSingleLabels.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.printSingleLabels.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(9);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
            }
        }
    }
}

