/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.felfel.manage;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FelFelQRCodeConverter;
import ch.icit.pegasus.client.converter.FelFelReusableStateConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.felfel.manage.FelFelBoxManagerModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.felfel.manage.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.FelFelSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.dtos.felfel.FelFelReusableBoxComplete;
import ch.icit.pegasus.server.core.dtos.felfel.FelFelReusableBoxComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FelFelBoxManagerAccess;
import ch.icit.pegasus.server.core.dtos.search.FelFelSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.SupplierSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class FelFelBoxManagerModule
extends ScreenTableView<FelFelReusableBoxComplete, FelFelSearchConfiguration.FELFEL_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_QR_CODE = "qrcode_filter";
    private static final String FILTER_CHECKIN = "checkin_filter";
    private static final String FILTER_DATE = "date_filter";
    private String searchQRCodeCriteria = null;
    private Boolean searchCheckinCriteria = null;
    private PeriodComplete searchDateCriteria = null;
    private TitledPeriodEditor periodeditor = null;

    public FelFelBoxManagerModule() {
        super(FelFelReusableBoxComplete.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return FelFelBoxManagerAccess.MODULE_FELFEL_BOX_MANAGER;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", SupplierSearchConfiguration.SUPPLIER_COLUMN.NUMBER + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_QR_CODE, Words.NUMBER_OR_NAME, "");
        ComboBox yesNo = ComboBoxFactory.getYesNoComboBox(true);
        this.filterChain.addSelectionComboBox(yesNo, FILTER_CHECKIN, Words.CHECKIN, Words.ALL);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodeditor = this.filterChain.addPeriodSelection(FILTER_DATE, p.getStartDate(), p.getEndDate(), "", true);
        this.periodeditor.setCheckBoxEnabled();
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<FelFelReusableBoxComplete, FelFelSearchConfiguration.FELFEL_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchQRCodeCriteria = null;
            this.searchCheckinCriteria = null;
            this.searchDateCriteria = null;
        } else if (name == FILTER_QR_CODE) {
            this.searchQRCodeCriteria = (String)value;
        } else if (name == FILTER_CHECKIN) {
            this.searchCheckinCriteria = value.equals(Words.YES) ? Boolean.valueOf(true) : (value.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null);
        } else if (name == FILTER_DATE) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.searchDateCriteria = per;
        }
        FelFelSearchConfiguration c = new FelFelSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setQrCode(this.searchQRCodeCriteria);
        c.setDate(this.searchDateCriteria);
        c.setCheckin(this.searchCheckinCriteria);
        c.getLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<FelFelReusableBoxComplete> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(FelFelSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<FelFelReusableBoxComplete> model) {
        return true;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.NONE;
    }

    @Override
    protected RowEditorFactory<FelFelReusableBoxComplete> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<FelFelReusableBoxComplete> rowEditor = new MessageProvidedRowEditor<FelFelReusableBoxComplete>(model, "Continue anyway?");
            rowEditor.orderErrors(true);
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<FelFelReusableBoxComplete>)rowEditor, p);
            rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
            rowEditor.addToFocusQueue(d1);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new FelFelBoxManagerModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo("QR Code", "", (Class)FelFelQRCodeConverter.class, (Enum<?>)FelFelSearchConfiguration.FELFEL_COLUMN.QR_CODE, FelFelReusableBoxComplete_.qrCode, TableColumnInfo.numberColumnWithExpandWidth * 2));
        info.add(new TableColumnInfo(Words.CHECKIN, "", (Class)FelFelReusableStateConverter.class, (Enum<?>)FelFelSearchConfiguration.FELFEL_COLUMN.CHECKIN, FelFelReusableBoxComplete_.checkin, 60));
        info.add(new TableColumnInfo(Words.DATE, "", (Class)DateTimeConverter.class, (Enum<?>)FelFelSearchConfiguration.FELFEL_COLUMN.DATE, FelFelReusableBoxComplete_.bookingDate, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        return info;
    }
}

