/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.equipmenttemplate.details;

import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.tables.EquipmentTemplateLabelEntryEditTable;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateLabelEntryComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateVariantComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateVariantComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class VariantLabelConfigurationDetailsPanel
extends StateDependantDetailsPanel<EquipmentTemplateComplete> {
    private static final long serialVersionUID = 1L;
    private EquipmentTemplateLabelEntryEditTable labelTable;

    public VariantLabelConfigurationDetailsPanel(RowEditor<EquipmentTemplateComplete> editor, RDProvider provider, IDataHandler dataHandler) {
        super(editor, provider, true, true, true);
        this.setTitleText(Words.LABEL_CONFIGURATION + "(not yet supported)");
        this.labelTable = new EquipmentTemplateLabelEntryEditTable();
        this.setCustomLayouter(new Layout());
        this.addToView(this.labelTable);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return EquipmentTemplateVariantComplete_.state;
    }

    @Override
    public boolean hasExpandableContent() {
        if (this.labelTable != null && this.labelTable.getModel() != null && this.labelTable.getModel().getNode() != null) {
            return !this.labelTable.getModel().getNode().getChildsAsList().isEmpty();
        }
        return false;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.labelTable);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean b = this.isStateDraft();
        boolean bl = b = b && isEnabled;
        if (isEnabled) {
            // empty if block
        }
        this.labelTable.setEnabled(false);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.labelTable.kill();
        this.labelTable = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.labelTable.getModel().setNode(node.getChildNamed(EquipmentTemplateVariantComplete_.labelEntries));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        List<ScreenValidationObject> a = super.validateParagraph();
        this.node.commitThis();
        Node n = this.node;
        EquipmentTemplateVariantComplete et = (EquipmentTemplateVariantComplete)n.getValue();
        for (EquipmentTemplateLabelEntryComplete label : et.getLabelEntries()) {
            if (label.getLabelText() == null || label.getLabelText().isEmpty()) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LABEL_TEXT_IS_SET));
            }
            if (label.getLabelAmount() > 0) continue;
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LABEL_AMOUNT_IS_GREATER_THAN_ZERO));
        }
        return a;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 340);
        }

        @Override
        public void layoutContainer(Container parent) {
            VariantLabelConfigurationDetailsPanel.this.labelTable.setLocation(0, 0);
            VariantLabelConfigurationDetailsPanel.this.labelTable.setSize(parent.getWidth(), parent.getHeight());
        }
    }
}

