/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.equipmenttemplate.details;

import ch.icit.pegasus.client.converter.GalleyEquipmentTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends StateDependantDetailsPanel<EquipmentTemplateComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDSearchTextField2<CustomerLight>> customer;
    private TitledItem<TextLabel> number;
    private TitledPeriodEditor period;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDComboBox> equipmentType;

    public SpecificationDetailsPanel(RowEditor<EquipmentTemplateComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.customer = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.equipmentType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(GalleyEquipmentTypeConverter.class)), Words.GALLEY_EQUIPMENT_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.period = new TitledPeriodEditor(null, null, true, provider, EquipmentTemplateComplete_.period.getFieldName());
        this.period.enableInfinity(false, true);
        this.setCustomLayouter(new Layout());
        this.addToView(this.customer);
        this.addToView(this.number);
        this.addToView(this.period);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.equipmentType);
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return EquipmentTemplateVariantLight_.state;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.period);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.equipmentType);
        return focusList;
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.customer.kill();
        this.customer = null;
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.locations = null;
        this.number.kill();
        this.number = null;
        this.period.kill();
        this.period = null;
        this.equipmentType.kill();
        this.equipmentType = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean draft = true;
        boolean enabledAndDraft = isEnabled && draft;
        super.setEnabled(enabledAndDraft);
        this.customer.setEnabled(enabledAndDraft);
        this.number.setEnabled(enabledAndDraft);
        this.period.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(enabledAndDraft);
        }
        this.equipmentType.setEnabled(enabledAndDraft);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            EquipmentTemplateComplete dto = (EquipmentTemplateComplete)this.editor.getModel().getNode().getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.node = this.editor.getModel().getNode();
        this.customer.getElement().setNode(this.node.getChildNamed(EquipmentTemplateComplete_.customer));
        this.number.getElement().setNode(this.node.getChildNamed(EquipmentTemplateComplete_.number));
        this.period.setStartDateNode(this.node.getChildNamed(new DtoField[]{EquipmentTemplateComplete_.period, PeriodComplete_.startDate}));
        this.period.setEndDateNode(this.node.getChildNamed(new DtoField[]{EquipmentTemplateComplete_.period, PeriodComplete_.endDate}));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(this.node.getChildNamed(EquipmentTemplateComplete_.eligibleLocations));
        }
        this.equipmentType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(GalleyEquipmentTypeComplete.class));
        this.equipmentType.getElement().setNode(this.node.getChildNamed(EquipmentTemplateComplete_.galleyEquipmentType));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.customer.getElement().isWritable() && this.customer.getElement().getNode().getValue() == null) {
            this.customer.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.CUSTOMER_NOT_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.AT_LEAST_ONE_LOCATION_MUST_BE_SET));
        }
        validationObjects.addAll(ValidationUtil.validatePeriod((Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{EquipmentTemplateComplete_.period, PeriodComplete_.startDate}), (Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{EquipmentTemplateComplete_.period, PeriodComplete_.endDate}), this.period));
        return validationObjects;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.editor.getModel().isAddRow()) {
            this.customer.requestFocusInWindowNow();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - (2 * SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.inner_horizontalBorder);
            w -= SpecificationDetailsPanel.this.horizontalBorder + 75;
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(75, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.customer.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.customer.setSize(170, (int)SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.period.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.number.getY() + SpecificationDetailsPanel.this.number.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.period.setSize((int)SpecificationDetailsPanel.this.period.getPreferredSize().getWidth(), (int)SpecificationDetailsPanel.this.period.getPreferredSize().getHeight());
            int cx = SpecificationDetailsPanel.this.horizontalBorder;
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.period.getY() + SpecificationDetailsPanel.this.period.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
                SpecificationDetailsPanel.this.locations.setSize(SpecificationDetailsPanel.this.locations.getPreferredSize());
                cx = SpecificationDetailsPanel.this.locations.getX() + SpecificationDetailsPanel.this.locations.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder;
            }
            SpecificationDetailsPanel.this.equipmentType.setLocation(cx, SpecificationDetailsPanel.this.period.getY() + SpecificationDetailsPanel.this.period.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.equipmentType.setSize(SpecificationDetailsPanel.this.equipmentType.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.period.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.equipmentType.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

