/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts.edelweiss;

import ch.icit.pegasus.client.converter.EdelweissSlowMovingArticleExchangeLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.DateDurationPanel;
import ch.icit.pegasus.client.gui.utils.panels.FTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tables.EdelweissSlowMoverExportSheetListTable;
import ch.icit.pegasus.client.gui.utils.tables.StoreSearchTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.EdelweissSlowMovingArticleExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissSlowMovingArticleExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissSlowMovingArticleExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.edelweiss.stocklevel.EdelweissSlowMoverExportComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthE;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class EdelweissSlowMoverExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> active;
    private FTPDataExchangeSettingsPanel ftpPanel;
    private TextLabel lastUpdates;
    private TitledItem<SearchTextField2<CustomerLight>> customer;
    private TitledItem<DateDurationPanel> includedPeriod;
    private StoreSearchTable includedStores;
    private Node<List<EdelweissSlowMoverExportComplete>> slowMoverData;
    private TitledItem<TextField> notificationAddress;
    private EdelweissSlowMoverExportSheetListTable history;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    private Node<EdelweissSlowMovingArticleExchangeSettingsComplete> settings;

    public EdelweissSlowMoverExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.active = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(EdelweissSlowMovingArticleExchangeSettingsComplete_.active)), Words.ACTIVE, TitledItem.TitledItemOrientation.EAST);
        this.active.getElement().addButtonListener(this);
        this.ftpPanel = new FTPDataExchangeSettingsPanel();
        this.ftpPanel.setNode(this.settings.getChildNamed(EdelweissSlowMovingArticleExchangeSettingsComplete_.sendDataExchangeSettings));
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(EdelweissSlowMovingArticleExchangeLastUpdateConverter.class));
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.settings.getChildNamed(EdelweissSlowMovingArticleExchangeSettingsComplete_.customer)), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.includedPeriod = new TitledItem<DateDurationPanel>(new DateDurationPanel(), "Included Period", TitledItem.TitledItemOrientation.NORTH);
        this.includedPeriod.getElement().setNode(this.settings.getChildNamed(EdelweissSlowMovingArticleExchangeSettingsComplete_.includePeriodValue), this.settings.getChildNamed(EdelweissSlowMovingArticleExchangeSettingsComplete_.includePeriodUnit));
        this.includedStores = new StoreSearchTable();
        this.includedStores.setNode((Node<List<StoreLight>>)this.settings.getChildNamed(EdelweissSlowMovingArticleExchangeSettingsComplete_.includedStores));
        this.notificationAddress = new TitledItem<TextField>(new TextField(), "Notification Addresses", TitledItem.TitledItemOrientation.NORTH);
        this.notificationAddress.getElement().setNode(this.settings.getChildNamed(EdelweissSlowMovingArticleExchangeSettingsComplete_.notificationMailAddress));
        this.history = new EdelweissSlowMoverExportSheetListTable();
        this.history.setNode(this.slowMoverData);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.ftpPanel);
        this.configPanel.add(this.active);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.customer);
        this.configPanel.add(this.includedPeriod);
        this.configPanel.add(this.includedStores);
        this.configPanel.add(this.notificationAddress);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                EdelweissSlowMovingArticleExchangeSettingsComplete esc = null;
                try {
                    OptionalWrapper settings1 = ((EdelweissSlowMovingArticleExchangeServiceManager)ServiceManagerRegistry.getService(EdelweissSlowMovingArticleExchangeServiceManager.class)).getSettings();
                    esc = (EdelweissSlowMovingArticleExchangeSettingsComplete)settings1.getValue();
                }
                catch (Exception settings1) {
                    // empty catch block
                }
                if (esc == null) {
                    EdelweissSlowMovingArticleExchangeSettingsComplete s = new EdelweissSlowMovingArticleExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc = s;
                }
                if (esc.getSendDataExchangeSettings() == null) {
                    SFTPDataExchangeSettingsComplete c = new SFTPDataExchangeSettingsComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc.setSendDataExchangeSettings(c);
                }
                if (esc.getSendDataExchangeSettings().getLoginPwd() == null) {
                    esc.getSendDataExchangeSettings().setLoginPwd(new EncryptedStringComplete());
                }
                esc.setSendTimerServiceSettings(EdelweissSlowMoverExchangeInsert.this.createTimerServiceConfig());
                EdelweissSlowMoverExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)esc, false, false);
                EdelweissSlowMoverExchangeInsert.this.slowMoverData = (Node)new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return EdelweissSlowMoverExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerServiceConfig() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfMonthTimeComplete(DayOfMonthE.DAY_26, Integer.valueOf(1), Integer.valueOf(50), Integer.valueOf(0)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.active.setEnabled(isEnabled);
            boolean b = isEnabled && this.active.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.ftpPanel.setEnabled(b);
            this.customer.setEnabled(b);
            this.includedStores.setEnabled(b);
            this.includedPeriod.setEnabled(b);
            this.notificationAddress.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.sendButton.kill();
            this.ftpPanel.kill();
            this.history.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.active.kill();
            this.customer.kill();
            this.includedPeriod.kill();
            this.includedStores.kill();
            this.notificationAddress.kill();
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.ftpPanel = null;
        this.sendButton = null;
        this.history = null;
        this.lastUpdates = null;
        this.saveButton = null;
        this.active = null;
        this.customer = null;
        this.includedStores = null;
        this.includedPeriod = null;
        this.notificationAddress = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "EDW Slow Mover Exchange";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.settings.commit();
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA_WITH_EDELWEISS);
                this.processFiles(false);
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateESpecsConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateESpecsConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                EdelweissSlowMoverExchangeInsert.this.settings.commit(EdelweissSlowMovingArticleExchangeSettingsComplete.class);
                EdelweissSlowMovingArticleExchangeSettingsComplete value = (EdelweissSlowMovingArticleExchangeSettingsComplete)EdelweissSlowMoverExchangeInsert.this.settings.getValue();
                value.getSendDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                value.setSendTimerServiceSettings(EdelweissSlowMoverExchangeInsert.this.createTimerServiceConfig());
                TimerServiceSettingsComplete sendTS = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(value.getSendTimerServiceSettings()).getValue();
                value.setSendTimerServiceSettings(sendTS);
                value = (EdelweissSlowMovingArticleExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)value).getValue();
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.EDW_SLOW_MOVER_EXCHANGE, value.getActive().booleanValue(), sendTS, -1L);
                EdelweissSlowMoverExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)value, false, false);
                EdelweissSlowMoverExchangeInsert.this.lastUpdates.setNode(EdelweissSlowMoverExchangeInsert.this.settings);
                EdelweissSlowMoverExchangeInsert.this.history.setNode(EdelweissSlowMoverExchangeInsert.this.slowMoverData);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        EdelweissSlowMoverExchangeInsert.this.hideAnimation();
                        EdelweissSlowMoverExchangeInsert.this.module.ended();
                        EdelweissSlowMoverExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)EdelweissSlowMoverExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles(boolean read) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((EdelweissSlowMovingArticleExchangeServiceManager)ServiceManagerRegistry.getService(EdelweissSlowMovingArticleExchangeServiceManager.class)).sendData();
                EdelweissSlowMoverExchangeInsert.this.lastUpdates.setNode(EdelweissSlowMoverExchangeInsert.this.settings);
                return EdelweissSlowMoverExchangeInsert.this.slowMoverData;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_EXPORTED, EdelweissSlowMoverExchangeInsert.this.sendButton);
                        EdelweissSlowMoverExchangeInsert.this.hideAnimation();
                        EdelweissSlowMoverExchangeInsert.this.setEnabled(true);
                        EdelweissSlowMoverExchangeInsert.this.module.ended();
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Export failed", (Component)EdelweissSlowMoverExchangeInsert.this.sendButton);
                        EdelweissSlowMoverExchangeInsert.this.hideAnimation();
                        EdelweissSlowMoverExchangeInsert.this.setEnabled(true);
                        EdelweissSlowMoverExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            EdelweissSlowMoverExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            EdelweissSlowMoverExchangeInsert.this.active.setLocation(border, border + EdelweissSlowMoverExchangeInsert.this.configPanel.getTitleHeight());
            EdelweissSlowMoverExchangeInsert.this.active.setSize(EdelweissSlowMoverExchangeInsert.this.active.getPreferredSize());
            EdelweissSlowMoverExchangeInsert.this.ftpPanel.setLocation(border, EdelweissSlowMoverExchangeInsert.this.active.getY() + EdelweissSlowMoverExchangeInsert.this.active.getHeight() + border);
            EdelweissSlowMoverExchangeInsert.this.ftpPanel.setSize(450, (int)EdelweissSlowMoverExchangeInsert.this.ftpPanel.getPreferredSize().getHeight());
            EdelweissSlowMoverExchangeInsert.this.lastUpdates.setLocation(border, EdelweissSlowMoverExchangeInsert.this.ftpPanel.getY() + EdelweissSlowMoverExchangeInsert.this.ftpPanel.getHeight());
            EdelweissSlowMoverExchangeInsert.this.lastUpdates.setSize(parent.getWidth() - 2 * border, (int)EdelweissSlowMoverExchangeInsert.this.lastUpdates.getPreferredSize().getHeight());
            EdelweissSlowMoverExchangeInsert.this.customer.setLocation(border, EdelweissSlowMoverExchangeInsert.this.lastUpdates.getY() + EdelweissSlowMoverExchangeInsert.this.lastUpdates.getHeight() + 5);
            EdelweissSlowMoverExchangeInsert.this.customer.setSize(parent.getWidth() - 2 * border, (int)EdelweissSlowMoverExchangeInsert.this.customer.getPreferredSize().getHeight());
            EdelweissSlowMoverExchangeInsert.this.includedPeriod.setLocation(border, EdelweissSlowMoverExchangeInsert.this.customer.getY() + EdelweissSlowMoverExchangeInsert.this.customer.getHeight() + border);
            EdelweissSlowMoverExchangeInsert.this.includedPeriod.setSize(450, (int)EdelweissSlowMoverExchangeInsert.this.includedPeriod.getPreferredSize().getHeight());
            EdelweissSlowMoverExchangeInsert.this.notificationAddress.setLocation(border, EdelweissSlowMoverExchangeInsert.this.includedPeriod.getY() + EdelweissSlowMoverExchangeInsert.this.includedPeriod.getHeight() + border);
            EdelweissSlowMoverExchangeInsert.this.notificationAddress.setSize(450, (int)EdelweissSlowMoverExchangeInsert.this.notificationAddress.getPreferredSize().getHeight());
            EdelweissSlowMoverExchangeInsert.this.includedStores.setLocation(border, EdelweissSlowMoverExchangeInsert.this.notificationAddress.getY() + EdelweissSlowMoverExchangeInsert.this.notificationAddress.getHeight() + border);
            EdelweissSlowMoverExchangeInsert.this.includedStores.setSize(450, 300);
            EdelweissSlowMoverExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - EdelweissSlowMoverExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + EdelweissSlowMoverExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            EdelweissSlowMoverExchangeInsert.this.saveButton.setSize(EdelweissSlowMoverExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            EdelweissSlowMoverExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            EdelweissSlowMoverExchangeInsert.this.history.setLocation(0, EdelweissSlowMoverExchangeInsert.this.sendPanel.getTitleHeight());
            EdelweissSlowMoverExchangeInsert.this.history.setSize(parent.getWidth(), EdelweissSlowMoverExchangeInsert.this.sendPanel.getHeight() - (border + EdelweissSlowMoverExchangeInsert.this.sendPanel.getTitleHeight() + 100));
            EdelweissSlowMoverExchangeInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - EdelweissSlowMoverExchangeInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (EdelweissSlowMoverExchangeInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            EdelweissSlowMoverExchangeInsert.this.sendButton.setSize(EdelweissSlowMoverExchangeInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (EdelweissSlowMoverExchangeInsert.this.animation != null) {
                EdelweissSlowMoverExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - EdelweissSlowMoverExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - EdelweissSlowMoverExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                EdelweissSlowMoverExchangeInsert.this.animation.setSize(EdelweissSlowMoverExchangeInsert.this.animation.getPreferredSize());
            }
            if (EdelweissSlowMoverExchangeInsert.this.isInserted) {
                EdelweissSlowMoverExchangeInsert.this.configPanel.setLocation(border, border);
                EdelweissSlowMoverExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                EdelweissSlowMoverExchangeInsert.this.sendPanel.setLocation(EdelweissSlowMoverExchangeInsert.this.configPanel.getX() + EdelweissSlowMoverExchangeInsert.this.configPanel.getWidth() + border, border);
                EdelweissSlowMoverExchangeInsert.this.sendPanel.setSize(EdelweissSlowMoverExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

