/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataMaintenanceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataMaintenanceSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class DataMaintenanceExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private ScrollPane scrollPane;
    private JPanelKillable contentPane;
    private TitledItem<CheckBox> useCloseFlightForTransactionWhenInvoiceClosed;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    protected Node<DataMaintenanceSettingsComplete> settings;
    protected DataMaintenanceSettingsComplete edsc;

    public DataMaintenanceExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.contentPane = new JPanelKillable();
        this.contentPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane.getHorizontalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.getVerticalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.setViewportView(this.contentPane);
        this.useCloseFlightForTransactionWhenInvoiceClosed = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(DataMaintenanceSettingsComplete_.useCloseFlightForTransactionWhenInvoiceClosed)), "Use Close Flight for Transaction when Invoice closed", TitledItem.TitledItemOrientation.EAST);
        this.useCloseFlightForTransactionWhenInvoiceClosed.getElement().addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText("Save");
        this.sendPanel.setHasBackground(true);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.contentPane.setLayout(new ConfigLayout());
        this.configPanel.setLayout(new ScrollPaneLayout());
        this.contentPane.add(this.useCloseFlightForTransactionWhenInvoiceClosed);
        this.configPanel.add(this.scrollPane);
        this.sendPanel.add(this.saveButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                try {
                    DataMaintenanceExchangeInsert.this.edsc = (DataMaintenanceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getMaintenanceSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataMaintenanceExchangeInsert.this.edsc.setTimerServiceSettingsCloseTransaction(DataMaintenanceExchangeInsert.this.createTimerServiceCloseFlightForTransaction());
                DataMaintenanceExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)DataMaintenanceExchangeInsert.this.edsc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return DataMaintenanceExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useCloseFlightForTransactionWhenInvoiceClosed.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.scrollPane.kill();
            this.saveButton.kill();
            this.useCloseFlightForTransactionWhenInvoiceClosed.kill();
            this.scrollPane = null;
            this.saveButton = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.useCloseFlightForTransactionWhenInvoiceClosed = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Data Maintenance";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source != this.saveButton) {
            this.setEnabled(this.isEnabled());
            return;
        }
        List<ScreenValidationObject> a = this.validateLevelCheck();
        if (a.isEmpty()) {
            this.ensureAnimation(Words.SAVE_DATA);
            this.saveConfig();
            return;
        }
        InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
        this.setEnabled(true);
    }

    private List<ScreenValidationObject> validateLevelCheck() {
        return new ArrayList<ScreenValidationObject>();
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                DataMaintenanceExchangeInsert.this.settings.commit(DataMaintenanceSettingsComplete.class);
                DataMaintenanceSettingsComplete rimsc = (DataMaintenanceSettingsComplete)DataMaintenanceExchangeInsert.this.settings.getValue();
                rimsc.setTimerServiceSettingsCloseTransaction(DataMaintenanceExchangeInsert.this.createTimerServiceCloseFlightForTransaction());
                if (Boolean.TRUE.equals(rimsc.getUseCloseFlightForTransactionWhenInvoiceClosed())) {
                    rimsc = (DataMaintenanceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimsc.getTimerServiceSettingsCloseTransaction()).getValue();
                    rimsc.setTimerServiceSettingsCloseTransaction(ts);
                    rimsc = (DataMaintenanceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.DATA_MAINTENANCE_CLOSE_FLIGHT_FOR_TRANSACTION, rimsc.getUseCloseFlightForTransactionWhenInvoiceClosed().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.DATA_MAINTENANCE_CLOSE_FLIGHT_FOR_TRANSACTION);
                    rimsc = (DataMaintenanceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                }
                Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        DataMaintenanceExchangeInsert.this.hideAnimation();
                        DataMaintenanceExchangeInsert.this.module.ended();
                        DataMaintenanceExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)DataMaintenanceExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerServiceCloseFlightForTransaction() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(2), Integer.valueOf(20)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private class ScrollPaneLayout
    extends DefaultLayout {
        private ScrollPaneLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            DataMaintenanceExchangeInsert.this.configPanel.layoutTitle(parent);
            DataMaintenanceExchangeInsert.this.scrollPane.setLocation(1, DataMaintenanceExchangeInsert.this.configPanel.getTitleHeight());
            DataMaintenanceExchangeInsert.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - (DataMaintenanceExchangeInsert.this.configPanel.getTitleHeight() + 1));
        }
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            DataMaintenanceExchangeInsert.this.useCloseFlightForTransactionWhenInvoiceClosed.setLocation(border, border);
            DataMaintenanceExchangeInsert.this.useCloseFlightForTransactionWhenInvoiceClosed.setSize(DataMaintenanceExchangeInsert.this.useCloseFlightForTransactionWhenInvoiceClosed.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            h = (int)((double)h + DataMaintenanceExchangeInsert.this.useCloseFlightForTransactionWhenInvoiceClosed.getPreferredSize().getHeight());
            return new Dimension(0, h += border);
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            DataMaintenanceExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            DataMaintenanceExchangeInsert.this.saveButton.setLocation(border, (int)((double)parent.getHeight() - (DataMaintenanceExchangeInsert.this.saveButton.getPreferredSize().getHeight() + (double)border)));
            DataMaintenanceExchangeInsert.this.saveButton.setSize(DataMaintenanceExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (DataMaintenanceExchangeInsert.this.animation != null) {
                DataMaintenanceExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - DataMaintenanceExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - DataMaintenanceExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                DataMaintenanceExchangeInsert.this.animation.setSize(DataMaintenanceExchangeInsert.this.animation.getPreferredSize());
            }
            if (DataMaintenanceExchangeInsert.this.isInserted) {
                DataMaintenanceExchangeInsert.this.configPanel.setLocation(border, border);
                DataMaintenanceExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                DataMaintenanceExchangeInsert.this.sendPanel.setLocation(DataMaintenanceExchangeInsert.this.configPanel.getX() + DataMaintenanceExchangeInsert.this.configPanel.getWidth() + border, border);
                DataMaintenanceExchangeInsert.this.sendPanel.setSize(DataMaintenanceExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

