/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dailyops.utils;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dailyops.FlightDailyOpsModuleDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.toolbar.ScreenToolView;
import ch.icit.pegasus.client.gui.screentemplates.toolbar.ToolButton;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.List;

public class OpenFlightsButton
extends ToolButton
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private FlightSearchConfiguration fsc;
    private RDProvider accessRight;

    public OpenFlightsButton(ScreenToolView toolBox, RDProvider p) {
        super(toolBox, DefaultSkins.FlightIcon);
        this.accessRight = p;
        this.addButtonListener(this);
    }

    private void startOpening() {
        final LoadingAnimation animation = this.toolBox.getOverview().startAnimation("Open Flight XXXXXXXXX (123/123)");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightDailyOpsModuleDataHandler.openFlights(OpenFlightsButton.this.fsc, animation);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        OpenFlightsButton.this.stopOpening(node);
                    }

                    public void errorOccurred(ClientException exception) {
                        OpenFlightsButton.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void stopOpening(Node<?> res) {
        if (res.getValue() instanceof ClientServerCallException) {
            this.toolBox.getOverview().showMessage(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, ((ClientServerCallException)((Object)res.getValue())).getMessage())}));
        } else if (res.getValue() instanceof List) {
            if (((List)res.getValue()).isEmpty()) {
                this.toolBox.getOverview().showMessage((List)res.getValue());
            } else {
                InnerPopupFactory.showMessageDialog(Words.ALL_FLIGHTS_OPENED, this);
            }
        }
        this.toolBox.getOverview().hideAnimation();
        this.toolBox.getOverview().reloadData();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean b = isEnabled;
        b = b && this.accessRight.isWritable("openAllFlights");
        super.setEnabled(b);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.fsc = (FlightSearchConfiguration)this.toolBox.getOverview().getModuleSearchParameters(null, null, false, false, null);
        Converter c = ConverterRegistry.getConverter(DateConverter.class);
        String t = "Are you sure to open all Flights at " + (String)c.convert((Object)this.fsc.getDayPeriod().getStartDate(), null, new Object[0]);
        InnerPopupFactory.showDesicionPopup("Open Flights", t, this, new InnerPopUpListener2(){

            @Override
            public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                if (xargs == null) {
                    return;
                }
                OpenFlightsButton.this.startOpening();
            }
        }, 350, -1, PopupType.NORMAL);
    }
}

