/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkin.product;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductProduceTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.ManualStockCheckoutRemarkComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.Iterator;

public class ProductGroupStockCheckinModuleDataHandler
extends DefaultDataHandler<ProductStockCheckinGroupLight, ProductStockCheckinGroupComplete> {
    public ProductGroupStockCheckinModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductStockCheckinGroupLight group = (ProductStockCheckinGroupLight)node.getValue(ProductStockCheckinGroupLight.class);
                ProductStockCheckinGroupComplete ngroup = (ProductStockCheckinGroupComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getProductCheckinGroup(new ProductStockCheckinGroupReference(group.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)ngroup, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<ProductStockCheckinGroupLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductStockCheckinGroupComplete g = (ProductStockCheckinGroupComplete)node.getValue(ProductStockCheckinGroupComplete.class);
                g.getStockCheckins().forEach(transaction -> transaction.setProductCheckinGroup((ProductStockCheckinGroupReference)g));
                g.getStockCheckinCorrections().forEach(transaction -> transaction.setProductCheckinGroup((ProductStockCheckinGroupReference)g));
                ProductStockCheckinGroupComplete gn = (ProductStockCheckinGroupComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).updateProductCheckinGroup(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ProductStockCheckinGroupComplete> createEmptyNode() {
        ProductStockCheckinGroupComplete d = new ProductStockCheckinGroupComplete();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<ProductStockCheckinGroupComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(ProductStockCheckinGroupComplete.class);
                ProductStockCheckinGroupComplete g = (ProductStockCheckinGroupComplete)node.getValue(ProductStockCheckinGroupComplete.class);
                Iterator it = g.getStockCheckins().iterator();
                while (it.hasNext()) {
                    ProductProduceTransactionComplete c = (ProductProduceTransactionComplete)it.next();
                    if (c.getQuantity() == null || c.getQuantity().getAmount() != null && c.getQuantity().getAmount() != 0L) continue;
                    it.remove();
                }
                if (g.getEligibleLocations().isEmpty()) {
                    g.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                g.getStockCheckins().forEach(transaction -> transaction.setProductCheckinGroup((ProductStockCheckinGroupReference)g));
                g.getStockCheckinCorrections().forEach(transaction -> transaction.setProductCheckinGroup((ProductStockCheckinGroupReference)g));
                ProductStockCheckinGroupComplete gn = (ProductStockCheckinGroupComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).createProductCheckinGroup(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductGroupStockCheckinModuleDataHandler.this.setCurrentLoadMaximum(7);
                ProductGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                ProductGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                ProductGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ProductGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                ProductGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ManualStockCheckoutRemarkComplete.class);
                ProductGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                ProductGroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return ProductGroupStockCheckinModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ProductStockCheckinGroupComplete> resetData(Node<ProductStockCheckinGroupComplete> node) {
        ProductStockCheckinGroupComplete n = new ProductStockCheckinGroupComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        n.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<ProductStockCheckinGroupComplete> getCommittingClass() {
        return ProductStockCheckinGroupComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<ProductStockCheckinGroupLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

