/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlestockswap.detail;

import ch.icit.pegasus.client.gui.modules.importer.utils.ImporterItemView;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.utils.ImportType;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportComplete;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportComplete_;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportLight;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ConfigurationDetailsPanel
extends DefaultDetailsPanel<ArticleStockSwapDataImportLight>
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> name;
    private TitledItem<RDTextField> description;
    private TitledItem<FileChooserPanel> file;
    private ViewButton downloadTemplateButton;
    private ImportType importType = ImportType.ARTICLE_STOCK_SWAP_IMPORT;
    private InfoButton infoButton;

    public ConfigurationDetailsPanel(RowEditor<ArticleStockSwapDataImportLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CONFIGURATION);
        this.setCustomLayouter(new Layout());
        this.file = new TitledItem<FileChooserPanel>(new FileChooserPanel(false), Words.FILE, TitledItem.TitledItemOrientation.NORTH);
        this.file.getElement().setFileType("xlsx");
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.description = new TitledItem<RDTextField>(new RDTextField(provider), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        this.downloadTemplateButton = new ViewButton();
        this.infoButton = new InfoButton();
        this.downloadTemplateButton.addButtonListener(this);
        this.infoButton.installStringViewer(this.createInfoText());
        this.addToView(this.file);
        this.addToView(this.name);
        this.addToView(this.description);
        this.add(this.downloadTemplateButton);
        this.add(this.infoButton);
    }

    private String createInfoText() {
        return this.importType.getFormat();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.description);
        CheckedListAdder.addToList(focusList, this.file);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        this.name.getElement().setNode(node.getChildNamed(ArticleStockSwapDataImportLight_.name));
        this.file.getElement().setNode(node.getChildNamed(ArticleStockSwapDataImportComplete_.sheet));
        this.description.getElement().setNode(node.getChildNamed(ArticleStockSwapDataImportComplete_.description));
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
        PegasusFileComplete gr = (PegasusFileComplete)this.editor.getModel().getNode().getChildNamed(ArticleStockSwapDataImportComplete_.sheet).getValue();
        if (gr != null && gr.getLocalFile() != null) {
            FileCommitter c = new FileCommitter(gr.getLocalFile(), FileCategoryE.IMPORT);
            c.setWriteBackAlgorithm(reference -> {
                this.editor.getModel().getNode().getChildNamed(ArticleStockSwapDataImportComplete_.sheet).setValue((Object)reference, 0L);
                ((ArticleStockSwapDataImportComplete)this.editor.getModel().getNode().getValue()).setSheet(reference);
            });
            a.add(c);
        }
        return a;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.downloadTemplateButton) {
            try {
                File f = this.downloadFile();
                if (f == null) {
                    InnerPopupFactory.showErrorDialog("No template ready. Please contact support.", (Component)this);
                }
                Desktop.getDesktop().open(f);
            }
            catch (IOException e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.file.kill();
        this.file = null;
        this.name.kill();
        this.name = null;
        this.description.kill();
        this.description = null;
        this.infoButton.kill();
        this.infoButton = null;
        this.downloadTemplateButton.kill();
        this.downloadTemplateButton = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.file.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.description.setEnabled(isEnabled);
        this.infoButton.setEnabled(isEnabled);
        this.downloadTemplateButton.setEnabled(isEnabled);
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.file.getElement().getNode().getValue() == null || ((PegasusFileComplete)this.file.getElement().getNode().getValue()).getLocalFile() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Article Swap file is selected"));
        }
        if (StringUtil.isBlank((String)((String)this.name.getElement().getNode().getValue()))) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Name is set"));
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    private File downloadFile() throws IOException {
        File tempFile = File.createTempFile("ImporterFile_", ".xlsx");
        URL url = this.createURL();
        if (url == null) {
            return null;
        }
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
        return tempFile;
    }

    private URL createURL() throws MalformedURLException {
        return ImporterItemView.class.getResource("/importtemplates/" + this.importType.getTemplateId());
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ConfigurationDetailsPanel.this.name.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.name.setSize(400, (int)ConfigurationDetailsPanel.this.name.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.description.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.name.getY() + ConfigurationDetailsPanel.this.name.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.description.setSize(400, (int)ConfigurationDetailsPanel.this.description.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.file.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.description.getY() + ConfigurationDetailsPanel.this.description.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.file.setSize(400, (int)ConfigurationDetailsPanel.this.file.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.infoButton.setLocation(ConfigurationDetailsPanel.this.horizontalBorder + 420, ConfigurationDetailsPanel.this.file.getY() + ConfigurationDetailsPanel.this.file.getHeight() - 2);
            ConfigurationDetailsPanel.this.infoButton.setSize(400, (int)ConfigurationDetailsPanel.this.infoButton.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.downloadTemplateButton.setLocation(ConfigurationDetailsPanel.this.horizontalBorder + 440, ConfigurationDetailsPanel.this.file.getY() + ConfigurationDetailsPanel.this.file.getHeight() - 4);
            ConfigurationDetailsPanel.this.downloadTemplateButton.setSize(400, (int)ConfigurationDetailsPanel.this.downloadTemplateButton.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int lh = ConfigurationDetailsPanel.this.verticalBorder;
            lh = (int)((double)lh + ConfigurationDetailsPanel.this.name.getPreferredSize().getHeight());
            lh += ConfigurationDetailsPanel.this.inner_verticalBorder;
            lh = (int)((double)lh + ConfigurationDetailsPanel.this.description.getPreferredSize().getHeight());
            lh += ConfigurationDetailsPanel.this.inner_verticalBorder;
            lh = (int)((double)lh + ConfigurationDetailsPanel.this.file.getPreferredSize().getHeight());
            return new Dimension(0, lh += ConfigurationDetailsPanel.this.verticalBorder);
        }
    }
}

