/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlepricecalculator.details;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PerUnitViewConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.articlepricecalculator.details.utils.ArticleAccCountCalculatorConverter;
import ch.icit.pegasus.client.gui.modules.articlepricecalculator.details.utils.ArticleAveragePriceCalculatorConverter;
import ch.icit.pegasus.client.gui.modules.articlepricecalculator.details.utils.ArticleMaxPriceCalculatorConverter;
import ch.icit.pegasus.client.gui.modules.articlepricecalculator.details.utils.ArticleMinPriceCalculatorConverter;
import ch.icit.pegasus.client.gui.modules.articlepricecalculator.details.utils.ArticlePriceCalculationEntryConverter;
import ch.icit.pegasus.client.gui.modules.articlepricecalculator.details.utils.ArticleTotalPriceCalculatorConverter;
import ch.icit.pegasus.client.gui.modules.articlepricecalculator.details.utils.ArticleTotalQuantityCalculatorConverter;
import ch.icit.pegasus.client.gui.modules.articlepricecalculator.details.utils.ArticleWeightedPriceCalculatorConverter;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.TitledCategoryChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.DispositionServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticlePriceModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationEntryComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationEntryComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationLight;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.Triple;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArticlesDetailsPanel
extends TableDetailsPanel<ArticlePriceCalculationLight>
implements SearchTextField2Listener {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> includeCustomerOwnedArticles;
    private TitledItem<SearchTextField2<BasicArticleLight>> articleSearch;
    private TitledItem<SearchTextField2<CustomerLight>> customerSearch;
    private TitledItem<SearchTextField2<ProductCatalogLight>> productCatalogSearch;
    private TitledItem<SearchTextField2<ProductVariantLight>> productSearch;
    private CheckBox fromToBox;
    private TitledItem<TextField> fromNo;
    private TitledItem<TextField> toNo;
    private TitledItem<SearchTextField2<SupplierLight>> supplier;
    private CheckBox catBox;
    private TitledCategoryChooser category;
    private TextButton add;
    private TextButton addAll;
    private TextButton clear;
    private TitledPeriodEditor searchValidityDate;
    private TitledItem<CheckBox> checkEveryDay;
    private TitledItem<CheckBox> useTender;
    private boolean isDraft = true;

    public ArticlesDetailsPanel(RowEditor<ArticlePriceCalculationLight> editor, RDProvider provider) {
        super(editor, provider, true, true, false, false);
        this.setTitleText(Words.ARTICLES);
        this.articleSearch = new TitledItem<SearchTextField2<BasicArticleLight>>(SearchTextField2Factory.getBasicArticleSearchField(true, new DTOProxyNode(null)), Words.NAME_OR_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.customerSearch = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, new DTOProxyNode(null)), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.productCatalogSearch = new TitledItem<SearchTextField2<ProductCatalogLight>>(SearchTextField2Factory.getStandardProductCatalogSearchField(true, new DTOProxyNode(null)), Words.PRODUCT_CATALOG, TitledItem.TitledItemOrientation.NORTH);
        this.productSearch = new TitledItem<SearchTextField2<ProductVariantLight>>(SearchTextField2Factory.getProductVariantSearchField(true, new DTOProxyNode(null)), Words.PRODUCT + " (" + Words.VALIDITY_FROM_START_DATE_TO_END_DATE + ")", TitledItem.TitledItemOrientation.NORTH);
        this.includeCustomerOwnedArticles = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CUSTOMER_OWNED, TitledItem.TitledItemOrientation.EAST);
        this.fromToBox = new CheckBox();
        this.fromNo = new TitledItem<NumberTextField>(new NumberTextField(new Node(), TextFieldType.INT), Words.FROM_NO, TitledItem.TitledItemOrientation.NORTH);
        this.toNo = new TitledItem<NumberTextField>(new NumberTextField(new Node(), TextFieldType.INT), Words.TO_NO, TitledItem.TitledItemOrientation.NORTH);
        this.supplier = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(true, new DTOProxyNode(null)), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        this.catBox = new CheckBox();
        this.category = new TitledCategoryChooser((Node)new DTOProxyNode(null), NodeToolkit.getAffixList(ArticleCategoryComplete.class), TitledCategoryChooser.getTypeForSettings(TitledCategoryChooser.CATEGORY_TYPE.ARTICLE), false, true);
        Node startNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        Node endNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.searchValidityDate = new TitledPeriodEditor((Node<Date>)startNode, (Node<Date>)endNode, true, null);
        Object[] o = new Object[]{startNode, endNode};
        this.productSearch.getElement().setAdditionalSearchField(o);
        this.checkEveryDay = new TitledItem<CheckBox>(new CheckBox(), Words.CHECK_EVERY_DAY, TitledItem.TitledItemOrientation.EAST);
        this.useTender = new TitledItem<CheckBox>(new CheckBox(), Words.USE_TENDER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.add = new TextButton(Words.ADD);
        this.addAll = new TextButton(Words.ADD_ALL);
        this.clear = new TextButton(Words.CLEAR);
        this.add.addButtonListener(this);
        this.addAll.addButtonListener(this);
        this.clear.addButtonListener(this);
        this.catBox.addButtonListener(this);
        this.fromToBox.addButtonListener(this);
        this.articleSearch.getElement().addSearchTextFieldListener(this);
        this.customerSearch.getElement().addSearchTextFieldListener(this);
        this.productCatalogSearch.getElement().addSearchTextFieldListener(this);
        this.productSearch.getElement().addSearchTextFieldListener(this);
        this.supplier.getElement().addSearchTextFieldListener(this);
        this.category.setProgress(1.0f);
        this.addToView(this.articleSearch);
        this.addToView(this.customerSearch);
        this.addToView(this.productCatalogSearch);
        this.addToView(this.searchValidityDate);
        this.addToView(this.checkEveryDay);
        this.addToView(this.useTender);
        this.addToView(this.productSearch);
        this.addToView(this.includeCustomerOwnedArticles);
        this.addToView(this.fromToBox);
        this.addToView(this.fromNo);
        this.addToView(this.toNo);
        this.addToView(this.supplier);
        this.addToView(this.catBox);
        this.addToView(this.category);
        this.addToView(this.clear);
        this.addToView(this.add);
        this.addToView(this.addAll);
        this.addToView(this.clear);
        this.addToView(this.table);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 10, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.ARTICLE, null, null, null, "", 10, Integer.MAX_VALUE, 100));
        columns.add(new TableColumnInfo(Words.OLD_STD_PRICE, null, null, null, "", 10, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        columns.add(new TableColumnInfo(Words.MIN_PRICE_PO, null, null, null, "", 10, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        columns.add(new TableColumnInfo(Words.MAX_PRICE_PO, null, null, null, "", 10, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        columns.add(new TableColumnInfo(Words.AVG_PRICE_PO, null, null, null, "", 10, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        columns.add(new TableColumnInfo(Words.WEIGHTED_AVERAGE_PRICE_PO, null, null, null, "", 10, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        columns.add(new TableColumnInfo(Words.TOTAL_COSTS, null, null, null, "", 10, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        columns.add(new TableColumnInfo(Words.TOTAL_QUANTITY, null, null, null, "", 10, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 10, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.NEW_STD_PRICE, null, null, null, "", 10, 2 * TableColumnInfo.priceColumnWidth, 2 * TableColumnInfo.priceColumnWidth));
        columns.add(new TableColumnInfo(Words.DIFF, null, null, null, "", 10, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(9)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(10)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(11)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(12)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    private void addOne() {
        if (this.articleSearch.getElement().isItemSelected()) {
            this.loadArticle(this.articleSearch.getElement().getNode());
        }
    }

    private void loadArticle(final Node articleNode) {
        if (articleNode.getValue(BasicArticleLight.class) == null) {
            final BasicArticleReference articleReference = (BasicArticleReference)articleNode.getValue(BasicArticleReference.class);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    BasicArticleComplete articleComplete = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(articleReference.getId())).getValue();
                    articleNode.removeExistingValues();
                    articleNode.setValue((Object)articleComplete, 0L);
                    return articleNode;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            BasicArticleComplete articleComplete = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
                            ArticlesDetailsPanel.this.addArticle((BasicArticleLight)articleComplete);
                        }

                        public void errorOccurred(ClientException exception) {
                            ArticlesDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.addArticle((BasicArticleLight)articleNode.getValue(BasicArticleLight.class));
        }
    }

    private void addArticle(BasicArticleLight article) {
        ArticlePriceCalculationEntryComplete entry = new ArticlePriceCalculationEntryComplete();
        entry.setClientOId(Long.valueOf(ADTO.getNextId()));
        entry.setArticle(article);
        boolean useTender = Boolean.TRUE.equals(this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.tenderPrice).getValue());
        CustomerReference customer = (CustomerReference)this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.tenderCustomer).getValue();
        PriceComplete netto = ArticlePriceCalculationToolkit.getNettoPrice((BasicArticleLight)article, (Timestamp)new Timestamp(System.currentTimeMillis()), (CustomerReference)customer, (boolean)useTender);
        entry.setNewPrice(new PriceComplete(netto));
        entry.setOldPrice(new PriceComplete(netto));
        entry.setOldPriceUnit(article.getPriceUnit());
        entry.setNewPriceUnit(article.getPriceUnit());
        entry.setCalcPriceUnit(article.getPriceUnit());
        entry.setCalcPrice(new PriceComplete(netto.getCurrency(), Double.valueOf(0.0)));
        entry.setMaxPrice(new PriceComplete(entry.getCalcPrice()));
        entry.setMinPrice(new PriceComplete(entry.getCalcPrice()));
        entry.setAveragePrice(new PriceComplete(entry.getCalcPrice()));
        entry.setWeightedAveragePrice(new PriceComplete(entry.getCalcPrice()));
        entry.setTotalCosts(new PriceComplete(entry.getCalcPrice()));
        entry.setMinPriceUnit(entry.getCalcPriceUnit());
        entry.setMaxPriceUnit(entry.getCalcPriceUnit());
        entry.setAveragePriceUnit(entry.getCalcPriceUnit());
        entry.setWeightedAveragePriceUnit(entry.getCalcPriceUnit());
        entry.setTotalQuantity(new QuantityComplete(Double.valueOf(0.0), article.getPriceUnit()));
        entry.setNumberOfAcceptations(Integer.valueOf(0));
        Node articleNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)entry, true, false);
        this.table.getModel().getNode().addChild(articleNode, System.currentTimeMillis());
    }

    private void addAll() {
        if (this.productSearch.getElement().isItemSelected()) {
            this.editor.showCommittingAnimation(Words.LOAD_ARTICLES_FROM_PPODUCTS);
            this.editor.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    ProductVariantLight productVariantLight = (ProductVariantLight)((SearchTextField2)ArticlesDetailsPanel.this.productSearch.getElement()).getNode().getValue();
                    HashMap<ProductVariantLight, Integer> productMap = new HashMap<ProductVariantLight, Integer>();
                    productMap.put(productVariantLight, 1);
                    boolean includeOwned = ((CheckBox)ArticlesDetailsPanel.this.includeCustomerOwnedArticles.getElement()).isChecked();
                    Triple o = ((DispositionServiceManager)ServiceManagerRegistry.getService(DispositionServiceManager.class)).getArticlesFromProduct(new MapWrapper(productMap), new TimestampWrapper(productVariantLight.getValidityPeriod().getStartDate().getTime() + 1L));
                    Map map = ((MapWrapper)o.getT()).getMap();
                    for (BasicArticleComplete art : map.keySet()) {
                        if (Boolean.TRUE.equals(art.getExcludeFromArticlePriceCalculation())) continue;
                        if (art.getCustomerIsOwner().booleanValue()) {
                            if (!includeOwned) continue;
                            ArticlesDetailsPanel.this.addArticle((BasicArticleLight)art);
                            continue;
                        }
                        ArticlesDetailsPanel.this.addArticle((BasicArticleLight)art);
                    }
                    if (o.getS() != null && !((MapWrapper)o.getS()).getMap().isEmpty()) {
                        ArrayList<ScreenValidationObject> ooo = new ArrayList<ScreenValidationObject>();
                        for (Map.Entry e : ((MapWrapper)o.getS()).getMap().entrySet()) {
                            for (String t : ((ListWrapper)e.getValue()).getList()) {
                                ooo.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, t));
                            }
                        }
                        InnerPopupFactory.showMessageDialog(ooo, Words.FOLLOWING_WARNINGS_OCCURRED, (Component)ArticlesDetailsPanel.this);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ArticlesDetailsPanel.this.editor.hideCommittingAnimation();
                            ArticlesDetailsPanel.this.editor.setEnabled(true);
                            ((SearchTextField2)ArticlesDetailsPanel.this.productSearch.getElement()).requestFocusInWindowNow();
                        }

                        public void errorOccurred(ClientException exception) {
                            ArticlesDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (this.productCatalogSearch.getElement().isItemSelected()) {
            this.editor.showCommittingAnimation(Words.LOAD_ARTICLES_FROM_PRODUCT_CATALOG);
            this.editor.setEnabled(false);
            final boolean includeOwned = this.includeCustomerOwnedArticles.getElement().isChecked();
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    ProductCatalogLight productCatalogLight = (ProductCatalogLight)((SearchTextField2)ArticlesDetailsPanel.this.productCatalogSearch.getElement()).getNode().getValue();
                    Date startD = ArticlesDetailsPanel.this.searchValidityDate.getStartDate();
                    Date endD = ArticlesDetailsPanel.this.searchValidityDate.getEndDate();
                    boolean ced = ((CheckBox)ArticlesDetailsPanel.this.checkEveryDay.getElement()).isChecked();
                    boolean tender = ((CheckBox)ArticlesDetailsPanel.this.useTender.getElement()).isChecked();
                    List articles = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getArticles(new ProductCatalogReference(productCatalogLight.getId()), new PeriodComplete(startD, endD), ced, tender).getList();
                    for (BasicArticleComplete articleComplete : articles) {
                        if (Boolean.TRUE.equals(articleComplete.getExcludeFromArticlePriceCalculation())) continue;
                        if (articleComplete.getCustomerIsOwner().booleanValue()) {
                            if (!includeOwned) continue;
                            ArticlesDetailsPanel.this.addArticle((BasicArticleLight)articleComplete);
                            continue;
                        }
                        ArticlesDetailsPanel.this.addArticle((BasicArticleLight)articleComplete);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ArticlesDetailsPanel.this.editor.hideCommittingAnimation();
                            ArticlesDetailsPanel.this.editor.setEnabled(true);
                            ((SearchTextField2)ArticlesDetailsPanel.this.productCatalogSearch.getElement()).requestFocusInWindowNow();
                        }

                        public void errorOccurred(ClientException exception) {
                            ArticlesDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.editor.showCommittingAnimation(Words.LOAD_ARTICLES);
            this.editor.setEnabled(false);
            final BasicArticleSearchConfiguration conf = new BasicArticleSearchConfiguration();
            conf.setInUse(Boolean.valueOf(true));
            conf.setExcludeFromArticlePriceCalculation(Boolean.valueOf(false));
            if (this.customerSearch.getElement().isItemSelected()) {
                if (this.customerSearch.getElement().getNode().getValue() != null) {
                    conf.setCustomer((CustomerReference)this.customerSearch.getElement().getNode().getValue());
                }
                if (!this.includeCustomerOwnedArticles.getElement().isChecked()) {
                    conf.setCustomerOwned(Boolean.valueOf(this.includeCustomerOwnedArticles.getElement().isChecked()));
                }
            }
            if (this.supplier.getElement().isItemSelected() && this.supplier.getElement().getNode().getValue() != null) {
                conf.setSupplier((SupplierReference)this.supplier.getElement().getNode().getValue());
            }
            if (this.catBox.isChecked() && this.category != null) {
                conf.setAttribute3Category((ArticleCategoryReference)this.category.getMainCategory());
                conf.setTemperatureCategory((ArticleCategoryReference)this.category.getGroupCategory());
                conf.setOwnershipCategory((ArticleCategoryReference)this.category.getSubGroupCategory());
            }
            if (this.fromToBox.isChecked() && this.fromNo.getElement().getNode().getValue() != null && this.toNo.getElement().getNode().getValue() != null) {
                conf.setFromNO((Integer)this.fromNo.getElement().getNode().getValue());
                conf.setToNO((Integer)this.toNo.getElement().getNode().getValue());
            }
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    Iterator articleSearchIterator = new SearchResultIterator((ASearchConfiguration)conf).iterator();
                    ArrayList list = new ArrayList();
                    while (articleSearchIterator.hasNext()) {
                        list.add(articleSearchIterator.next());
                    }
                    Node node = INodeCreator.getDefaultImpl().createNodes(list, false);
                    return node;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (node != null) {
                                Iterator it = node.getFailSafeChildIterator();
                                while (it.hasNext()) {
                                    Node n = (Node)it.next();
                                    ArticlesDetailsPanel.this.addArticle((BasicArticleLight)n.getValue(BasicArticleLight.class));
                                }
                            }
                            ((SearchTextField2)ArticlesDetailsPanel.this.articleSearch.getElement()).requestFocusInWindowNow();
                            ArticlesDetailsPanel.this.editor.hideCommittingAnimation();
                            ArticlesDetailsPanel.this.editor.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            ArticlesDetailsPanel.this.editor.hideCommittingAnimation();
                            ArticlesDetailsPanel.this.editor.setEnabled(true);
                            ArticlesDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    private void ensureAddStates() {
        boolean addable = this.provider.isAddable(ArticlePriceCalculationComplete_.articles);
        this.add.setEnabled(this.isEnabled() && this.articleSearch.getElement().isItemSelected() && addable);
        boolean searchReady = false;
        if (this.customerSearch.getElement().isItemSelected()) {
            searchReady = true;
        } else if (this.supplier.getElement().isItemSelected()) {
            searchReady = true;
        } else if (this.catBox.isChecked()) {
            searchReady = true;
        } else if (this.fromToBox.isChecked()) {
            searchReady = true;
        } else if (this.productSearch.getElement().isItemSelected()) {
            searchReady = true;
        } else if (this.productCatalogSearch.getElement().isItemSelected()) {
            searchReady = true;
        }
        searchReady = searchReady && this.isDraft;
        this.addAll.setEnabled(searchReady && this.isEnabled() && addable);
        if (this.add.isEnabled()) {
            this.add.requestFocusInWindowNow();
        } else if (this.addAll.isEnabled()) {
            this.addAll.requestFocusInWindowNow();
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.add) {
            this.addOne();
        } else if (source == this.addAll) {
            this.addAll();
        } else if (source == this.clear) {
            this.editor.showCommittingAnimation(Words.CLEAR_ARTICLES);
            this.editor.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    Iterator it = ArticlesDetailsPanel.this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.articles).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        ArticlesDetailsPanel.this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.articles).removeChild(n, System.currentTimeMillis());
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ArticlesDetailsPanel.this.editor.hideCommittingAnimation();
                            ArticlesDetailsPanel.this.editor.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            ArticlesDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.catBox) {
            this.setEnabled(this.isEnabled());
            this.fireFocusCycleChanged(this);
        } else if (source == this.fromToBox) {
            this.setEnabled(this.isEnabled());
            this.fireFocusCycleChanged(this);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        return super.validateParagraph();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean b = isEnabled && this.isDraft;
        boolean addable = this.provider.isAddable(ArticlePriceContractComplete_.articles);
        this.articleSearch.setEnabled(b);
        this.customerSearch.setEnabled(b);
        this.supplier.setEnabled(b);
        this.includeCustomerOwnedArticles.setEnabled(b);
        this.catBox.setEnabled(b);
        this.category.setEnabled(b && this.catBox.isChecked());
        this.fromToBox.setEnabled(b);
        this.fromNo.setEnabled(b && this.fromToBox.isChecked());
        this.toNo.setEnabled(b && this.fromToBox.isChecked());
        this.productCatalogSearch.setEnabled(b);
        this.productSearch.setEnabled(b);
        this.searchValidityDate.setEnabled(b);
        this.checkEveryDay.setEnabled(b);
        this.useTender.setEnabled(b);
        this.clear.setEnabled(b && addable);
        if (isEnabled) {
            this.table.setLocked(this.isDraft);
        } else {
            this.table.setEnabled(isEnabled);
        }
        this.ensureAddStates();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.articleSearch.kill();
        this.articleSearch = null;
        this.customerSearch.kill();
        this.customerSearch = null;
        this.supplier.kill();
        this.supplier = null;
        this.includeCustomerOwnedArticles.kill();
        this.includeCustomerOwnedArticles = null;
        this.catBox.kill();
        this.catBox = null;
        this.category.kill();
        this.category = null;
        this.fromToBox.kill();
        this.fromToBox = null;
        this.fromNo.kill();
        this.fromNo = null;
        this.toNo.kill();
        this.toNo = null;
        this.productCatalogSearch.kill();
        this.productCatalogSearch = null;
        this.productSearch.kill();
        this.productSearch = null;
        this.searchValidityDate.kill();
        this.searchValidityDate = null;
        this.checkEveryDay.kill();
        this.checkEveryDay = null;
        this.useTender.kill();
        this.useTender = null;
        this.add.kill();
        this.add = null;
        this.addAll.kill();
        this.addAll = null;
        this.clear.kill();
        this.clear = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.articleSearch);
        CheckedListAdder.addToList(a, this.customerSearch);
        CheckedListAdder.addToList(a, this.supplier);
        CheckedListAdder.addToList(a, this.includeCustomerOwnedArticles);
        CheckedListAdder.addToList(a, this.catBox);
        CheckedListAdder.addToList(a, this.category);
        CheckedListAdder.addToList(a, this.fromToBox);
        CheckedListAdder.addToList(a, this.fromNo);
        CheckedListAdder.addToList(a, this.toNo);
        CheckedListAdder.addToList(a, this.productSearch);
        CheckedListAdder.addToList(a, this.productCatalogSearch);
        CheckedListAdder.addToList(a, this.searchValidityDate);
        CheckedListAdder.addToList(a, this.checkEveryDay);
        CheckedListAdder.addToList(a, this.useTender);
        CheckedListAdder.addToList(a, this.clear);
        CheckedListAdder.addToList(a, this.add);
        CheckedListAdder.addToList(a, this.addAll);
        return a;
    }

    @Override
    public void setNode(Node<?> node) {
        this.isDraft = node.getChildNamed(ArticlePriceCalculationComplete_.state).getValue() == ArticlePriceModificationStateE.DRAFT;
        this.table.getModel().setNode(node.getChildNamed(ArticlePriceCalculationComplete_.articles));
        super.setNode(node);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layoutTitle(this);
        this.articleSearch.setLocation(this.horizontalBorder, this.verticalBorder);
        this.articleSearch.setSize(150, (int)this.articleSearch.getPreferredSize().getHeight());
        this.customerSearch.setLocation(this.articleSearch.getX() + this.articleSearch.getWidth() + this.horizontalBorder, this.verticalBorder);
        this.customerSearch.setSize(150, (int)this.customerSearch.getPreferredSize().getHeight());
        this.supplier.setLocation(this.customerSearch.getX() + this.customerSearch.getWidth() + this.horizontalBorder, this.verticalBorder);
        this.supplier.setSize(150, (int)this.supplier.getPreferredSize().getHeight());
        this.includeCustomerOwnedArticles.setLocation(this.supplier.getX() + this.supplier.getWidth() + this.horizontalBorder, (int)((double)(this.supplier.getY() + this.supplier.getHeight()) - (this.includeCustomerOwnedArticles.getPreferredSize().getHeight() - 5.0)));
        this.includeCustomerOwnedArticles.setSize(this.includeCustomerOwnedArticles.getPreferredSize());
        this.category.setLocation((int)((double)(this.horizontalBorder + 5) + this.catBox.getPreferredSize().getWidth()), this.articleSearch.getY() + this.articleSearch.getHeight() + this.verticalBorder);
        this.category.setSize(550, (int)this.category.getPreferredSize().getHeight());
        this.catBox.setLocation(this.horizontalBorder, (int)((double)(this.category.getY() + this.category.getHeight()) - (this.catBox.getPreferredSize().getHeight() + 7.0)));
        this.catBox.setSize(this.catBox.getPreferredSize());
        this.fromNo.setLocation((int)((double)(this.horizontalBorder + 5) + this.fromToBox.getPreferredSize().getWidth()), this.category.getY() + this.category.getHeight() + this.verticalBorder);
        this.fromNo.setSize(100, (int)this.fromNo.getPreferredSize().getHeight());
        this.toNo.setLocation(this.fromNo.getX() + this.fromNo.getWidth() + this.horizontalBorder, this.fromNo.getY());
        this.toNo.setSize(this.fromNo.getSize());
        this.fromToBox.setLocation(this.horizontalBorder, (int)((double)(this.fromNo.getY() + this.fromNo.getHeight() - this.fromNo.getElement().getHeight()) + ((double)this.fromNo.getElement().getHeight() - this.fromToBox.getPreferredSize().getHeight()) / 2.0));
        this.fromToBox.setSize(this.fromToBox.getPreferredSize());
        this.productSearch.setLocation(this.horizontalBorder, this.fromNo.getY() + this.fromNo.getHeight() + this.verticalBorder);
        this.productSearch.setSize(150, (int)this.productSearch.getPreferredSize().getHeight());
        this.productCatalogSearch.setLocation(this.productSearch.getX() + this.productSearch.getWidth() + this.horizontalBorder, this.productSearch.getY());
        this.productCatalogSearch.setSize(150, (int)this.productCatalogSearch.getPreferredSize().getHeight());
        this.searchValidityDate.setLocation(this.productCatalogSearch.getX() + this.productCatalogSearch.getWidth() + this.horizontalBorder, this.productCatalogSearch.getY());
        this.searchValidityDate.setSize(this.searchValidityDate.getPreferredSize());
        this.checkEveryDay.setLocation(this.searchValidityDate.getX() + this.searchValidityDate.getWidth() + this.inner_horizontalBorder, (int)((double)(this.searchValidityDate.getY() + this.searchValidityDate.getHeight()) - 2.0 * this.checkEveryDay.getPreferredSize().getHeight()));
        this.checkEveryDay.setSize(this.checkEveryDay.getPreferredSize());
        this.useTender.setLocation(this.searchValidityDate.getX() + this.searchValidityDate.getWidth() + this.inner_horizontalBorder, this.checkEveryDay.getY() + this.checkEveryDay.getHeight());
        this.useTender.setSize(this.useTender.getPreferredSize());
        this.addAll.setLocation((int)((double)parent.getWidth() - ((double)this.horizontalBorder + this.addAll.getPreferredSize().getWidth())), (int)((double)(this.productSearch.getY() + this.productSearch.getHeight()) - this.productSearch.getElement().getPreferredSize().getHeight()));
        this.addAll.setSize(this.addAll.getPreferredSize());
        this.add.setLocation((int)((double)this.addAll.getX() - ((double)this.horizontalBorder + this.add.getPreferredSize().getWidth())), this.addAll.getY());
        this.add.setSize(this.add.getPreferredSize());
        this.clear.setLocation((int)((double)this.add.getX() - (this.clear.getPreferredSize().getWidth() + (double)this.horizontalBorder)), this.add.getY());
        this.clear.setSize(this.clear.getPreferredSize());
        this.table.setLocation(0, this.productSearch.getY() + this.productSearch.getHeight() + this.verticalBorder);
        this.table.setSize(parent.getWidth(), parent.getHeight() - this.table.getY());
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        return new Dimension(0, 400);
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        this.ensureAddStates();
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel no;
        private TextLabel name;
        private TextLabel oldPrice;
        private TextLabel minPrice;
        private TextLabel maxPrice;
        private TextLabel averagePrice;
        private TextLabel weightedAveragePrice;
        private TextLabel numberOfAcceptations;
        private TextLabel totalCosts;
        private TextLabel totalQuantity;
        private InputComboBox newPrice;
        private TextLabel perNewPrice;
        private TextLabel difference;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.no = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.article, BasicArticleLight_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.name = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.article, BasicArticleLight_.name}), ConverterRegistry.getConverter(StringConverter.class));
            this.oldPrice = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ArticlePriceCalculationEntryConverter.class));
            this.minPrice = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ArticleMinPriceCalculatorConverter.class));
            this.maxPrice = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ArticleMaxPriceCalculatorConverter.class));
            this.averagePrice = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ArticleAveragePriceCalculatorConverter.class));
            this.weightedAveragePrice = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ArticleWeightedPriceCalculatorConverter.class));
            this.totalCosts = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ArticleTotalPriceCalculatorConverter.class));
            this.totalQuantity = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ArticleTotalQuantityCalculatorConverter.class));
            this.numberOfAcceptations = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ArticleAccCountCalculatorConverter.class));
            this.newPrice = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.newPrice, PriceComplete_.price}), m.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.newPrice, PriceComplete_.currency}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.perNewPrice = new TextLabel(m.getNode().getChildNamed(ArticlePriceCalculationEntryComplete_.newPriceUnit), ConverterRegistry.getConverter(PerUnitViewConverter.class));
            m.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.newPrice, PriceComplete_.price}).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.newPrice, PriceComplete_.currency}).addNodeListener((NodeListener)this);
            this.difference = new TextLabel("-");
            this.calculatePriceDifference();
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.no);
            this.add(this.name);
            this.add(this.oldPrice);
            this.add(this.minPrice);
            this.add(this.maxPrice);
            this.add(this.averagePrice);
            this.add(this.weightedAveragePrice);
            this.add(this.totalCosts);
            this.add(this.totalQuantity);
            this.add(this.numberOfAcceptations);
            this.add(this.newPrice);
            this.add(this.perNewPrice);
            this.add(this.difference);
            this.add(this.delete);
        }

        private void calculatePriceDifference() {
            BasicArticleLight articleLight = (BasicArticleLight)this.model.getNode().getChildNamed(ArticlePriceCalculationEntryComplete_.article).getValue();
            if (articleLight == null) {
                return;
            }
            double d = (Double)this.model.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.newPrice, PriceComplete_.price}).getValue();
            UnitComplete priceUnit = (UnitComplete)this.model.getNode().getChildNamed(ArticlePriceCalculationEntryComplete_.newPriceUnit).getValue();
            CurrencyComplete currency = (CurrencyComplete)this.model.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.newPrice, PriceComplete_.currency}).getValue();
            boolean useTender = Boolean.TRUE.equals(ArticlesDetailsPanel.this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.tenderPrice).getValue());
            CustomerReference customer = (CustomerReference)ArticlesDetailsPanel.this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.tenderCustomer).getValue();
            ArticlePriceCalculationEntryComplete e = (ArticlePriceCalculationEntryComplete)this.model.getNode().getValue();
            double oldPrice = e.getOldPrice().getPrice();
            UnitComplete storeUnit = articleLight.getPriceUnit();
            CurrencyComplete oldCurrency = e.getOldPrice().getCurrency();
            Date date = (Date)ArticlesDetailsPanel.this.editor.getModel().getNode().getChildNamed(ArticlePriceCalculationComplete_.date).getValue();
            double convertedAmount = UnitConversionToolkit.convertUnit((UnitComplete)priceUnit, (UnitComplete)storeUnit, (double)d, null, (Timestamp)new Timestamp(date.getTime()));
            double diff = convertedAmount - oldPrice;
            PriceComplete newPrice = new PriceComplete(oldCurrency, Double.valueOf(diff));
            this.difference.setText(((PriceConverter1)ConverterRegistry.getConverter(PriceConverter1.class)).convert(newPrice, null, new Object[0]));
            if (newPrice.getPrice() > 0.0) {
                this.difference.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_error_string_color")));
            } else {
                this.difference.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_ok_string_color")));
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> focusList = this.newPrice.getFocusComponents();
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.article, BasicArticleLight_.number}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.article, BasicArticleLight_.name}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.oldPrice, PriceComplete_.price}).getValue();
                }
                case 4: {
                    return this.model.getNode().getChildNamed(new DtoField[]{ArticlePriceCalculationEntryComplete_.newPrice, PriceComplete_.price}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean canEditArticles = ArticlesDetailsPanel.this.provider.isWritable(ArticlePriceCalculationComplete_.articles);
            this.no.setEnabled(isEnabled && canEditArticles);
            this.name.setEnabled(isEnabled && canEditArticles);
            this.oldPrice.setEnabled(isEnabled && canEditArticles);
            this.minPrice.setEnabled(isEnabled && canEditArticles);
            this.maxPrice.setEnabled(isEnabled && canEditArticles);
            this.weightedAveragePrice.setEnabled(isEnabled && canEditArticles);
            this.averagePrice.setEnabled(isEnabled && canEditArticles);
            this.newPrice.setEnabled(isEnabled && canEditArticles);
            this.perNewPrice.setEnabled(isEnabled && canEditArticles);
            this.totalCosts.setEnabled(isEnabled && canEditArticles);
            this.totalQuantity.setEnabled(isEnabled && canEditArticles);
            this.numberOfAcceptations.setEnabled(isEnabled && canEditArticles);
            this.difference.setEnabled(isEnabled && canEditArticles);
            this.delete.setEnabled(isEnabled && canEditArticles);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.no = null;
            this.name.kill();
            this.name = null;
            this.oldPrice.kill();
            this.oldPrice = null;
            this.newPrice.kill();
            this.newPrice = null;
            this.minPrice.kill();
            this.minPrice = null;
            this.maxPrice.kill();
            this.maxPrice = null;
            this.weightedAveragePrice.kill();
            this.weightedAveragePrice = null;
            this.numberOfAcceptations.kill();
            this.numberOfAcceptations = null;
            this.totalCosts.kill();
            this.totalCosts = null;
            this.totalQuantity.kill();
            this.totalQuantity = null;
            this.averagePrice.kill();
            this.averagePrice = null;
            this.perNewPrice.kill();
            this.perNewPrice = null;
            this.difference.kill();
            this.difference = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        public void valueChanged(Node<?> node) {
            this.calculatePriceDifference();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.no.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.no.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.oldPrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.oldPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.oldPrice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.oldPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.minPrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.minPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.minPrice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.minPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.maxPrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.maxPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.maxPrice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.maxPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.averagePrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.averagePrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.averagePrice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.averagePrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.weightedAveragePrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.weightedAveragePrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.weightedAveragePrice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.weightedAveragePrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                TableRowImpl.this.totalCosts.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.totalCosts.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.totalCosts.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.totalCosts.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(8);
                TableRowImpl.this.totalQuantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.totalQuantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.totalQuantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.totalQuantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(9);
                TableRowImpl.this.numberOfAcceptations.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.numberOfAcceptations.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.numberOfAcceptations.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.numberOfAcceptations.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(10);
                TableRowImpl.this.newPrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.newPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.newPrice.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.perNewPrice.getPreferredSize().getWidth())), (int)TableRowImpl.this.newPrice.getPreferredSize().getHeight());
                TableRowImpl.this.perNewPrice.setLocation(TableRowImpl.this.newPrice.getX() + TableRowImpl.this.newPrice.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.perNewPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.perNewPrice.setSize(TableRowImpl.this.perNewPrice.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(11);
                TableRowImpl.this.difference.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.difference.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.difference.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.difference.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(12);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

