/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.aircraft;

import ch.icit.pegasus.client.converter.AircraftTypeConverter;
import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.aircraft.AircraftModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.aircraft.details.GalleyLoadingDetailsPanel;
import ch.icit.pegasus.client.gui.modules.aircraft.details.PaxClassDetailsPanel;
import ch.icit.pegasus.client.gui.modules.aircraft.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.aircraft.details.TemplateDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.AircraftSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AircraftAccess;
import ch.icit.pegasus.server.core.dtos.search.AircraftSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.TrolleyScanSettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class AircraftModule
extends ScreenTableView<AircraftLight, AircraftSearchConfiguration.AIRCRAFT_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_CUSTOMER = "customer_filter";
    private static final String FILTER_MATRICULATION = "matriculation_filter";
    private String searchCriteria1 = null;
    private CustomerLight searchCriteria2 = null;
    private Boolean searchCriteria3 = null;

    public AircraftModule() {
        super(AircraftLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return AircraftAccess.MODULE_AIRCRAFT;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", AircraftSearchConfiguration.AIRCRAFT_COLUMN.MATRICULATION.toString() + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.setSearchTextField2Width(200);
        this.filterChain.addSearchField(FILTER_MATRICULATION, Words.MATRICULATION_OR_NUMER, "");
        this.filterChain.addCustomerSearchField(FILTER_CUSTOMER);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<AircraftLight, AircraftSearchConfiguration.AIRCRAFT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean emptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
            this.searchCriteria2 = null;
        } else if (name == FILTER_MATRICULATION) {
            this.searchCriteria1 = (String)value;
        } else if (name == FILTER_CUSTOMER) {
            this.searchCriteria2 = value instanceof CustomerLight ? (CustomerLight)value : null;
        }
        AircraftSearchConfiguration c = new AircraftSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setCustomer(this.searchCriteria2);
        c.setIsDeleted(this.searchCriteria3);
        try {
            int no = Integer.valueOf(this.searchCriteria1);
            c.setNumber(Integer.valueOf(no));
        }
        catch (NumberFormatException e) {
            c.setDescriptionOrMatriculation(this.searchCriteria1);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    protected RowEditorFactory<AircraftLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<AircraftLight> rowEditor = new MessageProvidedRowEditor<AircraftLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel details1 = new SpecificationDetailsPanel((RowEditor<AircraftLight>)rowEditor, p);
            PaxClassDetailsPanel details2 = new PaxClassDetailsPanel((RowEditor<AircraftLight>)rowEditor, p);
            TrolleyScanSettingsComplete trolleyScan = (TrolleyScanSettingsComplete)NodeToolkit.getAffixClass(TrolleyScanSettingsComplete.class).getValue();
            GalleyLoadingDetailsPanel loadingDetailsPanel = null;
            if (rowEditor.getModel().isAddRow()) {
                TemplateDetailsPanel p1 = new TemplateDetailsPanel((RowEditor<AircraftLight>)rowEditor, p);
                rowEditor.add(p1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
                c1.add((Component)details1, new TableLayoutConstraint(0, 0, 0.0, 1.0));
                c1.add((Component)details2, new TableLayoutConstraint(1, 0, 1.0, 1.0));
                rowEditor.add(c1, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.addToFocusQueue(p1);
            } else if (Boolean.TRUE.equals(trolleyScan.getUseTrolleyScan())) {
                loadingDetailsPanel = new GalleyLoadingDetailsPanel((RowEditor<AircraftLight>)rowEditor, p);
                rowEditor.add(details1, (Object)new TableLayoutConstraint(0, 0, 0.0, 1.0));
                rowEditor.add(details2, (Object)new TableLayoutConstraint(1, 0, 0.5, 1.0));
                rowEditor.add(loadingDetailsPanel, (Object)new TableLayoutConstraint(2, 0, 0.5, 1.0));
            } else {
                rowEditor.add(details1, (Object)new TableLayoutConstraint(0, 0, 0.0, 1.0));
                rowEditor.add(details2, (Object)new TableLayoutConstraint(1, 0, 1.0, 1.0));
            }
            rowEditor.addToFocusQueue(details1);
            rowEditor.addToFocusQueue(details2);
            if (loadingDetailsPanel != null) {
                rowEditor.addToFocusQueue(loadingDetailsPanel);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new AircraftModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)AircraftSearchConfiguration.AIRCRAFT_COLUMN.NUMBER, AircraftLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        columns.add(new TableColumnInfo(Words.DESCRIPTION, "", (Class)StringConverter.class, (Enum<?>)AircraftSearchConfiguration.AIRCRAFT_COLUMN.DESCRIPTION, AircraftLight_.description, 120, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.MATRICULATION_NUMBER, "", (Class)StringConverter.class, (Enum<?>)AircraftSearchConfiguration.AIRCRAFT_COLUMN.MATRICULATION, AircraftLight_.matriculation, 100, Integer.MAX_VALUE, 100));
        columns.add(new TableColumnInfo(Words.AIRCRAFT_TYPE, "", (Class)AircraftTypeConverter.class, (Enum<?>)AircraftSearchConfiguration.AIRCRAFT_COLUMN.TYPE_CODE, AircraftLight_.type, 100, Integer.MAX_VALUE, 100));
        columns.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)AircraftSearchConfiguration.AIRCRAFT_COLUMN.CUSTOMER, AircraftLight_.customer, 80, 80, 80));
        return columns;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<AircraftLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(AircraftSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<AircraftLight> model) {
        return model != null && model.getDTO(AircraftLight.class) != null;
    }
}

