/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.changelog;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.html.HTMLFontAndColor;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class ChangeLogViewer
extends BorderedInletPanel {
    private static final long serialVersionUID = -1034467786705786933L;
    private ScrollPane scrollPane;
    private JEditorPane editorPane = new JEditorPane();

    public ChangeLogViewer(URL url) {
        super(false, false);
        HTMLEditorKit kit = new HTMLEditorKit();
        this.editorPane.setEditorKit(kit);
        this.editorPane.setOpaque(false);
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        try {
            this.editorPane.setPage(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Color foregroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        Font font = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color titleColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground"));
        StyleSheet styleSheet = kit.getStyleSheet();
        styleSheet.addRule("body {" + HTMLFontAndColor.getCSSFontAndColorString(foregroundColor, font) + "}");
        styleSheet.addRule("change {color:#00FFEB;  }");
        styleSheet.addRule("bugfix {color:#FF6E70;  }");
        styleSheet.addRule("feature {color:#00FF04; }");
        styleSheet.addRule("basic {color:#e3ff00; }");
        styleSheet.addRule("milestone { color: #337ab7 }");
        styleSheet.addRule("task { color: #337ab7 }");
        styleSheet.addRule("a {text-decoration: underline; color:" + HTMLFontAndColor.getCssColorString(foregroundColor) + "}");
        styleSheet.addRule("version { margin-left: 14px;");
        styleSheet.addRule("category { font-weight: bold; margin-left: 20px;");
        styleSheet.addRule("ul {list-style-type: circle;}");
        styleSheet.addRule("h1 {padding-top: 0px; margin-top: 0px;}");
        styleSheet.addRule("h1, version, h2, h3, h4 {color:" + HTMLFontAndColor.getCssColorString(titleColor) + "};");
        this.scrollPane = new ScrollPane(this.editorPane);
        this.scrollPane.installDefaultColor();
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    private void openLink(HyperlinkEvent e) throws URISyntaxException, IOException {
        Desktop.getDesktop().browse(e.getURL().toURI());
    }
}

