/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.batch.impl;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.BatchWorkStateE;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import java.util.List;

public class OpenAllFlightsBatch
extends BatchJob<FlightSearchConfiguration> {
    private static final long serialVersionUID = 1L;
    private Node<List<ScreenValidationObject>> errorsNode;

    public OpenAllFlightsBatch(ThreadSafeExecutable job, Node<FlightSearchConfiguration> node, Node<List<ScreenValidationObject>> rets) {
        super(DefaultSkins.FlightIcon, job, node);
    }

    @Override
    public void jobDone(Node<?> node) {
        this.errorsNode = node;
        List l = (List)node.getValue();
        if (l.isEmpty()) {
            this.stateChange(BatchWorkStateE.DONE);
        } else {
            this.stateChange(BatchWorkStateE.ERROR);
        }
    }

    @Override
    public boolean isModal() {
        return true;
    }

    @Override
    public String getErrorText() {
        if (this.errorsNode != null) {
            List l = (List)this.errorsNode.getValue();
            String t = "Unable to open all Flights";
            for (ScreenValidationObject o : l) {
                t = t + "\n- " + o.getMessage();
            }
            return t;
        }
        return "Unable to open all Flights";
    }

    @Override
    public String getLoadingText() {
        return "Opening all Flights";
    }

    @Override
    public String getSuccessText() {
        return "All Flights opened";
    }
}

