/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.batch;

import ch.icit.pegasus.client.gui.batch.BatchJobListener;
import ch.icit.pegasus.client.gui.batch.BatchList;
import ch.icit.pegasus.client.gui.batch.BatchWorkStateE;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.SkinButton_NEW;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.AsynchronLoaderAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public abstract class BatchJob<T>
extends SkinButton_NEW
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TextLabel label;
    private ThreadSafeExecutable job;
    private List<BatchJobListener<T>> batchJobListeners = new ArrayList<BatchJobListener<T>>();
    protected Node<T> node;
    protected List<ScreenValidationObject> errors = new ArrayList<ScreenValidationObject>();
    private BatchWorkStateE workStateE;
    private BatchList<T, ?> batchList;
    private AsynchronLoaderAnimation loaderAnimation;
    private Timer scheduleTime;
    private DeleteButton deleteButton;

    public BatchJob(DefaultSkins clazz, ThreadSafeExecutable job, Node<T> node) {
        super(clazz, false);
        this.node = node;
        this.label = new TextLabel();
        this.job = job;
        this.border = 3;
        this.stateChange(BatchWorkStateE.WAITING);
        this.addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.label);
    }

    private void removeScheduled() {
        this.scheduleTime = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchJob.this.scheduleTime.stop();
                BatchJob.this.scheduleTime = null;
                BatchJob.this.batchList.removeBatch(BatchJob.this);
            }
        });
        this.scheduleTime.start();
    }

    public BatchWorkStateE getJobState() {
        return this.workStateE;
    }

    public Node<T> getNode() {
        return this.node;
    }

    public boolean isModal() {
        return false;
    }

    public List<ScreenValidationObject> getErrors() {
        return this.errors;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this) {
            InnerPopupFactory.showBatchJobInfo(x, y, this, null, this);
        } else if (source == this.deleteButton) {
            this.batchList.removeBatch(this);
        }
    }

    private void startAnimation() {
        if (this.deleteButton != null) {
            this.deleteButton.kill();
            this.deleteButton = null;
        }
        if (this.loaderAnimation == null) {
            this.loaderAnimation = new AsynchronLoaderAnimation();
            this.loaderAnimation.setProgress(0.0f);
            this.add((Component)this.loaderAnimation, 0);
            this.invalidate();
            this.validate();
        }
        this.loaderAnimation.startAnimation();
    }

    private void stopAnimation() {
        if (this.loaderAnimation != null) {
            this.loaderAnimation.stopAnimation();
            this.loaderAnimation.fadeOut(true);
            this.loaderAnimation = null;
        }
        if (this.deleteButton == null) {
            this.deleteButton = new DeleteButton();
            this.deleteButton.setProgress(0.0f);
            this.deleteButton.addButtonListener(this);
            this.add(this.deleteButton);
            this.deleteButton.fadeIn();
            this.invalidate();
            this.validate();
        }
    }

    public void setBatchList(BatchList<T, ?> batchList) {
        this.batchList = batchList;
    }

    public abstract String getErrorText();

    public abstract String getLoadingText();

    public abstract String getSuccessText();

    public String getWaitingText() {
        return "Waiting";
    }

    protected final void stateChange(BatchWorkStateE s) {
        this.workStateE = s;
        switch (s) {
            case DONE: {
                this.stopAnimation();
                this.label.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_ok_string_color")));
                this.label.setText(this.getSuccessText());
                this.removeScheduled();
                break;
            }
            case ERROR: {
                this.stopAnimation();
                this.label.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_error_string_color")));
                this.label.setText(this.getErrorText());
                break;
            }
            case LOADING: {
                this.startAnimation();
                this.label.setText(this.getLoadingText());
                break;
            }
            case WAITING: {
                this.stopAnimation();
                this.label.setText("Waiting");
                break;
            }
        }
        this.fireBatchStateChanged(this.node);
        this.repaint();
    }

    public void jobDone(Node<?> node) {
        this.stateChange(BatchWorkStateE.DONE);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
        this.job = null;
        if (this.batchList != null) {
            this.batchList.removeBatch(this);
        }
    }

    public void startJob() {
        this.stateChange(BatchWorkStateE.LOADING);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return BatchJob.this.job.loadData();
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        BatchJob.this.jobDone(node);
                    }

                    public void errorOccurred(ClientException exception) {
                        BatchJob.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.runInBackground(run);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.getSkin() != null) {
            ((Skin1Field)this.getSkin()).paint(g2, this.border, this.border, this.getState());
        }
        this.paintChildren(g2);
    }

    public void addBatchJobListener(BatchJobListener<T> job) {
        this.batchJobListeners.add(job);
    }

    public void removeBatchJobListener(BatchJobListener<T> job) {
        this.batchJobListeners.remove(job);
    }

    protected void fireBatchStateChanged(Node<T> node) {
        for (BatchJobListener<T> b : this.batchJobListeners) {
            b.batchStateChanged(this, node);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int offset = 0;
            if (BatchJob.this.loaderAnimation != null) {
                offset = (int)((double)offset + ((double)BatchJob.this.border + BatchJob.this.loaderAnimation.getPreferredSize().getWidth() + (double)BatchJob.this.border));
                BatchJob.this.loaderAnimation.setLocation(parent.getWidth() - offset + BatchJob.this.border, (int)(((double)parent.getHeight() - BatchJob.this.loaderAnimation.getPreferredSize().getHeight()) / 2.0));
                BatchJob.this.loaderAnimation.setSize(BatchJob.this.loaderAnimation.getPreferredSize());
            }
            if (BatchJob.this.deleteButton != null) {
                int t = (int)((double)BatchJob.this.border + BatchJob.this.deleteButton.getPreferredSize().getWidth() + (double)BatchJob.this.border);
                if (t > offset) {
                    offset = t;
                }
                BatchJob.this.deleteButton.setLocation(parent.getWidth() - offset + BatchJob.this.border, (int)(((double)parent.getHeight() - BatchJob.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                BatchJob.this.deleteButton.setSize(BatchJob.this.deleteButton.getPreferredSize());
            }
            BatchJob.this.label.setLocation(BatchJob.this.border + ((Skin1Field)BatchJob.this.getSkin()).getImage(Button.ButtonState.UP).getWidth() + BatchJob.this.border, (int)(((double)parent.getHeight() - BatchJob.this.label.getPreferredSize().getHeight()) / 2.0));
            BatchJob.this.label.setSize(parent.getWidth() - (BatchJob.this.label.getX() + BatchJob.this.border + offset), (int)BatchJob.this.label.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(BatchJob.this.border + ((Skin1Field)BatchJob.this.getSkin()).getImage(Button.ButtonState.UP).getWidth() + BatchJob.this.border + 25 + BatchJob.this.border, 25);
        }
    }
}

