/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits.copy;

import ch.icit.pegasus.client.comparators.CateringServicePartComparator;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.StepComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentInsertTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartChoiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceSubstitutionComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.DayOfMonthRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.DayOfMonthRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixDurationRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixPeriodRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupFillUpProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MonthRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MonthRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.PeriodRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.RotationDurationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.RotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.WeekdayRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.WeekdayRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MealPlanCopyToolkit {
    public static CateringServiceScheduleComplete copyService(CateringServiceScheduleComplete source, CateringServiceScheduleVariantComplete variant) {
        CateringServiceScheduleComplete destination = new CateringServiceScheduleComplete();
        Map<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> loadingGroupMapping = MealPlanCopyToolkit.copyLoadingGroups(source, destination);
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setCabinClass(source.getCabinClass());
        destination.setType(source.getType());
        destination.setPeriod(new PeriodComplete(variant.getValidityPeriod()));
        destination.setEligibleLocations(source.getEligibleLocations());
        CateringServiceScheduleVariantComplete v = MealPlanCopyToolkit.copyVariant(source, variant, destination, loadingGroupMapping);
        destination.setCurrentVariant(v);
        destination.getVariants().add(v);
        return destination;
    }

    private static Map<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> copyLoadingGroups(CateringServiceScheduleComplete source, CateringServiceScheduleComplete destination) {
        HashMap<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> mapping = new HashMap<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete>();
        for (LoadingGroupTemplateComplete loadingGroupTemplateComplete : source.getLoadingGroups()) {
            LoadingGroupTemplateComplete ng = new LoadingGroupTemplateComplete();
            ng.setClientOId(Long.valueOf(ADTO.getNextId()));
            ng.setCheckerGroupId(loadingGroupTemplateComplete.getCheckerGroupId());
            ng.setContainingService(destination);
            ng.setDeliverAlaCarte(loadingGroupTemplateComplete.getDeliverAlaCarte());
            ng.setDeliverForAlaCartePax(loadingGroupTemplateComplete.getDeliverForAlaCartePax());
            ng.setDeliverForRegularPax(loadingGroupTemplateComplete.getDeliverForRegularPax());
            ng.setDeliverForSpmlPax(loadingGroupTemplateComplete.getDeliverForSpmlPax());
            ng.setDeliverSpml(loadingGroupTemplateComplete.getDeliverSpml());
            ng.setFillUpProducts(MealPlanCopyToolkit.copyFillUpProducts(loadingGroupTemplateComplete.getFillUpProducts()));
            ng.setFixStowedChoice(loadingGroupTemplateComplete.getFixStowedChoice());
            ng.setInsertType(loadingGroupTemplateComplete.getInsertType());
            ng.setKeepSPMLSpaceFree(loadingGroupTemplateComplete.getKeepSPMLSpaceFree());
            ng.setMealType(loadingGroupTemplateComplete.getMealType());
            ng.setName(loadingGroupTemplateComplete.getName());
            ng.setUseMealTypeSPMLStowage(loadingGroupTemplateComplete.getUseMealTypeSPMLStowage());
            ng.setUseSPMLStowageAsFillUp(loadingGroupTemplateComplete.getUseSPMLStowageAsFillUp());
            ng.setGroupSPML(loadingGroupTemplateComplete.getGroupSPML());
            mapping.put(loadingGroupTemplateComplete, ng);
        }
        return mapping;
    }

    private static List<LoadingGroupFillUpProductVariantComplete> copyFillUpProducts(List<LoadingGroupFillUpProductVariantComplete> fillUpProducts) {
        ArrayList<LoadingGroupFillUpProductVariantComplete> retlist = new ArrayList<LoadingGroupFillUpProductVariantComplete>();
        for (LoadingGroupFillUpProductVariantComplete fillUpProduct : fillUpProducts) {
            LoadingGroupFillUpProductVariantComplete g = new LoadingGroupFillUpProductVariantComplete();
            g.setFillUpProduct(fillUpProduct.getFillUpProduct());
            g.setValidityDate(fillUpProduct.getValidityDate());
            retlist.add(g);
        }
        return retlist;
    }

    public static CateringServiceScheduleVariantComplete copyVariant(CateringServiceScheduleComplete source, CateringServiceScheduleVariantComplete sourceVariant, CateringServiceScheduleComplete copiedSchedule, Map<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> loadingGroupMapping) {
        CateringServiceScheduleVariantComplete nVariant = new CateringServiceScheduleVariantComplete();
        nVariant.setClientOId(Long.valueOf(ADTO.getNextId()));
        nVariant.setValidityPeriod(new PeriodComplete(sourceVariant.getValidityPeriod()));
        Map<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> groupMapping = loadingGroupMapping;
        if (groupMapping == null) {
            groupMapping = new Hashtable<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete>();
            for (LoadingGroupTemplateComplete group : source.getLoadingGroups()) {
                LoadingGroupTemplateComplete g = new LoadingGroupTemplateComplete();
                g.setClientOId(Long.valueOf(ADTO.getNextId()));
                g.setInsertType(group.getInsertType());
                g.setName(group.getName());
                g.setContainingService(copiedSchedule);
                groupMapping.put(group, group);
            }
        }
        ArrayList<LoadingGroupTemplateComplete> g = new ArrayList<LoadingGroupTemplateComplete>();
        g.addAll(groupMapping.values());
        copiedSchedule.setLoadingGroups(g);
        Hashtable<Long, CateringServiceRotationComplete> rotationMapping = new Hashtable<Long, CateringServiceRotationComplete>();
        nVariant.setRotations(MealPlanCopyToolkit.copyRotations(sourceVariant, groupMapping, rotationMapping));
        nVariant.setRotationStrategy(MealPlanCopyToolkit.copyRotationStrategy(sourceVariant, rotationMapping));
        nVariant.setSubstitutions(MealPlanCopyToolkit.copySubstitutions(sourceVariant, groupMapping));
        nVariant.setAlaCarteCatalog(sourceVariant.getAlaCarteCatalog());
        nVariant.setSpmlCatalog(sourceVariant.getSpmlCatalog());
        for (MealTypeConfigurationComplete mc : sourceVariant.getMealTypeConfigs()) {
            MealTypeConfigurationComplete nmc = new MealTypeConfigurationComplete();
            nmc.setClientOId(Long.valueOf(ADTO.getNextId()));
            nmc.setAlaCarteMode(mc.getAlaCarteMode());
            nmc.setAlaCarteTypes(mc.getAlaCarteTypes());
            nmc.setMealType(mc.getMealType());
            nmc.setNormalizeRatioAmounts(mc.getNormalizeRatioAmounts());
            nmc.setRoundingStrategy(mc.getRoundingStrategy());
            nmc.setSpmlMode(mc.getSpmlMode());
            nmc.setSpmlTypes(mc.getSpmlTypes());
            nVariant.getMealTypeConfigs().add(nmc);
        }
        return nVariant;
    }

    private static List<CateringServiceSubstitutionComplete> copySubstitutions(CateringServiceScheduleVariantComplete source, Map<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> loading2loadingMapper) {
        ArrayList<CateringServiceSubstitutionComplete> nc = new ArrayList<CateringServiceSubstitutionComplete>();
        for (CateringServiceSubstitutionComplete oc : source.getSubstitutions()) {
            CateringServiceSubstitutionComplete ncc = MealPlanCopyToolkit.copySubstitution(oc, loading2loadingMapper);
            nc.add(ncc);
        }
        return nc;
    }

    private static CateringServiceSubstitutionComplete copySubstitution(CateringServiceSubstitutionComplete source, Map<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> loading2loadingMapper) {
        CateringServiceSubstitutionComplete nc = new CateringServiceSubstitutionComplete();
        nc.setClientOId(Long.valueOf(ADTO.getNextId()));
        nc.setNumber(source.getNumber());
        nc.setParts(MealPlanCopyToolkit.copyParts(source.getParts(), loading2loadingMapper));
        nc.setPeriod(MealPlanCopyToolkit.copyPeriod(source.getPeriod()));
        nc.setAdditional(source.getAdditional());
        return nc;
    }

    private static PeriodComplete copyPeriod(PeriodComplete source) {
        PeriodComplete np = new PeriodComplete();
        np.setClientOId(Long.valueOf(np.getNextId()));
        np.setEndDate(source.getEndDate());
        np.setStartDate(source.getStartDate());
        return np;
    }

    private static List<CateringServiceRotationComplete> copyRotations(CateringServiceScheduleVariantComplete source, Map<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> loading2loadingMapper, Map<Long, CateringServiceRotationComplete> rotation2rotationMap) {
        ArrayList<CateringServiceRotationComplete> nr = new ArrayList<CateringServiceRotationComplete>();
        for (CateringServiceRotationComplete rot : source.getRotations()) {
            CateringServiceRotationComplete nRot = MealPlanCopyToolkit.copyRotation(rot, loading2loadingMapper, rotation2rotationMap);
            if (nRot == null) continue;
            nr.add(nRot);
        }
        return nr;
    }

    private static CateringServiceRotationComplete copyRotation(CateringServiceRotationComplete source, Map<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> loading2loadingMapper, Map<Long, CateringServiceRotationComplete> rotation2rotationMap) {
        CateringServiceRotationComplete nRot = new CateringServiceRotationComplete();
        nRot.setNumber(source.getNumber());
        nRot.setClientOId(Long.valueOf(ADTO.getNextId()));
        nRot.setRotationStrategy(MealPlanCopyToolkit.copyRotationDuration(source.getRotationStrategy()));
        nRot.setParts(MealPlanCopyToolkit.copyParts(source.getParts(), loading2loadingMapper));
        if (rotation2rotationMap != null) {
            rotation2rotationMap.put(source.getId(), nRot);
        }
        return nRot;
    }

    public static CateringServiceRotationComplete copyRotation(CateringServiceRotationComplete source, Node<CateringServiceScheduleComplete> currentService, Node<CateringServiceScheduleVariantComplete> currentVariant) {
        Collections.sort(source.getParts(), ComparatorRegistry.getComparator(CateringServicePartComparator.class));
        CateringServiceRotationComplete nRot = new CateringServiceRotationComplete();
        nRot.setClientOId(Long.valueOf(ADTO.getNextId()));
        nRot.setRotationStrategy(MealPlanCopyToolkit.copyRotationDuration(source.getRotationStrategy(), currentVariant));
        nRot.setParts(MealPlanCopyToolkit.copyParts(source.getParts(), currentService.getChildNamed(CateringServiceScheduleComplete_.loadingGroups), currentVariant.getChildNamed(CateringServiceScheduleVariantComplete_.rotations)));
        Iterator it = currentService.getChildNamed(CateringServiceScheduleComplete_.loadingGroups).getChilds();
        while (it.hasNext()) {
            Node p = (Node)it.next();
            boolean found = false;
            for (CateringServicePartComplete part : nRot.getParts()) {
                if (!part.getLoadingGroup().getName().equals(p.getChildNamed(LoadingGroupTemplateComplete_.name).getValue())) continue;
                found = true;
            }
            if (found) continue;
            CateringServicePartComplete npart = new CateringServicePartComplete();
            npart.setClientOId(Long.valueOf(ADTO.getNextId()));
            npart.setNumber(Integer.valueOf(nRot.getParts().size() + 1));
            npart.setLoadingGroup((ALoadingGroupComplete)p.getValue());
            if (npart.getLoadingGroup().getName() == null) {
                npart.getLoadingGroup().setName((String)p.getChildNamed(LoadingGroupTemplateComplete_.name).getValue());
            }
            if (npart.getLoadingGroup().getInsertType() == null) {
                npart.getLoadingGroup().setInsertType((GalleyEquipmentInsertTypeComplete)p.getChildNamed(LoadingGroupTemplateComplete_.insertType).getValue());
            }
            nRot.getParts().add(npart);
        }
        return nRot;
    }

    private static List<CateringServicePartComplete> copyParts(List<CateringServicePartComplete> source, Node currentLoadingGroups, Node currentRotations) {
        ArrayList<CateringServicePartComplete> n = new ArrayList<CateringServicePartComplete>();
        for (CateringServicePartComplete part : source) {
            CateringServicePartComplete np = MealPlanCopyToolkit.copyPart(part, currentLoadingGroups, currentRotations);
            if (np == null) continue;
            n.add(np);
        }
        return n;
    }

    private static List<CateringServicePartComplete> copyParts(List<CateringServicePartComplete> source, Map<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> loading2loadingMapper) {
        ArrayList<CateringServicePartComplete> n = new ArrayList<CateringServicePartComplete>();
        for (CateringServicePartComplete part : source) {
            CateringServicePartComplete np = MealPlanCopyToolkit.copyPart(part, loading2loadingMapper);
            if (np == null) continue;
            n.add(np);
        }
        return n;
    }

    public static CateringServicePartComplete copyPart(CateringServicePartComplete source, Node currentLoadingGroups, Node currentRotations) {
        CateringServicePartComplete n = new CateringServicePartComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        n.setNumber(source.getNumber());
        ALoadingGroupComplete nGroup = null;
        Iterator it = currentLoadingGroups.getChilds();
        int c = 1;
        while (it.hasNext()) {
            Node lg = (Node)it.next();
            ALoadingGroupComplete lgc = (ALoadingGroupComplete)lg.getValue(ALoadingGroupComplete.class);
            if (((String)lg.getChildNamed(LoadingGroupTemplateComplete_.name).getValue()).equals(source.getLoadingGroup().getName())) {
                if (lgc.getName() == null) {
                    lgc.setName((String)lg.getChildNamed(LoadingGroupTemplateComplete_.name).getValue());
                }
                if (lgc.getInsertType() == null) {
                    lgc.setInsertType((GalleyEquipmentInsertTypeComplete)lg.getChildNamed(LoadingGroupTemplateComplete_.insertType).getValue());
                }
                n.setNumber(Integer.valueOf(c));
                nGroup = lgc;
            }
            ++c;
        }
        if (nGroup != null) {
            n.setLoadingGroup(nGroup);
        } else {
            LoadingGroupTemplateComplete lgc = new LoadingGroupTemplateComplete();
            lgc.setClientOId(Long.valueOf(ADTO.getNextId()));
            lgc.setInsertType(source.getLoadingGroup().getInsertType());
            lgc.setName(source.getLoadingGroup().getName());
            n.setLoadingGroup((ALoadingGroupComplete)lgc);
            n.setNumber(Integer.valueOf(currentLoadingGroups.getChildCount() + 1));
            Node nlgc = INodeCreator.getDefaultImpl().getNode4DTO((Object)lgc, true, false);
            currentLoadingGroups.addChild(nlgc, System.currentTimeMillis());
            it = currentRotations.getChilds();
            while (it.hasNext()) {
                Node rot = (Node)it.next();
                CateringServicePartComplete p = new CateringServicePartComplete();
                p.setClientOId(Long.valueOf(ADTO.getNextId()));
                p.setNumber(Integer.valueOf(currentLoadingGroups.getChildCount() - 1));
                p.setLoadingGroup((ALoadingGroupComplete)lgc);
                Node np = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, false);
                rot.getChildNamed(new String[]{"parts"}).addChild(np, System.currentTimeMillis());
            }
        }
        n.setChoices(MealPlanCopyToolkit.copyChoices(source));
        return n;
    }

    public static Node copyPart2(CateringServicePartComplete source, List<CateringServiceRotationComplete> sourceRotations, Node currentLoadingGroups, Node currentRotations) {
        LoadingGroupTemplateComplete nGroup = null;
        nGroup = new LoadingGroupTemplateComplete();
        nGroup.setClientOId(Long.valueOf(ADTO.getNextId()));
        nGroup.setInsertType(source.getLoadingGroup().getInsertType());
        nGroup.setName(source.getLoadingGroup().getName());
        Node nlgc = INodeCreator.getDefaultImpl().getNode4DTO((Object)nGroup, true, false);
        currentLoadingGroups.addChild(nlgc, System.currentTimeMillis());
        Node lastPart = null;
        Iterator it = currentRotations.getChilds();
        while (it.hasNext()) {
            Node np;
            CateringServicePartComplete pofRot;
            Node rot = (Node)it.next();
            CateringServicePartComplete p = new CateringServicePartComplete();
            p.setClientOId(Long.valueOf(ADTO.getNextId()));
            p.setNumber(Integer.valueOf(currentLoadingGroups.getChildCount() - 1));
            p.setLoadingGroup((ALoadingGroupComplete)nGroup);
            int j = (Integer)rot.getChildNamed(new String[]{"number"}).getValue();
            CateringServiceRotationComplete oRot = MealPlanCopyToolkit.getRotation(sourceRotations, j);
            if (oRot != null && (pofRot = MealPlanCopyToolkit.getPartForOld(oRot.getParts(), source)) != null) {
                p.setChoices(MealPlanCopyToolkit.copyChoices(pofRot));
            }
            lastPart = np = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, false);
            rot.getChildNamed(new String[]{"parts"}).addChild(np, System.currentTimeMillis());
        }
        return lastPart;
    }

    private static CateringServiceRotationComplete getRotation(List<CateringServiceRotationComplete> rots, int i) {
        for (CateringServiceRotationComplete rot : rots) {
            if (rot.getNumber() != i) continue;
            return rot;
        }
        return null;
    }

    private static CateringServicePartComplete getPartForOld(List<CateringServicePartComplete> oldList, CateringServicePartComplete toCopy) {
        for (CateringServicePartComplete p : oldList) {
            if (!p.getNumber().equals(toCopy.getNumber()) || !p.getLoadingGroup().getName().equals(toCopy.getLoadingGroup().getName())) continue;
            return p;
        }
        return null;
    }

    private static CateringServicePartComplete copyPart(CateringServicePartComplete source, Map<LoadingGroupTemplateComplete, LoadingGroupTemplateComplete> loading2loadingMapper) {
        CateringServicePartComplete n = new CateringServicePartComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        n.setNumber(source.getNumber());
        LoadingGroupTemplateComplete c = loading2loadingMapper.get(source.getLoadingGroup());
        if (c == null) {
            c = new LoadingGroupTemplateComplete();
            c.setClientOId(Long.valueOf(ADTO.getNextId()));
            c.setInsertType(source.getLoadingGroup().getInsertType());
            c.setName(source.getLoadingGroup().getName());
            loading2loadingMapper.put((LoadingGroupTemplateComplete)source.getLoadingGroup(), c);
        }
        n.setLoadingGroup((ALoadingGroupComplete)c);
        n.setChoices(MealPlanCopyToolkit.copyChoices(source));
        return n;
    }

    private static List<CateringServicePartChoiceComplete> copyChoices(CateringServicePartComplete source) {
        ArrayList<CateringServicePartChoiceComplete> nc = new ArrayList<CateringServicePartChoiceComplete>();
        for (CateringServicePartChoiceComplete oc : source.getChoices()) {
            CateringServicePartChoiceComplete ncc = MealPlanCopyToolkit.copyChoice(oc);
            if (ncc == null) continue;
            nc.add(ncc);
        }
        return nc;
    }

    public static CateringServicePartChoiceComplete copyChoice(CateringServicePartChoiceComplete source) {
        CateringServicePartChoiceComplete nc = new CateringServicePartChoiceComplete();
        nc.setClientOId(Long.valueOf(ADTO.getNextId()));
        nc.setNumber(source.getNumber());
        nc.setProduct(source.getProduct());
        nc.setRatio(source.getRatio());
        nc.setCalculationType(source.getCalculationType());
        nc.setFixAmount(source.getFixAmount());
        nc.setIgnoreOnInvoice(source.getIgnoreOnInvoice());
        nc.setSteps(MealPlanCopyToolkit.copySteps(source.getSteps()));
        nc.setIgnoreOnDeliverySlip(source.getIgnoreOnDeliverySlip());
        nc.setIgnoreOnInvoice(source.getIgnoreOnInvoice());
        nc.setRoundingStrategy(source.getRoundingStrategy());
        nc.setShowAsStandard(source.getShowAsStandard());
        return nc;
    }

    private static List<StepComplete> copySteps(List<StepComplete> steps) {
        ArrayList<StepComplete> nc = new ArrayList<StepComplete>();
        for (StepComplete oc : steps) {
            StepComplete ncc = MealPlanCopyToolkit.copyStep(oc);
            if (ncc == null) continue;
            nc.add(ncc);
        }
        return nc;
    }

    private static StepComplete copyStep(StepComplete oc) {
        StepComplete ns = new StepComplete();
        ns.setClientOId(Long.valueOf(ADTO.getNextId()));
        ns.setQuantity(oc.getQuantity());
        ns.setUpperLimit(oc.getUpperLimit());
        return ns;
    }

    private static RotationDurationComplete copyRotationDuration(RotationDurationComplete source) {
        if (source instanceof DayOfMonthRotationComplete) {
            DayOfMonthRotationComplete o = (DayOfMonthRotationComplete)source;
            DayOfMonthRotationComplete n = new DayOfMonthRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setUseEvenMonths(((DayOfMonthRotationComplete)source).getUseEvenMonths());
            n.setUseOddMonths(((DayOfMonthRotationComplete)source).getUseOddMonths());
            n.setDay1(o.getDay1());
            n.setDay2(o.getDay2());
            n.setDay3(o.getDay3());
            n.setDay4(o.getDay4());
            n.setDay5(o.getDay5());
            n.setDay6(o.getDay6());
            n.setDay7(o.getDay7());
            n.setDay8(o.getDay8());
            n.setDay9(o.getDay9());
            n.setDay10(o.getDay10());
            n.setDay11(o.getDay11());
            n.setDay12(o.getDay12());
            n.setDay13(o.getDay13());
            n.setDay14(o.getDay14());
            n.setDay15(o.getDay15());
            n.setDay16(o.getDay16());
            n.setDay17(o.getDay17());
            n.setDay18(o.getDay18());
            n.setDay19(o.getDay19());
            n.setDay20(o.getDay20());
            n.setDay21(o.getDay21());
            n.setDay22(o.getDay22());
            n.setDay23(o.getDay23());
            n.setDay24(o.getDay24());
            n.setDay25(o.getDay25());
            n.setDay26(o.getDay26());
            n.setDay27(o.getDay27());
            n.setDay28(o.getDay28());
            n.setDay29(o.getDay29());
            n.setDay30(o.getDay30());
            n.setDay31(o.getDay31());
            return n;
        }
        if (source instanceof FixDurationRotationComplete) {
            FixDurationRotationComplete o = (FixDurationRotationComplete)source;
            FixDurationRotationComplete n = new FixDurationRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setDuration(MealPlanCopyToolkit.copyDateDuration(o.getDuration()));
            return n;
        }
        if (source instanceof MonthRotationComplete) {
            MonthRotationComplete o = (MonthRotationComplete)source;
            MonthRotationComplete n = new MonthRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setMonth1(o.getMonth1());
            n.setMonth2(o.getMonth2());
            n.setMonth3(o.getMonth3());
            n.setMonth4(o.getMonth4());
            n.setMonth5(o.getMonth5());
            n.setMonth6(o.getMonth6());
            n.setMonth7(o.getMonth7());
            n.setMonth8(o.getMonth8());
            n.setMonth9(o.getMonth9());
            n.setMonth10(o.getMonth10());
            n.setMonth11(o.getMonth11());
            n.setMonth12(o.getMonth12());
            return n;
        }
        if (source instanceof WeekdayRotationComplete) {
            WeekdayRotationComplete o = (WeekdayRotationComplete)source;
            WeekdayRotationComplete n = new WeekdayRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setDay1(o.getDay1());
            n.setDay2(o.getDay2());
            n.setDay3(o.getDay3());
            n.setDay4(o.getDay4());
            n.setDay5(o.getDay5());
            n.setDay6(o.getDay6());
            n.setDay7(o.getDay7());
            return n;
        }
        return null;
    }

    private static RotationDurationComplete copyRotationDuration(RotationDurationComplete source, Node<CateringServiceScheduleVariantComplete> currentService) {
        if (source instanceof DayOfMonthRotationComplete) {
            DayOfMonthRotationComplete o = (DayOfMonthRotationComplete)source;
            DayOfMonthRotationComplete n = new DayOfMonthRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setDay1(o.getDay1());
            n.setDay2(o.getDay2());
            n.setDay3(o.getDay3());
            n.setDay4(o.getDay4());
            n.setDay5(o.getDay5());
            n.setDay6(o.getDay6());
            n.setDay7(o.getDay7());
            n.setDay8(o.getDay8());
            n.setDay9(o.getDay9());
            n.setDay10(o.getDay10());
            n.setDay11(o.getDay11());
            n.setDay12(o.getDay12());
            n.setDay13(o.getDay13());
            n.setDay14(o.getDay14());
            n.setDay15(o.getDay15());
            n.setDay16(o.getDay16());
            n.setDay17(o.getDay17());
            n.setDay18(o.getDay18());
            n.setDay19(o.getDay19());
            n.setDay20(o.getDay20());
            n.setDay21(o.getDay21());
            n.setDay22(o.getDay22());
            n.setDay23(o.getDay23());
            n.setDay24(o.getDay24());
            n.setDay25(o.getDay25());
            n.setDay26(o.getDay26());
            n.setDay27(o.getDay27());
            n.setDay28(o.getDay28());
            n.setDay29(o.getDay29());
            n.setDay30(o.getDay30());
            n.setDay31(o.getDay31());
            return n;
        }
        if (source instanceof FixDurationRotationComplete) {
            FixDurationRotationComplete o = (FixDurationRotationComplete)source;
            FixDurationRotationComplete n = new FixDurationRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setDuration(MealPlanCopyToolkit.copyDateDuration(o.getDuration()));
            return n;
        }
        if (source instanceof MonthRotationComplete) {
            MonthRotationComplete o = (MonthRotationComplete)source;
            MonthRotationComplete n = new MonthRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setMonth1(o.getMonth1());
            n.setMonth2(o.getMonth2());
            n.setMonth3(o.getMonth3());
            n.setMonth4(o.getMonth4());
            n.setMonth5(o.getMonth5());
            n.setMonth6(o.getMonth6());
            n.setMonth7(o.getMonth7());
            n.setMonth8(o.getMonth8());
            n.setMonth9(o.getMonth9());
            n.setMonth10(o.getMonth10());
            n.setMonth11(o.getMonth11());
            n.setMonth12(o.getMonth12());
            return n;
        }
        if (source instanceof WeekdayRotationComplete) {
            WeekdayRotationComplete o = (WeekdayRotationComplete)source;
            WeekdayRotationComplete n = new WeekdayRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setDay1(o.getDay1());
            n.setDay2(o.getDay2());
            n.setDay3(o.getDay3());
            n.setDay4(o.getDay4());
            n.setDay5(o.getDay5());
            n.setDay6(o.getDay6());
            n.setDay7(o.getDay7());
            return n;
        }
        RotationStrategyComplete strat = (RotationStrategyComplete)currentService.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).getValue();
        if (strat instanceof DayOfMonthRotationStrategyComplete) {
            DayOfMonthRotationComplete n = new DayOfMonthRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            return n;
        }
        if (strat instanceof FixPeriodRotationStrategyComplete) {
            return null;
        }
        if (strat instanceof FixRotationStrategyComplete) {
            FixDurationRotationComplete n = new FixDurationRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            return n;
        }
        if (strat instanceof MonthRotationStrategyComplete) {
            MonthRotationComplete n = new MonthRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            return n;
        }
        if (strat instanceof WeekdayRotationStrategyComplete) {
            WeekdayRotationComplete n = new WeekdayRotationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            return n;
        }
        return null;
    }

    private static DateDurationComplete copyDateDuration(DateDurationComplete source) {
        DateDurationComplete n = new DateDurationComplete();
        n.setDuration(source.getDuration());
        n.setUnit(source.getUnit());
        return n;
    }

    private static RotationStrategyComplete copyRotationStrategy(CateringServiceScheduleVariantComplete source, Map<Long, CateringServiceRotationComplete> rotation2rotationMap) {
        if (source.getRotationStrategy() instanceof DayOfMonthRotationStrategyComplete) {
            DayOfMonthRotationStrategyComplete rsc = new DayOfMonthRotationStrategyComplete();
            rsc.setClientOId(Long.valueOf(ADTO.getNextId()));
            rsc.setName(source.getRotationStrategy().getName());
            return rsc;
        }
        if (source.getRotationStrategy() instanceof FixRotationStrategyComplete) {
            FixRotationStrategyComplete rsc = new FixRotationStrategyComplete();
            rsc.setClientOId(Long.valueOf(ADTO.getNextId()));
            rsc.setStartDate(((FixRotationStrategyComplete)source.getRotationStrategy()).getStartDate());
            rsc.setName(source.getRotationStrategy().getName());
            return rsc;
        }
        if (source.getRotationStrategy() instanceof MonthRotationStrategyComplete) {
            MonthRotationStrategyComplete rsc = new MonthRotationStrategyComplete();
            rsc.setClientOId(Long.valueOf(ADTO.getNextId()));
            rsc.setName(source.getRotationStrategy().getName());
            return rsc;
        }
        if (source.getRotationStrategy() instanceof WeekdayRotationStrategyComplete) {
            WeekdayRotationStrategyComplete rsc = new WeekdayRotationStrategyComplete();
            rsc.setClientOId(Long.valueOf(ADTO.getNextId()));
            rsc.setName(source.getRotationStrategy().getName());
            return rsc;
        }
        if (source.getRotationStrategy() instanceof FixPeriodRotationStrategyComplete) {
            FixPeriodRotationStrategyComplete fprsc = new FixPeriodRotationStrategyComplete();
            fprsc.setClientOId(Long.valueOf(ADTO.getNextId()));
            fprsc.setName(source.getRotationStrategy().getName());
            FixPeriodRotationStrategyComplete oldStrat = (FixPeriodRotationStrategyComplete)source.getRotationStrategy();
            for (PeriodRotationComplete rots : oldStrat.getPeriods()) {
                PeriodRotationComplete r = new PeriodRotationComplete();
                r.setClientOId(Long.valueOf(ADTO.getNextId()));
                r.setRotation(rotation2rotationMap.get(rots.getRotation().getId()));
                r.setPeriod(new PeriodComplete(rots.getPeriod().getStartDate(), rots.getPeriod().getEndDate()));
                fprsc.getPeriods().add(r);
            }
            return fprsc;
        }
        return null;
    }
}

