/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits.copy;

import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.AircraftServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateDrawerComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateLabelEntryComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateProductComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateVariantComplete;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.GalleyComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.StowagePositionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.StowagePositionSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.scanning.GalleyLoadConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.MealPlanConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationVariantComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.handlingcost.AbsolutePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.ArticleDeliverablePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostProductDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantReference;
import ch.icit.pegasus.server.core.dtos.handlingcost.LinearPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.PriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Coordinate3dComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Dimension3dComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DiscountTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PurchasePriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.CatalogEntryComplete;
import ch.icit.pegasus.server.core.dtos.product.CateringPointCostComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogProductGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerDiscountsComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerPriceComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerTaxRatesComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.SoBProductConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.recipe.AdditiveDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.AllergenDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.CompoundIngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.IngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.InterpolationStepComplete;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.OtherDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.PreparationInstructionComplete;
import ch.icit.pegasus.server.core.dtos.recipe.QuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.SimpleIngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.StepQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.CustomerSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleCookingWasteComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticlePriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorComplete;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.kanban.ArticleKanbanConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodProductComplete;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsComplete;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsOrderNumberComplete;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyTemplateToolkit {
    static Logger log = LoggerFactory.getLogger(LegToolkit.class);

    public static void copyAllProducts(int sourceCustomer, int targetCustomer, Component source, boolean copyAllVariants, Integer ... excludes) throws SearchException, ServiceException, ClientServerCallException {
        CustomerSearchConfiguration c = new CustomerSearchConfiguration();
        c.setNumber(Integer.valueOf(sourceCustomer));
        SearchResult r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)c);
        CustomerLight sc = (CustomerLight)r.getSingleResult();
        c.setNumber(Integer.valueOf(targetCustomer));
        r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)c);
        CustomerLight tc = (CustomerLight)r.getSingleResult();
        CopyTemplateToolkit.copyAllProducts(sc, tc, source, new Date(System.currentTimeMillis()), copyAllVariants, new Integer[0]);
    }

    public static void copyAllProducts(CustomerLight sourceCustomer, CustomerLight targetCustomer, Component source, Date date, boolean copyAllVariants, Integer ... toCopy) throws ServiceException, ClientGetFromServerException, ClientSaveOnServerException {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (targetCustomer == null) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Please select a destination Customer"));
        }
        if (!a.isEmpty()) {
            InnerPopupFactory.showErrorDialog(a, "Unable to copy Products", source);
        } else {
            for (Integer no2copy : toCopy) {
                ProductVariantSearchConfiguration ps = new ProductVariantSearchConfiguration();
                ps.setCustomer(sourceCustomer);
                ps.setNumber(no2copy);
                ps.setValidityDate(new Timestamp(date.getTime()));
                HashSet<ProductComplete> copiedProducts = new HashSet<ProductComplete>();
                SearchResultIterator r = new SearchResultIterator((ASearchConfiguration)ps);
                for (ProductVariantLight v : r) {
                    try {
                        if (copiedProducts.contains(v.getProduct())) continue;
                        ProductComplete np = CopyTemplateToolkit.copyProduct(v.getProduct(), copyAllVariants ? null : v.getProduct().getCurrentVariant(), true);
                        np.setCustomer(targetCustomer);
                        np = (ProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createProduct(np).getValue();
                        copiedProducts.add(v.getProduct());
                    }
                    catch (Exception e) {
                        log.error("Unable to copy Product " + v.getProduct().getNumber());
                    }
                }
            }
        }
    }

    private static StepPriceCalculationComplete copyStepPrice(StepPriceCalculationComplete stepPrice, CurrencyComplete currencyComplete) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        StepPriceCalculationComplete ns = new StepPriceCalculationComplete();
        ns.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (stepPrice != null) {
            for (StepPriceFunctionComplete f : stepPrice.getSteps()) {
                StepPriceFunctionComplete nf = new StepPriceFunctionComplete();
                nf.setClientOId(Long.valueOf(ADTO.getNextId()));
                nf.setPrice(new PriceComplete(currencyComplete, Double.valueOf(0.0)));
                if (f.getPrice() != null) {
                    if (f.getPrice().getPrice() != null) {
                        nf.getPrice().setPrice(f.getPrice().getPrice());
                    } else {
                        nf.getPrice().setPrice(Double.valueOf(0.0));
                    }
                    if (f.getPrice().getCurrency() != null) {
                        nf.getPrice().setCurrency(f.getPrice().getCurrency());
                    }
                }
                nf.setPrice(new PriceComplete(f.getPrice()));
                nf.setSequenceNumber(f.getSequenceNumber());
                nf.setUpperLimit(new QuantityComplete(f.getUpperLimit()));
                ns.getSteps().add(nf);
            }
        }
        return ns;
    }

    public static ArticleKanbanConfigurationComplete copyArticleKanbanConfiguration(ArticleKanbanConfigurationComplete sc) {
        ArticleKanbanConfigurationComplete c = new ArticleKanbanConfigurationComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (sc != null) {
            c.setAverageDailyUsageQuantity(new StoreQuantityComplete(sc.getAverageDailyUsageQuantity()));
            c.setQuantityPerCard(new StoreQuantityComplete(sc.getQuantityPerCard()));
            c.setStorePosition(sc.getStorePosition());
            c.setValidity(new PeriodComplete(new java.sql.Date(sc.getValidity().getStartDate().getTime()), new java.sql.Date(sc.getValidity().getEndDate().getTime())));
        }
        return c;
    }

    public static SupplierConditionComplete copySupplierCondition(SupplierConditionComplete sc) {
        SupplierConditionComplete c = new SupplierConditionComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (sc != null) {
            c.setArticleNumber(sc.getArticleNumber());
            c.setDeliveryTime(sc.getDeliveryTime());
            c.setMinOrderAmount(sc.getMinOrderAmount());
            c.setMinOrderAmountUnit(sc.getMinOrderAmountUnit());
            c.setMinOrderAmountIsMandatory(sc.getMinOrderAmountIsMandatory());
            c.setOrderUnit(sc.getOrderUnit());
            c.setPercentage(sc.getPercentage());
            c.setPreference(sc.getPreference());
            c.setCategoryComment(sc.getCategoryComment());
            c.setCategoryTaxZone(sc.getCategoryTaxZone());
            c.setValidity(new PeriodComplete(sc.getValidity().getStartDate(), sc.getValidity().getEndDate()));
            c.setUsePackingQuantity(sc.getUsePackingQuantity());
            c.setPackingQuantities(CopyTemplateToolkit.copyPackagingQuantity(sc.getPackingQuantities()));
            if (sc.getShelfLife() != null) {
                c.setShelfLife(new DateDurationComplete(sc.getShelfLife().getUnit(), sc.getShelfLife().getDuration()));
            } else {
                c.setShelfLife(null);
            }
            if (sc.getStepPrice() != null && sc.getSupplier() != null) {
                c.setStepPrice(CopyTemplateToolkit.copyStepPrice(sc.getStepPrice(), sc.getSupplier().getPaymentCurrency()));
            }
            c.setSupplier(sc.getSupplier());
        }
        return c;
    }

    public static ServiceProductComplete copyServiceProduct(ServiceProductComplete serviceProduct) throws ClientServerCallException {
        ServiceProductComplete copy = new ServiceProductComplete();
        copy.setClientOId(Long.valueOf(ADTO.getNextId()));
        copy.setCreationDate(new Timestamp(System.currentTimeMillis()));
        copy.setCustomer(serviceProduct.getCustomer());
        copy.setIsDeleted(Boolean.valueOf(false));
        copy.setPeriod(CopyTemplateToolkit.copyPeriod(serviceProduct.getPeriod()));
        copy.setHourlyWork(serviceProduct.getHourlyWork());
        List<ServiceProductVariantComplete> variants = CopyTemplateToolkit.copyServiceProductVariants(serviceProduct.getVariants(), copy);
        Collections.sort(variants);
        ArrayList<ServiceProductVariantComplete> variantRefs = new ArrayList<ServiceProductVariantComplete>();
        for (ServiceProductVariantComplete variant : variants) {
            variantRefs.add(variant);
        }
        copy.setVariants(variantRefs);
        copy.setCurrentVariant(variants.get(variants.size() - 1));
        return copy;
    }

    public static PeriodComplete copyPeriod(PeriodComplete period) {
        PeriodComplete copy = new PeriodComplete();
        copy.setClientOId(Long.valueOf(ADTO.getNextId()));
        copy.setEndDate(new java.sql.Date(period.getEndDate().getTime()));
        copy.setStartDate(new java.sql.Date(period.getStartDate().getTime()));
        return copy;
    }

    public static List<ServiceProductVariantComplete> copyServiceProductVariants(List<ServiceProductVariantReference> variants, ServiceProductComplete spc) throws ClientServerCallException {
        ArrayList<ServiceProductVariantComplete> variantsCopy = new ArrayList<ServiceProductVariantComplete>();
        for (ServiceProductVariantReference variant : variants) {
            variantsCopy.add(CopyTemplateToolkit.copyServiceProductVariant(variant, spc));
        }
        return variantsCopy;
    }

    public static ServiceProductVariantComplete copyServiceProductVariant(ServiceProductVariantReference variantRef, ServiceProductComplete spc) throws ClientServerCallException {
        ServiceProductVariantComplete variant = (ServiceProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getServiceProductVariant(variantRef).getValue();
        ServiceProductVariantComplete copy = new ServiceProductVariantComplete();
        copy.setClientOId(Long.valueOf(ADTO.getNextId()));
        copy.setCustomerProductNumber(variant.getCustomerProductNumber());
        copy.setName(variant.getName());
        copy.setSalesPrice(variant.getSalesPrice());
        copy.setState(variant.getState());
        copy.setTaxRates(variant.getTaxRates());
        copy.setValidityPeriod(CopyTemplateToolkit.copyPeriod(variant.getValidityPeriod()));
        copy.setServiceProduct(spc);
        copy.setDeliveryAirport(variant.getDeliveryAirport());
        return copy;
    }

    private static IngredientComplete copyIngredient(IngredientComplete d) {
        if (d instanceof SimpleIngredientComplete) {
            SimpleIngredientComplete od = (SimpleIngredientComplete)d;
            SimpleIngredientComplete nd = new SimpleIngredientComplete();
            nd.setArticle(od.getArticle());
            nd.setClientOId(Long.valueOf(ADTO.getNextId()));
            nd.setSequenceNumber(od.getSequenceNumber());
            nd.setPreferredSupplier(od.getPreferredSupplier());
            nd.setPreferredTaxZone(od.getPreferredTaxZone());
            for (PreparationInstructionComplete p : od.getInstructions()) {
                PreparationInstructionComplete np = new PreparationInstructionComplete();
                np.setClientOId(Long.valueOf(ADTO.getNextId()));
                np.setInstructionText(p.getInstructionText());
                np.setSequenceNumber(p.getSequenceNumber());
                nd.getInstructions().add(np);
            }
            nd.setQuantity(CopyTemplateToolkit.copyQuantityInterpolation(od.getQuantity()));
            nd.setNettoQuantity(CopyTemplateToolkit.copyQuantityInterpolation(od.getNettoQuantity()));
            return nd;
        }
        CompoundIngredientComplete oc = (CompoundIngredientComplete)d;
        CompoundIngredientComplete nc = new CompoundIngredientComplete();
        nc.setClientOId(Long.valueOf(ADTO.getNextId()));
        nc.setRecipe(oc.getRecipe());
        nc.setSequenceNumber(oc.getSequenceNumber());
        nc.setQuantity(CopyTemplateToolkit.copyQuantityInterpolation(oc.getQuantity()));
        nc.setNettoQuantity(CopyTemplateToolkit.copyQuantityInterpolation(oc.getNettoQuantity()));
        for (PreparationInstructionComplete p : oc.getPreparationInstructions()) {
            PreparationInstructionComplete np = new PreparationInstructionComplete();
            np.setClientOId(Long.valueOf(ADTO.getNextId()));
            np.setInstructionText(p.getInstructionText());
            np.setSequenceNumber(p.getSequenceNumber());
            nc.getPreparationInstructions().add(np);
        }
        return nc;
    }

    public static ProductCatalogComplete copyProductCatalog(ProductCatalogLight origin) throws ClientServerCallException {
        ProductCatalogComplete pc = (ProductCatalogComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductCatalog(new ProductCatalogReference(origin.getId())).getValue();
        ProductCatalogComplete nP = new ProductCatalogComplete();
        nP.setClientOId(Long.valueOf(ADTO.getNextId()));
        nP.setCustomer(pc.getCustomer());
        nP.setEndDate(pc.getEndDate());
        nP.setStartDate(pc.getStartDate());
        nP.setTitleImage(pc.getTitleImage());
        nP.setEligibleLocations(pc.getEligibleLocations());
        nP.setMealPlan(pc.getMealPlan());
        nP.setAutoGenerated(pc.getAutoGenerated());
        nP.setComment(pc.getComment());
        nP.setGroups(CopyTemplateToolkit.copyProductGroups(pc.getGroups()));
        return nP;
    }

    private static List<ProductCatalogProductGroupComplete> copyProductGroups(List<ProductCatalogProductGroupComplete> groups) {
        ArrayList<ProductCatalogProductGroupComplete> ng = new ArrayList<ProductCatalogProductGroupComplete>();
        for (ProductCatalogProductGroupComplete g : groups) {
            ProductCatalogProductGroupComplete ngg = CopyTemplateToolkit.copyProductGroup(g);
            ng.add(ngg);
        }
        return ng;
    }

    private static ProductCatalogProductGroupComplete copyProductGroup(ProductCatalogProductGroupComplete g) {
        ProductCatalogProductGroupComplete ng = new ProductCatalogProductGroupComplete();
        ng.setClientOId(Long.valueOf(ADTO.getNextId()));
        ng.setName(g.getName());
        ng.setSequenceNumber(g.getSequenceNumber());
        ng.setEntries(CopyTemplateToolkit.copyCatalogEntries(g.getEntries()));
        return ng;
    }

    private static List<CatalogEntryComplete> copyCatalogEntries(List<CatalogEntryComplete> entries) {
        ArrayList<CatalogEntryComplete> nce = new ArrayList<CatalogEntryComplete>();
        for (CatalogEntryComplete e : entries) {
            CatalogEntryComplete ne = new CatalogEntryComplete();
            ne.setClientOId(Long.valueOf(ADTO.getNextId()));
            ne.setProduct(e.getProduct());
            ne.setSequenceNumber(e.getSequenceNumber());
            nce.add(ne);
        }
        return nce;
    }

    private static List<ProductVariantReference> copyProductVariants(List<ProductVariantReference> source1, ProductComplete destination, boolean upload) throws ClientServerCallException {
        ArrayList<ProductVariantReference> refs = new ArrayList<ProductVariantReference>();
        ArrayList<ProductVariantComplete> completes = new ArrayList<ProductVariantComplete>();
        for (ProductVariantReference r : source1) {
            ProductVariantComplete rc = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference(r).getValue();
            ProductVariantComplete nv = CopyTemplateToolkit.copyProductVariant(rc, upload);
            nv.setProduct(destination);
            destination.getVariants().add(nv);
            if (destination.getCurrentVariant() == null) {
                destination.setCurrentVariant((ProductVariantLight)nv);
            }
            completes.add(nv);
        }
        Collections.sort(completes);
        refs.addAll(completes);
        if (!refs.isEmpty()) {
            destination.setCurrentVariant((ProductVariantLight)completes.get(completes.size() - 1));
        }
        return refs;
    }

    public static StowingListTemplateComplete copyStowingListTemplate(StowingListTemplateComplete source, StowingListTemplateVariantLight variant2Copy, boolean upload) throws ClientServerCallException {
        StowingListTemplateComplete destination = new StowingListTemplateComplete();
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setCustomer(source.getCustomer());
        destination.setTemplate((StowingListTemplateReference)source);
        destination.setPeriod(CopyTemplateToolkit.copyPeriod(source.getPeriod()));
        destination.getEligibleLocations().addAll(source.getEligibleLocations());
        HashMap<StowingListTemplateLegComplete, StowingListTemplateLegComplete> templateLegs = new HashMap<StowingListTemplateLegComplete, StowingListTemplateLegComplete>();
        for (StowingListTemplateLegComplete leg : source.getLegs()) {
            StowingListTemplateLegComplete newLeg = CopyTemplateToolkit.copyLeg(leg, destination);
            templateLegs.put(leg, newLeg);
            destination.getLegs().add(newLeg);
        }
        if (source.getGalleyBellySwitch() != null) {
            destination.setGalleyBellySwitch((StowingListTemplateLegComplete)templateLegs.get(source.getGalleyBellySwitch()));
        }
        if (variant2Copy != null) {
            StowingListTemplateVariantLight copiedVariant = CopyTemplateToolkit.copyVariant(variant2Copy, destination, templateLegs);
            destination.getVariants().add(copiedVariant);
        } else {
            for (StowingListTemplateVariantLight variant : ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(source.getVariants())).getList()) {
                StowingListTemplateVariantLight copiedVariant = CopyTemplateToolkit.copyVariant(variant, destination, templateLegs);
                destination.getVariants().add(copiedVariant);
            }
        }
        return destination;
    }

    private static StowingListTemplateVariantLight copyVariant(StowingListTemplateVariantLight variant2Copy, StowingListTemplateComplete destination, Map<StowingListTemplateLegComplete, StowingListTemplateLegComplete> templateLegs) {
        StowingListTemplateVariantLight copiedVariant = new StowingListTemplateVariantLight();
        copiedVariant.setName(variant2Copy.getName());
        copiedVariant.setRemark(variant2Copy.getRemark());
        copiedVariant.setReportName(variant2Copy.getReportName());
        copiedVariant.setBase(destination);
        copiedVariant.setValidityPeriod(CopyTemplateToolkit.copyPeriod(variant2Copy.getValidityPeriod()));
        copiedVariant.setState(ModificationStateE.DRAFT);
        copiedVariant.setUseOnlyForCurrentCustomer(variant2Copy.getUseOnlyForCurrentCustomer());
        copiedVariant.setFillEmptyEquipments(variant2Copy.getFillEmptyEquipments());
        copiedVariant.setAircraft(variant2Copy.getAircraft());
        copiedVariant.setLimeFlightMigrationCode(variant2Copy.getLimeFlightMigrationCode());
        copiedVariant.getHandlingCosts().addAll(variant2Copy.getHandlingCosts());
        copiedVariant.setTemplate((StowingListTemplateVariantReference)variant2Copy);
        copiedVariant.setFlightLevel(variant2Copy.getFlightLevel());
        copiedVariant.setDefaultBoundedInboundSeals(variant2Copy.getDefaultBoundedInboundSeals());
        copiedVariant.setDefaultBoundedOutboundSeals(variant2Copy.getDefaultBoundedOutboundSeals());
        copiedVariant.setLoadAdditionalOnly(variant2Copy.getLoadAdditionalOnly());
        copiedVariant.setOffloadOnly(variant2Copy.getOffloadOnly());
        copiedVariant.setHandlingCosts(variant2Copy.getHandlingCosts());
        if (variant2Copy.getMealplan() != null) {
            copiedVariant.setMealplan(new MealPlanConfigurationComplete());
            copiedVariant.getMealplan().setClientOId(Long.valueOf(ADTO.getNextId()));
            copiedVariant.getMealplan().setStowingList(copiedVariant);
            copiedVariant.getMealplan().setMealplan(variant2Copy.getMealplan().getMealplan());
        }
        HashMap<StowingListTemplateVariantLegComplete, StowingListTemplateVariantLegComplete> variantLegs = new HashMap<StowingListTemplateVariantLegComplete, StowingListTemplateVariantLegComplete>();
        for (StowingListTemplateVariantLegComplete leg : variant2Copy.getLegs()) {
            StowingListTemplateVariantLegComplete newLeg = CopyTemplateToolkit.copyLeg(leg, copiedVariant);
            variantLegs.put(leg, newLeg);
            copiedVariant.getLegs().add(newLeg);
        }
        for (StowingListConfigurationVariantComplete stowingListConfig : variant2Copy.getStowingListConfigs()) {
            StowingListConfigurationVariantComplete newConfig = new StowingListConfigurationVariantComplete();
            newConfig.setClientOId(Long.valueOf(ADTO.getNextId()));
            newConfig.setVariant(copiedVariant);
            for (Map.Entry entry : stowingListConfig.getLegMapping().entrySet()) {
                StowingListTemplateVariantLegComplete mappedVariantLeg = (StowingListTemplateVariantLegComplete)variantLegs.get(entry.getKey());
                StowingListTemplateLegComplete mappedTemplateLeg = templateLegs.get(entry.getValue());
                newConfig.getLegMapping().put(mappedVariantLeg, mappedTemplateLeg);
            }
            copiedVariant.getStowingListConfigs().add(newConfig);
        }
        return copiedVariant;
    }

    private static StowingListTemplateVariantLegComplete copyLeg(StowingListTemplateVariantLegComplete leg, StowingListTemplateVariantLight copiedVariant) {
        StowingListTemplateVariantLegComplete newLeg = new StowingListTemplateVariantLegComplete();
        newLeg.setClientOId(Long.valueOf(ADTO.getNextId()));
        newLeg.setStowingList((StowingListTemplateVariantReference)copiedVariant);
        newLeg.setLegType(leg.getLegType());
        newLeg.setArrivalAirport(leg.getArrivalAirport());
        newLeg.setDepartureAirport(leg.getDepartureAirport());
        newLeg.setNumber(leg.getNumber());
        return newLeg;
    }

    public static StowingListTemplateVariantLight copyStowingListTemplateVariant(StowingListTemplateComplete source, StowingListTemplateVariantLight variant2Copy, boolean upload) throws ClientServerCallException {
        StowingListTemplateVariantLight copiedVariant = new StowingListTemplateVariantLight();
        copiedVariant.setName(variant2Copy.getName());
        copiedVariant.setRemark(variant2Copy.getRemark());
        copiedVariant.setReportName(variant2Copy.getReportName());
        copiedVariant.setBase(source);
        copiedVariant.setValidityPeriod(CopyTemplateToolkit.copyPeriod(variant2Copy.getValidityPeriod()));
        copiedVariant.setFlightLevel(variant2Copy.getFlightLevel());
        source.getVariants().add(copiedVariant);
        return copiedVariant;
    }

    public static ProductComplete copyProduct(ProductComplete source, ProductVariantLight variant2Copy, boolean upload) throws ClientServerCallException {
        ProductComplete destination = new ProductComplete();
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setCustomer(source.getCustomer());
        destination.setSalesOnBoard(source.getSalesOnBoard());
        destination.setEligibleLocations(source.getEligibleLocations());
        destination.setReturnsCountType(source.getReturnsCountType());
        destination.setBonded(source.getBonded());
        destination.setProductGroup(source.getProductGroup());
        destination.setShowOnKitchenSheet(source.getShowOnKitchenSheet());
        ArrayList<ProductVariantReference> nv = new ArrayList<ProductVariantReference>();
        if (variant2Copy != null) {
            destination.setPeriod(CopyTemplateToolkit.copyPeriod(variant2Copy.getValidityPeriod()));
            nv.add((ProductVariantReference)variant2Copy);
        } else {
            destination.setPeriod(CopyTemplateToolkit.copyPeriod(source.getPeriod()));
            nv.addAll(source.getVariants());
        }
        List<ProductVariantReference> r = CopyTemplateToolkit.copyProductVariants(nv, destination, upload);
        destination.setVariants(r);
        return destination;
    }

    public static ProductPriceFactorComplete copyProductPriceFactor(ProductPriceFactorComplete sp) {
        if (sp == null) {
            return null;
        }
        ProductPriceFactorComplete np = new ProductPriceFactorComplete();
        np.setClientOId(Long.valueOf(ADTO.getNextId()));
        np.setFactor(sp.getFactor());
        np.setFixPrice(sp.getFixPrice());
        np.setPrint(sp.getPrint());
        np.setSalesPriceFactor(sp.getSalesPriceFactor());
        return np;
    }

    public static CateringPointCostComplete copyCateringPointCost(CateringPointCostComplete source) {
        if (source == null) {
            return null;
        }
        CateringPointCostComplete c = new CateringPointCostComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        c.setCostCenter(source.getCostCenter());
        c.setPoints(source.getPoints());
        c.setLoadFactor(source.getLoadFactor());
        c.setCabinClass(source.getCabinClass());
        c.setFromAmount(source.getFromAmount());
        c.setToAmount(source.getToAmount());
        return c;
    }

    private static ProductComponentComplete copyProductComponent(ProductComponentComplete pcc) {
        if (pcc instanceof SimpleComponentComplete) {
            SimpleComponentComplete oPcc = (SimpleComponentComplete)pcc;
            SimpleComponentComplete nPcc = new SimpleComponentComplete();
            nPcc.setClientOId(Long.valueOf(ADTO.getNextId()));
            BasicArticleComplete nArt = oPcc.getArticle();
            nPcc.setArticle(nArt);
            nPcc.setCostCenter(oPcc.getCostCenter());
            nPcc.setNumber(oPcc.getNumber());
            nPcc.setComment(oPcc.getComment());
            nPcc.setShowInCatalog(oPcc.getShowInCatalog());
            nPcc.setShowAllergens(pcc.getShowAllergens());
            nPcc.setAutoCalculateBrutto(oPcc.getAutoCalculateBrutto());
            List cateringPoints = nPcc.getCateringPointCosts();
            for (CateringPointCostComplete c : oPcc.getCateringPointCosts()) {
                CateringPointCostComplete nc = CopyTemplateToolkit.copyCateringPointCost(c);
                if (nc == null) continue;
                cateringPoints.add(nc);
            }
            nPcc.setQuantity(CopyTemplateToolkit.copyQuantityInterpolation(oPcc.getQuantity()));
            nPcc.setNettoQuantity(CopyTemplateToolkit.copyQuantityInterpolation(oPcc.getNettoQuantity()));
            return nPcc;
        }
        if (pcc instanceof CompoundComponentComplete) {
            CompoundComponentComplete oCc = (CompoundComponentComplete)pcc;
            CompoundComponentComplete nCc = new CompoundComponentComplete();
            nCc.setClientOId(Long.valueOf(ADTO.getNextId()));
            List cateringPoints = nCc.getCateringPointCosts();
            for (CateringPointCostComplete c : oCc.getCateringPointCosts()) {
                CateringPointCostComplete nc = CopyTemplateToolkit.copyCateringPointCost(c);
                if (nc == null) continue;
                cateringPoints.add(nc);
            }
            nCc.setCostCenter(oCc.getCostCenter());
            nCc.setAutoCalculateBrutto(oCc.getAutoCalculateBrutto());
            nCc.setNumber(oCc.getNumber());
            nCc.setRecipe(oCc.getUnderlyingRecipe());
            nCc.setComment(oCc.getComment());
            nCc.setShowInCatalog(oCc.getShowInCatalog());
            nCc.setShowAllergens(pcc.getShowAllergens());
            nCc.setQuantity(CopyTemplateToolkit.copyQuantityInterpolation(oCc.getQuantity()));
            nCc.setNettoQuantity(CopyTemplateToolkit.copyQuantityInterpolation(oCc.getNettoQuantity()));
            return nCc;
        }
        return null;
    }

    public static List<PreparationInstructionComplete> copyPreparationInstructions(List<PreparationInstructionComplete> ing) {
        ArrayList<PreparationInstructionComplete> assis = new ArrayList<PreparationInstructionComplete>();
        for (PreparationInstructionComplete pi : ing) {
            PreparationInstructionComplete npi = new PreparationInstructionComplete();
            npi.setClientOId(Long.valueOf(ADTO.getNextId()));
            npi.setSequenceNumber(pi.getSequenceNumber());
            npi.setInstructionText(pi.getInstructionText());
            assis.add(npi);
        }
        return assis;
    }

    public static QuantityInterpolationComplete copyQuantityInterpolation(QuantityInterpolationComplete q) {
        if (q instanceof LinearQuantityInterpolationComplete) {
            LinearQuantityInterpolationComplete qq = (LinearQuantityInterpolationComplete)q;
            LinearQuantityInterpolationComplete lq = new LinearQuantityInterpolationComplete();
            lq.setClientOId(Long.valueOf(ADTO.getNextId()));
            QuantityComplete qc = new QuantityComplete();
            qc.setClientOId(Long.valueOf(qc.getNextId()));
            qc.setQuantity(qq.getResultingQuantity().getQuantity());
            qc.setUnit(qq.getResultingQuantity().getUnit());
            lq.setResultingQuantity(qc);
            return lq;
        }
        if (q instanceof StepQuantityInterpolationComplete) {
            StepQuantityInterpolationComplete qq = (StepQuantityInterpolationComplete)q;
            StepQuantityInterpolationComplete sq = new StepQuantityInterpolationComplete();
            sq.setClientOId(Long.valueOf(ADTO.getNextId()));
            ArrayList<InterpolationStepComplete> nSteps = new ArrayList<InterpolationStepComplete>();
            for (InterpolationStepComplete step : qq.getSteps()) {
                InterpolationStepComplete nStep = new InterpolationStepComplete();
                nStep.setClientOId(Long.valueOf(ADTO.getNextId()));
                nStep.setSequenceNumber(step.getSequenceNumber());
                QuantityComplete upQ = new QuantityComplete();
                upQ.setClientOId(Long.valueOf(upQ.getNextId()));
                upQ.setQuantity(step.getUpperBound().getQuantity());
                upQ.setUnit(step.getUpperBound().getUnit());
                nStep.setUpperBound(upQ);
                QuantityComplete res = new QuantityComplete();
                res.setClientOId(Long.valueOf(res.getNextId()));
                res.setQuantity(step.getResultingQuantity().getQuantity());
                res.setUnit(step.getResultingQuantity().getUnit());
                nStep.setResultingQuantity(res);
                nSteps.add(nStep);
            }
            sq.setSteps(nSteps);
            return sq;
        }
        return null;
    }

    public static SimpleProductComponentGroupComplete copyProductGroup(SimpleProductComponentGroupComplete group, boolean upload) {
        SimpleProductComponentGroupComplete nGroup = new SimpleProductComponentGroupComplete();
        nGroup.setClientOId(Long.valueOf(ADTO.getNextId()));
        nGroup.setName(group.getName());
        nGroup.setNumber(group.getNumber());
        nGroup.setComment(group.getComment());
        nGroup.setShowInCatalog(group.getShowInCatalog());
        nGroup.setUseImage(group.getUseImage());
        nGroup.setShowAllergens(group.getShowAllergens());
        nGroup.setCostCenter(group.getCostCenter());
        nGroup.setGroupType(group.getGroupType());
        nGroup.setProductionGroupName(group.getProductionGroupName());
        List cateringPoints = nGroup.getCateringPointCosts();
        for (CateringPointCostComplete c : group.getCateringPointCosts()) {
            CateringPointCostComplete nc = CopyTemplateToolkit.copyCateringPointCost(c);
            if (nc == null) continue;
            cateringPoints.add(nc);
        }
        try {
            nGroup.setImage(CopyTemplateToolkit.copyImageReference(group.getImage(), upload));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList<ProductComponentComplete> nList = new ArrayList<ProductComponentComplete>();
        for (ProductComponentComplete pcc : group.getComponents()) {
            ProductComponentComplete nPcc = CopyTemplateToolkit.copyProductComponent(pcc);
            nList.add(nPcc);
        }
        nGroup.setComponents(nList);
        return nGroup;
    }

    private static QuantityComplete copyQuantity(QuantityComplete q) {
        if (q == null) {
            return null;
        }
        QuantityComplete nq = new QuantityComplete();
        nq.setClientOId(Long.valueOf(nq.getNextId()));
        nq.setQuantity(q.getQuantity());
        nq.setUnit(q.getUnit());
        return nq;
    }

    public static PriceComplete copyPrice(PriceComplete p) {
        if (p == null) {
            return null;
        }
        PriceComplete np = new PriceComplete();
        np.setClientOId(Long.valueOf(np.getNextId()));
        np.setPrice(p.getPrice());
        np.setCurrency(p.getCurrency());
        return np;
    }

    public static RecipeVariantComplete copyRecipeVariant(RecipeVariantComplete source, boolean upload) {
        RecipeVariantComplete destination = new RecipeVariantComplete();
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setAdditiveDeclarations(CopyTemplateToolkit.copyAdditiveDeclaration(source.getAdditiveDeclarations()));
        destination.setAllergenDeclarations(CopyTemplateToolkit.copyAllegenDeclaration(source.getAllergenDeclarations()));
        destination.setOtherDeclarations(CopyTemplateToolkit.copyOtherDeclaration(source.getOtherDeclarations()));
        destination.setCategory(source.getCategory());
        destination.setComment(source.getComment());
        destination.setCreationDate(new Timestamp(System.currentTimeMillis()));
        destination.setName(source.getName());
        destination.setPrice(new PriceComplete(source.getPrice()));
        destination.setRecipe(source.getRecipe());
        destination.setState(source.getState());
        destination.setYield(new QuantityComplete(source.getYield()));
        destination.setConversionToDefaultUnit(source.getConversionToDefaultUnit());
        destination.setDefaultCostCenter(source.getDefaultCostCenter());
        destination.setEnglishName(source.getEnglishName());
        destination.setAdditionalComment(source.getAdditionalComment());
        destination.setProductGroup(source.getProductGroup());
        destination.setPreparationGroup(source.getPreparationGroup());
        destination.setUseDefaultCostCenterForCCP2(source.getUseDefaultCostCenterForCCP2());
        destination.setExcludeFromKonterProben(source.getExcludeFromKonterProben());
        destination.setAlwaysUseOnOPRP05Log(source.getAlwaysUseOnOPRP05Log());
        destination.setUseReserve(source.getUseReserve());
        List cateringPoints = destination.getCateringPointCosts();
        for (CateringPointCostComplete c : source.getCateringPointCosts()) {
            CateringPointCostComplete nc = CopyTemplateToolkit.copyCateringPointCost(c);
            if (nc == null) continue;
            cateringPoints.add(nc);
        }
        try {
            destination.setImageReference(CopyTemplateToolkit.copyImageReference(source.getImageReference(), upload));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (IngredientComplete i : source.getIngredients()) {
            IngredientComplete n = CopyTemplateToolkit.copyIngredient(i);
            destination.getIngredients().add(n);
        }
        return destination;
    }

    private static List<OtherDeclarationComplete> copyOtherDeclaration(List<OtherDeclarationComplete> otherDeclarations) {
        ArrayList<OtherDeclarationComplete> o = new ArrayList<OtherDeclarationComplete>();
        for (OtherDeclarationComplete d : otherDeclarations) {
            OtherDeclarationComplete n = new OtherDeclarationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setCharacteristic(d.getCharacteristic());
            n.setDeclare(d.getDeclare());
            n.setSequenceNumber(n.getSequenceNumber());
            o.add(n);
        }
        return o;
    }

    private static List<AllergenDeclarationComplete> copyAllegenDeclaration(List<AllergenDeclarationComplete> allergenDeclarations) {
        ArrayList<AllergenDeclarationComplete> o = new ArrayList<AllergenDeclarationComplete>();
        for (AllergenDeclarationComplete d : allergenDeclarations) {
            AllergenDeclarationComplete n = new AllergenDeclarationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setCharacteristic(d.getCharacteristic());
            n.setContainsTraces(d.getContainsTraces());
            n.setSequenceNumber(d.getSequenceNumber());
            o.add(n);
        }
        return o;
    }

    public static List<AdditiveDeclarationComplete> copyAdditiveDeclaration(List<AdditiveDeclarationComplete> additiveDeclarations) {
        ArrayList<AdditiveDeclarationComplete> o = new ArrayList<AdditiveDeclarationComplete>();
        for (AdditiveDeclarationComplete d : additiveDeclarations) {
            AdditiveDeclarationComplete n = new AdditiveDeclarationComplete();
            n.setClientOId(Long.valueOf(ADTO.getNextId()));
            n.setCharacteristic(d.getCharacteristic());
            n.setDeclare(d.getDeclare());
            n.setSequenceNumber(d.getSequenceNumber());
            o.add(n);
        }
        return o;
    }

    public static ProductVariantComplete copyProductVariant(ProductVariantComplete l, boolean upload) {
        ProductVariantComplete source = l;
        ComplexProductVariantComplete destination = null;
        if (source instanceof ComplexProductVariantComplete) {
            destination = new ComplexProductVariantComplete();
            if (source instanceof ComplexProductVariantComplete) {
                ComplexProductVariantComplete p = (ComplexProductVariantComplete)source;
                List comps = destination.getProductComponentGroups();
                for (SimpleProductComponentGroupComplete s : p.getProductComponentGroups()) {
                    SimpleProductComponentGroupComplete ns = CopyTemplateToolkit.copyProductGroup(s, upload);
                    if (ns == null) continue;
                    comps.add(ns);
                }
            }
        } else if (l instanceof SimpleProductVariantComplete) {
            destination = new SimpleProductVariantComplete();
            if (source instanceof SimpleProductVariantComplete) {
                SimpleProductVariantComplete s = (SimpleProductVariantComplete)source;
                ((SimpleProductVariantComplete)destination).setComponent((SimpleComponentComplete)CopyTemplateToolkit.copyProductComponent((ProductComponentComplete)s.getComponent()));
            }
        }
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setUseMasterDataForProductGroupTypes(source.getUseMasterDataForProductGroupTypes());
        destination.setName(source.getName());
        destination.setLabelUnit(source.getLabelUnit());
        destination.setExcludeFromAutoTaxing(source.getExcludeFromAutoTaxing());
        destination.setDeliveryUnit(source.getDeliveryUnit());
        destination.setCustomerProductNumber(source.getCustomerProductNumber());
        destination.setLabelName(source.getLabelName());
        destination.setProductEanCode(source.getProductEanCode());
        destination.setFlightCheckerName(source.getFlightCheckerName());
        destination.setProduct(source.getProduct());
        destination.setTakeKonterProbe(source.getTakeKonterProbe());
        destination.setShowOnDailyOpsSheet(source.getShowOnDailyOpsSheet());
        destination.setPriceComment(source.getPriceComment());
        destination.setDepartment(source.getDepartment());
        destination.setCalculateBrutto(source.getCalculateBrutto());
        destination.setCalculateNetto(source.getCalculateNetto());
        destination.setNettoWeight(source.getNettoWeight());
        destination.setBruttoWeight(source.getBruttoWeight());
        destination.setSapNumber(source.getSapNumber());
        destination.setCreateRetailInMotionTransactions(source.getCreateRetailInMotionTransactions());
        destination.setPaxMealType(source.getPaxMealType());
        destination.setIngredientText(source.getIngredientText());
        destination.setBarCode(source.getBarCode());
        destination.setCommission(source.getCommission());
        destination.setPackSize(source.getPackSize());
        destination.setProductsPerLabel(source.getPackSize());
        destination.setLongIngredientText(source.getLongIngredientText());
        destination.setNutritionText(source.getNutritionText());
        destination.setDefaultDeliveryNumber(source.getDefaultDeliveryNumber());
        destination.setAdditionalOrderLabelLayout(source.getAdditionalOrderLabelLayout());
        destination.setUseExpiryDate(source.getUseExpiryDate());
        destination.setDefaultExpiryDate(source.getDefaultExpiryDate());
        destination.setAdditionalOrderLabelLayout2(source.getAdditionalOrderLabelLayout2());
        destination.setEanBarcodeCustomerUnit(source.getEanBarcodeCustomerUnit());
        destination.setEanBarcodeLogisticsUnit(source.getEanBarcodeLogisticsUnit());
        destination.setEanBarcodeCustomerUnit(source.getEanBarcodeCustomerUnit());
        destination.setUltraFresh(source.getUltraFresh());
        destination.setStandardProduct(source.getStandardProduct());
        destination.setAlaCarteProduct(source.getAlaCarteProduct());
        destination.setSpmlProduct(source.getSpmlProduct());
        destination.setMenuTypes(source.getMenuTypes());
        destination.setHideOnLabel(source.getHideOnLabel());
        destination.setHandlingCosts(source.getHandlingCosts());
        destination.setAdditional(source.getAdditional());
        destination.setAircraftType(source.getAircraftType());
        destination.setBoundDirection(source.getBoundDirection());
        destination.setCabinClasses(source.getCabinClasses());
        destination.setFixedPrice(source.getFixedPrice());
        destination.setCategory(source.getCategory());
        destination.setState(ModificationStateE.DRAFT);
        destination.setProductCycle(source.getProductCycle());
        destination.setAdditionalComment(source.getAdditionalComment());
        destination.setInternalVariantComment(source.getInternalVariantComment());
        destination.setAlwaysOnDeliverySlip(source.getAlwaysOnDeliverySlip());
        destination.setMealType(source.getMealType());
        destination.setProductType(source.getProductType());
        destination.setProductToMealMultiplier(source.getProductToMealMultiplier());
        destination.setPaxName(source.getPaxName());
        destination.setTenderVariant(source.getTenderVariant());
        destination.setDefaultLabelColor(source.getDefaultLabelColor());
        destination.setDefaultInsertType(source.getDefaultInsertType());
        destination.setHaulTypes(source.getHaulTypes());
        destination.setMaterialPrice(CopyTemplateToolkit.copyPrice(source.getMaterialPrice()));
        destination.setValidityPeriod(CopyTemplateToolkit.copyPeriod(source.getValidityPeriod()));
        if (source.getSobConfiguration() != null && source.getProduct().getSalesOnBoard().booleanValue()) {
            destination.setSobConfiguration(CopyTemplateToolkit.copySobProductConfiguration(source.getSobConfiguration()));
        }
        try {
            destination.setImageReference(CopyTemplateToolkit.copyImageReference(l.getImageReference(), upload));
        }
        catch (IOException s) {
            // empty catch block
        }
        for (ProductCustomerPriceComplete priceComplete : source.getCustomerPrice()) {
            ProductCustomerPriceComplete newPrice = new ProductCustomerPriceComplete();
            newPrice.setCustomer(priceComplete.getCustomer());
            newPrice.setPrice(new PriceComplete(priceComplete.getPrice()));
            destination.getCustomerPrice().add(newPrice);
        }
        for (ProductCustomerDiscountsComplete productCustomerDiscountsComplete : source.getCustomerDiscounts()) {
            ProductCustomerDiscountsComplete newDiscount = new ProductCustomerDiscountsComplete();
            newDiscount.setCustomer(productCustomerDiscountsComplete.getCustomer());
            newDiscount.setDiscount(productCustomerDiscountsComplete.getDiscount());
            destination.getCustomerDiscounts().add(newDiscount);
        }
        for (Object productCustomerTaxRatesComplete : source.getCustomerTaxRates()) {
            ProductCustomerTaxRatesComplete taxRatesComplete = new ProductCustomerTaxRatesComplete();
            taxRatesComplete.setCustomer(productCustomerTaxRatesComplete.getCustomer());
            taxRatesComplete.setTaxRate(productCustomerTaxRatesComplete.getTaxRate());
            destination.getCustomerTaxRates().add(taxRatesComplete);
        }
        if (source.getSalesPrice() != null) {
            destination.setSalesPrice(new PriceComplete(source.getSalesPrice()));
        } else {
            destination.setSalesPrice(new PriceComplete());
        }
        destination.setSeason(source.getSeason());
        destination.setServiceTypes(source.getServiceTypes());
        destination.setMenuTypes(source.getMenuTypes());
        List cateringPoints = destination.getCateringPointCosts();
        for (CateringPointCostComplete c : source.getCateringPointCosts()) {
            CateringPointCostComplete nc = CopyTemplateToolkit.copyCateringPointCost(c);
            if (nc == null) continue;
            cateringPoints.add(nc);
        }
        List factors = destination.getProductPriceFactors();
        for (ProductPriceFactorComplete f : source.getProductPriceFactors()) {
            ProductPriceFactorComplete nf = CopyTemplateToolkit.copyProductPriceFactor(f);
            if (nf == null) continue;
            factors.add(nf);
        }
        destination.setDiscounts(source.getDiscounts());
        destination.setTaxRates(source.getTaxRates());
        destination.setCrewPrice(CopyTemplateToolkit.copyPrice(source.getCrewPrice()));
        return destination;
    }

    private static SoBProductConfigurationComplete copySobProductConfiguration(SoBProductConfigurationComplete o) {
        if (o == null) {
            return null;
        }
        SoBProductConfigurationComplete destination = new SoBProductConfigurationComplete();
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setComplimentary(o.getComplimentary());
        destination.setConversionFactor(o.getConversionFactor());
        destination.setCrew(o.getCrew());
        destination.setNormal(o.getNormal());
        destination.setReceiptRequired(o.getReceiptRequired());
        destination.setSobPrice(CopyTemplateToolkit.copyPrice(o.getSobPrice()));
        destination.setSobUnit(o.getSobUnit());
        destination.setStockCheck(o.getStockCheck());
        destination.setUpliftable(o.getUpliftable());
        return destination;
    }

    private static PegasusFileComplete copyImageReference(PegasusFileComplete source, boolean upload) throws IOException {
        if (source != null) {
            try {
                File f = FileTransferUtil.download((PegasusFileComplete)source, (FileTransferListener[])new FileTransferListener[0]);
                PegasusFileComplete destination = new PegasusFileComplete();
                destination.setCategory(source.getCategory());
                destination.setClientOId(Long.valueOf(ADTO.getNextId()));
                destination.setDescription(source.getDescription());
                destination.setFileName(FilenameUtils.getBaseName((String)f.getName()));
                destination.setFileSuffix(FilenameUtils.getExtension((String)f.getName()));
                destination.setLocalFile(f);
                if (upload) {
                    destination = FileTransferUtil.upload((PegasusFileComplete)destination, (FileTransferListener[])new FileTransferListener[0]);
                }
                return destination;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static ServiceProductVariantComplete copyServiceProductVariant(ServiceProductVariantComplete o) {
        ServiceProductVariantComplete destination = new ServiceProductVariantComplete();
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setSalesPrice(CopyTemplateToolkit.copyPrice(o.getSalesPrice()));
        destination.setServiceProduct(o.getServiceProduct());
        destination.setState(ModificationStateE.DRAFT);
        destination.setValidityPeriod(CopyTemplateToolkit.copyPeriod(o.getValidityPeriod()));
        return destination;
    }

    public static AircraftComplete copyAircraft(AircraftLight destination) throws ClientServerCallException {
        if (destination == null) {
            AircraftComplete nAircraft = new AircraftComplete();
            nAircraft.setClientOId(Long.valueOf(ADTO.getNextId()));
            return nAircraft;
        }
        AircraftComplete art = (AircraftComplete)((AircraftServiceManager)ServiceManagerRegistry.getService(AircraftServiceManager.class)).getAircraft((AircraftReference)destination).getValue();
        AircraftComplete nAircraft = new AircraftComplete();
        nAircraft.setClientOId(Long.valueOf(ADTO.getNextId()));
        nAircraft.setType(art.getType());
        nAircraft.setCustomer(art.getCustomer());
        nAircraft.setDescription(art.getDescription());
        nAircraft.setEquipmentSystem(art.getEquipmentSystem());
        nAircraft.setMatriculation(art.getMatriculation());
        nAircraft.setSeatConfigurations(CopyTemplateToolkit.copySeatConfiguration(art.getSeatConfigurations()));
        nAircraft.setGalleys(CopyTemplateToolkit.copyGalley(art.getGalleys()));
        nAircraft.setLoadConfigurations(CopyTemplateToolkit.copyLoadingConfiguration(art.getLoadConfigurations()));
        return nAircraft;
    }

    private static List<GalleyLoadConfigurationComplete> copyLoadingConfiguration(List<GalleyLoadConfigurationComplete> loadConfigurations) {
        ArrayList<GalleyLoadConfigurationComplete> l = new ArrayList<GalleyLoadConfigurationComplete>();
        for (GalleyLoadConfigurationComplete loadConfiguration : loadConfigurations) {
            GalleyLoadConfigurationComplete nl = new GalleyLoadConfigurationComplete();
            nl.setGalleys(loadConfiguration.getGalleys());
            nl.setClientOId(Long.valueOf(ADTO.getNextId()));
            l.add(nl);
        }
        return l;
    }

    private static DiscountTypeComplete copyDiscount(DiscountTypeComplete f) {
        DiscountTypeComplete discount = new DiscountTypeComplete();
        discount.setClientOId(Long.valueOf(ADTO.getNextId()));
        discount.setName(f.getName());
        discount.setDecription(f.getDecription());
        discount.setRate(f.getRate());
        return discount;
    }

    private static List<SeatConfigurationComplete> copySeatConfiguration(List<SeatConfigurationComplete> source) {
        ArrayList<SeatConfigurationComplete> seatConfig = new ArrayList<SeatConfigurationComplete>();
        for (SeatConfigurationComplete c : source) {
            SeatConfigurationComplete nc = new SeatConfigurationComplete();
            nc.setClientOId(Long.valueOf(ADTO.getNextId()));
            nc.setCabinClass(c.getCabinClass());
            nc.setNumber(c.getNumber());
            seatConfig.add(nc);
        }
        return seatConfig;
    }

    private static List<GalleyComplete> copyGalley(List<GalleyComplete> source) {
        ArrayList<GalleyComplete> galleys = new ArrayList<GalleyComplete>();
        for (GalleyComplete g : source) {
            GalleyComplete ng = new GalleyComplete();
            ng.setClientOId(Long.valueOf(ADTO.getNextId()));
            ng.setCode(g.getCode());
            ng.setDoorway(g.getDoorway());
            ng.setCabinClasses(CopyTemplateToolkit.copyCabinClasses(g.getCabinClasses()));
            ng.setStowagePositionSpecifications(CopyTemplateToolkit.copyStowingPositionSpecification(g));
            galleys.add(ng);
        }
        return galleys;
    }

    private static List<StowagePositionSpecificationComplete> copyStowingPositionSpecification(GalleyComplete source) {
        ArrayList<StowagePositionSpecificationComplete> poses = new ArrayList<StowagePositionSpecificationComplete>();
        for (StowagePositionSpecificationComplete p : source.getStowagePositionSpecifications()) {
            StowagePositionSpecificationComplete np = new StowagePositionSpecificationComplete();
            np.setClientOId(Long.valueOf(ADTO.getNextId()));
            np.setAlternativePositions(CopyTemplateToolkit.copyStowagePosition(p.getAlternativePositions()));
            np.setDefaultPositions(CopyTemplateToolkit.copyStowagePosition(p.getDefaultPositions()));
            poses.add(np);
        }
        return poses;
    }

    private static List<StowagePositionComplete> copyStowagePosition(List<StowagePositionComplete> source) {
        ArrayList<StowagePositionComplete> list = new ArrayList<StowagePositionComplete>();
        for (StowagePositionComplete p : source) {
            StowagePositionComplete np = new StowagePositionComplete();
            np.setEquipmentSystem(p.getEquipmentSystem());
            np.setClientOId(Long.valueOf(ADTO.getNextId()));
            np.setCode(p.getCode());
            np.setDefaultGalleyEquipmentType(p.getDefaultGalleyEquipmentType());
            np.setLocation(CopyTemplateToolkit.copyCoordinate(p.getLocation()));
            np.setType(p.getType());
            np.setDimension(CopyTemplateToolkit.copyDimension(p.getDimension()));
            np.setEquipmentSystem(p.getEquipmentSystem());
            list.add(np);
        }
        return list;
    }

    private static Dimension3dComplete copyDimension(Dimension3dComplete source) {
        if (source == null) {
            return null;
        }
        Dimension3dComplete d = new Dimension3dComplete();
        d.setClientOId(Long.valueOf(d.getNextId()));
        d.setDepth(source.getDepth());
        d.setHeight(source.getHeight());
        d.setWidth(source.getWidth());
        return d;
    }

    private static Coordinate3dComplete copyCoordinate(Coordinate3dComplete source) {
        Coordinate3dComplete nc = new Coordinate3dComplete();
        nc.setX(source.getX());
        nc.setY(source.getY());
        nc.setZ(source.getZ());
        return nc;
    }

    public static BasicArticleComplete copyArticle(BasicArticleLight destination) throws Exception {
        PegasusFileComplete nImg;
        File f;
        BasicArticleComplete oldArticle = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)destination).getValue();
        BasicArticleComplete newArticle = new BasicArticleComplete();
        newArticle.setName(oldArticle.getName());
        newArticle.setOrderName(oldArticle.getOrderName());
        newArticle.setCommodityNumber(oldArticle.getCommodityNumber());
        newArticle.setProductCatalogName(oldArticle.getProductCatalogName());
        newArticle.setContractQuantityAmount(oldArticle.getContractQuantityAmount());
        newArticle.setContractQuantityUnit(oldArticle.getContractQuantityUnit());
        newArticle.setEanCode(oldArticle.getEanCode());
        newArticle.setKosher(oldArticle.getKosher());
        newArticle.setNoExpiryDate(oldArticle.getNoExpiryDate());
        newArticle.setPurchaseCharge(oldArticle.getPurchaseCharge());
        newArticle.setSyncWithNoPro(oldArticle.getSyncWithNoPro());
        newArticle.setIgnorePurchasePriceUpdateNotification(oldArticle.getIgnorePurchasePriceUpdateNotification());
        newArticle.setNeedsXRay(oldArticle.getNeedsXRay());
        newArticle.setMinStock(oldArticle.getMinStock());
        newArticle.setMaxStock(oldArticle.getMaxStock());
        newArticle.setCategory(oldArticle.getCategory());
        newArticle.setProductionDepth(oldArticle.getProductionDepth());
        newArticle.setExcludeFromPurchaseLabelPrint(oldArticle.getExcludeFromPurchaseLabelPrint());
        newArticle.setShowOnCCPAnyway(oldArticle.getShowOnCCPAnyway());
        newArticle.setExcludeFromArticlePriceCalculation(oldArticle.getExcludeFromArticlePriceCalculation());
        newArticle.setPriceUnit(oldArticle.getPriceUnit());
        newArticle.setMainStoreUnit(oldArticle.getMainStoreUnit());
        newArticle.setFloatStoreUnit(oldArticle.getFloatStoreUnit());
        newArticle.setBaseUnit(oldArticle.getBaseUnit());
        newArticle.setIsNominated(oldArticle.getIsNominated());
        newArticle.setTakeKonterProben(oldArticle.getTakeKonterProben());
        newArticle.setIsInUse(oldArticle.getIsInUse());
        newArticle.setChilled(oldArticle.getChilled());
        newArticle.setFrozen(oldArticle.getFrozen());
        newArticle.setCanCreateTransactions(oldArticle.getCanCreateTransactions());
        newArticle.setReUsable(oldArticle.getReUsable());
        newArticle.setBonded(oldArticle.getBonded());
        newArticle.setTaxZone(oldArticle.getTaxZone());
        newArticle.setComment(oldArticle.getComment());
        newArticle.setUsageComment(oldArticle.getUsageComment());
        newArticle.setCustomer(oldArticle.getCustomer());
        newArticle.setCustomerArticleNumber(oldArticle.getCustomerArticleNumber());
        newArticle.setCustomerIsOwner(oldArticle.getCustomerIsOwner());
        newArticle.setExcludeFromMaterialCostCalculations(oldArticle.getExcludeFromMaterialCostCalculations());
        newArticle.setUseTenderPurchaseWaste(oldArticle.getUseTenderPurchaseWaste());
        newArticle.setTenderPurchaseWaste(oldArticle.getTenderPurchaseWaste());
        newArticle.setUseTenderCookingWaste(oldArticle.getUseTenderCookingWaste());
        newArticle.setTenderCookingWaste(oldArticle.getTenderCookingWaste());
        newArticle.setUseArticlePurchaseWaste(oldArticle.getUseArticlePurchaseWaste());
        newArticle.setPurchaseWaste(oldArticle.getPurchaseWaste());
        newArticle.setCookingWaste(oldArticle.getCookingWaste());
        newArticle.setDefaultProductionDepartment(oldArticle.getDefaultProductionDepartment());
        newArticle.setDefaultRequisitionDeliverDepartment(oldArticle.getDefaultRequisitionDeliverDepartment());
        newArticle.setSapNumber(oldArticle.getSapNumber());
        newArticle.setOriginCountry(oldArticle.getOriginCountry());
        newArticle.setUseCustomsData(oldArticle.getUseCustomsData());
        newArticle.setCustomsNumber(oldArticle.getCustomsNumber());
        newArticle.setCustomsTariff(oldArticle.getCustomsTariff());
        newArticle.setCustomsAdditionalEntry(oldArticle.getCustomsAdditionalEntry());
        newArticle.setIncludeForInvoiceCommission(oldArticle.getIncludeForInvoiceCommission());
        newArticle.setBilledBy(oldArticle.getBilledBy());
        newArticle.setCommissionType(oldArticle.getCommissionType());
        newArticle.setInvoiceCommissionUseFixCosts(oldArticle.getInvoiceCommissionUseFixCosts());
        newArticle.setInvoiceCommissionUsePerItemCosts(oldArticle.getInvoiceCommissionUsePerItemCosts());
        newArticle.setInvoiceCommissionUsePerItemQuantity(oldArticle.getInvoiceCommissionUsePerItemQuantity());
        newArticle.setInvoiceCommissionUsePerItemPrice(oldArticle.getInvoiceCommissionUsePerItemPrice());
        newArticle.setInvoiceCommissionUserPerItemCurrency(oldArticle.getInvoiceCommissionUserPerItemCurrency());
        for (BasicArticleCookingWasteComplete w : oldArticle.getCustomerCookingWaste()) {
            BasicArticleCookingWasteComplete nw = new BasicArticleCookingWasteComplete();
            nw.setClientOId(Long.valueOf(ADTO.getNextId()));
            nw.setCookingWaste(w.getCookingWaste());
            nw.setCustomer(w.getCustomer());
            newArticle.getCustomerCookingWaste().add(nw);
        }
        newArticle.setHalal(oldArticle.getHalal());
        newArticle.setUseArticleCookingWaste(oldArticle.getUseArticleCookingWaste());
        newArticle.setMarkedAsContracted(oldArticle.getMarkedAsContracted());
        newArticle.setGmcCode(oldArticle.getGmcCode());
        newArticle.setEnglishName(oldArticle.getEnglishName());
        newArticle.setEligibleLocations(oldArticle.getEligibleLocations());
        if (oldArticle.getMainStoreUnitImage() != null) {
            f = FileTransferUtil.download((PegasusFileComplete)oldArticle.getMainStoreUnitImage(), (FileTransferListener[])new FileTransferListener[0]);
            nImg = new PegasusFileComplete();
            nImg.setClientOId(Long.valueOf(ADTO.getNextId()));
            nImg.setCategory(FileCategoryE.PICTURE);
            nImg.setLocalFile(f);
            nImg.setFileName(FilenameUtils.getName((String)f.getName()));
            nImg.setFileSuffix(FilenameUtils.getExtension((String)f.getName()));
            newArticle.setMainStoreUnitImage(nImg);
        }
        if (oldArticle.getFloatStoreUnitImage() != null) {
            f = FileTransferUtil.download((PegasusFileComplete)oldArticle.getFloatStoreUnitImage(), (FileTransferListener[])new FileTransferListener[0]);
            nImg = new PegasusFileComplete();
            nImg.setClientOId(Long.valueOf(ADTO.getNextId()));
            nImg.setCategory(FileCategoryE.PICTURE);
            nImg.setLocalFile(f);
            nImg.setFileName(FilenameUtils.getName((String)f.getName()));
            nImg.setFileSuffix(FilenameUtils.getExtension((String)f.getName()));
            newArticle.setFloatStoreUnitImage(nImg);
        }
        if (oldArticle.getProductionUnitImage() != null) {
            f = FileTransferUtil.download((PegasusFileComplete)oldArticle.getProductionUnitImage(), (FileTransferListener[])new FileTransferListener[0]);
            nImg = new PegasusFileComplete();
            nImg.setClientOId(Long.valueOf(ADTO.getNextId()));
            nImg.setCategory(FileCategoryE.PICTURE);
            nImg.setLocalFile(f);
            nImg.setFileName(FilenameUtils.getName((String)f.getName()));
            nImg.setFileSuffix(FilenameUtils.getExtension((String)f.getName()));
            newArticle.setProductionUnitImage(nImg);
        }
        newArticle.setSuppliers(CopyTemplateToolkit.copySupplier(oldArticle));
        newArticle.setPackingQuantitiesVariants(CopyTemplateToolkit.copyPackagingBase(oldArticle));
        Collections.sort(oldArticle.getPrices());
        PriceComplete nettoPrice = ArticlePriceCalculationToolkit.getNettoPrice((BasicArticleLight)oldArticle, (Timestamp)new Timestamp(System.currentTimeMillis()), null, (boolean)false);
        BasicArticlePriceComplete ap = new BasicArticlePriceComplete();
        ap.setArticle((BasicArticleReference)newArticle);
        ap.setValidity(new PeriodComplete(((BasicArticlePriceComplete)oldArticle.getPrices().get(0)).getValidity().getStartDate(), ((BasicArticlePriceComplete)oldArticle.getPrices().get(oldArticle.getPrices().size() - 1)).getValidity().getEndDate()));
        ap.setPrice(nettoPrice);
        newArticle.getPrices().add(ap);
        newArticle.setStoreConditions(CopyTemplateToolkit.copyStoreCondition(oldArticle.getStoreConditions()));
        newArticle.setProductionDepth(oldArticle.getProductionDepth());
        MaterialCostFactorVariantComplete fv = ArticlePriceCalculationToolkit.getMaterialCostFactor((BasicArticleLight)oldArticle, (Timestamp)new Timestamp(System.currentTimeMillis()));
        MaterialCostFactorVariantComplete nfv = new MaterialCostFactorVariantComplete();
        nfv.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (fv != null) {
            for (MaterialCostFactorComplete f2 : fv.getMaterialCostFactors()) {
                MaterialCostFactorComplete ff = new MaterialCostFactorComplete();
                ff.setClientOId(Long.valueOf(ADTO.getNextId()));
                ff.setNumber(f2.getNumber());
                ff.setPurchasePriceFactor(f2.getPurchasePriceFactor());
                ff.setValue(f2.getValue());
                nfv.getMaterialCostFactors().add(ff);
            }
        }
        Collections.sort(oldArticle.getMaterialCostFactorVariants());
        nfv.setValidityPeriod(new PeriodComplete(((MaterialCostFactorVariantComplete)oldArticle.getMaterialCostFactorVariants().get(0)).getValidityPeriod().getStartDate(), ((MaterialCostFactorVariantComplete)oldArticle.getMaterialCostFactorVariants().get(oldArticle.getMaterialCostFactorVariants().size() - 1)).getValidityPeriod().getEndDate()));
        newArticle.getMaterialCostFactorVariants().add(nfv);
        return newArticle;
    }

    private static List<SupplierConditionBaseComplete> copySupplier(BasicArticleComplete art) {
        ArrayList<SupplierConditionBaseComplete> suppliers = new ArrayList<SupplierConditionBaseComplete>();
        for (SupplierConditionBaseComplete sup : art.getSuppliers()) {
            SupplierConditionBaseComplete nsup = new SupplierConditionBaseComplete();
            nsup.setClientOId(Long.valueOf(ADTO.getNextId()));
            nsup.setSupplier(sup.getSupplier());
            nsup.setSupplierConditionCategory(CopyTemplateToolkit.copyCategories(sup.getSupplierConditionCategory()));
            suppliers.add(nsup);
        }
        return suppliers;
    }

    private static List<SupplierConditionCategoryComplete> copyCategories(List<SupplierConditionCategoryComplete> supplierConditionCategory) {
        ArrayList<SupplierConditionCategoryComplete> categories = new ArrayList<SupplierConditionCategoryComplete>();
        for (SupplierConditionCategoryComplete categoryComplete : supplierConditionCategory) {
            SupplierConditionCategoryComplete ncat = new SupplierConditionCategoryComplete();
            ncat.setName(categoryComplete.getName());
            ncat.setClientOId(Long.valueOf(ADTO.getNextId()));
            ncat.setTaxZone(categoryComplete.getTaxZone());
            ncat.setConditions(CopyTemplateToolkit.copySupplierConditions(categoryComplete.getConditions()));
            categories.add(ncat);
        }
        return categories;
    }

    private static List<SupplierConditionComplete> copySupplierConditions(List<SupplierConditionComplete> conditions) {
        ArrayList<SupplierConditionComplete> sups = new ArrayList<SupplierConditionComplete>();
        for (SupplierConditionComplete condition : conditions) {
            SupplierConditionComplete ncondition = CopyTemplateToolkit.copySupplierCondition(condition);
            sups.add(ncondition);
        }
        return sups;
    }

    private static List<StoreConditionComplete> copyStoreCondition(List<StoreConditionComplete> destination) {
        ArrayList<StoreConditionComplete> list = new ArrayList<StoreConditionComplete>();
        for (StoreConditionComplete cdc : destination) {
            StoreConditionComplete newStoreCondition = new StoreConditionComplete();
            newStoreCondition.setCapacity(cdc.getCapacity());
            newStoreCondition.setPreference(cdc.getPreference());
            newStoreCondition.setPosition(cdc.getPosition());
            newStoreCondition.setClientOId(Long.valueOf(ADTO.getNextId()));
            newStoreCondition.setType(cdc.getType());
            newStoreCondition.setDepartment(cdc.getDepartment());
            list.add(newStoreCondition);
        }
        return list;
    }

    private static List<PackagingQuantityBaseComplete> copyPackagingBase(BasicArticleComplete article) {
        ArrayList<PackagingQuantityBaseComplete> base = new ArrayList<PackagingQuantityBaseComplete>();
        for (PackagingQuantityBaseComplete baseComplete : article.getPackingQuantitiesVariants()) {
            PackagingQuantityBaseComplete nBase = new PackagingQuantityBaseComplete();
            nBase.setPeriod(CopyTemplateToolkit.copyPeriod(baseComplete.getPeriod()));
            nBase.setClientOId(Long.valueOf(ADTO.getNextId()));
            nBase.setPackingQuantities(CopyTemplateToolkit.copyPackagingQuantity(baseComplete.getPackingQuantities()));
            base.add(nBase);
        }
        return base;
    }

    public static List<PackagingQuantityComplete> copyPackagingQuantity(List<PackagingQuantityComplete> destination) {
        ArrayList<PackagingQuantityComplete> qt = new ArrayList<PackagingQuantityComplete>();
        for (PackagingQuantityComplete value : destination) {
            PackagingQuantityComplete nValue = new PackagingQuantityComplete();
            nValue.setUnit(value.getUnit());
            nValue.setSequenceNumber(value.getSequenceNumber());
            nValue.setAmount(value.getAmount());
            nValue.setClientOId(Long.valueOf(ADTO.getNextId()));
            qt.add(nValue);
        }
        return qt;
    }

    private static List<MaterialCostFactorComplete> fillMaterialCostFactors(BasicArticleComplete destination) {
        ArrayList<MaterialCostFactorComplete> list = new ArrayList<MaterialCostFactorComplete>();
        Node l = NodeToolkit.getAffixList(PurchasePriceFactorComplete.class);
        Iterator it = l.getChilds();
        while (it.hasNext()) {
            Node b = (Node)it.next();
            MaterialCostFactorComplete newMatCost = new MaterialCostFactorComplete();
            newMatCost.setPurchasePriceFactor((PurchasePriceFactorComplete)b.getValue());
            newMatCost.setValue(Double.valueOf(0.0));
            newMatCost.setClientOId(Long.valueOf(ADTO.getNextId()));
            list.add(newMatCost);
        }
        return list;
    }

    public static FlightScheduleComplete copyFlightSchedule(FlightScheduleComplete nfs) {
        FlightScheduleComplete ofs = new FlightScheduleComplete();
        ofs.setClientOId(Long.valueOf(ADTO.getNextId()));
        ofs.setCustomer(nfs.getCustomer());
        ofs.setDaysOfWeek(nfs.getDaysOfWeek());
        ofs.setDeliverySlipSheet(nfs.getDeliverySlipSheet());
        ofs.setHandlingCosts(nfs.getHandlingCosts());
        ofs.setFlightType(nfs.getFlightType());
        ofs.setInboundCode(nfs.getInboundCode());
        ofs.setLabelLayout(nfs.getLabelLayout());
        ofs.setSpecialMealLayout(nfs.getSpecialMealLayout());
        ofs.setOutboundCode(nfs.getOutboundCode());
        ofs.setPeriod(new PeriodComplete(nfs.getPeriod().getStartDate(), nfs.getPeriod().getEndDate()));
        ofs.setReturnDay(nfs.getReturnDay());
        ofs.setSta(nfs.getSta());
        ofs.setState(ModificationStateE.DRAFT);
        ofs.setStd(nfs.getStd());
        ofs.setDefaultGate(nfs.getDefaultGate());
        ofs.setDeliveryAirport(nfs.getDeliveryAirport());
        ofs.setUpliftCount(nfs.getUpliftCount());
        ofs.setEligibleLocations(nfs.getEligibleLocations());
        ofs.setCrewRemark(nfs.getCrewRemark());
        ofs.setHaulType(nfs.getHaulType());
        ofs.setCategory(nfs.getCategory());
        ofs.setSealLabelLayout(nfs.getSealLabelLayout());
        ofs.setShortFlightCode(nfs.getShortFlightCode());
        ofs.setExcludeFromKitchenForecast(nfs.getExcludeFromKitchenForecast());
        ofs.setLegs(CopyTemplateToolkit.copyLegs(nfs.getLegs()));
        for (AdditionalOrderTemplateComplete o : nfs.getAdditionalOrders()) {
            AdditionalOrderTemplateComplete nt = new AdditionalOrderTemplateComplete();
            nt.setClientOId(Long.valueOf(ADTO.getNextId()));
            nt.setCabinClass(o.getCabinClass());
            int index = o.getLeg().getNumber();
            if (ofs.getLegs().size() <= index) {
                index = 0;
            }
            nt.setLeg((FlightScheduleLegComplete)ofs.getLegs().get(index));
            nt.setProduct(o.getProduct());
            nt.setQuantity(o.getQuantity());
            ofs.getAdditionalOrders().add(nt);
        }
        return ofs;
    }

    private static StowingListTemplateLegComplete copyLeg(StowingListTemplateLegComplete leg, StowingListTemplateComplete stw) {
        StowingListTemplateLegComplete newLeg = new StowingListTemplateLegComplete();
        newLeg.setClientOId(Long.valueOf(ADTO.getNextId()));
        newLeg.setStowingList(stw);
        newLeg.setLegType(leg.getLegType());
        newLeg.setArrivalAirport(leg.getArrivalAirport());
        newLeg.setDepartureAirport(leg.getDepartureAirport());
        newLeg.setNumber(leg.getNumber());
        return newLeg;
    }

    private static List<FlightScheduleLegComplete> copyLegs(List<FlightScheduleLegComplete> legs) {
        ArrayList<FlightScheduleLegComplete> nls = new ArrayList<FlightScheduleLegComplete>();
        for (FlightScheduleLegComplete l : legs) {
            FlightScheduleLegComplete nl = new FlightScheduleLegComplete();
            nl.setClientOId(Long.valueOf(ADTO.getNextId()));
            nl.setArrivalAirport(l.getArrivalAirport());
            nl.setDepartureAirport(l.getDepartureAirport());
            nl.setNumber(l.getNumber());
            nl.setLegType(l.getLegType());
            nl.setFlightTime(l.getFlightTime());
            nl.setFlightNo(l.getFlightNo());
            nls.add(nl);
        }
        return nls;
    }

    public static HandlingCostComplete copyHandlingCost(HandlingCostComplete handlingCost, @Nullable HandlingCostVariantComplete variant2Copy) throws ClientServerCallException {
        HandlingCostComplete nh = new HandlingCostComplete();
        nh.setClientOId(Long.valueOf(ADTO.getNextId()));
        nh.getEligibleLocations().addAll(handlingCost.getEligibleLocations());
        nh.setCustomer(handlingCost.getCustomer());
        ArrayList<HandlingCostVariantReference> nv = new ArrayList<HandlingCostVariantReference>();
        if (variant2Copy == null) {
            nv.addAll(handlingCost.getVariants());
            nh.setPeriod(CopyTemplateToolkit.copyPeriod(handlingCost.getPeriod()));
        } else {
            nv.add((HandlingCostVariantReference)variant2Copy);
            nh.setPeriod(CopyTemplateToolkit.copyPeriod(variant2Copy.getValidityPeriod()));
        }
        List<HandlingCostVariantReference> r = CopyTemplateToolkit.copyHandlingCostVariants(nv, nh);
        nh.setVariants(r);
        return nh;
    }

    public static List<HandlingCostVariantReference> copyHandlingCostVariants(List<HandlingCostVariantReference> source1, HandlingCostComplete destination) throws ClientServerCallException {
        ArrayList<HandlingCostVariantReference> refs = new ArrayList<HandlingCostVariantReference>();
        ArrayList<HandlingCostVariantComplete> completes = new ArrayList<HandlingCostVariantComplete>();
        for (HandlingCostVariantReference r : source1) {
            HandlingCostVariantComplete rc = (HandlingCostVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getHandlingCostVariant(r).getValue();
            HandlingCostVariantComplete nv = CopyTemplateToolkit.copyHandlingCostVariant(rc);
            nv.setBase(destination);
            completes.add(nv);
            refs.add((HandlingCostVariantReference)nv);
        }
        Collections.sort(completes, (o1, o2) -> o1.getValidityPeriod().compareTo(o2.getValidityPeriod()));
        if (!completes.isEmpty()) {
            HandlingCostVariantComplete handlingCostVariantComplete = (HandlingCostVariantComplete)completes.get(completes.size() - 1);
            destination.setCurrentVariant(handlingCostVariantComplete);
        }
        return refs;
    }

    public static HandlingCostVariantComplete copyHandlingCostVariant(HandlingCostVariantComplete l) {
        HandlingCostVariantComplete destination = new HandlingCostVariantComplete();
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setBase(l.getBase());
        destination.setCustomerInvoiceNumber(l.getCustomerInvoiceNumber());
        destination.setDeliverable(CopyTemplateToolkit.copyHandlingCostDeliverable(l.getDeliverable()));
        destination.setName(l.getName());
        destination.setReportName(l.getReportName());
        destination.setQuantity(CopyTemplateToolkit.copyPriceCalculation(l.getQuantity()));
        destination.setDiscounts(l.getDiscounts());
        destination.setState(ModificationStateE.DRAFT);
        destination.setValidityPeriod(CopyTemplateToolkit.copyPeriod(l.getValidityPeriod()));
        destination.setType(l.getType());
        destination.setExcludeFromCanBeUseFromOtherCustomers(l.getExcludeFromCanBeUseFromOtherCustomers());
        destination.setPaxClasses(CopyTemplateToolkit.copyCabinClasses(l.getPaxClasses()));
        List cateringPoints = destination.getCateringPointCosts();
        for (CateringPointCostComplete c : l.getCateringPointCosts()) {
            CateringPointCostComplete nc = CopyTemplateToolkit.copyCateringPointCost(c);
            if (nc == null) continue;
            cateringPoints.add(nc);
        }
        List taxes = destination.getTaxRates();
        for (TaxRateComplete f : l.getTaxRates()) {
            taxes.add(f);
        }
        return destination;
    }

    public static EquipmentTemplateComplete copyEquipmentTemplate(EquipmentTemplateComplete equipment, @Nullable EquipmentTemplateVariantLight variant2Copy) throws ClientServerCallException {
        EquipmentTemplateComplete nh = new EquipmentTemplateComplete();
        nh.setClientOId(Long.valueOf(ADTO.getNextId()));
        nh.getEligibleLocations().addAll(equipment.getEligibleLocations());
        nh.setCustomer(equipment.getCustomer());
        ArrayList<EquipmentTemplateVariantReference> nv = new ArrayList<EquipmentTemplateVariantReference>();
        if (variant2Copy != null) {
            nh.setPeriod(CopyTemplateToolkit.copyPeriod(variant2Copy.getValidityPeriod()));
            nv.add((EquipmentTemplateVariantReference)variant2Copy);
        } else {
            nh.setPeriod(CopyTemplateToolkit.copyPeriod(equipment.getPeriod()));
            nv.addAll(equipment.getVariants());
        }
        List<EquipmentTemplateVariantReference> r = CopyTemplateToolkit.copyEquipmentTemplateVariants(nv, nh);
        nh.setVariants(r);
        return nh;
    }

    public static List<EquipmentTemplateVariantReference> copyEquipmentTemplateVariants(List<EquipmentTemplateVariantReference> source1, EquipmentTemplateComplete destination) throws ClientServerCallException {
        ArrayList<EquipmentTemplateVariantReference> refs = new ArrayList<EquipmentTemplateVariantReference>();
        ArrayList<EquipmentTemplateVariantComplete> completes = new ArrayList<EquipmentTemplateVariantComplete>();
        for (EquipmentTemplateVariantReference r : source1) {
            EquipmentTemplateVariantComplete rc = (EquipmentTemplateVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getEquipmentTemplateVariant(r).getValue();
            EquipmentTemplateVariantComplete nv = CopyTemplateToolkit.copyEquipmentTempalteVariant(rc);
            nv.setBase(destination);
            completes.add(nv);
            refs.add((EquipmentTemplateVariantReference)nv);
        }
        Collections.sort(completes);
        destination.setCurrentVariant((EquipmentTemplateVariantLight)completes.get(completes.size() - 1));
        return refs;
    }

    public static EquipmentTemplateVariantComplete copyEquipmentTempalteVariant(EquipmentTemplateVariantComplete l) {
        EquipmentTemplateVariantComplete destination = new EquipmentTemplateVariantComplete();
        destination.setClientOId(Long.valueOf(ADTO.getNextId()));
        destination.setBase(l.getBase());
        destination.setName(l.getName());
        destination.setValidityPeriod(CopyTemplateToolkit.copyPeriod(l.getValidityPeriod()));
        destination.setState(ModificationStateE.DRAFT);
        List drawers = destination.getDrawers();
        for (EquipmentTemplateDrawerComplete c : l.getDrawers()) {
            EquipmentTemplateDrawerComplete nc = CopyTemplateToolkit.copyEquipmentTemplateDrawer(c);
            if (nc == null) continue;
            drawers.add(nc);
        }
        List labelEntries = destination.getLabelEntries();
        for (EquipmentTemplateLabelEntryComplete c : l.getLabelEntries()) {
            EquipmentTemplateLabelEntryComplete nc = CopyTemplateToolkit.copyEquipmentTemplateLabelEntry(c);
            if (nc == null) continue;
            labelEntries.add(nc);
        }
        return destination;
    }

    private static EquipmentTemplateLabelEntryComplete copyEquipmentTemplateLabelEntry(EquipmentTemplateLabelEntryComplete s) {
        EquipmentTemplateLabelEntryComplete d = new EquipmentTemplateLabelEntryComplete();
        d.setClientOId(s.getClientOId());
        d.setLabelAmount(s.getLabelAmount());
        d.setLabelText(s.getLabelText());
        return d;
    }

    private static EquipmentTemplateDrawerComplete copyEquipmentTemplateDrawer(EquipmentTemplateDrawerComplete s) {
        EquipmentTemplateDrawerComplete d = new EquipmentTemplateDrawerComplete();
        d.setClientOId(s.getClientOId());
        d.setInsertType(s.getInsertType());
        d.setLocation(s.getLocation());
        for (EquipmentTemplateProductComplete p : s.getProducts()) {
            EquipmentTemplateProductComplete nc = CopyTemplateToolkit.copyEquipmentTemplateProduct(p);
            if (nc == null) continue;
            d.getProducts().add(nc);
        }
        return d;
    }

    private static EquipmentTemplateProductComplete copyEquipmentTemplateProduct(EquipmentTemplateProductComplete s) {
        EquipmentTemplateProductComplete d = new EquipmentTemplateProductComplete();
        d.setClientOId(s.getClientOId());
        d.setProduct(s.getProduct());
        d.setAmount(s.getAmount());
        d.setShowOnLabel(s.getShowOnLabel());
        d.setSequenceNo(s.getSequenceNo());
        return d;
    }

    private static PriceCalculationComplete copyPriceCalculation(PriceCalculationComplete quantity) {
        if (quantity instanceof AbsolutePriceCalculationComplete) {
            AbsolutePriceCalculationComplete a = new AbsolutePriceCalculationComplete();
            a.setClientOId(Long.valueOf(ADTO.getNextId()));
            a.setCurrency(((AbsolutePriceCalculationComplete)quantity).getCurrency());
            a.setPrice(((AbsolutePriceCalculationComplete)quantity).getPrice());
            return a;
        }
        if (quantity instanceof LinearPriceCalculationComplete) {
            LinearPriceCalculationComplete l = new LinearPriceCalculationComplete();
            l.setClientOId(Long.valueOf(ADTO.getNextId()));
            l.setPrice(new PriceComplete(((LinearPriceCalculationComplete)quantity).getPrice()));
            l.setQuantity(new QuantityComplete(((LinearPriceCalculationComplete)quantity).getQuantity()));
            return l;
        }
        if (quantity instanceof StepPriceCalculationComplete) {
            StepPriceCalculationComplete s = new StepPriceCalculationComplete();
            s.setClientOId(Long.valueOf(ADTO.getNextId()));
            s.setSteps(CopyTemplateToolkit.copySteps(((StepPriceCalculationComplete)quantity).getSteps()));
            return s;
        }
        return null;
    }

    private static List<StepPriceFunctionComplete> copySteps(List<StepPriceFunctionComplete> steps) {
        ArrayList<StepPriceFunctionComplete> funcs = new ArrayList<StepPriceFunctionComplete>();
        for (StepPriceFunctionComplete f : steps) {
            StepPriceFunctionComplete nf = new StepPriceFunctionComplete();
            nf.setClientOId(Long.valueOf(ADTO.getNextId()));
            nf.setPrice(new PriceComplete(f.getPrice().getCurrency(), f.getPrice().getPrice()));
            nf.setSequenceNumber(f.getSequenceNumber());
            nf.setUpperLimit(new QuantityComplete(f.getUpperLimit()));
            funcs.add(nf);
        }
        return funcs;
    }

    private static List<CabinClassComplete> copyCabinClasses(List<CabinClassComplete> paxClasses) {
        ArrayList<CabinClassComplete> list = new ArrayList<CabinClassComplete>();
        for (CabinClassComplete c : paxClasses) {
            list.add(c);
        }
        return list;
    }

    private static HandlingCostDeliverableComplete copyHandlingCostDeliverable(HandlingCostDeliverableComplete deliverable) {
        if (deliverable instanceof HandlingCostProductDeliverableComplete) {
            HandlingCostProductDeliverableComplete p = new HandlingCostProductDeliverableComplete();
            p.setClientOId(Long.valueOf(ADTO.getNextId()));
            p.setProduct(((HandlingCostProductDeliverableComplete)deliverable).getProduct());
            return p;
        }
        if (deliverable instanceof HandlingCostArticleDeliverableComplete) {
            HandlingCostArticleDeliverableComplete a = new HandlingCostArticleDeliverableComplete();
            a.setClientOId(Long.valueOf(ADTO.getNextId()));
            ArrayList<ArticleDeliverablePriceCalculationComplete> list = new ArrayList<ArticleDeliverablePriceCalculationComplete>();
            for (ArticleDeliverablePriceCalculationComplete adpcc : ((HandlingCostArticleDeliverableComplete)deliverable).getArticles()) {
                AbsolutePriceCalculationComplete ccc;
                ArticleDeliverablePriceCalculationComplete c = new ArticleDeliverablePriceCalculationComplete();
                if (adpcc.getPriceCalculation() instanceof AbsolutePriceCalculationComplete) {
                    ccc = (AbsolutePriceCalculationComplete)adpcc.getPriceCalculation();
                    AbsolutePriceCalculationComplete apcc = new AbsolutePriceCalculationComplete();
                    apcc.setCurrency(ccc.getCurrency());
                    apcc.setPrice(ccc.getPrice());
                    apcc.setClientOId(ccc.getClientOId());
                    c.setPriceCalculation((PriceCalculationComplete)apcc);
                }
                if (adpcc.getPriceCalculation() instanceof LinearPriceCalculationComplete) {
                    ccc = (LinearPriceCalculationComplete)adpcc.getPriceCalculation();
                    LinearPriceCalculationComplete lpcc = new LinearPriceCalculationComplete();
                    lpcc.setQuantity(ccc.getQuantity());
                    lpcc.setPrice(ccc.getPrice());
                    lpcc.setClientOId(ccc.getClientOId());
                    c.setPriceCalculation((PriceCalculationComplete)lpcc);
                }
                if (adpcc.getPriceCalculation() instanceof StepPriceCalculationComplete) {
                    ccc = (StepPriceCalculationComplete)adpcc.getPriceCalculation();
                    StepPriceCalculationComplete spcc = new StepPriceCalculationComplete();
                    spcc.setSteps(ccc.getSteps());
                    spcc.setClientOId(ccc.getClientOId());
                    c.setPriceCalculation((PriceCalculationComplete)spcc);
                }
                c.setPriceCalculation(adpcc.getPriceCalculation());
                c.setArticle(adpcc.getArticle());
                list.add(c);
            }
            a.setArticles(list);
            return a;
        }
        return null;
    }

    public static TradeGoodsComplete copyTradeGoods(TradeGoodsComplete gc) {
        TradeGoodsComplete ntg = new TradeGoodsComplete();
        ntg.setClientOId(Long.valueOf(ADTO.getNextId()));
        ntg.setCustomer(gc.getCustomer());
        ntg.setDeliveryAirport(gc.getDeliveryAirport());
        ntg.setEligibleLocations(gc.getEligibleLocations());
        ntg.setEstimatedCost(new PriceComplete(gc.getEstimatedCost()));
        ntg.setOrderRemark(gc.getOrderRemark());
        ntg.setSellName(gc.getSellName());
        ntg.setState(ModificationStateE.DRAFT);
        for (TradeGoodsOrderNumberComplete on : gc.getAssociatedOrderNumbers()) {
            TradeGoodsOrderNumberComplete o = new TradeGoodsOrderNumberComplete();
            o.setClientOId(Long.valueOf(ADTO.getNextId()));
            o.setNumber(on.getNumber());
            ntg.getAssociatedOrderNumbers().add(o);
        }
        for (TradeGoodProductComplete p : gc.getTradeGoodProducts()) {
            TradeGoodProductComplete np = new TradeGoodProductComplete();
            np.setClientOId(Long.valueOf(ADTO.getNextId()));
            np.setProduct(p.getProduct());
            np.setQuantity(p.getQuantity());
            np.setSequenceNumber(p.getSequenceNumber());
            np.setCost(new PriceComplete(p.getCost()));
            ntg.getTradeGoodProducts().add(np);
        }
        return ntg;
    }

    public static CateringServiceScheduleVariantComplete copyCateringServiceScheduleVariant(CateringServiceScheduleVariantComplete org, boolean b) {
        return null;
    }
}

