/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.ArticleChargeConverter;
import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FormulaConverter;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.QuantityConverter0Decimal;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderAcceptationCorrComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderMoveComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPositionMutationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPositionStockCorrMovementComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPositionStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPreparationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPreparationCorrComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRejectionCorrComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckoutGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionContentComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.IStockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckoutCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.StockTransactionRemarkComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionToolkit {
    private static final Logger log = LoggerFactory.getLogger(TransactionToolkit.class);
    public static final int TYPE_CHARGEQUANTITY = 3;
    public static final int TYPE_CHARGEEXPIRY = 5;
    public static final int TYPE_CHARGEPRICE = 7;
    public static final int TYPE_CUSTOMER_INFO = 11;
    public static final int TYPE_PACKAGING_TABLE = 17;
    public static final int USAGE_COMMENT = 13;

    public static Node<?> createBatchView4BasicArticle(BasicArticleComplete article, Node<List<StoreComplete>> stores) {
        HashMap<Object, ViewNode> hash = new HashMap<Object, ViewNode>();
        ViewNode topView = new ViewNode("topView");
        long currentID = System.currentTimeMillis();
        topView.setId(Long.valueOf(currentID++));
        Iterator it = stores.getChilds();
        while (it.hasNext()) {
            Node store = (Node)it.next();
            Iterator it2 = store.getChildNamed(new String[]{"positions"}).getChilds();
            while (it2.hasNext()) {
                Node position = (Node)it2.next();
                Iterator it3 = position.getChildNamed(new String[]{"charges"}).getChilds();
                while (it3.hasNext()) {
                    Node charge = (Node)it3.next();
                    if (!((ArticleChargeComplete)charge.getValue()).getBasicArticle().equals((Object)article)) continue;
                    ViewNode storeView = (ViewNode)hash.get(store.getValue());
                    if (storeView == null) {
                        storeView = new ViewNode("storeView");
                        ViewNode posses = new ViewNode("positions");
                        posses.setId(Long.valueOf(currentID++));
                        store.setName("store");
                        storeView.addChild(store, 0L);
                        storeView.addChild((Node)posses, 0L);
                        storeView.setId(Long.valueOf(currentID++));
                        QuantityComplete qu = (QuantityComplete)charge.getChildNamed(new String[]{"quantity"}).getValue();
                        QuantityComplete nq = new QuantityComplete();
                        nq.setUnit(qu.getUnit());
                        nq.setQuantity(Double.valueOf(0.0));
                        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)nq, false, false);
                        n.setName("defaultQuantity");
                        storeView.addChild(n, 0L);
                        topView.addChild((Node)storeView, 0L);
                        hash.put(store.getValue(), storeView);
                    }
                    storeView.getChildNamed(new String[]{"positions"}).addChild(charge, 0L);
                    Node n = storeView.getChildNamed(new String[]{"expiryDate"});
                    if (n == null) {
                        storeView.addChild(charge.getChildNamed(new String[]{"expiryDate"}), 0L);
                        continue;
                    }
                    Node n2 = charge.getChildNamed(new String[]{"expiryDate"});
                    Date d1 = (Date)n.getValue();
                    Date d2 = (Date)n2.getValue();
                    if (d2.getTime() >= d1.getTime()) continue;
                    storeView.removeChild(n, 0L);
                    storeView.addChild(n2, 0L);
                }
            }
        }
        hash.clear();
        return topView;
    }

    public static String getArticleChargeInfo(ArticleChargeComplete charge) {
        DateTimeConverter c = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
        if (charge == null) {
            return "";
        }
        String t = "";
        Converter conv = ConverterRegistry.getConverter(BasicArticleConverter.class);
        String tlop = (String)conv.convert((Object)charge.getBasicArticle(), null, new Object[0]);
        if (tlop != null && !tlop.isEmpty()) {
            t = t + "<b>" + tlop + "</b><br/><hr/><br/>";
        }
        t = t + "<b>Charge ";
        t = t + charge.getNumber();
        t = t + "</b><ul><li>created at " + c.convert((Object)charge.getCreationDate(), null, new Object[0]) + "</li></ul>";
        t = t + "<b>Customs Documents</b><ul>";
        if (charge.getDocuments() == null || charge.getDocuments().isEmpty()) {
            t = t + "<li>No Documents attached</li>";
        } else {
            for (CustomsDocumentComplete cdc : charge.getDocuments()) {
                t = t + "<li>" + cdc.getCustomsDocumentType().getName() + ": " + cdc.getCustomsDocumentId() + "</li>";
            }
        }
        t = t + "</ul>";
        return t;
    }

    public static Long getLongValue(Node node) {
        if (node == null) {
            return 0L;
        }
        if (node.getValue() == null) {
            return 0L;
        }
        Object o = node.getValue();
        Long ni = 0L;
        if (o instanceof Integer) {
            ni = ((Integer)o).longValue();
        } else if (o instanceof Long) {
            ni = (Long)o;
        } else if (o instanceof Double) {
            Double d = (Double)o;
            ni = Math.round(d);
        }
        if (ni == null) {
            ni = 0L;
        }
        return ni;
    }

    public static Double getDoubleValue(Node node) {
        Object o = node.getValue();
        Double ni = 0.0;
        if (o instanceof Integer) {
            ni = ((Integer)o).doubleValue();
        } else if (o instanceof Long) {
            ni = ((Long)o).doubleValue();
        } else if (o instanceof Double) {
            ni = (Double)o;
        }
        if (ni == null) {
            ni = 0.0;
        }
        return ni;
    }

    public static String getRemarkInfo(StockTransactionRemarkComplete remark, String comment) {
        String t = "";
        t = t + "<b>Remark</b><ul><li>";
        t = remark != null ? t + remark.getDescription() + "</li></ul>" : t + "No remark set</li></ul>";
        if (comment != null) {
            t = t + "<b>Comment</b><ul><li>" + comment + "</li></ul>";
        }
        return t;
    }

    public static String getArticleChargeBatchInfo(ArticleChargeBatchComplete charge) {
        if (charge == null) {
            return null;
        }
        String t = TransactionToolkit.getArticleChargeInfo(charge.getCharge());
        Converter c = ConverterRegistry.getConverter(QuantityConverter0Decimal.class);
        t = t + "<b>Batch Quantity</b><ul>";
        t = t + "<li>" + c.convert((Object)charge.getQuantity(), null, new Object[0]) + " of " + c.convert((Object)charge.getCharge().getQuantity(), null, new Object[0]) + "</li>";
        t = t + "</ul>";
        List packingQuantities = charge.getCharge().getPackingQuantities();
        BasicArticleLight light = charge.getCharge().getBasicArticle();
        BasicArticleComplete complete = (BasicArticleComplete)INodeCreator.getDefaultImpl().getNode4DTO((Object)light, false, false).getValue(BasicArticleComplete.class);
        if (complete == null) {
            try {
                complete = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(light.getId())).getValue();
            }
            catch (ClientServerCallException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        t = t + ArticleToolkit.getArticleInfoPopupString(complete, charge.getCharge().getCreationDate(), 115115, false, null, false, packingQuantities, null);
        return t;
    }

    public static String getCheckoutCorrectionText(StockCheckoutGroupComplete group, ManualStockCheckoutComplete checkout) {
        String t = "<b>Corrections</b><ul>";
        ArrayList<ManualStockCheckoutCorrectionComplete> effectedCorrections = new ArrayList<ManualStockCheckoutCorrectionComplete>();
        for (ManualStockCheckoutCorrectionComplete correction : group.getStockCheckoutCorrections()) {
            if (!checkout.equals((Object)correction.getReferencedTransaction())) continue;
            effectedCorrections.add(correction);
        }
        if (effectedCorrections.isEmpty()) {
            t = t + "<li> no corrections</li>";
        } else {
            Collections.sort(effectedCorrections, (o1, o2) -> o1.getDate().compareTo(o2.getDate()));
            DateTimeConverter dateTimeConverter = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
            for (ManualStockCheckoutCorrectionComplete correction : effectedCorrections) {
                t = t + "<li>" + correction.getUser().getContact().getFirstName() + " " + correction.getUser().getContact().getLastName();
                t = t + " changed from " + correction.getAmountOld() + " " + (correction.getUnitOld() != null ? correction.getUnitOld().getShortName() : "");
                t = t + " to " + correction.getAmount().getAmount() + " " + correction.getAmount().getUnit().getShortName();
                t = t + " at " + dateTimeConverter.convert((Object)correction.getDate(), null, new Object[0]);
                t = t + ", Stock Updated: " + (Boolean.TRUE.equals(correction.getStockUpdated()) ? Words.YES : Words.NO_ANSWER);
                t = t + ", (Type: " + correction.getStockCorrection() + ")";
                t = t + "</li>";
            }
        }
        t = t + "</ul>";
        return t;
    }

    public static String getCheckinCorrectionText(StockCheckinGroupComplete group, ManualStockCheckinComplete checkout) {
        String t = "<b>Corrections</b><ul>";
        ArrayList<ManualStockCheckinCorrectionComplete> effectedCorrections = new ArrayList<ManualStockCheckinCorrectionComplete>();
        for (ManualStockCheckinCorrectionComplete correction : group.getStockCheckinCorrections()) {
            if (!checkout.equals((Object)correction.getReferencedTransaction())) continue;
            effectedCorrections.add(correction);
        }
        if (effectedCorrections.isEmpty()) {
            t = t + "<li> no corrections</li>";
        } else {
            Collections.sort(effectedCorrections, (o1, o2) -> o1.getDate().compareTo(o2.getDate()));
            DateTimeConverter dateTimeConverter = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
            for (ManualStockCheckinCorrectionComplete correction : effectedCorrections) {
                t = t + "<li>" + correction.getUser().getContact().getFirstName() + " " + correction.getUser().getContact().getLastName();
                t = t + " changed from " + correction.getAmountOld() + " " + correction.getUnitOld().getShortName();
                t = t + " to " + correction.getAmount().getAmount() + " " + correction.getAmount().getUnit().getShortName();
                t = t + " at " + dateTimeConverter.convert((Object)correction.getDate(), null, new Object[0]);
                t = t + ", Stock Updated: " + (Boolean.TRUE.equals(correction.getStockUpdated()) ? Words.YES : Words.NO_ANSWER);
                t = t + ", (Type: " + correction.getStockCorrection() + ")";
                t = t + "</li>";
            }
        }
        t = t + "</ul>";
        return t;
    }

    public static String getCheckoutChargeInfo(ManualStockCheckoutComplete out, ArticleChargeComplete charge, int magicNo) {
        String t = TransactionToolkit.getArticleChargeInfo(charge);
        if (charge == null) {
            return "-";
        }
        Converter c = null;
        if (magicNo % 11 == 0) {
            c = ConverterRegistry.getConverter(CustomerConverter.class);
            t = t + "<b>Customer Infos:</b><ul>";
            if (charge.getBasicArticle().getCustomer() != null) {
                t = t + "<li>Owner: " + c.convert((Object)charge.getBasicArticle().getCustomer(), null, new Object[0]) + "</li>";
                t = t + "<li>Customer Art.No: ";
                t = charge.getBasicArticle().getCustomerArticleNumber() != null ? t + charge.getBasicArticle().getCustomerArticleNumber() + "</li>" : t + "-";
                t = t + "<li>Is Owner: ";
                t = charge.getBasicArticle().getCustomerIsOwner().booleanValue() ? t + "true</li>" : t + "false</li>";
            } else {
                t = t + "<li>No Customer set</li>";
            }
            t = t + "</ul>";
        }
        if (magicNo % 13 == 0 && charge.getBasicArticle() != null && charge.getBasicArticle().getUsageComment() != null) {
            t = t + "<b>Usage Comment</b>";
            t = t + "<ul><li>";
            t = t + charge.getBasicArticle().getUsageComment();
            t = t + "</li></ul>";
        }
        if (magicNo % 17 == 0) {
            List packagingQuantity;
            List list = packagingQuantity = charge != null ? charge.getPackingQuantities() : null;
            if (packagingQuantity != null) {
                Converter formulaConverter = ConverterRegistry.getConverter(FormulaConverter.class);
                Node packN = INodeCreator.getDefaultImpl().createNodes(packagingQuantity, false, false);
                t = t + "<b>" + Words.CONVERSION + "</b>";
                t = t + "<ul><li>";
                t = t + formulaConverter.convert(null, packN, new Object[0]);
                t = t + "</li></ul>";
            }
        }
        if (magicNo % 3 == 0) {
            c = ConverterRegistry.getConverter(QuantityConverter2Decimal.class);
            t = t + "<b>Remaining Charge Quantity:</b><ul><li>" + c.convert((Object)charge.getQuantity(), null, new Object[0]) + "</li></ul>";
        }
        if (magicNo % 5 == 0) {
            c = ConverterRegistry.getConverter(DateConverter.class);
            t = t + "<b>Charge Expiry Date:</b><ul><li>" + c.convert((Object)charge.getExpiryDate(), null, new Object[0]) + "</li></ul>";
        }
        if (magicNo % 7 == 0) {
            c = ConverterRegistry.getConverter(PriceConverter2.class);
            t = t + "<b>Charge Price:</b><ul><li>" + c.convert((Object)charge.getPrice(), null, new Object[0]);
            c = ConverterRegistry.getConverter(UnitConverter.class);
            t = t + "/" + c.convert((Object)charge.getPriceUnit(), null, new Object[0]) + "</li></ul>";
        }
        return t;
    }

    public static String getCheckoutChargeInfo(ManualStockCheckoutComplete out, ArticleChargeComplete charge) {
        return TransactionToolkit.getCheckoutChargeInfo(out, charge, 1155);
    }

    public static String getMovementChargeInfo(ManualStockMovementComplete out, ArticleChargeComplete charge, int magicNo) {
        String t = TransactionToolkit.getArticleChargeInfo(charge);
        if (charge == null) {
            return "-";
        }
        Converter c = null;
        if (magicNo % 11 == 0) {
            c = ConverterRegistry.getConverter(CustomerConverter.class);
            t = t + "<b>Customer Infos:</b><ul>";
            if (charge.getBasicArticle().getCustomer() != null) {
                t = t + "<li>Owner: " + c.convert((Object)charge.getBasicArticle().getCustomer(), null, new Object[0]) + "</li>";
                t = t + "<li>Customer Art.No: ";
                t = charge.getBasicArticle().getCustomerArticleNumber() != null ? t + charge.getBasicArticle().getCustomerArticleNumber() + "</li>" : t + "-";
                t = t + "<li>Is Owner: ";
                t = charge.getBasicArticle().getCustomerIsOwner().booleanValue() ? t + "true</li>" : t + "false</li>";
            } else {
                t = t + "<li>No Customer set</li>";
            }
            t = t + "</ul>";
        }
        if (magicNo % 13 == 0 && charge.getBasicArticle() != null && charge.getBasicArticle().getUsageComment() != null) {
            t = t + "<b>Usage Comment</b>";
            t = t + "<ul><li>";
            t = t + charge.getBasicArticle().getUsageComment();
            t = t + "</li></ul>";
        }
        if (magicNo % 3 == 0) {
            c = ConverterRegistry.getConverter(QuantityConverter2Decimal.class);
            t = t + "<b>Remaining Charge Quantity:</b><ul><li>" + c.convert((Object)charge.getQuantity(), null, new Object[0]) + "</li></ul>";
        }
        if (magicNo % 5 == 0) {
            c = ConverterRegistry.getConverter(DateConverter.class);
            t = t + "<b>Charge Expiry Date:</b><ul><li>" + c.convert((Object)charge.getExpiryDate(), null, new Object[0]) + "</li></ul>";
        }
        if (magicNo % 7 == 0) {
            c = ConverterRegistry.getConverter(PriceConverter2.class);
            t = t + "<b>Charge Price:</b><ul><li>" + c.convert((Object)charge.getPrice(), null, new Object[0]);
            c = ConverterRegistry.getConverter(UnitConverter.class);
            t = t + "/" + c.convert((Object)charge.getPriceUnit(), null, new Object[0]) + "</li></ul>";
        }
        if (magicNo % 17 == 0) {
            List packagingQuantity;
            List list = packagingQuantity = charge != null ? charge.getPackingQuantities() : null;
            if (packagingQuantity != null) {
                Converter formulaConverter = ConverterRegistry.getConverter(FormulaConverter.class);
                Node packN = INodeCreator.getDefaultImpl().createNodes(packagingQuantity, false, false);
                t = t + "<b>" + Words.CONVERSION + "</b>";
                t = t + "<ul><li>";
                t = t + formulaConverter.convert(null, packN, new Object[0]);
                t = t + "</li></ul>";
            }
        }
        return t;
    }

    public static String getMovementChargeInfo(ManualStockMovementComplete out, ArticleChargeComplete charge) {
        return TransactionToolkit.getMovementChargeInfo(out, charge, 1155);
    }

    public static String getStorePositionContentInfo(StorePositionContentComplete value) {
        String total = "";
        for (ArticleChargeBatchComplete artCharge : value.getBatches()) {
            String t = TransactionToolkit.getArticleChargeBatchInfo(artCharge);
            total = total + t;
            total = total + "<hr/>";
        }
        if (!total.isEmpty()) {
            total = total.substring(0, total.length() - 10);
        }
        return total;
    }

    public static boolean ensureErrorPopup(Node node, String prefixText, InnerPopUpListener2 listener, Component source) {
        if (node != null && node.getValue() != null) {
            List<ScreenValidationObject> t = TransactionToolkit.processValidationExceptions((Map)node.getValue());
            if (t.isEmpty()) {
                if (listener != null) {
                    listener.popUpClosed(null, new Object[0]);
                }
                return false;
            }
            InnerPopupFactory.showDialog(t, "Move Articles", prefixText, "", listener, source, PopupType.NORMAL);
            return true;
        }
        listener.popUpClosed(null, new Object[0]);
        return false;
    }

    public static boolean hasErrors(Node node) {
        List<ScreenValidationObject> t = TransactionToolkit.processValidationExceptions((Map)node.getValue());
        return !t.isEmpty();
    }

    private static String getArticleNameForTransaction(IStockTransactionComplete trans) {
        Converter c = ConverterRegistry.getConverter(BasicArticleConverter.class);
        Converter c2 = ConverterRegistry.getConverter(ArticleChargeConverter.class);
        if (trans instanceof PurchaseOrderTransactionComplete) {
            return (String)c.convert((Object)((PurchaseOrderTransactionComplete)trans).getOrderPosition().getArticle(), null, new Object[0]);
        }
        if (trans instanceof RequisitionOrderPositionStockCorrMovementComplete) {
            return (String)c.convert((Object)((StockCheckoutComplete)trans).getCharge().getBasicArticle(), null, new Object[0]);
        }
        if (trans instanceof RequisitionOrderPreparationCorrComplete) {
            return (String)c.convert((Object)((StockCheckoutComplete)trans).getCharge().getBasicArticle(), null, new Object[0]);
        }
        if (trans instanceof RequisitionOrderRejectionCorrComplete) {
            return (String)c.convert((Object)((RequisitionOrderRejectionCorrComplete)trans).getCharge().getBasicArticle(), null, new Object[0]);
        }
        if (trans instanceof RequisitionOrderPreparationComplete) {
            return (String)c.convert((Object)((RequisitionOrderPreparationComplete)trans).getCharge().getBasicArticle(), null, new Object[0]);
        }
        if (trans instanceof RequisitionOrderPositionStockMovementComplete) {
            return (String)c.convert((Object)((RequisitionOrderPositionStockMovementComplete)trans).getBatch().getCharge().getBasicArticle(), null, new Object[0]);
        }
        if (trans instanceof RequisitionOrderAcceptationComplete) {
            return (String)c.convert((Object)((RequisitionOrderAcceptationComplete)trans).getCharge().getBasicArticle(), null, new Object[0]);
        }
        if (trans instanceof RequisitionOrderPositionMutationComplete) {
            return (String)c.convert((Object)((RequisitionOrderPositionMutationComplete)trans).getOrderPosition().getArticle(), null, new Object[0]);
        }
        if (trans instanceof RequisitionOrderMoveComplete) {
            return (String)c.convert((Object)((RequisitionOrderMoveComplete)trans).getCharge().getBasicArticle(), null, new Object[0]);
        }
        if (trans instanceof RequisitionOrderAcceptationCorrComplete) {
            return (String)c.convert((Object)((RequisitionOrderAcceptationCorrComplete)trans).getCharge().getBasicArticle(), null, new Object[0]);
        }
        if (trans instanceof RequisitionOrderRejectionComplete) {
            return (String)c.convert((Object)((RequisitionOrderRejectionComplete)trans).getCharge().getBasicArticle(), null, new Object[0]);
        }
        if (trans instanceof StockCheckinComplete) {
            return (String)c.convert((Object)((StockCheckinComplete)trans).getArticle(), null, new Object[0]);
        }
        if (trans instanceof StockCheckoutComplete) {
            return (String)c2.convert((Object)((StockCheckoutComplete)trans).getCharge(), null, new Object[0]);
        }
        if (trans instanceof StockInventoryComplete) {
            return (String)c.convert((Object)((StockInventoryComplete)trans).getArticle(), null, new Object[0]);
        }
        if (trans instanceof StockMovementComplete) {
            return (String)c2.convert((Object)((StockMovementComplete)trans).getCharge(), null, new Object[0]);
        }
        return "";
    }

    public static List<ScreenValidationObject> processValidationExceptions(Map<IStockTransactionComplete, String> map) {
        ArrayList<ScreenValidationObject> r = new ArrayList<ScreenValidationObject>();
        for (IStockTransactionComplete trans : map.keySet()) {
            String t = map.get(trans);
            String articleNameForTransaction = TransactionToolkit.getArticleNameForTransaction(trans);
            if (t == null || t.isEmpty()) {
                t = articleNameForTransaction + ": Movement performed";
                r.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, t));
                continue;
            }
            t = articleNameForTransaction + ": " + t;
            r.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, t));
        }
        return r;
    }
}

