/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.loaders;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;

public class ArticleChargeLoader
extends ThreadSafeExecutable {
    private ArticleChargeLight artL;
    private RemoteLoader loader;
    private Node cn;

    public ArticleChargeLoader(ArticleChargeLight artL, RemoteLoader loader, Node cn, Object caller) {
        super(caller);
        this.artL = artL;
        this.loader = loader;
        this.cn = cn;
        ThreadSafeLoader.run(this);
    }

    @Override
    public Node<?> loadData() throws Exception {
        try {
            ArticleChargeComplete a = ArticleChargeLoader.loadArticle(this.artL);
            this.cn.setValue((Object)a, 0L);
            return this.cn;
        }
        catch (ClientGetFromServerException e) {
            ViewNode r = new ViewNode("Error");
            r.setValue((Object)e, 0L);
            return r;
        }
    }

    @Override
    public RemoteLoader getInvoker() {
        return this.loader;
    }

    @Override
    public long getID() {
        return 0L;
    }

    public static ArticleChargeComplete loadArticle(ArticleChargeLight l) throws ClientServerCallException {
        return (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge(new ArticleChargeReference(l.getId())).getValue();
    }
}

