/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.QuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ArticleQuantityTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();

    public ArticleQuantityTable() {
        super(true, Words.ADD, false, false, Words.ARTICLES);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ArticleQuantityTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                SimpleComponentComplete comp = new SimpleComponentComplete();
                comp.setClientOId(Long.valueOf(ADTO.getNextId()));
                comp.setQuantity((QuantityInterpolationComplete)new LinearQuantityInterpolationComplete());
                comp.getQuantity().setClientOId(Long.valueOf(ADTO.getNextId()));
                ArticleQuantityTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)comp, true, false), 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ARTICLE, null, null, null, "", 40, 40, 40));
        int qw = InputComboBox2.getPreferredWidth(this, 11) + 2 * this.getCellPadding();
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", qw, qw, qw));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<BasicArticleLight> article;
        private InputComboBox2 quantity;
        private DeleteButton delete;
        private BasicArticleLight bal;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.article = SearchTextField2Factory.getBasicArticleSearchField(true, m.getNode().getChildNamed(SimpleComponentComplete_.article));
            this.article.addSearchTextFieldListener((source, n) -> {
                if (n.getValue(BasicArticleLight.class) == null) {
                    BasicArticleReference bar = (BasicArticleReference)n.getValue();
                    new BasicArticleLoader(bar, new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            TableRowImpl.this.bal = (BasicArticleLight)node.getValue(BasicArticleLight.class);
                            TableRowImpl.this.articleLoaded();
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)TableRowImpl.this);
                        }
                    }, m.getNode().getChildNamed(SimpleComponentComplete_.article), this);
                } else {
                    this.bal = (BasicArticleLight)n.getValue(BasicArticleLight.class);
                    this.articleLoaded();
                }
            });
            Node qty = m.getNode().getChildNamed(new DtoField[]{SimpleComponentComplete_.quantity, LinearQuantityInterpolationComplete_.resultingQuantity});
            this.quantity = new InputComboBox2(qty.getChildNamed(QuantityComplete_.quantity), qty.getChildNamed(QuantityComplete_.unit), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout3());
            this.add(this.article);
            this.add(this.quantity);
            this.add(this.delete);
        }

        private void articleLoaded() {
            List possibleUnits = UnitConversionToolkit.getPossibleUnits((BasicArticleLight)this.bal, (Timestamp)new Timestamp(System.currentTimeMillis()), (boolean)true, (SystemSettingsComplete)ArticleQuantityTable.this.settings);
            ViewNode n = new ViewNode("");
            n.setValue((Object)possibleUnits, 0L);
            this.quantity.setPossibleUnits((Node)n);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public boolean isInnerComponent(Component c) {
            boolean b = this.article.isInnerComponent(c);
            if (b) {
                return true;
            }
            return super.isInnerComponent(c);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.article.kill();
            this.delete.kill();
            this.quantity.kill();
            this.article = null;
            this.delete = null;
            this.quantity = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.article);
            CheckedListAdder.addToList(a, this.quantity);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

