/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.rightdependant;

import ch.icit.pegasus.client.gui.utils.rightdependant.RDProviderRule;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataFieldRightsE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.util.ArrayList;
import java.util.List;

public class RDProvider {
    private ModuleAccessRightComplete accessRight;
    private boolean isAdd;
    private boolean isDeleted;
    private RDProviderRule additionalRule;
    private List<SubModuleAccessRightComplete> subRights = new ArrayList<SubModuleAccessRightComplete>();
    private List<String> useAccessRightsAnyway = new ArrayList<String>();

    public RDProvider(ModuleAccessRightComplete accessRight, boolean isAdd) {
        this.accessRight = accessRight;
        this.isAdd = isAdd;
    }

    public RDProvider(UserComplete user, AccessDefinitionComplete module) {
        for (ModuleAccessRightComplete m : user.getModules()) {
            if (!m.getModule().getInvokingName().equals(module.getIdentifier())) continue;
            this.accessRight = m;
        }
        if (this.accessRight == null) {
            throw new IllegalStateException("No access");
        }
    }

    public RDProvider(ModuleAccessRightComplete accessRight) {
        this.accessRight = accessRight;
        this.isAdd = false;
    }

    public void addAccessRightToUseItAnyway(DtoField g) {
        this.addAccessRightToUseItAnyway(g.getFieldName());
    }

    public void addAccessRightToUseItAnyway(String g) {
        this.useAccessRightsAnyway.add(g);
    }

    public boolean getDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public boolean isWritable(DtoField field) {
        return this.isWritable(field.getFieldName());
    }

    public boolean isTrue(DtoField field) {
        return this.isWritable(field.getName(), true);
    }

    @Deprecated
    public boolean isWritable(String field) {
        return this.isWritable(field, false);
    }

    public boolean isWritable(String field, boolean ignoreAddState) {
        if (!ignoreAddState && this.isAdd && !this.useAccessRightsAnyway.contains(field)) {
            return true;
        }
        if (this.isDeleted) {
            return false;
        }
        if (this.accessRight == null) {
            return false;
        }
        for (DataFieldAccessRightComplete fa : this.accessRight.getFieldAccessRights()) {
            if (!fa.getField().getName().equals(field)) continue;
            if (this.additionalRule != null) {
                return this.additionalRule.canAccess(field, this);
            }
            return true;
        }
        return false;
    }

    public boolean isAddable(DtoField field) {
        return this.isAddable(field.getFieldName());
    }

    @Deprecated
    public boolean isAddable(String field) {
        if (this.isAdd) {
            return true;
        }
        if (this.isDeleted) {
            return false;
        }
        if (this.accessRight == null) {
            return false;
        }
        for (DataFieldAccessRightComplete fa : this.accessRight.getFieldAccessRights()) {
            if (!fa.getField().getName().equals(field) || fa.getAccessRight() != DataFieldRightsE.ADD) continue;
            if (this.additionalRule != null) {
                return this.additionalRule.canAccess(field, this);
            }
            return true;
        }
        return false;
    }

    public boolean isDeletable(DtoField field) {
        return this.isDeletable(field.getFieldName());
    }

    public boolean isDeletable(String field) {
        if (this.isAdd) {
            return true;
        }
        if (this.isDeleted) {
            return false;
        }
        if (this.accessRight == null) {
            return false;
        }
        for (DataFieldAccessRightComplete fa : this.accessRight.getFieldAccessRights()) {
            if (!fa.getField().getName().equals(field) || fa.getAccessRight() != DataFieldRightsE.REMOVE) continue;
            if (this.additionalRule != null) {
                return this.additionalRule.canAccess(field, this);
            }
            return true;
        }
        return false;
    }

    public boolean isOrderChangable(DtoField<?> field) {
        return this.isOrderChangable(field.getFieldName());
    }

    public boolean isOrderChangable(String field) {
        if (this.isAdd) {
            return true;
        }
        if (this.isDeleted) {
            return false;
        }
        if (this.accessRight == null) {
            return false;
        }
        for (DataFieldAccessRightComplete fa : this.accessRight.getFieldAccessRights()) {
            if (!fa.getField().getName().equals(field) || fa.getAccessRight() != DataFieldRightsE.CHANGEORDER) continue;
            if (this.additionalRule != null) {
                return this.additionalRule.canAccess(field, this);
            }
            return true;
        }
        return false;
    }

    public boolean hasSubRight(AccessDefinitionComplete module) {
        return this.hasSubRight(module.getIdentifier());
    }

    public boolean hasSubRight(String module) {
        if (this.accessRight == null) {
            return false;
        }
        for (SubModuleAccessRightComplete r : this.accessRight.getSubModules()) {
            if (!r.getModule().getInvokingName().equals(module)) continue;
            return true;
        }
        for (SubModuleAccessRightComplete r : this.subRights) {
            if (r == null || r.getModule() == null || r.getModule().getInvokingName() == null || !r.getModule().getInvokingName().equals(module)) continue;
            return true;
        }
        return false;
    }

    public void setAdditionalRule(RDProviderRule providerRule) {
        this.additionalRule = providerRule;
    }

    public RDProviderRule getAdditionalRule() {
        return this.additionalRule;
    }

    public List<SubModuleAccessRightComplete> getAdditionalSubModuleRights() {
        return this.subRights;
    }
}

