/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.productionweeklyplan.label;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2ViewFactory;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanelLayout;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.label.BoxLabelCalculator;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.label.ProductionLabelTableHeader;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.textfield.PlainTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.production_new.FoodContainerComplete;
import ch.icit.pegasus.server.core.dtos.production_new.FoodContainerComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete_;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;

public class ProductionLabelViewTable
extends ScrollableBackground {
    private Node<WeeklyPlanComplete> node;
    private Table2 dataTable;
    private BoxLabelCalculator boxLabelCalculator;

    public ProductionLabelViewTable(RDProvider provider) {
        super(false);
        this.getScrollPane().setHorizontalScrollBarPolicy(30);
        this.boxLabelCalculator = new BoxLabelCalculator();
        this.dataTable = new Table2(false, "");
        this.dataTable.getFatLines().add(2);
        this.dataTable.getFatLines().add(6);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(1.0, "Item", 0, 300, Integer.MAX_VALUE));
        columns.add(new TableColumnInfo(0.0, "Product", 75));
        columns.add(new TableColumnInfo(0.0, "Recipe", 75));
        columns.add(new TableColumnInfo(0.0, "Box", 150));
        columns.add(new TableColumnInfo(0.0, "Lid", 150));
        columns.add(new TableColumnInfo(0.0, "Default<br/>Label", 150));
        columns.add(new TableColumnInfo(0.0, "Additional<br/>Label", 150));
        columns.add(new TableColumnInfo(0.0, "Quantity", 75));
        columns.add(new TableColumnInfo(0.0, "Produce", 75));
        this.dataTable.setModel(new Table2Model(columns, new Table2ViewFactory(){

            @Override
            public Table2RowPanel getRowPanel(Table2RowModel model) {
                return ProductionLabelViewTable.this.createRow(model);
            }

            @Override
            public Table2RowPanel getHeaderPane(Table2RowModel model) {
                return new ProductionLabelTableHeader(model);
            }
        }));
        this.getViewPort().setLayout(new Layout());
        this.getViewPort().add(this.dataTable);
    }

    public void setNode(Node<WeeklyPlanComplete> node) {
        this.node = node;
        this.dataTable.getModel().setNode(node.getChildNamed(WeeklyPlanComplete_.foodContainers));
        this.boxLabelCalculator.setNode(this.node);
        this.boxLabelCalculator.updateSum();
        this.revalidate();
    }

    private Table2RowPanel createRow(Table2RowModel model) {
        TextLabel recipeNo;
        TextLabel itemName;
        DefaultTable2RowPanel row = new DefaultTable2RowPanel(model);
        FoodContainerComplete container = (FoodContainerComplete)model.getNode().getValue();
        if (container.getRecipe() != null) {
            itemName = new TextLabel(container.getRecipe().getCurrentVariant().getName());
            recipeNo = new TextLabel(container.getRecipe().getNumber() + "");
        } else {
            itemName = new TextLabel(container.getProduct().getCurrentVariant().getName());
            recipeNo = new TextLabel("");
        }
        row.addLayoutComponent(itemName, DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(container.getProduct().getNumber() + ""), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(recipeNo, DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(FoodContainerComplete_.foodBox), ConverterRegistry.getConverter(BasicArticleConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(FoodContainerComplete_.lid), ConverterRegistry.getConverter(BasicArticleConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(FoodContainerComplete_.boxLabel), ConverterRegistry.getConverter(BasicArticleConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(SearchTextField2Factory.getBasicArticleSearchField(true, model.getNode().getChildNamed(FoodContainerComplete_.additionalLabel)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(FoodContainerComplete_.quantity), ConverterRegistry.getConverter(IntegerConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new PlainTextField(model.getNode().getChildNamed(FoodContainerComplete_.manualQuantity), TextFieldType.INT), DefaultTable2RowPanelLayout.LayoutType.FILL);
        return row;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 150);
        }

        @Override
        public void layoutContainer(Container parent) {
            ProductionLabelViewTable.this.dataTable.setLocation(0, 0);
            ProductionLabelViewTable.this.dataTable.setSize(parent.getWidth(), parent.getHeight());
        }
    }
}

