/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.panels.PaxLegTable;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PaxEditPopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private PaxLegTable panel;

    public PaxEditPopupInsert(Node<FlightLight> flight, Map<FlightScheduleLegComplete, Map<CabinClassComplete, Integer>> map) {
        ArrayList<Node<SeatConfigurationComplete>> listOfSeatNodes = new ArrayList<Node<SeatConfigurationComplete>>();
        ArrayList<Node<? extends ALegComplete>> listOfLegNodes = new ArrayList<Node<? extends ALegComplete>>();
        Iterator it = flight.getChildNamed(new String[]{"flightSchedule-legs"}).getFailSafeChildIterator();
        while (it.hasNext()) {
            listOfLegNodes.add((Node)it.next());
        }
        it = flight.getChildNamed(new String[]{"flightSchedule-defaultStowingList-stowingList-seatConfigurations"}).getFailSafeChildIterator();
        while (it.hasNext()) {
            listOfSeatNodes.add((Node)it.next());
        }
        this.panel = new PaxLegTable(listOfSeatNodes, listOfLegNodes, map);
        this.setLayout(new Layout());
        this.add(this.panel);
    }

    public Map<? extends ALegComplete, Map<CabinClassComplete, Integer>> getMap() {
        return this.panel.getMap();
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.panel.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.panel.kill();
        this.panel = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return PaxEditPopupInsert.this.panel.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            PaxEditPopupInsert.this.panel.setLocation(0, 0);
            PaxEditPopupInsert.this.panel.setSize(parent.getSize());
        }
    }
}

