/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.StringPopUpInsert;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import java.awt.Component;
import java.sql.Date;
import java.sql.Timestamp;

public class ArticleInfoLoadingPopupInsert
extends StringPopUpInsert {
    private static final long serialVersionUID = 1L;
    private Node artNode;
    private int currentMagicNumber;
    private final Node<Date> validityNode;
    private String additionalText;

    public ArticleInfoLoadingPopupInsert(Node articleNode, Node<Date> validityNode, int magicNr) {
        this(articleNode, validityNode, magicNr, "");
    }

    public ArticleInfoLoadingPopupInsert(Node articleNode, Node<Date> validityNode, int magicNr, String additionalText) {
        super((String)null);
        this.validityNode = validityNode;
        this.additionalText = additionalText;
        this.currentMagicNumber = magicNr;
        this.artNode = articleNode;
        if (this.artNode.getValue(BasicArticleComplete.class) == null) {
            if (this.artNode.getValue(BasicArticleReference.class) == null) {
                this.remoteObjectLoaded(articleNode);
            } else {
                this.ensureAnimation("Load Article", "Load Article");
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        BasicArticleLight l = (BasicArticleLight)ArticleInfoLoadingPopupInsert.this.artNode.getValue();
                        try {
                            BasicArticleComplete ac = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)l).getValue();
                            ArticleInfoLoadingPopupInsert.this.artNode.removeExistingValues();
                            ArticleInfoLoadingPopupInsert.this.artNode.setValue((Object)ac, 0L);
                            return ArticleInfoLoadingPopupInsert.this.artNode;
                        }
                        catch (ClientGetFromServerException e) {
                            ViewNode r = new ViewNode("Error");
                            r.setValue((Object)e, 0L);
                            return r;
                        }
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return ArticleInfoLoadingPopupInsert.this;
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            }
        } else {
            this.remoteObjectLoaded(articleNode);
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (node != null && node.getValue() instanceof ClientServerCallException) {
            InnerPopupFactory.showErrorDialog((Exception)((Object)((ClientServerCallException)((Object)node.getValue()))), (Component)this);
            this.hideAnimation();
            return;
        }
        this.hideAnimation();
        Object fromTimestamp = this.validityNode.getValue();
        Timestamp timestamp = fromTimestamp == null ? new Timestamp(System.currentTimeMillis()) : (fromTimestamp instanceof Timestamp ? (Timestamp)fromTimestamp : new Timestamp(((Date)fromTimestamp).getTime()));
        String t = ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)node.getValue(BasicArticleComplete.class), timestamp, this.currentMagicNumber, true);
        if (this.additionalText != null) {
            t = t + this.additionalText;
        }
        this.initMultiLabelThings(t, true);
    }
}

