/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.EnterMessagePopupInsert;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionLight;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Timestamp;
import java.util.List;
import javax.swing.JComponent;

public class AllergenCheckPopUpInsert
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private final PurchaseOrderPositionLight position;
    private final boolean infoOnly;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private Color backgroundColor;
    protected MultiLineTextLabel label;
    private LoadingAnimation loadingAnimation;
    private TextButton checkAllergensOk;
    private TextButton checkAllergensNotOk;

    public AllergenCheckPopUpInsert(String text, PurchaseOrderPositionLight position, boolean infoOnly) {
        this.position = position;
        this.infoOnly = infoOnly;
        this.initLayout();
        this.initMultiLabelThings(text);
    }

    protected void ensureAnimation(String current) {
        if (this.loadingAnimation == null) {
            this.loadingAnimation = new LoadingAnimation();
            this.loadingAnimation.stateChanged(current);
            this.viewPort.add(this.loadingAnimation);
            this.loadingAnimation.start();
            this.loadingAnimation.fadeIn();
        }
        if (this.label != null) {
            this.label.fadeOut(false);
        }
    }

    protected void hideAnimation() {
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.fadeOut(true);
            this.loadingAnimation = null;
        }
        if (this.label != null) {
            this.label.fadeIn();
        }
    }

    private void initLayout() {
        this.setOpaque(false);
        this.setLayout(new InnerLayout());
    }

    private void doSaveAllergenSpotCheck() {
        this.checkAllergensNotOk.fadeOut(true);
        this.checkAllergensOk.fadeOut(true);
        this.ensureAnimation("Save Allergen Check");
        this.loadingAnimation.fadeIn();
        this.popup.enableOKButton(false);
        this.saveData();
    }

    private void initMultiLabelThings(String text) {
        this.label = new MultiLineTextLabel();
        this.label.getFader().setPermanent(true);
        this.backgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.backgroundColor);
        this.viewPort = new Port();
        this.viewPort.setLayout(new ViewPortLayout());
        if (!this.infoOnly) {
            this.checkAllergensOk = new TextButton("Allergens Ok");
            this.checkAllergensNotOk = new TextButton("Allergens Not Ok");
            this.checkAllergensOk.addButtonListener((source, x, y) -> {
                this.position.setAllergenChecked(Boolean.valueOf(true));
                this.position.setAllergenCheckDate(new Timestamp(System.currentTimeMillis()));
                this.position.setAllergenCheckUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                this.position.setAllergenCheckComment("");
                this.position.setAllergenStatus(Boolean.valueOf(true));
                this.doSaveAllergenSpotCheck();
            });
            this.checkAllergensNotOk.addButtonListener((source, x, y) -> {
                this.position.setAllergenChecked(Boolean.valueOf(true));
                this.position.setAllergenCheckDate(new Timestamp(System.currentTimeMillis()));
                this.position.setAllergenCheckUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                this.position.setAllergenStatus(Boolean.valueOf(false));
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, "Allergen deviation comment");
                Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)this.position.getAllergenCheckComment(), false, false);
                popUp.setView(new EnterMessagePopupInsert(node));
                InnerPopUpListener2 listener2 = (source1, xargs) -> {
                    if (xargs == null) {
                        this.position.setAllergenChecked(Boolean.valueOf(false));
                        this.position.setAllergenCheckDate(null);
                        this.position.setAllergenCheckUser(null);
                        this.position.setAllergenStatus(Boolean.valueOf(false));
                    } else {
                        this.position.setAllergenCheckComment((String)node.getValue());
                    }
                    this.doSaveAllergenSpotCheck();
                };
                popUp.showPopUp(x, y, 400, 400, listener2, source, PopupType.NORMAL);
            });
        }
        this.setText(text);
        this.viewPort.add(this.label);
        if (!this.infoOnly) {
            this.viewPort.add(this.checkAllergensNotOk);
            this.viewPort.add(this.checkAllergensOk);
        }
        this.scrollPane.setViewportView(this.viewPort);
        this.add(this.scrollPane);
        this.invalidate();
        this.validate();
    }

    private void saveData() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).saveAllergenCheck((PurchaseOrderPositionComplete)AllergenCheckPopUpInsert.this.position);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        AllergenCheckPopUpInsert.this.hideAnimation();
                        AllergenCheckPopUpInsert.this.popup.enableOKButton(true);
                        AllergenCheckPopUpInsert.this.label.setText("Allergen Check saved");
                    }

                    public void errorOccurred(ClientException exception) {
                        AllergenCheckPopUpInsert.this.hideAnimation();
                        AllergenCheckPopUpInsert.this.popup.enableOKButton(true);
                        AllergenCheckPopUpInsert.this.label.setText("Allergen Check not saved");
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)AllergenCheckPopUpInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.label != null) {
            this.label.kill();
            this.label = null;
        }
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.kill();
            this.loadingAnimation = null;
        }
    }

    public void setText(String t) {
        if (this.label != null) {
            this.label.setLabelText(t);
        }
    }

    public String getText() {
        if (this.label != null) {
            return this.label.getText();
        }
        return "";
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            return new Object[1];
        }
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)AllergenCheckPopUpInsert.this.scrollPane.getWidth() - AllergenCheckPopUpInsert.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)AllergenCheckPopUpInsert.this.label.getPreferredSize().getHeight();
            if (!AllergenCheckPopUpInsert.this.infoOnly && AllergenCheckPopUpInsert.this.checkAllergensNotOk != null) {
                h += 5;
                h = (int)((double)h + AllergenCheckPopUpInsert.this.checkAllergensNotOk.getPreferredSize().getHeight());
            }
            if (AllergenCheckPopUpInsert.this.loadingAnimation != null && (double)h < AllergenCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight()) {
                h = (int)AllergenCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight();
            }
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            AllergenCheckPopUpInsert.this.label.setLocation(0, 0);
            AllergenCheckPopUpInsert.this.label.setSize(parent.getWidth(), (int)AllergenCheckPopUpInsert.this.label.getPreferredSize().getHeight());
            if (AllergenCheckPopUpInsert.this.loadingAnimation != null) {
                AllergenCheckPopUpInsert.this.loadingAnimation.setSize(AllergenCheckPopUpInsert.this.loadingAnimation.getPreferredSize());
                AllergenCheckPopUpInsert.this.loadingAnimation.setLocation((parent.getWidth() - AllergenCheckPopUpInsert.this.loadingAnimation.getWidth()) / 2, (parent.getHeight() - AllergenCheckPopUpInsert.this.loadingAnimation.getHeight()) / 2);
            }
            if (!AllergenCheckPopUpInsert.this.infoOnly) {
                if (AllergenCheckPopUpInsert.this.checkAllergensOk != null && AllergenCheckPopUpInsert.this.checkAllergensOk.getFader() != null && AllergenCheckPopUpInsert.this.checkAllergensOk.getFader().isFaded()) {
                    AllergenCheckPopUpInsert.this.checkAllergensOk.setLocation(5, AllergenCheckPopUpInsert.this.label.getY() + AllergenCheckPopUpInsert.this.label.getHeight() + 5);
                    AllergenCheckPopUpInsert.this.checkAllergensOk.setSize(AllergenCheckPopUpInsert.this.checkAllergensOk.getPreferredSize());
                }
                if (AllergenCheckPopUpInsert.this.checkAllergensNotOk != null && AllergenCheckPopUpInsert.this.checkAllergensNotOk.getFader() != null && AllergenCheckPopUpInsert.this.checkAllergensNotOk.getFader().isFaded()) {
                    AllergenCheckPopUpInsert.this.checkAllergensNotOk.setLocation((int)((double)parent.getWidth() - (5.0 + AllergenCheckPopUpInsert.this.checkAllergensNotOk.getPreferredSize().getWidth())), AllergenCheckPopUpInsert.this.label.getY() + AllergenCheckPopUpInsert.this.label.getHeight() + 5);
                    AllergenCheckPopUpInsert.this.checkAllergensNotOk.setSize(AllergenCheckPopUpInsert.this.checkAllergensNotOk.getPreferredSize());
                }
            }
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(AllergenCheckPopUpInsert.this.backgroundColor);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (AllergenCheckPopUpInsert.this.loadingAnimation != null) {
                AllergenCheckPopUpInsert.this.loadingAnimation.setLocation((int)((double)parent.getWidth() - AllergenCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - AllergenCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight()) / 2.0));
                AllergenCheckPopUpInsert.this.loadingAnimation.setSize(AllergenCheckPopUpInsert.this.loadingAnimation.getPreferredSize());
            }
            if (AllergenCheckPopUpInsert.this.scrollPane != null) {
                AllergenCheckPopUpInsert.this.scrollPane.setLocation(0, 0);
                AllergenCheckPopUpInsert.this.scrollPane.setSize(parent.getSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension();
            if (AllergenCheckPopUpInsert.this.userPrefHeight != null) {
                d.setSize(d.getWidth(), (double)AllergenCheckPopUpInsert.this.userPrefHeight.intValue());
            } else if (AllergenCheckPopUpInsert.this.viewPort != null) {
                d.setSize(d.getWidth(), AllergenCheckPopUpInsert.this.viewPort.getPreferredSize().getHeight());
            } else {
                d.setSize(d.getWidth(), (double)(AllergenCheckPopUpInsert.this.loadingAnimation.getHeight() + 10));
            }
            if (AllergenCheckPopUpInsert.this.userPrefWidth != null) {
                d.setSize((double)AllergenCheckPopUpInsert.this.userPrefWidth.intValue(), d.getHeight());
            } else if (AllergenCheckPopUpInsert.this.viewPort != null) {
                d.setSize(AllergenCheckPopUpInsert.this.viewPort.getPreferredSize().getWidth(), d.getHeight());
            } else {
                d.setSize(AllergenCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getWidth() + 10.0, d.getHeight());
            }
            return d;
        }
    }
}

