/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.datechooser;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class TitledDateTimePeriodChooser
extends DefaultPanel
implements Nodable,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateTimeChooser> start;
    private ArrowConnectorIcon connector;
    private TitledItem<DateTimeChooser> end;
    private int border = 3;
    private Node<?> node;

    public TitledDateTimePeriodChooser() {
        this(null, null);
    }

    public TitledDateTimePeriodChooser(Node<Timestamp> startNode, Node<Timestamp> endNode) {
        this.start = new TitledItem<DateTimeChooser>(new DateTimeChooser(startNode), Words.START, TitledItem.TitledItemOrientation.NORTH);
        this.end = new TitledItem<DateTimeChooser>(new DateTimeChooser(endNode), Words.END, TitledItem.TitledItemOrientation.NORTH);
        this.connector = new ArrowConnectorIcon(4);
        this.setLayout(new Layout());
        this.add(this.start);
        this.add(this.end);
        this.add(this.connector);
    }

    public TitledDateTimePeriodChooser(Node<TimestampPeriodComplete> node) {
        this((Node<Timestamp>)node.getChildNamed(TimestampPeriodComplete_.startTime), (Node<Timestamp>)node.getChildNamed(TimestampPeriodComplete_.endTime));
        this.node = node;
    }

    public void setTitleText(String titleStartDate, String titleEndDate) {
        this.start.setTitleText(titleStartDate);
        this.end.setTitleText(titleEndDate);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.start);
        CheckedListAdder.addToList(focusList, this.end);
        return focusList;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.start.setVisibleContainer(pane);
        this.end.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.start.requestFocusInWindowNow();
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        this.setNode((Node<Timestamp>)node.getChildNamed(TimestampPeriodComplete_.startTime), (Node<Timestamp>)node.getChildNamed(TimestampPeriodComplete_.endTime));
    }

    public void setNode(Node<Timestamp> snode, Node<Timestamp> enode) {
        this.start.getElement().setNode(snode);
        this.end.getElement().setNode(enode);
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.start.setEnabled(isEnabled);
        this.end.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.start.kill();
        this.end.kill();
        this.connector.kill();
        this.start = null;
        this.end = null;
        this.connector = null;
    }

    public TimestampPeriodComplete getTimePeriod() {
        Timestamp start = this.start.getElement().getTimestamp();
        Timestamp end = this.end.getElement().getTimestamp();
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(start.getTime());
        instance.set(13, 0);
        instance.set(14, 0);
        start.setTime(instance.getTimeInMillis());
        instance.setTimeInMillis(end.getTime());
        instance.set(13, 0);
        instance.set(14, 0);
        end.setTime(instance.getTimeInMillis());
        return new TimestampPeriodComplete(start, end);
    }

    public DateTimeChooser getStartTimeChooser() {
        return this.start.getElement();
    }

    public DateTimeChooser getEndTimeChooser() {
        return this.end.getElement();
    }

    @Override
    public String getPersistString() {
        return null;
    }

    @Override
    public void loadState(String state, String id) {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean shouldPersist() {
        return false;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)TitledDateTimePeriodChooser.this.start.getPreferredSize().getHeight();
            int w = (int)(TitledDateTimePeriodChooser.this.start.getPreferredSize().getWidth() + (double)TitledDateTimePeriodChooser.this.border + TitledDateTimePeriodChooser.this.connector.getPreferredSize().getWidth() + (double)TitledDateTimePeriodChooser.this.border + TitledDateTimePeriodChooser.this.end.getPreferredSize().getWidth());
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            TitledDateTimePeriodChooser.this.start.setLocation(0, 0);
            TitledDateTimePeriodChooser.this.start.setSize(TitledDateTimePeriodChooser.this.start.getPreferredSize());
            TitledDateTimePeriodChooser.this.connector.setLocation(TitledDateTimePeriodChooser.this.start.getWidth() + TitledDateTimePeriodChooser.this.border, (int)((double)parent.getHeight() - (TitledDateTimePeriodChooser.this.connector.getPreferredSize().getHeight() + 6.0)));
            TitledDateTimePeriodChooser.this.connector.setSize(TitledDateTimePeriodChooser.this.connector.getPreferredSize());
            TitledDateTimePeriodChooser.this.end.setLocation(TitledDateTimePeriodChooser.this.connector.getX() + TitledDateTimePeriodChooser.this.connector.getWidth() + TitledDateTimePeriodChooser.this.border, 0);
            TitledDateTimePeriodChooser.this.end.setSize(TitledDateTimePeriodChooser.this.end.getPreferredSize());
        }
    }
}

