/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RadioButtonBox
extends JPanelKillable
implements Focusable,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    private int border = 10;
    private List<Component> box = new ArrayList<Component>();
    private List<RadioButton> buttons = new ArrayList<RadioButton>();
    private List<HorizontalSeparator> optionSeparaters = new ArrayList<HorizontalSeparator>();
    private boolean useSeparators = false;
    private int orientation = 1;
    private int column;

    public RadioButtonBox() {
        this.setOpaque(false);
        this.setLayout(new Layout());
    }

    public List<RadioButton> getButtons() {
        return this.buttons;
    }

    private void ensureHorizontalLines() {
        int h;
        int c = this.buttons.size();
        if (c - 1 > (h = this.optionSeparaters.size())) {
            while (c - 1 > h) {
                HorizontalSeparator s = new HorizontalSeparator();
                this.add(s);
                this.optionSeparaters.add(s);
                h = this.optionSeparaters.size();
            }
        } else {
            while (c - 1 < h && !this.optionSeparaters.isEmpty()) {
                HorizontalSeparator s = this.optionSeparaters.get(0);
                this.remove(s);
                this.optionSeparaters.remove(s);
                h = this.optionSeparaters.size();
            }
        }
    }

    public void setBorder(int b) {
        this.border = b;
    }

    public void setOrientation(int i) {
        this.orientation = i;
    }

    public void setColumn(int i) {
        this.column = i;
    }

    public RadioButton getAnyButton() {
        if (this.buttons.size() > 0) {
            return this.buttons.get(0);
        }
        return null;
    }

    public RadioButton getSelectedButton() {
        for (RadioButton b : this.buttons) {
            if (!b.isChecked()) continue;
            return b;
        }
        return null;
    }

    public void addBox(Component c, RadioButton button) {
        this.box.add(c);
        this.buttons.add(button);
        this.add(c);
        if (this.useSeparators) {
            this.ensureHorizontalLines();
        }
    }

    public void setUseSeparators(boolean useSeparators) {
        this.useSeparators = useSeparators;
    }

    public void setChecked(RadioButton b) {
        for (RadioButton bb : this.buttons) {
            if (b.equals(bb)) continue;
            bb.setChecked(false);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (Component c : this.box) {
            if (!(c instanceof Killable)) continue;
            ((Killable)((Object)c)).kill();
        }
        this.box.clear();
    }

    public void clearList() {
        for (Component c : this.box) {
            if (!(c instanceof Killable)) continue;
            ((Killable)((Object)c)).kill();
        }
        this.box.clear();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        for (Component c : this.box) {
            c.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (Component comps : this.box) {
            if (!(comps instanceof Focusable)) continue;
            a.addAll(((Focusable)((Object)comps)).getFocusComponents());
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public String getPersistString() {
        return null;
    }

    @Override
    public void loadState(String state, String id) {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean shouldPersist() {
        return false;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (RadioButtonBox.this.orientation == 0) {
                int h = 0;
                int hh = 0;
                for (Component c : RadioButtonBox.this.box) {
                    h = (int)((double)h + c.getPreferredSize().getWidth());
                    h += RadioButtonBox.this.border;
                    hh = (int)c.getPreferredSize().getHeight();
                }
                return new Dimension(h -= RadioButtonBox.this.border, hh);
            }
            int mw = 0;
            int h = 0;
            Iterator it = RadioButtonBox.this.optionSeparaters.iterator();
            for (Component c : RadioButtonBox.this.box) {
                h = (int)((double)h + c.getPreferredSize().getHeight());
                h += RadioButtonBox.this.border;
                if (c.getPreferredSize().getWidth() > (double)mw) {
                    mw = (int)c.getPreferredSize().getWidth();
                }
                if (!RadioButtonBox.this.useSeparators || !it.hasNext()) continue;
                HorizontalSeparator s = (HorizontalSeparator)it.next();
                h = (int)((double)h + s.getPreferredSize().getHeight());
                h += RadioButtonBox.this.border;
            }
            return new Dimension(mw, h -= RadioButtonBox.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (RadioButtonBox.this.orientation == 0) {
                int h = 0;
                for (Component c : RadioButtonBox.this.box) {
                    if (h != 0 && RadioButtonBox.this.column != 0) {
                        h = RadioButtonBox.this.column;
                    }
                    c.setLocation(h, 0);
                    c.setSize(c.getPreferredSize());
                    h += c.getWidth();
                    h += RadioButtonBox.this.border;
                }
            } else {
                int h = 0;
                Iterator it = RadioButtonBox.this.optionSeparaters.iterator();
                for (Component c : RadioButtonBox.this.box) {
                    c.setLocation(0, h);
                    c.setSize(c.getPreferredSize());
                    h += c.getHeight();
                    h += RadioButtonBox.this.border;
                    if (!RadioButtonBox.this.useSeparators || !it.hasNext()) continue;
                    HorizontalSeparator s = (HorizontalSeparator)it.next();
                    s.setLocation(0, h);
                    s.setSize(parent.getWidth(), (int)s.getPreferredSize().getHeight());
                    h += s.getHeight();
                    h += RadioButtonBox.this.border;
                }
            }
        }
    }
}

