/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.skins.HorizontalTextureSkin;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;

public class TabTableTreeView
extends JPanel
implements LafListener,
ImageConsumer {
    private static final long serialVersionUID = 1L;
    private static BufferedImage titleImage_EXPANDED;
    private static BufferedImage titleImage_COLAPSED;
    private MutableFocusContainerListener focusCycleCreator;
    private ArrayList<InnerTab> tabs = new ArrayList();

    public TabTableTreeView(MutableFocusContainerListener focusCreator) {
        this.lafAttributeChanged("All attribues changed");
        this.focusCycleCreator = focusCreator;
        this.setOpaque(false);
        this.setLayout(new TabLayout());
    }

    public void changeAddButtonState(int view, boolean isActiv) {
        if (view <= this.tabs.size() - 1) {
            InnerTab t = this.tabs.get(view);
            t.setAddEnabled(isActiv);
        }
    }

    public void addTab(Table2 table, String tabName, String buttonName) {
        InnerTab a = new InnerTab(table, tabName, buttonName);
        this.tabs.add(a);
        this.ensureTableBindings();
        this.add(a);
    }

    private void ensureTableBindings() {
        for (InnerTab tab : this.tabs) {
            for (InnerTab tab2 : this.tabs) {
                if (tab == tab2) continue;
                tab.getTableModel().addModel(tab2.getTableModel());
            }
        }
    }

    public Table2Model getTab(int i) {
        return this.tabs.get(i).getTableModel();
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    public void addTableRowSelectionListener(Table2RowSelectionListener l) {
        for (InnerTab t : this.tabs) {
            t.addTableRowSelectionListener(l);
        }
    }

    public ArrayList<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (InnerTab t : this.tabs) {
            if (!t.isExpanded) continue;
            a.addAll(t.getFocusComponents());
        }
        return a;
    }

    @Override
    public void loadImages() {
        if (titleImage_COLAPSED == null) {
            titleImage_COLAPSED = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("tab_table_tree_background_colapsed"));
            titleImage_EXPANDED = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("tab_table_tree_background_expanded"));
        }
    }

    @Override
    public void clearImages() {
        titleImage_COLAPSED = null;
        this.loadImages();
    }

    private class TabLayout
    extends DefaultLayout {
        private TabLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int currentY = 0;
            for (InnerTab tab : TabTableTreeView.this.tabs) {
                tab.setLocation(0, currentY);
                tab.setSize(w, (int)tab.getPreferredSize().getHeight());
                currentY += tab.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = 0;
            int maxWidth = 0;
            for (InnerTab tab : TabTableTreeView.this.tabs) {
                currentY = (int)((double)currentY + tab.getPreferredSize().getHeight());
                if (!(tab.getPreferredSize().getWidth() > (double)maxWidth)) continue;
                maxWidth = (int)tab.getPreferredSize().getWidth();
            }
            return new Dimension(maxWidth, currentY);
        }
    }

    private class InnerTab
    extends JPanel
    implements MouseListener,
    ButtonListener {
        private Table2 table;
        private TextLabel title;
        private boolean isExpanded = true;
        private InnerTabTitleSkin skin;
        private ExpandIcon expandIcon;
        private TextLabel addLabel;
        private AddButton addButton;
        private boolean isAddEnabled = true;
        private Color addButtonBackgroundColor;

        public InnerTab(Table2 aTable, String titleName, String buttonName) {
            this.table = aTable;
            this.title = new TextLabel(titleName);
            this.addButtonBackgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("mealplan_addbutton_background"));
            this.setOpaque(false);
            this.skin = new InnerTabTitleSkin();
            this.expandIcon = new ExpandIcon();
            this.addLabel = new TextLabel(buttonName);
            this.addButton = new AddButton();
            this.addLabel.getFader().setPermanent(true);
            this.addLabel.setDelegateComponent(this.addButton);
            this.addButton.getFader().setPermanent(true);
            this.table.getFader().setPermanent(true);
            this.addButton.addButtonListener(this);
            this.expandIcon.addButtonListener(this);
            this.setLayout(new InnerTabLayout());
            this.addMouseListener(this);
            this.add(this.title);
            this.add(this.table);
            this.add(this.expandIcon);
            this.add(this.addButton);
            this.add(this.addLabel);
            this.setExpanded(false);
        }

        public ArrayList<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.table.getFocusComponents());
            if (this.isAddEnabled) {
                a.add(this.addButton);
            }
            return a;
        }

        public Table2Model getTableModel() {
            return this.table.getModel();
        }

        public void setAddEnabled(boolean isAddEnabled) {
            this.isAddEnabled = isAddEnabled;
            if (this.isAddEnabled) {
                this.addButton.fadeIn();
                this.addLabel.fadeIn();
            } else {
                this.addButton.fadeOut(false);
                this.addLabel.fadeOut(false);
            }
        }

        public void setExpanded(boolean expand) {
            if (this.isExpanded != expand) {
                this.isExpanded = expand;
                if (this.isExpanded) {
                    this.addButton.fadeIn();
                    this.addLabel.fadeIn();
                    this.table.fadeIn();
                } else {
                    this.addButton.fadeOut(false);
                    this.addLabel.fadeOut(false);
                    this.table.fadeOut(false);
                }
                this.expandIcon.setExpanded(this.isExpanded);
                if (TabTableTreeView.this.focusCycleCreator != null) {
                    // empty if block
                }
                TabTableTreeView.this.validate();
            }
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.skin.paint(g2, 0, 0, this.getWidth(), 0);
            if (this.getHeight() > this.skin.getImage(0).getHeight()) {
                g2.setColor(this.addButtonBackgroundColor);
                g2.fillRect(0, this.skin.getImage(0).getHeight(), this.getWidth(), this.getHeight() - this.skin.getImage(0).getHeight());
            }
            if (this.isAddEnabled) {
                g2.setColor(new Color(30, 30, 30));
                g2.drawLine(0, this.addButton.getY() - 5, this.getWidth(), this.addButton.getY() - 5);
            }
            this.paintChildren(g2);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getX() > 0 && this.getWidth() > e.getX() && e.getY() > 0 && this.skin.getImage(0).getHeight() > e.getY()) {
                this.setExpanded(!this.isExpanded);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.addButton) {
                this.table.getButtonHandler().addButtonPressed(0, 0, null);
            } else if (source == this.expandIcon) {
                this.setExpanded(this.expandIcon.isExpanded());
            }
        }

        public void addTableRowSelectionListener(Table2RowSelectionListener l) {
            this.table.getModel().addTableSelectionListener(l);
        }

        private class InnerTabLayout
        extends DefaultLayout {
            private InnerTabLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
                InnerTab.this.expandIcon.setLocation(10, (int)(((double)titleImage_COLAPSED.getHeight() - InnerTab.this.expandIcon.getPreferredSize().getHeight()) / 2.0));
                InnerTab.this.expandIcon.setSize(InnerTab.this.expandIcon.getPreferredSize());
                InnerTab.this.title.setLocation(InnerTab.this.expandIcon.getX() + InnerTab.this.expandIcon.getWidth() + 10, (int)(((double)titleImage_COLAPSED.getHeight() - InnerTab.this.title.getPreferredSize().getHeight()) / 2.0));
                InnerTab.this.title.setSize(InnerTab.this.title.getPreferredSize());
                if (InnerTab.this.isExpanded) {
                    int currentY = titleImage_COLAPSED.getHeight();
                    if (InnerTab.this.table.getRowCount() > 0) {
                        InnerTab.this.table.setLocation(0, titleImage_COLAPSED.getHeight());
                        InnerTab.this.table.setSize(parent.getWidth(), (int)InnerTab.this.table.getPreferredSize().getHeight());
                        currentY += InnerTab.this.table.getHeight();
                    } else {
                        InnerTab.this.table.setSize(0, 0);
                    }
                    if (InnerTab.this.isAddEnabled) {
                        InnerTab.this.addButton.setLocation(10, currentY + border);
                        InnerTab.this.addButton.setSize(InnerTab.this.addButton.getPreferredSize());
                        InnerTab.this.addLabel.setLocation(InnerTab.this.addButton.getX() + InnerTab.this.addButton.getWidth() + border, (int)((double)InnerTab.this.addButton.getY() + ((double)InnerTab.this.addButton.getHeight() - InnerTab.this.addLabel.getPreferredSize().getHeight()) / 2.0));
                        InnerTab.this.addLabel.setSize(InnerTab.this.addLabel.getPreferredSize());
                    }
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                if (InnerTab.this.isExpanded) {
                    int border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
                    int aHeight = titleImage_COLAPSED.getHeight();
                    if (InnerTab.this.table.getRowCount() > 0) {
                        aHeight = (int)((double)aHeight + InnerTab.this.table.getPreferredSize().getHeight());
                    }
                    if (InnerTab.this.isAddEnabled) {
                        aHeight = (int)((double)aHeight + ((double)border + InnerTab.this.addButton.getPreferredSize().getHeight() + (double)border));
                    }
                    return new Dimension((int)InnerTab.this.table.getPreferredSize().getWidth(), aHeight);
                }
                return new Dimension((int)InnerTab.this.table.getPreferredSize().getWidth(), titleImage_COLAPSED.getHeight());
            }
        }

        private class InnerTabTitleSkin
        extends HorizontalTextureSkin {
            private InnerTabTitleSkin() {
            }

            @Override
            public BufferedImage getImage(int type) {
                if (InnerTab.this.isExpanded) {
                    return titleImage_EXPANDED;
                }
                return titleImage_COLAPSED;
            }

            @Override
            public void loadImages() {
            }

            @Override
            public void clearImages() {
                this.loadImages();
            }
        }
    }
}

