/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;

public class MultiLineTextLabel
extends JLabel
implements Killable,
Fadable {
    private static final long serialVersionUID = 1L;
    private AlphaFader<MultiLineTextLabel> fader;
    private boolean isKilled;

    public MultiLineTextLabel() {
        this.setOpaque(false);
        this.fader = new AlphaFader<MultiLineTextLabel>(this);
        this.setProgress(1.0f);
        this.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
        this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
    }

    public MultiLineTextLabel(String text) {
        this();
        this.setLabelText(text);
    }

    @Override
    public void setText(String t) {
        this.setLabelText(t);
    }

    public void setLabelText(String t) {
        String tt = t;
        if (tt == null) {
            tt = "No comment";
        }
        if (tt.startsWith("<html>")) {
            super.setText(tt);
        } else {
            super.setText("<html>" + tt + "</html>");
        }
        this.setToolTipText(tt);
    }

    public void panit(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.fader);
        this.paintChildren(g2);
    }

    @Override
    public void fadeIn() {
        this.fader.fadeIn();
    }

    @Override
    public void fadeIn(long animationTime) {
        this.fader.fadeIn(animationTime);
    }

    @Override
    public void fadeOut(boolean destroy, long animationTime) {
        this.fader.fadeOut(animationTime, destroy);
    }

    @Override
    public void fadeOut(boolean destroy) {
        this.fader.fadeOut(destroy);
    }

    public AlphaFader<MultiLineTextLabel> getFader() {
        return this.fader;
    }

    @Override
    public void setProgress(float progress) {
        this.fader.setProgress(progress);
    }

    @Override
    public float getProgress() {
        return this.fader.getProgress();
    }

    @Override
    public boolean isAnimating(AlphaFader.FadeType fadeIn) {
        return this.fader.isAnimating(fadeIn);
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    @Override
    public boolean isKilled() {
        return this.isKilled;
    }
}

