/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.BufferedImageRegistry;
import ch.icit.pegasus.client.gui.utils.GraphicsUtils;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.server.core.util.ResourcesLoader;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributesConverter {
    private static final Logger logger = LoggerFactory.getLogger(AttributesConverter.class);
    private static HashMap<String, Color> colorMap = new HashMap();
    private static HashMap<String, Font> fontMap = new HashMap();

    public static Font getDefaultBoldFont() {
        return AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type"));
    }

    private static String getImagePath() {
        return "img/Chocolate";
    }

    public static URL getSVGFile(String path) {
        String p = "";
        p = AttributesConverter.cutPath(path);
        p = AttributesConverter.getImagePath() + p;
        return ResourcesLoader.getResource((String)p);
    }

    private static String cutPath(String path) {
        int s;
        String nPath = path;
        if (path == null) {
            System.out.println("error");
        }
        if ((s = path.indexOf("${img}")) != -1) {
            nPath = path.substring(s + 6, path.length());
        }
        return nPath;
    }

    public static Color getColor4String(String color) {
        Color colorObject = colorMap.get(color);
        if (colorObject == null) {
            if (color == null) {
                return Color.gray;
            }
            String[] colorComponents = color.split(",");
            if (colorComponents.length == 3) {
                colorObject = new Color(Integer.valueOf(colorComponents[0]), Integer.valueOf(colorComponents[1]), Integer.valueOf(colorComponents[2]));
            } else if (colorComponents.length == 4) {
                colorObject = new Color(Integer.valueOf(colorComponents[0]), Integer.valueOf(colorComponents[1]), Integer.valueOf(colorComponents[2]), Integer.valueOf(colorComponents[3]));
            }
            colorMap.put(color, colorObject);
        }
        return colorObject;
    }

    public static Point getPoint4String(String pointValue) {
        String[] a = pointValue.split(",");
        Double x = Double.valueOf(a[0]);
        Double y = Double.valueOf(a[1]);
        Point n = new Point();
        n.setLocation(x, y);
        return n;
    }

    public static Boolean getBoolean4String(String booleaValue) {
        return Boolean.parseBoolean(booleaValue);
    }

    public static BufferedImage getBufferedImage4String(String path) {
        return AttributesConverter.getBufferedImage4String(path, true);
    }

    public static BufferedImage getBufferedImage4String(String path, boolean withDefault) {
        ImageIcon icon;
        BufferedImage img;
        block4: {
            img = BufferedImageRegistry.getBufferedImage(path);
            if (img != null) {
                return img;
            }
            String p = AttributesConverter.cutPath(path);
            p = AttributesConverter.getImagePath() + p;
            icon = null;
            try {
                icon = new ImageIcon(ResourcesLoader.getResource((String)p));
                img = GraphicsUtils.toCompartibleImage(icon);
            }
            catch (NullPointerException e) {
                logger.error("Unable to load image " + p + "! Load default img instead");
                if (!withDefault) break block4;
                img = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("default_img"));
            }
        }
        icon = null;
        if (img != null) {
            BufferedImageRegistry.registerBufferedImage(path, img);
        }
        return img;
    }

    public static Integer getInteger4String(String integerValue) {
        return Integer.valueOf(integerValue);
    }

    public static Float getFloat4String(String floatValue) {
        return Float.valueOf(floatValue);
    }

    public static Long getLong4String(String longValue) {
        return Long.valueOf(longValue);
    }

    public static Font getFont4String(String fontname, String fontSize, String fontStyle) {
        Font font = fontMap.get(fontname + fontSize + fontStyle);
        if (font == null) {
            int size = AttributesConverter.getInteger4String(fontSize);
            int style = AttributesConverter.getInteger4String(fontStyle);
            font = new Font(fontname, style, size);
            fontMap.put(fontname + fontSize + fontStyle, font);
        }
        return font;
    }

    public static void clearImageCache() {
        BufferedImageRegistry.clear();
    }
}

