/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.ScreenViewProvider;
import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.hud.DTOProvider;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.DetailsEditorParagraph;
import ch.icit.pegasus.client.gui.table.RowContentPanelLayout;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.commiter.ClientFileTransferListener;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.Screen;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DisablePanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.validator.Validator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowEditor<T extends IUniversal>
extends JPanel
implements ButtonListener,
MutableFocusContainerListener,
Focusable,
ClientFileTransferListener,
RemoteLoader,
AnimationListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    Logger log = LoggerFactory.getLogger(RowEditor.class);
    protected RowModel<T> model;
    private IDataHandler.DATAHANDLER_STATE currentState;
    private boolean enableFromOutside;
    private boolean isInit = false;
    protected TablePanelAddSaveButton cancel;
    protected TablePanelAddSaveButton add;
    private boolean cancelVisible = true;
    private boolean addVisible = true;
    private boolean isIgnoreCancelQuestion;
    private boolean isAdding = false;
    private String commitingText = Words.SAVE_DATA;
    protected InnerPopupFactory.CANCEL_TYPES overrideType;
    private ScreenTableView<T, ?> backRef;
    private boolean hasButtons;
    private RemoteLoader additionalRemoteLoadListener;
    protected List<RemoteCommitter> remoteCommitter = new ArrayList<RemoteCommitter>();
    private final List<DetailsEditorParagraph> paragraphs = new ArrayList<DetailsEditorParagraph>();
    private DisablePanel disablePanel;
    private final ArrayList<Focusable> focusOrder = new ArrayList();
    private Long undoId;
    protected Hashtable<Class<?>, Class<?>> mapping = new Hashtable();
    private boolean isInnerElement = false;
    private boolean isResetOnCancel;
    protected AccessDefinitionComplete nextTool2Open;
    private T currentTopLevelData;
    private ADTO innerData;
    private boolean isLoading;

    public RowEditor(RowModel<T> model, long id) {
        this(model, id, true);
    }

    public RowEditor(RowModel<T> model, long id, boolean hasButton) {
        this(model, hasButton);
        this.undoId = id;
    }

    public RowEditor(RowModel<T> model, boolean hasButton) {
        this.model = model;
        this.model.setLoaded(false);
        this.hasButtons = hasButton;
        this.install();
        this.ensureButtons();
    }

    public RowEditor(RowModel<T> model) {
        this(model, true);
    }

    public RowModel<T> getModel() {
        return this.model;
    }

    public void putCommitClassMapping(Class<?> c1, Class<?> c2) {
        this.mapping.put(c1, c2);
    }

    public void setOverrideType(InnerPopupFactory.CANCEL_TYPES type) {
        this.overrideType = type;
    }

    public void setInnerData(ADTO i) {
        this.innerData = i;
    }

    public void setResetOnCancel(boolean b) {
        this.isResetOnCancel = b;
    }

    public void tryToAccessSubModuleTypeSafe(RemoteLoader remoteLoader, AccessDefinitionComplete tool2open, T currentToplevelData, ADTO innerData) {
        this.tryToAccessSubModule(remoteLoader, tool2open, currentToplevelData, innerData);
    }

    public void tryToAccessSubModule(RemoteLoader remoteLoader, AccessDefinitionComplete tool2open, T currentToplevelData, ADTO innerData) {
        this.nextTool2Open = tool2open;
        this.currentTopLevelData = currentToplevelData;
        this.innerData = innerData;
        this.additionalRemoteLoadListener = remoteLoader;
        InnerPopupFactory.showTriStateDesicionPopup("Save current changes?", "<b>Do you want to save the current changes before exit?</b><br/>Press SAVE to save data.<br/>Press DISCARD to drop the data.<br/>Press CANCEL to abort this action.", this, new InnerPopUpListener2(){

            @Override
            public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                if (xargs == null) {
                    RowEditor.this.nextTool2Open = null;
                    RowEditor.this.currentTopLevelData = null;
                    RowEditor.this.innerData = null;
                } else if (xargs.length >= 1 && xargs[0] instanceof Boolean) {
                    boolean b = (Boolean)xargs[0];
                    if (b) {
                        RowEditor.this.doValidation();
                    } else {
                        Object[] o = new Object[]{};
                        RowEditor.this.popUpClosed(null, o);
                    }
                }
            }
        }, 350, 200, PopupType.WARNING);
    }

    public void setAddButtonText(TextButton.BUTTON_TYPES type) {
        this.add.changeType(type);
    }

    public void setAddButtonText(String t) {
        this.add.setText(t);
    }

    public Button getCancelButton() {
        return this.cancel;
    }

    public void setCancelButtonText(TextButton.BUTTON_TYPES type) {
        this.cancel.changeType(type);
    }

    public void hideCancelButton() {
        this.cancel.setVisible(false);
        this.cancelVisible = false;
        this.cancel.setProgress(0.0f);
    }

    public void hideCloseButton() {
        this.add.setVisible(false);
        this.addVisible = false;
        this.add.setProgress(0.0f);
    }

    public List<DetailsEditorParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public void disableAddActionEvent() {
    }

    public void ensureButtons() {
        this.cancel.setVisible(true);
        this.cancel.setProgress(1.0f);
    }

    public void enableSaveButton(boolean ena) {
        if (this.add != null) {
            this.add.setEnabled(ena);
        }
    }

    public void addValidator2SaveButton(Validator v) {
        this.add.addValidator(v);
    }

    public void enableCancelButton(boolean ena) {
        if (this.cancel != null) {
            this.cancel.setEnabled(ena);
        }
    }

    public void updateEnableStateToDetailsPanel() {
        for (ArrayList<Component> cc : ((DetailsParagraphLayout)this.getLayout()).getComponents()) {
            for (Component c : cc) {
                if (c instanceof DetailsEditorParagraph) {
                    ((DetailsEditorParagraph)((Object)c)).setValid(this.add.isEnabled());
                    continue;
                }
                if (!(c instanceof CombinedDetailsParagraph)) continue;
                ((CombinedDetailsParagraph)c).setValid(this.add.isEnabled());
            }
        }
    }

    public void addToFocusQueue(DetailsEditorParagraph p) {
        if (p == null) {
            return;
        }
        if (p instanceof MutableFocusContainer) {
            p.addFocusCycleChangeListener(this);
        }
        this.focusOrder.add(p);
    }

    public void add(JComponent c, Object cons) {
        if (this.model.isAddRow()) {
            if (c instanceof DetailsEditorParagraph) {
                DetailsEditorParagraph d = (DetailsEditorParagraph)((Object)c);
                if (d.isInAddEditor()) {
                    super.add((Component)c, cons);
                }
            } else {
                super.add((Component)c, cons);
            }
        } else {
            super.add((Component)c, cons);
        }
        this.paragraphs.add((DetailsEditorParagraph)((Object)c));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean b;
        boolean bl = b = isEnabled && this.getModel().getNode() != null;
        if (this.cancel != null) {
            this.cancel.setEnabled(b);
        }
        if (this.add != null) {
            this.add.setEnabled(b);
        }
        ArrayList<ArrayList<Component>> comps = ((DetailsParagraphLayout)this.getLayout()).getComponents();
        for (ArrayList<Component> coms : comps) {
            for (Component c : coms) {
                if (c == null) continue;
                if (c instanceof Killable) {
                    if (((Killable)((Object)c)).isKilled()) continue;
                    c.setEnabled(b);
                    continue;
                }
                c.setEnabled(b);
            }
        }
    }

    protected long getUnDoId() {
        return this.undoId;
    }

    public boolean hasButtons() {
        return this.hasButtons;
    }

    public void resetParagraphs() {
        ArrayList<ArrayList<Component>> list = ((DetailsParagraphLayout)this.getLayout()).getComponents();
        for (ArrayList<Component> l : list) {
            for (Component c : l) {
                if (!(c instanceof DetailsEditorParagraph)) continue;
                ((DetailsEditorParagraph)((Object)c)).resetParagraph();
            }
        }
    }

    public void allInstalled() {
        this.getLayout().layoutContainer(this);
    }

    public void setBorders(int hb, int vb) {
        ((DetailsParagraphLayout)this.getLayout()).setHorizontalBorder(hb);
        ((DetailsParagraphLayout)this.getLayout()).setVerticalBorder(vb);
    }

    public void setStartBorders(int hsb, int vsb) {
        ((DetailsParagraphLayout)this.getLayout()).setHorizontalStartBorder(hsb);
    }

    public void checkRelayout() {
        if (this.model.getView().reCalculateHeight()) {
            this.model.getView().reSizePanel(this.model.getView().getWidth(), this.model.getView().getPreferredHeight());
        }
    }

    public void createFocusCycle() {
        if (this.isInit) {
            return;
        }
        ArrayList<Component> a = new ArrayList<Component>();
        Component latestfocusElement = null;
        for (Focusable c : this.focusOrder) {
            List<Component> ar;
            if (c instanceof DefaultDetailsPanel && !((DefaultDetailsPanel)c).isExpanded() || (ar = c.getFocusComponents()) == null) continue;
            for (Component cc : ar) {
                if (cc.hasFocus()) {
                    latestfocusElement = cc;
                }
                a.add(cc);
            }
        }
        if (this.add != null && this.addVisible && this.add.isEnabled()) {
            a.add(this.add);
        }
        if (this.cancel != null && this.cancelVisible && this.cancel.isEnabled()) {
            a.add(this.cancel);
        }
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
        if (latestfocusElement != null) {
            latestfocusElement.requestFocusInWindow();
        }
    }

    public int getLayoutVerticalBorder() {
        return ((DetailsParagraphLayout)this.getLayout()).getVerticalBorder();
    }

    public void expandAnimationDone() {
        if (!this.model.doLoadCompleteData(this)) {
            this.remoteObjectLoaded(this.getModel().getNode());
        } else {
            this.showCommittingAnimation(Words.LOAD_DATA);
        }
    }

    public void dataLoaded() {
        this.disablePanel.kill();
        this.hideCommittingAnimation();
    }

    private void install() {
        if (this.hasButtons) {
            this.cancel = new TablePanelAddSaveButton(TextButton.BUTTON_TYPES.CANCEL);
            this.add = this.model.isAddRow() ? new TablePanelAddSaveButton(TextButton.BUTTON_TYPES.ADD) : new TablePanelAddSaveButton(TextButton.BUTTON_TYPES.SAVE);
            this.add.setTopLevelParent(this);
            this.cancel.addButtonListener(this);
            this.add.addButtonListener(this);
        }
        this.disablePanel = new DisablePanel();
        this.setLayout(new DetailsParagraphLayout());
        this.setOpaque(false);
        this.setFocusCycleRoot(true);
        if (this.hasButtons) {
            this.add(this.cancel);
            this.add(this.add);
        }
        this.add((Component)this.disablePanel, 0);
    }

    protected void kill() {
        this.paragraphs.clear();
        this.model.resetNode();
        for (Component com : this.getComponents()) {
            this.remove(com);
            if (!(com instanceof DetailsEditorParagraph)) continue;
            ((DetailsEditorParagraph)((Object)com)).kill();
        }
        if (this.disablePanel != null) {
            this.disablePanel.kill();
        }
        this.disablePanel = null;
        this.cancel = null;
        this.add = null;
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    public void commitData(Node node, RemoteLoader model) {
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)true, false, false);
        n.setName("recentlyCommitted");
        node.addChild(n, 0L);
        node.commit();
        this.model.getParentModel().getDataHandler().updateData(node, model, this.model.getParentModel().getTable().getLoadingAnimation());
    }

    public void createNewData(Node node) {
        this.model.getParentModel().getDataHandler().createNewData(node, this.model, true, this.model.getParentModel().getTable().getLoadingAnimation());
    }

    protected void setComponentsEnabled(boolean isEnabled) {
        ArrayList<ArrayList<Component>> list = ((DetailsParagraphLayout)this.getLayout()).getComponents();
        for (ArrayList<Component> l : list) {
            for (Component c : l) {
                if (c == null) continue;
                c.setEnabled(isEnabled);
            }
        }
        if (this.add != null) {
            this.add.setEnabled(isEnabled);
        }
        if (this.cancel != null) {
            this.cancel.setEnabled(isEnabled);
        }
    }

    protected List<ScreenValidationObject> validateInnerPanels() {
        ArrayList<ScreenValidationObject> oo = new ArrayList<ScreenValidationObject>();
        for (ArrayList<Component> cc : ((DetailsParagraphLayout)this.getLayout()).getComponents()) {
            for (Component c : cc) {
                List<ScreenValidationObject> o;
                if (c instanceof DetailsEditorParagraph) {
                    o = ((DetailsEditorParagraph)((Object)c)).validateParagraph();
                    if (o == null || o.isEmpty()) continue;
                    oo.addAll(o);
                    continue;
                }
                if (!(c instanceof CombinedDetailsParagraph) || (o = ((CombinedDetailsParagraph)c).validateParagraph()) == null || o.isEmpty()) continue;
                oo.addAll(o);
            }
        }
        return oo;
    }

    public IDataHandler.DATAHANDLER_STATE getLoadingState() {
        return this.currentState;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            return;
        }
        boolean reload = false;
        if (this.model.getNode() != null) {
            try {
                this.model.getNode().removeAllListenersRecursivley();
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            if (this.model.isAddRow()) {
                this.model.getParentModel().getDataHandler().resetData(this.model.getNode());
                this.model.getNode().updateNode();
                this.model.getNode().updateView();
                this.resetParagraphs();
            } else if (this.isInnerElement()) {
                this.model.getNode().removeAllChilds();
            } else {
                reload = true;
            }
            if (this.isResetOnCancel || reload) {
                reload = true;
                this.currentState = IDataHandler.DATAHANDLER_STATE.RELOAD;
                this.model.getParentModel().getTable().setLoadingAnimationText("Refresh Data");
                if (!this.model.getParentModel().getDataHandler().reloadDataAfterClosing(this.model.getNode(), this, this.model.getParentModel().getTable().getLoadingAnimation())) {
                    this.remoteObjectLoaded(this.model.getNode());
                }
            }
        }
        if (!reload) {
            this.currentState = null;
            this.dataReloaded();
        }
    }

    public void dataReloaded() {
        this.model.setBlocked(false);
        this.model.expandRow(false);
        if (this.model.getParentModel() != null && this.model.getParentModel().getTable() != null) {
            this.model.getParentModel().getTable().hideAnimation();
        }
        if (this.model.getView() != null) {
            this.model.getView().refreshCells();
        }
        this.showScreen();
    }

    public void showScreen() {
        if (this.nextTool2Open != null && this.getModel().getParentModel() != null) {
            String aName = HUDToolkit.getScreenClassForInvoker(this.nextTool2Open.getIdentifier());
            String aTitle = this.nextTool2Open.getDisplayName();
            Screen screen = (Screen)ScreenViewProvider.forName(aName, this.getModel().getParentModel().getTable().getOutSideConnection().getMainFrame(), aTitle, this.getModel().getParentModel().getTable().getOutSideConnection().getMainFrame().getCurrenScreen());
            if (screen != null) {
                this.getModel().getParentModel().getTable().getOutSideConnection().getMainFrame().showScreen(screen, null);
            }
        }
    }

    protected void doValidation() {
        final List<ScreenValidationObject> ooo = this.validateInnerPanels();
        final ArrayList<DetailsEditorParagraph> remoteValidatingParagraphs = new ArrayList<DetailsEditorParagraph>();
        if (ooo.isEmpty()) {
            for (ArrayList<Component> cc : ((DetailsParagraphLayout)this.getLayout()).getComponents()) {
                for (Component c : cc) {
                    if (c instanceof DetailsEditorParagraph) {
                        if (!((DetailsEditorParagraph)((Object)c)).isRemoteValidation()) continue;
                        remoteValidatingParagraphs.add((DetailsEditorParagraph)((Object)c));
                        continue;
                    }
                    if (!(c instanceof CombinedDetailsParagraph) || !((CombinedDetailsParagraph)c).isRemoteValidation()) continue;
                    remoteValidatingParagraphs.add((DetailsEditorParagraph)((Object)c));
                }
            }
        }
        if (!remoteValidatingParagraphs.isEmpty()) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    for (DetailsEditorParagraph p : remoteValidatingParagraphs) {
                        p.validateRemote(ooo);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            RowEditor.this.doSave(ooo);
                        }

                        public void errorOccurred(ClientException exception) {
                            RowEditor.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.doSave(ooo);
        }
    }

    public boolean isAdding() {
        return this.isAdding;
    }

    public void doSave(List<ScreenValidationObject> validations) {
        if (validations == null || !validations.isEmpty()) {
            this.hideCommittingAnimation();
            this.isAdding = false;
            return;
        }
        this.model.getNode().removeAllListenersRecursivley();
        if (this.model.getParentModel().isSaveInTable() || this.model.isAddRow() && !this.isInnerElement()) {
            if (this.model.getNode() != null) {
                this.showCommittingAnimation(this.commitingText);
                this.model.getParentModel().block4Saving(true);
                this.setComponentsEnabled(false);
                ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
                for (Component com : this.getComponents()) {
                    List<RemoteCommitter> b;
                    if (!(com instanceof DetailsEditorParagraph) || (b = ((DetailsEditorParagraph)((Object)com)).commitParagraph()) == null) continue;
                    for (RemoteCommitter commiters : b) {
                        if (!(commiters instanceof FileCommitter) || ((FileCommitter)commiters).getFile() == null) continue;
                        a.add(commiters);
                    }
                }
                this.model.getNode().commit(this.model.getParentModel().getDataHandler().getCommittingClass(), this.mapping);
                if (a != null && a.size() > 0) {
                    for (RemoteCommitter c : a) {
                        this.remoteCommitter.add(c);
                    }
                    this.invokeCommitter();
                } else {
                    this.fileUploaded(null, null);
                }
            }
        } else {
            if (this.model.isAddRow()) {
                this.model.setCurrentState(3);
            }
            this.model.getNode().commit(this.model.getParentModel().getDataHandler().getCommittingClass(), this.mapping);
            this.model.remoteObjectLoaded(this.model.getNode());
        }
        this.showScreen();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.add) {
            this.isAdding = true;
            this.showCommittingAnimation("Validate Data");
            this.doValidation();
        } else if (source == this.cancel) {
            if (!this.isIgnoreCancelQuestion && this.getModel().getNode().hasDataChanged(new HashSet())) {
                InnerPopupFactory.CANCEL_TYPES type = InnerPopupFactory.CANCEL_TYPES.CANCEL_NORMAL;
                if (this.overrideType != null) {
                    type = this.overrideType;
                } else if (this.model.isAddRow()) {
                    type = InnerPopupFactory.CANCEL_TYPES.CANCEL_ADD;
                }
                InnerPopupFactory.showEnsureCancelPopup(this.cancel, x, y, this, type);
            } else {
                Object[] o = new Object[]{};
                this.popUpClosed(null, o);
            }
        }
    }

    public void setIgnoreCancelQuestion(boolean isIgnore) {
        this.isIgnoreCancelQuestion = isIgnore;
    }

    public boolean isInnerElement() {
        return this.isInnerElement;
    }

    public void setBackRef(ScreenTableView screenView) {
        this.backRef = screenView;
    }

    public int getPreferredHeight() {
        return (int)((DetailsParagraphLayout)this.getLayout()).preferredLayoutSize(this).getHeight();
    }

    public Object getInnerSelectedDTO() {
        for (ArrayList<Component> arr : ((DetailsParagraphLayout)this.getLayout()).getComponents()) {
            for (Component c : arr) {
                if (c instanceof CombinedDetailsParagraph) {
                    for (ArrayList<Component> arr2 : ((RowContentPanelLayout)((CombinedDetailsParagraph)c).getLayout()).getComponents()) {
                        for (Component c2 : arr2) {
                            if (!(c2 instanceof DTOProvider) || ((DTOProvider)((Object)c2)).getSelectedDTO() == null) continue;
                            return ((DTOProvider)((Object)c2)).getSelectedDTO();
                        }
                    }
                    continue;
                }
                if (!(c instanceof DTOProvider) || ((DTOProvider)((Object)c)).getSelectedDTO() == null) continue;
                return ((DTOProvider)((Object)c)).getSelectedDTO();
            }
        }
        return null;
    }

    public Button getAddButton() {
        return this.add;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public final void setVisibleContainer(VisibleContainer pane) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof Focusable)) continue;
            ((Focusable)((Object)c)).setVisibleContainer(pane);
        }
    }

    @Override
    public void focusCycleChanged(MutableFocusContainer container) {
        this.createFocusCycle();
    }

    @Override
    public void exceptionOccurred(Exception exception) {
        InnerPopupFactory.showErrorDialog(ScreenValidationObject.createMessageString((List)ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "File upload failed")})), (Component)this);
        Node node = this.model.getNode();
        Object value = node.getValue();
        node.setValue(value, 0L);
        node.updateNode();
    }

    public void showCommittingAnimation(String shownText) {
        this.model.getParentModel().getTable().setLoadingAnimationText(shownText);
        this.model.getParentModel().getTable().revalidate();
    }

    public void hideCommittingAnimation() {
        if (this.model != null && this.model.getParentModel() != null && this.model.getParentModel().getTable() != null) {
            this.model.getParentModel().getTable().hideAnimation();
            this.model.getParentModel().getTable().revalidate();
        }
    }

    protected void invokeCommitter() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                for (RemoteCommitter c : RowEditor.this.remoteCommitter) {
                    c.commit(null);
                }
                RowEditor.this.remoteCommitter.clear();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        RowEditor.this.fileUploaded(null, null);
                    }

                    public void errorOccurred(ClientException exception) {
                        RowEditor.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void fileUploaded(File file, PegasusFileComplete ref) {
        Iterator<RemoteCommitter> it = this.remoteCommitter.iterator();
        while (it.hasNext()) {
            RemoteCommitter rc = it.next();
            if (!(rc instanceof FileCommitter) || file != ((FileCommitter)rc).getFile()) continue;
            ((FileCommitter)rc).writeFileReferenceBack(ref);
            it.remove();
        }
        if (this.model != null && this.model.getNode() != null) {
            this.showCommittingAnimation(Words.SAVE_DATA);
            if (this.model.isAddRow()) {
                this.model.setCurrentState(3);
                this.createNewData(this.model.getNode());
            } else {
                RowModel<T> loader = this.additionalRemoteLoadListener;
                if (loader == null) {
                    loader = this.model;
                }
                this.commitData(this.model.getNode(), loader);
                if (this.backRef != null) {
                    this.backRef.commitSent();
                }
            }
        }
    }

    @Override
    public void statusChanged(File file, FileTransferState state) {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    public void setInnerElement(boolean b) {
        this.isInnerElement = b;
    }

    @Override
    public void fileDownloaded(File file) {
    }

    public void remoteObjectLoaded(Node<?> node) {
        if (this.currentState == IDataHandler.DATAHANDLER_STATE.RELOAD) {
            this.dataReloaded();
            return;
        }
        this.hideCommittingAnimation();
        this.setNode(node);
        this.model.setLoaded(true);
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), "", new InnerPopUpListener2(){

            @Override
            public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                RowEditor.this.setEnabled(true);
            }
        }, (Component)this);
        this.hideCommittingAnimation();
        this.getModel().setBlocked(false);
        this.getModel().expandRow(false);
    }

    public void setNode2Panels(Node node, ArrayList<ArrayList<Component>> comps) {
        for (ArrayList<Component> cc : comps) {
            for (Component c : cc) {
                if (!(c instanceof DetailsEditorParagraph) || ((DetailsEditorParagraph)((Object)c)).isKilled()) continue;
                ((DetailsEditorParagraph)((Object)c)).setNode(this.model.getNode());
            }
        }
    }

    public ArrayList<ArrayList<Component>> getInnerComponents() {
        return ((DetailsParagraphLayout)this.getLayout()).getComponents();
    }

    public void setNode(Node node) {
        this.isInit = true;
        if (node != null && this.model != null && this.model.getNode() != null) {
            this.model.getNode().setValue(node.getValue(), 0L);
        }
        this.setNode2Panels(node, ((DetailsParagraphLayout)this.getLayout()).getComponents());
        if (this.disablePanel != null) {
            this.disablePanel.kill();
        }
        this.isInit = false;
        if (this.add != null) {
            this.add.setUserObject(this.getModel().getNode());
        }
        if (this.model != null && this.model.getParentModel() != null) {
            this.model.getParentModel().getTable().requestRelayout();
        }
        if (!this.enableFromOutside) {
            this.setEnabled(true);
        }
        this.createFocusCycle();
        if (this.model != null && this.model.getView() != null && this.model.getView().isExpanded()) {
            this.model.getView().rowContentPanel.grapDefaultFocus();
        }
    }

    public void setEnableFromOutside(boolean enableFromOutside) {
        this.enableFromOutside = enableFromOutside;
    }

    @Override
    public void animationFinished(boolean wasFadin) {
        if (!wasFadin) {
            this.model.getParentModel().getTable().hideAnimation();
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component p = this.getComponent(i);
            if (!(p instanceof DetailsEditorParagraph) || !((DetailsEditorParagraph)((Object)p)).grabsFocus()) continue;
            DetailsEditorParagraph component = (DetailsEditorParagraph)((Object)this.getComponent(i));
            SwingUtilities.invokeLater(() -> component.requestFocusInWindowNow());
            return;
        }
        if (this.cancel != null && this.cancel.isEnabled()) {
            this.cancel.requestFocusInWindowNow();
        } else if (this.add != null && this.add.isEnabled()) {
            this.add.requestFocusInWindowNow();
        }
    }

    public String getCommitingText() {
        return this.commitingText;
    }

    public void setCommitingText(String commitingText) {
        this.commitingText = commitingText;
    }

    private class DetailsParagraphLayout
    extends DefaultLayout
    implements AttributeListener {
        private int vertical_border = 10;
        private int horizontal_border = 10;
        private int horizontal_button_border = 10;
        int startHBorder = 15;
        private final ArrayList<ArrayList<Component>> components = new ArrayList();
        private final ArrayList<ArrayList<TableLayoutConstraint>> constrains = new ArrayList();

        private DetailsParagraphLayout() {
        }

        public ArrayList<ArrayList<Component>> getComponents() {
            return this.components;
        }

        public void setVerticalBorder(int b) {
            this.vertical_border = b;
        }

        public void setHorizontalStartBorder(int b) {
            this.startHBorder = b;
        }

        public void setHorizontalBorder(int b) {
            this.horizontal_border = b;
        }

        public int getVerticalBorder() {
            return this.vertical_border;
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints == null) {
                return;
            }
            TableLayoutConstraint cons = (TableLayoutConstraint)constraints;
            while (cons.getColumn() >= this.components.size()) {
                this.components.add(new ArrayList());
                this.constrains.add(new ArrayList());
            }
            ArrayList<Component> col = this.components.get(cons.getColumn());
            ArrayList<TableLayoutConstraint> col2 = this.constrains.get(cons.getColumn());
            int count = 0;
            while (cons.getRow() >= col.size()) {
                ++count;
                col.add(null);
                col2.add(null);
            }
            col.set(cons.getRow(), comp);
            col2.set(cons.getRow(), cons);
        }

        private int getRowHeight(int columnNo, int maxRow) {
            int currentY = 0;
            ArrayList<Component> column = this.components.get(columnNo);
            int cR = 0;
            for (Component row : column) {
                if (cR <= maxRow) {
                    if (row != null) {
                        currentY = (int)((double)currentY + row.getPreferredSize().getHeight());
                    } else {
                        for (int i = columnNo - 1; i >= 0; --i) {
                            ArrayList<Component> colBefore = this.components.get(i);
                            if (colBefore.get(cR) == null) continue;
                            currentY = (int)((double)currentY + colBefore.get(cR).getPreferredSize().getHeight());
                            break;
                        }
                    }
                }
                ++cR;
            }
            return currentY + this.vertical_border;
        }

        private int getCurrentY4Span(int maxRow, int startcolumn, int maxcolumn) {
            int maxY = 0;
            for (int currentC = startcolumn; currentC < this.components.size() && currentC < maxcolumn; ++currentC) {
                int cY = this.getRowHeight(currentC, maxRow);
                if (cY <= maxY) continue;
                maxY = cY;
            }
            return maxY;
        }

        @Override
        public void layoutContainer(Container parent) {
            int startY;
            int currentY;
            int w = parent.getWidth();
            int currentX = this.horizontal_border;
            int maxY = currentY = (startY = this.vertical_border);
            int col = 0;
            for (ArrayList<Component> columns : this.components) {
                int maxWidth = 0;
                int rowC = 0;
                for (Component row : columns) {
                    if (row != null) {
                        int cmY;
                        currentX = this.getCurrentX(rowC, col);
                        TableLayoutConstraint cons = this.constrains.get(col).get(rowC);
                        currentY = cmY = this.getCurrentY4Span(rowC - 1, col, col + cons.getxSpan());
                        if (rowC > 0) {
                            currentY += rowC * this.vertical_border;
                        }
                        row.setLocation(currentX, currentY);
                        int tw = (int)row.getPreferredSize().getWidth();
                        int th = (int)row.getPreferredSize().getHeight();
                        Dimension pref = this.preferredLayoutRowSize(row, rowC);
                        int dif = w - (int)(pref.getWidth() + (double)(2 * this.startHBorder));
                        if (cons.getxSpan() != 1) {
                            tw = w - 2 * this.startHBorder;
                        } else if (dif != 0 && cons.getxExpand() != -1.0) {
                            double factor = cons.getxExpand();
                            int add = (int)((double)dif * factor);
                            tw += add;
                        }
                        if (tw > w) {
                            tw = w;
                        }
                        row.setSize(tw, th);
                        if ((double)cons.getxSpan() == 1.0 && maxWidth < row.getWidth()) {
                            maxWidth = row.getWidth();
                        }
                        currentY += row.getHeight() + this.vertical_border;
                    }
                    ++rowC;
                }
                ++col;
                if (maxY < currentY) {
                    maxY = currentY;
                }
                currentX += maxWidth + this.horizontal_border;
                currentY = startY;
            }
            if (RowEditor.this.hasButtons) {
                if (RowEditor.this.model.isAddRow()) {
                    RowEditor.this.add.setLocation(this.horizontal_button_border, maxY + this.vertical_border);
                    RowEditor.this.add.setSize(RowEditor.this.add.getPreferredSize());
                } else {
                    RowEditor.this.add.setLocation(this.horizontal_border, maxY + this.vertical_border);
                    RowEditor.this.add.setSize(RowEditor.this.add.getPreferredSize());
                }
                if (RowEditor.this.add.isVisible()) {
                    RowEditor.this.cancel.setLocation(RowEditor.this.add.getX() + RowEditor.this.add.getWidth() + this.horizontal_button_border, RowEditor.this.add.getY());
                    RowEditor.this.cancel.setSize(RowEditor.this.cancel.getPreferredSize());
                } else {
                    RowEditor.this.cancel.setLocation(this.horizontal_button_border, maxY + this.vertical_border);
                    RowEditor.this.cancel.setSize(RowEditor.this.cancel.getPreferredSize());
                }
            }
            RowEditor.this.checkRelayout();
            if (RowEditor.this.disablePanel != null) {
                RowEditor.this.disablePanel.setLocation(0, 0);
                RowEditor.this.disablePanel.setSize(parent.getSize());
            }
        }

        public int getCurrentX(int currentRow, int currentColumn) {
            if (currentColumn == 0) {
                return this.startHBorder;
            }
            int column = 0;
            for (ArrayList<Component> columns : this.components) {
                int rowC = 0;
                for (Component row : columns) {
                    if (rowC == currentRow && column == currentColumn - 1) {
                        return row.getX() + row.getWidth() + this.horizontal_border;
                    }
                    ++rowC;
                }
                ++column;
            }
            return 0;
        }

        public Dimension preferredLayoutRowSize(Component parent, int effectedRow) {
            int prefW = 0;
            int colC = 0;
            for (ArrayList<Component> columns : this.components) {
                int rowC = 0;
                for (Component row : columns) {
                    if (row != null && rowC == effectedRow) {
                        prefW = (int)((double)prefW + row.getPreferredSize().getWidth());
                        prefW += this.horizontal_border;
                    }
                    ++rowC;
                }
                ++colC;
            }
            return new Dimension(prefW -= this.horizontal_border, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int startY;
            int currentY;
            int currentX = this.horizontal_border;
            int maxY = currentY = (startY = this.vertical_border);
            int col = 0;
            for (ArrayList<Component> columns : this.components) {
                int maxWidthI = 0;
                int rowC = 0;
                for (Component row : columns) {
                    if (row != null) {
                        int cmY;
                        TableLayoutConstraint cons = this.constrains.get(col).get(rowC);
                        int consX = cons != null ? cons.getxSpan() : 1;
                        currentY = cmY = this.getCurrentY4Span(rowC - 1, col, col + consX);
                        if (rowC > 0) {
                            currentY += rowC * this.vertical_border;
                        }
                        if ((double)consX == 1.0 && (double)maxWidthI < row.getPreferredSize().getWidth()) {
                            maxWidthI = (int)row.getPreferredSize().getWidth();
                        }
                        currentY = (int)((double)currentY + (row.getPreferredSize().getHeight() + (double)this.vertical_border));
                    }
                    ++rowC;
                }
                ++col;
                if (maxY < currentY) {
                    maxY = currentY;
                }
                currentX += maxWidthI + this.horizontal_border;
                currentY = startY;
            }
            if (RowEditor.this.hasButtons) {
                maxY += this.vertical_border;
                maxY = (int)((double)maxY + RowEditor.this.add.getPreferredSize().getHeight());
                maxY += this.vertical_border;
            } else {
                ++maxY;
            }
            return new Dimension(currentX, maxY);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            for (ArrayList<Component> column : this.components) {
                if (!column.contains(comp)) continue;
                column.remove(comp);
            }
        }

        @Override
        public void attributeChanged(String attributeName) {
            if ("All attributes changed".equals(attributeName)) {
                this.vertical_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_editor_paragraph_vertical_gap"));
                this.horizontal_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_editor_paragraph_horizontal_gap"));
                this.horizontal_button_border = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_editor_button_vertical_gap"));
            }
        }
    }
}

